/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileSystem;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import ro.amiq.dvt.utils.ArrayLevenshteinDistance;
import ro.amiq.dvt.utils.StringMatcher;

public class PathMapper {
    private PathMapper() {
    }

    public static Result map(Collection<String> a, Collection<String> b, Collection<String> mappings) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        ArrayList<Pair<Matcher>> matchers = new ArrayList<Pair<Matcher>>();
        if (mappings != null) {
            for (String mapping : mappings) {
                try {
                    matchers.add(DefaultMatchers.fromMapping(mapping));
                }
                catch (Exception e) {
                    String message = "";
                    if (e.getMessage() != null) {
                        message = "(" + e.getMessage().replaceAll("\\R", " ") + ")";
                    }
                    throw new IllegalArgumentException("Mapping '" + mapping + "' is invalid " + message, e);
                }
            }
        }
        return PathMapper.map(new Pair<Collection<String>>(a, b), matchers);
    }

    private static Result map(Pair<Collection<String>> input, Collection<Pair<Matcher>> matchers) {
        Result result = new Result(input);
        try {
            Pair<Set<String>> inputSets = PathMapper.convertToSets(result, input);
            PathMapper.mapExactMatches(result, inputSets);
            if (PathMapper.clearEmptyInput(result, inputSets)) {
                Result result2 = result;
                return result2;
            }
            Pair<Set<Path>> pathSets = PathMapper.convertToPathSets(result, inputSets);
            Map<String, Pair<List<Path>>> groupMap = PathMapper.groupByName(result, pathSets);
            for (Pair<List<Path>> group : groupMap.values()) {
                if (PathMapper.clearEmptyGroup(result, group) || PathMapper.mapSimpleGroup(result, group)) continue;
                Collections.sort((List)group.a);
                Collections.sort((List)group.b);
                for (Pair<Matcher> matcher : matchers) {
                    if (((List)group.a).isEmpty() || ((List)group.b).isEmpty()) break;
                    Pair<List<Path>> subGroup = PathMapper.groupByMatcher(result, matcher, group);
                    if (((List)subGroup.a).isEmpty() || ((List)subGroup.b).isEmpty()) continue;
                    if (PathMapper.mapSimpleGroup(result, subGroup)) {
                        ((List)group.a).removeAll((Collection)subGroup.a);
                        ((List)group.b).removeAll((Collection)subGroup.b);
                        continue;
                    }
                    List<Pair<Path>> matches = PathMapper.mapByLevenshteinDistance(result, subGroup);
                    for (Pair<Path> match : matches) {
                        ((List)group.a).remove(match.a);
                        ((List)group.b).remove(match.b);
                        result.add(((Path)match.a).toString(), ((Path)match.b).toString());
                    }
                }
                if (PathMapper.clearEmptyGroup(result, group) || PathMapper.mapSimpleGroup(result, group)) continue;
                List<Pair<Path>> matches = PathMapper.mapByLevenshteinDistance(result, group);
                for (Pair<Path> match : matches) {
                    ((List)group.a).remove(match.a);
                    ((List)group.b).remove(match.b);
                    result.add(((Path)match.a).toString(), ((Path)match.b).toString());
                }
                if (PathMapper.clearEmptyGroup(result, group)) continue;
                throw new IllegalStateException();
            }
            Result result3 = result;
            return result3;
        }
        finally {
            result.end();
        }
    }

    private static List<Pair<Path>> mapByLevenshteinDistance(Result result, Pair<List<Path>> group) {
        result.timer("map by Levenshtein distance");
        ArrayList<Pair<Path>> matches = new ArrayList<Pair<Path>>();
        int[][] scores = PathMapper.calculateLevenshteinScores(result, group);
        Pair indices = new Pair(new LinkedHashSet(), new LinkedHashSet());
        int i = 0;
        while (i < ((List)group.a).size()) {
            ((Set)indices.a).add(i);
            ++i;
        }
        int j = 0;
        while (j < ((List)group.b).size()) {
            ((Set)indices.b).add(j);
            ++j;
        }
        while (!((Set)indices.a).isEmpty() && !((Set)indices.b).isEmpty()) {
            int minScore = Integer.MAX_VALUE;
            int minIndexA = -1;
            int minIndexB = -1;
            Iterator iterator = ((Set)indices.a).iterator();
            while (iterator.hasNext()) {
                int i2 = (Integer)iterator.next();
                Iterator iterator2 = ((Set)indices.b).iterator();
                while (iterator2.hasNext()) {
                    int j2 = (Integer)iterator2.next();
                    if (scores[i2][j2] >= minScore) continue;
                    minScore = scores[i2][j2];
                    minIndexA = i2;
                    minIndexB = j2;
                }
            }
            ((Set)indices.a).remove(minIndexA);
            ((Set)indices.b).remove(minIndexB);
            matches.add(new Pair<Path>((Path)((List)group.a).get(minIndexA), (Path)((List)group.b).get(minIndexB)));
        }
        result.timer("map by Levenshtein distance");
        return matches;
    }

    private static int[][] calculateLevenshteinScores(Result result, Pair<List<Path>> pair) {
        result.timer("calculate Levenshtein scores");
        int[][] scores = new int[((List)pair.a).size()][((List)pair.b).size()];
        int i = 0;
        while (i < ((List)pair.a).size()) {
            int j = 0;
            while (j < ((List)pair.b).size()) {
                scores[i][j] = ArrayLevenshteinDistance.of(((Path)((List)pair.a).get((int)i)).segments, ((Path)((List)pair.b).get((int)j)).segments);
                ++j;
            }
            ++i;
        }
        result.timer("calculate Levenshtein scores");
        return scores;
    }

    private static Pair<List<Path>> groupByMatcher(Result result, Pair<Matcher> matcher, Pair<List<Path>> group) {
        result.timer("group by matcher");
        Pair<List<Path>> list = new Pair<List<Path>>(((List)group.a).stream().filter(((Matcher)matcher.a)::matches).collect(Collectors.toList()), ((List)group.b).stream().filter(((Matcher)matcher.b)::matches).collect(Collectors.toList()));
        result.timer("group by matcher");
        return list;
    }

    private static Pair<Set<String>> convertToSets(Result result, Pair<Collection<String>> input) {
        result.timer("convert to sets");
        Pair<Set<String>> set = new Pair<Set<String>>(new HashSet((Collection)input.a), new HashSet((Collection)input.b));
        result.timer("convert to sets");
        return set;
    }

    private static Pair<Set<Path>> convertToPathSets(Result result, Pair<Set<String>> inputSet) {
        result.timer("convert to path sets");
        Pair<Set<Path>> pathSets = new Pair<Set<Path>>(((Set)inputSet.a).stream().map(string -> new Path((String)string)).collect(Collectors.toSet()), ((Set)inputSet.b).stream().map(string -> new Path((String)string)).collect(Collectors.toSet()));
        result.timer("convert to path sets");
        return pathSets;
    }

    private static boolean mapSimpleGroup(Result result, Pair<List<Path>> pair) {
        if (((List)pair.a).size() == 1 && ((List)pair.b).size() == 1) {
            result.add(((Path)((List)pair.a).get(0)).toString(), ((Path)((List)pair.b).get(0)).toString());
            return true;
        }
        return false;
    }

    private static boolean clearEmptyGroup(Result result, Pair<List<Path>> pair) {
        if (((List)pair.a).isEmpty() || ((List)pair.b).isEmpty()) {
            if (((List)pair.a).isEmpty()) {
                result.addUnmappedB(((List)pair.b).stream().map(Path::toString).collect(Collectors.toList()));
            }
            if (((List)pair.b).isEmpty()) {
                result.addUnmappedA(((List)pair.a).stream().map(Path::toString).collect(Collectors.toList()));
            }
            return true;
        }
        return false;
    }

    private static boolean clearEmptyInput(Result result, Pair<Set<String>> inputSet) {
        if (((Set)inputSet.a).isEmpty() || ((Set)inputSet.b).isEmpty()) {
            if (((Set)inputSet.a).isEmpty()) {
                result.addUnmappedB((Collection)inputSet.b);
            }
            if (((Set)inputSet.b).isEmpty()) {
                result.addUnmappedA((Collection)inputSet.a);
            }
            return true;
        }
        return false;
    }

    private static Map<String, Pair<List<Path>>> groupByName(Result result, Pair<Set<Path>> pathSet) {
        result.timer("group by name");
        HashMap<String, Pair<List<Path>>> groups = new HashMap<String, Pair<List<Path>>>();
        for (Path path : (Set)pathSet.a) {
            ((List)groups.computeIfAbsent(path.segments[0], (Function<String, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$6(java.lang.String ), (Ljava/lang/String;)Lro/amiq/dvt/utils/PathMapper$Pair;)()).a).add(path);
        }
        for (Path path : (Set)pathSet.b) {
            ((List)groups.computeIfAbsent((String)path.segments[0], (Function<String, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$7(java.lang.String ), (Ljava/lang/String;)Lro/amiq/dvt/utils/PathMapper$Pair;)()).b).add(path);
        }
        result.timer("group by name");
        return groups;
    }

    private static void mapExactMatches(Result result, Pair<Set<String>> inputSet) {
        result.timer("map exact matches");
        Iterator iterator = ((Set)inputSet.a).iterator();
        while (iterator.hasNext()) {
            String aString = (String)iterator.next();
            if (!((Set)inputSet.b).contains(aString)) continue;
            result.add(aString, aString);
            ((Set)inputSet.b).remove(aString);
            iterator.remove();
        }
        result.timer("map exact matches");
    }

    private static /* synthetic */ Pair lambda$6(String k) {
        return new Pair(new ArrayList(), new ArrayList());
    }

    private static /* synthetic */ Pair lambda$7(String k) {
        return new Pair(new ArrayList(), new ArrayList());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DefaultMatchers {
        PERL{

            @Override
            protected Matcher create(String pattern) {
                PathMatcher matcher = FILE_SISTEM.getPathMatcher("regex:" + pattern);
                return path -> matcher.matches(path.path);
            }
        }
        ,
        GLOB{

            @Override
            protected Matcher create(String pattern) {
                PathMatcher matcher = FILE_SISTEM.getPathMatcher("glob:" + pattern);
                return path -> matcher.matches(path.path);
            }
        }
        ,
        SIMPLE{

            @Override
            protected Matcher create(String pattern) {
                if (pattern.contains("*") || pattern.contains("?")) {
                    StringMatcher matcher = new StringMatcher(pattern, IS_MACOS, false, true);
                    return path -> matcher.match(path.string);
                }
                java.nio.file.Path patternPath = Paths.get(pattern, new String[0]);
                return path2 -> path2.path.startsWith(patternPath);
            }
        };

        private static final FileSystem FILE_SISTEM;
        private static final boolean IS_MACOS;

        static {
            FILE_SISTEM = Paths.get(System.getProperty("user.dir"), new String[0]).getFileSystem();
            IS_MACOS = System.getProperty("os.name").toLowerCase().contains("mac");
        }

        protected abstract Matcher create(String var1);

        public static Pair<Matcher> fromMapping(String mapping) {
            Objects.requireNonNull(mapping);
            String[] parts = mapping.split("=");
            if (parts.length != 2) {
                throw new IllegalArgumentException("mapping must contain exactly one '=', this one contains " + (parts.length - 1));
            }
            DefaultMatchers[] defaultMatchersArray = DefaultMatchers.values();
            int n = defaultMatchersArray.length;
            int n2 = 0;
            while (n2 < n) {
                DefaultMatchers value = defaultMatchersArray[n2];
                int length = value.name().length();
                if (parts[0].length() > length && parts[0].charAt(length) == '+' && parts[0].substring(0, length).equalsIgnoreCase(value.name())) {
                    return new Pair<Matcher>(value.create(parts[0].substring(length + 1)), value.create(parts[1]));
                }
                ++n2;
            }
            return new Pair<Matcher>(PERL.create(parts[0]), PERL.create(parts[1]));
        }
    }

    @FunctionalInterface
    private static interface Matcher {
        public boolean matches(Path var1);
    }

    private static class Pair<T> {
        private final T a;
        private final T b;

        private Pair(T a, T b) {
            this.a = Objects.requireNonNull(a);
            this.b = Objects.requireNonNull(b);
        }

        public int hashCode() {
            return 31 * (31 + this.a.hashCode()) + this.b.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return this.a.equals(((Pair)obj).a) && !this.b.equals(((Pair)obj).b);
        }

        public String toString() {
            return String.valueOf(this.a.toString()) + " -> " + this.b.toString();
        }
    }

    private static class Path
    implements Comparable<Path> {
        private final String string;
        private final java.nio.file.Path path;
        private final String[] segments;

        private Path(String string) {
            this.string = Objects.requireNonNull(string);
            this.path = Paths.get(string, new String[0]);
            this.segments = Path.computeSegments(this.path);
        }

        private static String[] computeSegments(java.nio.file.Path path) {
            int count = path.getNameCount();
            java.nio.file.Path root = path.getRoot();
            String[] result = null;
            if (root != null) {
                result = new String[count + 1];
                result[count] = root.toString();
            } else {
                result = new String[count];
            }
            int i = 0;
            while (i < count) {
                result[count - i - 1] = path.getName(i).toString();
                ++i;
            }
            return result;
        }

        @Override
        public int compareTo(Path obj) {
            return this.path.compareTo(obj.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return this.path.equals(((Path)obj).path);
        }

        public String toString() {
            return this.string;
        }
    }

    public static class Result {
        private final Stats stats;
        private final Map<String, String> mapAB;
        private final Map<String, String> mapBA;
        private final Set<String> unmappedA;
        private final Set<String> unmappedB;

        private Result(Pair<Collection<String>> input) {
            this.stats = new Stats(input);
            this.mapAB = new HashMap<String, String>();
            this.mapBA = new HashMap<String, String>();
            this.unmappedA = new HashSet<String>();
            this.unmappedB = new HashSet<String>();
        }

        private void end() {
            this.stats.end(this);
        }

        private void add(String a, String b) {
            if (this.mapAB.put(a, b) != null) {
                throw new IllegalStateException("Map A->B already contains a mapping for " + a);
            }
            if (this.mapBA.put(b, a) != null) {
                throw new IllegalStateException("Map B->A already contains a mapping for " + b);
            }
        }

        private void addUnmappedA(Collection<String> a) {
            this.unmappedA.addAll(a);
        }

        private void addUnmappedB(Collection<String> b) {
            this.unmappedB.addAll(b);
        }

        private void timer(String name) {
            this.stats.timer(name);
        }

        public String getA(String b) {
            return this.mapBA.get(b);
        }

        public String getB(String a) {
            return this.mapAB.get(a);
        }

        public boolean isUnmappedA(String a) {
            return this.unmappedA.contains(a);
        }

        public boolean isUnmappedB(String b) {
            return this.unmappedB.contains(b);
        }

        public String stats() {
            return this.stats.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : this.mapAB.entrySet()) {
                sb.append(entry.getKey()).append(" -> ").append(entry.getValue()).append('\n');
            }
            return sb.toString();
        }
    }

    private static class Stats {
        private final Map<String, Long[]> timers = new LinkedHashMap<String, Long[]>();
        private final Pair<Collection<String>> input;
        private Result output;

        private Stats(Pair<Collection<String>> input) {
            this.input = input;
            this.timer("total");
        }

        private void end(Result result) {
            this.timer("total");
            this.output = result;
        }

        /*
         * Exception decompiling
         */
        private void timer(String name) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public String toString() {
            String format = null;
            ArrayList<Map.Entry<String, String>> mappedEntries = new ArrayList<Map.Entry<String, String>>(this.output.mapAB.entrySet());
            mappedEntries.sort(Map.Entry.comparingByKey());
            format = "%-" + mappedEntries.stream().mapToInt(e -> ((String)e.getKey()).length()).max().getAsInt() + "s";
            int nExact = 0;
            int nSimilar = 0;
            StringBuilder sbExact = new StringBuilder();
            StringBuilder sbSimilar = new StringBuilder();
            for (Map.Entry entry : mappedEntries) {
                if (((String)entry.getKey()).equals(entry.getValue())) {
                    sbExact.append("   ").append(String.format(format, entry.getKey())).append(" -> ").append((String)entry.getValue()).append('\n');
                    ++nExact;
                    continue;
                }
                sbSimilar.append("   ").append(String.format(format, entry.getKey())).append(" -> ").append((String)entry.getValue()).append('\n');
                ++nSimilar;
            }
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<String> unmmapedAEntries = new ArrayList<String>(this.output.unmappedA);
            Collections.sort(unmmapedAEntries);
            for (String entry : unmmapedAEntries) {
                stringBuilder.append("   ").append(entry).append('\n');
            }
            StringBuilder sbUnmappedB = new StringBuilder();
            ArrayList<String> unmmapedBEntries = new ArrayList<String>(this.output.unmappedB);
            Collections.sort(unmmapedBEntries);
            for (String entry : unmmapedBEntries) {
                sbUnmappedB.append("   ").append(entry).append('\n');
            }
            format = "%-" + this.timers.entrySet().stream().mapToInt(e -> ((String)e.getKey()).length()).max().getAsInt() + "s";
            StringBuilder sbTimers = new StringBuilder();
            for (Map.Entry<String, Long[]> entry : this.timers.entrySet()) {
                sbTimers.append("   ").append(String.format(format, entry.getKey())).append(" : ").append(entry.getValue()[0] / 1000000L).append(" ms (").append(entry.getValue()[2]).append(")").append('\n');
            }
            return "================================================================================" + '\n' + "- Exact" + '\n' + sbExact + '\n' + "- Similar" + '\n' + sbSimilar + '\n' + "- Unmapped A" + '\n' + stringBuilder + '\n' + "- Unmapped B" + '\n' + sbUnmappedB + '\n' + "================================================================================" + '\n' + "- Initial" + '\n' + "   A         : " + ((Collection)this.input.a).size() + '\n' + "   B         : " + ((Collection)this.input.b).size() + '\n' + "- Unique" + '\n' + "   A         : " + (this.output.mapAB.size() + this.output.unmappedA.size()) + '\n' + "   B         : " + (this.output.mapBA.size() + this.output.unmappedB.size()) + '\n' + "- Unmapped" + '\n' + "   A         : " + this.output.unmappedA.size() + '\n' + "   B         : " + this.output.unmappedB.size() + '\n' + "- Mapped " + '\n' + "   Similar   : " + nSimilar + '\n' + "   Exact     : " + nExact + '\n' + "================================================================================" + '\n' + "- Timers" + '\n' + sbTimers + "================================================================================" + '\n';
        }
    }
}

