/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class StoppableJob
extends Job {
    private static final long DEFAULT_GRACE_TIME = 3000L;
    private final long graceTime;
    private volatile Thread monitorThread;

    public StoppableJob(String name) {
        this(name, 3000L);
    }

    public StoppableJob(String name, long graceTime) {
        super(name);
        if (graceTime < 0L) {
            throw new IllegalArgumentException("Grace time should me more than 0 milliseconds.");
        }
        this.graceTime = graceTime;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.CANCEL_STATUS;
        try {
            this.monitorThread = new Thread(this::stopWithGrace, String.valueOf(this.getName()) + " Killer");
            status = this.stoppableRun(monitor);
            this.monitorThread.interrupt();
            this.monitorThread = null;
        }
        catch (ThreadDeath threadDeath) {
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
        return status;
    }

    protected void canceling() {
        if (this.monitorThread != null) {
            this.monitorThread.start();
        }
    }

    private void stopWithGrace() {
        try {
            Thread.sleep(this.graceTime);
            Thread jobThread = this.getThread();
            if (jobThread != null && Thread.currentThread() == this.monitorThread && !Thread.interrupted()) {
                jobThread.stop();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    protected abstract IStatus stoppableRun(IProgressMonitor var1);
}

