/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.diagrams.wavedrom.BitField;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTUnpackedStruct;
import ro.amiq.dvt.utils.VlogBitVector__structMemberInfo;

public class StructMemberContextInfo {
    public int startingIndex;
    public String name;
    public BitVectorContext context;

    public StructMemberContextInfo(int index, String name, BitVectorContext context) {
        this.startingIndex = index;
        this.name = name;
        this.context = context;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Integer.toString(this.startingIndex));
        sb.append(", ").append(this.context);
        return sb.toString();
    }

    public BitField.Color getBitfieldColor() {
        if (this.isUnion()) {
            return BitField.Color.PURPLE;
        }
        if (this.isStruct()) {
            return BitField.Color.BLUE;
        }
        if (this.isEnum()) {
            return BitField.Color.ORANGE;
        }
        return BitField.Color.GREEN;
    }

    public List<StructMemberContextInfo> getMembers() {
        if (this.context == null) {
            return Collections.emptyList();
        }
        DVTNumber contextNumber = this.context.getContextNumber();
        if (contextNumber instanceof DVTUnpackedStruct) {
            return ((DVTUnpackedStruct)contextNumber).getMembersInfoOrdered();
        }
        if (contextNumber instanceof VlogBitVector__structMemberInfo) {
            return ((VlogBitVector__structMemberInfo)contextNumber).getMembersInfoOrdered();
        }
        return Collections.emptyList();
    }

    public boolean isUnion() {
        IRfNamedElement origin = this.context.getOrigin();
        if (!(origin instanceof IRfAssociatedTypeElement)) {
            return false;
        }
        IRfNamedElement associatedType = ((IRfAssociatedTypeElement)origin).getAssociatedType();
        if (associatedType instanceof IRfAssociatedTypeElement) {
            associatedType = ((IRfAssociatedTypeElement)associatedType).getResolvedType(true);
        }
        if (associatedType instanceof IRfTypeAliasElement) {
            associatedType = ((IRfTypeAliasElement)associatedType).getTranslatedType();
        }
        if (associatedType instanceof IRfCompositeTypeElement) {
            return ((IRfCompositeTypeElement)associatedType).isUnion();
        }
        return false;
    }

    public boolean isStruct() {
        IRfNamedElement origin = this.context.getOrigin();
        if (!(origin instanceof IRfAssociatedTypeElement)) {
            return false;
        }
        IRfNamedElement associatedType = ((IRfAssociatedTypeElement)origin).getAssociatedType();
        if (associatedType instanceof IRfAssociatedTypeElement) {
            associatedType = ((IRfAssociatedTypeElement)associatedType).getResolvedType(true);
        }
        if (associatedType instanceof IRfCompositeTypeElement) {
            return ((IRfCompositeTypeElement)associatedType).isStruct();
        }
        return false;
    }

    public boolean isEnum() {
        IRfNamedElement origin = this.context.getOrigin();
        if (!(origin instanceof IRfAssociatedTypeElement)) {
            return false;
        }
        IRfNamedElement associatedType = ((IRfAssociatedTypeElement)origin).getAssociatedType();
        if (associatedType instanceof IRfAssociatedTypeElement) {
            associatedType = ((IRfAssociatedTypeElement)associatedType).getResolvedType(true);
        }
        if (associatedType instanceof IRfCompositeTypeElement) {
            return ((IRfCompositeTypeElement)associatedType).isEnum();
        }
        return false;
    }

    public boolean isParentUnion() {
        IRfNamedElement origin = this.context.getOrigin();
        IRfScopeElement enclosingScope = origin.getEnclosingScope();
        if (enclosingScope instanceof IRfCompositeTypeElement) {
            return ((IRfCompositeTypeElement)enclosingScope).isUnion();
        }
        return false;
    }
}

