/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;

public enum TimeoutUtils {
    INSTANCE;

    private static final long DELTA = 10L;

    public boolean runWithTimeout(long timeout, IProgressMonitor monitor, final Runnable r) {
        final AtomicBoolean done = new AtomicBoolean(false);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                    done.set(true);
                }
                catch (InterruptException interruptException) {}
            }
        });
        t.start();
        int i = 0;
        while ((long)i < timeout / 10L) {
            if (done.get() || monitor != null && monitor.isCanceled()) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        if (done.get()) {
            return true;
        }
        t.stop();
        return false;
    }

    private static class InterruptException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private InterruptException() {
        }
    }
}

