/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.File;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.nature.INatureContributor;
import ro.amiq.dvt.nature.NatureContributors;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.BaseUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public class Utils
extends BaseUtils {
    public static void notifyHighlightPositionsChange(final IDocument document, final String positionCategory) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench == null) {
                    return;
                }
                IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                if (windows == null || windows.length == 0) {
                    return;
                }
                IWorkbenchWindow[] iWorkbenchWindowArray = windows;
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] pages = window.getPages();
                    if (pages != null && pages.length != 0) {
                        IWorkbenchPage[] iWorkbenchPageArray = pages;
                        int n3 = pages.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IWorkbenchPage page = iWorkbenchPageArray[n4];
                            IEditorReference[] references = page.getEditorReferences();
                            if (references != null && references.length != 0) {
                                IEditorReference[] iEditorReferenceArray = references;
                                int n5 = references.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    IDocument editorDocument;
                                    IEditorReference reference = iEditorReferenceArray[n6];
                                    IEditorPart editor = reference.getEditor(false);
                                    if (editor != null && editor instanceof IDVTEditor && (editorDocument = ((IDVTEditor)editor).getDocument()) != null && editorDocument == document) {
                                        ((IDVTEditor)editor).updateBackgroundHighlightPositions(positionCategory);
                                    }
                                    ++n6;
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    public static IResource[] getDirtyResources(IProject project) {
        HashSet<IResource> dirtyres = new HashSet<IResource>();
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int l = 0;
        while (l < windows.length) {
            IWorkbenchPage[] pages = windows[l].getPages();
            int i = 0;
            while (i < pages.length) {
                IEditorPart[] eparts = pages[i].getDirtyEditors();
                int j = 0;
                while (j < eparts.length) {
                    IResource resource = (IResource)eparts[j].getEditorInput().getAdapter(IResource.class);
                    if (resource != null && project.equals((Object)resource.getProject())) {
                        dirtyres.add(resource);
                    }
                    ++j;
                }
                ++i;
            }
            ++l;
        }
        return dirtyres.toArray(new IResource[dirtyres.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasDvtNature(IProject project) {
        try {
            INatureContributor contributor;
            if (project == null) {
                return false;
            }
            Iterator<INatureContributor> iterator = NatureContributors.getContributors().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(contributor = iterator.next()).hasNature(project));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAccessibleDVTProject(IProject project) {
        return project != null && project.isAccessible() && Utils.hasDvtNature(project);
    }

    public static IProjectDescription getProjectDescription(File projectFile) {
        IProjectDescription description = null;
        try {
            Path path = new Path(projectFile.getPath());
            description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
        }
        catch (Exception exception) {
            return null;
        }
        return description;
    }

    public static File getProjectFileFromDirectory(File directory) {
        File dotProjFile = new File(directory, ".project");
        return dotProjFile.exists() ? dotProjFile : null;
    }

    public static IProject getProject(String projectName) {
        block3: {
            try {
                if (projectName != null && !projectName.isEmpty()) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static String getDVTActivePerspectiveID() {
        String activePerspectiveId = Utils.getActivePerspectiveID();
        if (activePerspectiveId == null) {
            return null;
        }
        if (activePerspectiveId.startsWith("ro.amiq.edt.ui.perspectives.EDTPerspective") || activePerspectiveId.startsWith("ro.amiq.vlogdt.ui.perspectives.VlogPerspective") || activePerspectiveId.startsWith("ro.amiq.vhdldt.ui.perspectives.VhdlPerspective") || activePerspectiveId.startsWith("ro.amiq.msdldt.ui.perspectives.MSDLPerspective") || activePerspectiveId.startsWith("ro.amiq.slndt.ui.perspectives.SLNDTPerspective") || activePerspectiveId.startsWith("ro.amiq.pssdt.ui.perspectives.PSSPerspective") || activePerspectiveId.startsWith("ro.amiq.dvt.cdt.ui.perspectives.CPPPerspective") || activePerspectiveId.startsWith("ro.amiq.dvt.ui.perspectives.DVTPerspective") || activePerspectiveId.startsWith("ro.amiq.dvt.ui.perspectives.DVTSlimPerspective") || activePerspectiveId.startsWith("ro.amiq.dvt.debug.ui.perspectives.DebugPerspective")) {
            return activePerspectiveId;
        }
        return null;
    }

    private static String getActivePerspectiveID() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow[] workbenchWindows = wb.getWorkbenchWindows();
        if (workbenchWindows.length == 0) {
            IPerspectiveRegistry perspectiveRegistry = wb.getPerspectiveRegistry();
            if (perspectiveRegistry == null) {
                return null;
            }
            return perspectiveRegistry.getDefaultPerspective();
        }
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        if (win == null) {
            return null;
        }
        IWorkbenchPage page = win.getActivePage();
        if (page == null) {
            return null;
        }
        IPerspectiveDescriptor perspective = page.getPerspective();
        if (perspective == null) {
            return null;
        }
        return perspective.getId();
    }

    public static IPath getWorkspaceLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation();
    }

    public static IDocument getDocumentFromEditor(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return documentProvider.getDocument((Object)editorInput);
    }

    public static IProject getProjectFromEditor(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    public static void copyToClipboard(String text, int clipboards) {
        if (text == null || text.isEmpty()) {
            return;
        }
        int clips = 1;
        if ((clipboards & 1) != 0 || (clipboards & 2) != 0) {
            clips = clipboards;
        }
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(Display.getDefault());
            clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()}, clips);
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    public static String pasteFromClipboard() {
        Display display = Display.getDefault();
        if (display == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Runnable r = () -> {
            try {
                Clipboard clipboard = new Clipboard(display);
                TextTransfer textTransfer = TextTransfer.getInstance();
                result.append(clipboard.getContents((Transfer)textTransfer));
                clipboard.dispose();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        };
        if (display.getThread() == Thread.currentThread()) {
            r.run();
        } else {
            display.syncExec(r);
        }
        return result.toString();
    }

    public static boolean isPluginInitializationDone() {
        return DVTPlugin.getDefault().isPluginInitializationDone();
    }

    public static void workaroundProgessViewBug() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench == null) {
                    return;
                }
                IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                if (activeWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                try {
                    activePage.showView("org.eclipse.ui.views.ProgressView", null, 3);
                }
                catch (PartInitException partInitException) {}
            }
        });
    }

    public static boolean isDiagramsShowPDInfo() {
        return PrefConst.getDiagramsShowPDInfo();
    }

    public static BreadcrumbInput computeBreadcrumbInfo(IFile iFile, IRfBreadcrumbElement bcElement, boolean includeSelf) {
        if (bcElement == null) {
            return null;
        }
        try {
            BreadcrumbInput breadcrumbInput;
            IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
            if (activeEditor instanceof IDVTBreadcrumbHost && ((IDVTBreadcrumbHost)activeEditor).hasBreadcrumbViewer(DHBreadcrumbViewer.class) && (breadcrumbInput = AbstractBreadcrumbUtils.getBreadcrumbInput(DHBreadcrumbViewer.class, (IDVTBreadcrumbHost)activeEditor)) != null) {
                if (includeSelf) {
                    breadcrumbInput.append(bcElement);
                }
                AbstractBreadcrumbUtils breadcrumbUtils = ((IDVTBreadcrumbHost)activeEditor).getBreadcrumbUtils(DHBreadcrumbViewer.class);
                IProject project = ((IDVTBreadcrumbHost)activeEditor).getProject();
                if (activeEditor instanceof DVTEditor) {
                    iFile.setSessionProperty(IDVTConstants.INHIBIT_DPM_UPDATE_QN, new Object());
                } else {
                    iFile.setSessionProperty(IDVTConstants.DH_BREADCRUMB_QN, (Object)new BreadcrumbInput(project, breadcrumbInput, breadcrumbUtils.getBreadcrumbSerializer()));
                }
                return breadcrumbInput;
            }
            return null;
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static boolean isInternalPreferenceDisableNewHyperlinkTooltipEngine() {
        return PrefConst.internalIsDisableNewHyperlinkTooltipEngine();
    }

    public static ParserPath getParserPath(ITextEditor editor) {
        IResource resource = (IResource)editor.getAdapter(IResource.class);
        if (resource == null) {
            return null;
        }
        return DVTFileUtils.getInstance().resource2parser(resource);
    }

    public static IProject getProject(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    public static String getVersion() {
        return (String)DVTPlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
    }

    public static java.nio.file.Path getActiveProjectPath() {
        IPath projectLocation;
        block4: {
            IProject selectedProject = DVTFileUtils.getInstance().getSelectedProject();
            if (selectedProject == null) {
                return null;
            }
            try {
                projectLocation = selectedProject.getLocation();
                if (projectLocation != null) break block4;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return Paths.get(projectLocation.toOSString(), new String[0]);
    }
}

