/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigInteger;
import ro.amiq.dvt.model.reflection.IRfEnumElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class VhdlEnum
extends VlogBitVector {
    private final IRfNamedElement enumValueOrType;

    public VhdlEnum(IRfNamedElement enumValue, int size, boolean is4State) {
        this(enumValue, size, null, BigInteger.ZERO, is4State);
    }

    public VhdlEnum(IRfNamedElement enumValueOrType, int size, int[] packed, BigInteger numberValue, boolean is4State) {
        super(false, size - 1, 0, packed, is4State, numberValue);
        this.enumValueOrType = enumValueOrType;
    }

    @Override
    public VlogBitVector decreaseDimension() {
        VlogBitVector decreaseDimension = super.decreaseDimension();
        return new VhdlEnum(this.enumValueOrType, decreaseDimension.getSize(), decreaseDimension.getArrayDimensions(), BigInteger.ZERO, this.is4State());
    }

    @Override
    public boolean equals(VlogBitVector obj) {
        boolean sameNumber = super.equals(obj);
        if (!(obj instanceof VhdlEnum)) {
            return sameNumber;
        }
        return this.enumValueOrType.equals(((VhdlEnum)obj).getEnumValue());
    }

    public IRfNamedElement getEnumValue() {
        return this.enumValueOrType;
    }

    @Override
    public DVTNumber getDefaultValue(boolean force4State) {
        return new VhdlEnum(this.enumValueOrType, this.getSize(), this.packed, BigInteger.ZERO, force4State || this.is4State);
    }

    @Override
    public VlogBitVector copy() {
        return new VhdlEnum(this.enumValueOrType, this.getSize(), this.packed, this.getNumber(), this.is4State);
    }

    public IRfNamedElement getEnumValueFromOrdinal(int intValue) {
        if (!(this.enumValueOrType instanceof IRfEnumElement)) {
            return null;
        }
        return ((IRfEnumElement)this.enumValueOrType).getEnumValueForOrdinal(intValue);
    }

    @Override
    public String toString() {
        if (this.enumValueOrType instanceof IRfEnumElement) {
            return super.toString();
        }
        return this.enumValueOrType.getName();
    }

    @Override
    public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        if (this.enumValueOrType instanceof IRfEnumElement) {
            return super.toNiceString(context, radix, useCharLimit, useLowerCaseMaskType);
        }
        return this.enumValueOrType.getName();
    }

    @Override
    public String toString(int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        if (this.enumValueOrType instanceof IRfEnumElement) {
            return super.toString(radix, useCharLimit, useLowerCaseMaskType);
        }
        return this.enumValueOrType.getName();
    }

    @Override
    public String print(int radix, boolean stripLeadingZeroes, int width, boolean useLowerCaseMaskType, boolean structAssignPattern) {
        if (this.enumValueOrType instanceof IRfEnumElement) {
            return super.print(radix, stripLeadingZeroes, width, useLowerCaseMaskType, structAssignPattern);
        }
        return this.enumValueOrType.getName();
    }
}

