/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigInteger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class VhdlPhysicalUnit
extends VlogBitVector {
    private final String physicalUnit;

    public VhdlPhysicalUnit(String physicalUnit, int value) {
        super(false, 31, 0, null, false, BigInteger.valueOf(value));
        this.physicalUnit = physicalUnit;
    }

    @Override
    public boolean equals(VlogBitVector obj) {
        boolean sameNumber = super.equals(obj);
        if (!(obj instanceof VhdlPhysicalUnit)) {
            return sameNumber;
        }
        return this.physicalUnit.equals(((VhdlPhysicalUnit)obj).physicalUnit);
    }

    @Override
    public DVTNumber getDefaultValue(boolean force4State) {
        return new VhdlPhysicalUnit(this.physicalUnit, 0);
    }

    @Override
    public VlogBitVector copy() {
        return new VhdlPhysicalUnit(this.physicalUnit, this.getNumber().intValue());
    }

    @Override
    public String toString() {
        return String.valueOf(Double.toString(this.doubleValue())) + " " + this.physicalUnit;
    }

    @Override
    public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        return String.valueOf(super.toString(radix, useCharLimit, useLowerCaseMaskType)) + " " + this.physicalUnit;
    }

    @Override
    public String toString(int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        return String.valueOf(super.toString(radix, useCharLimit, useLowerCaseMaskType)) + " " + this.physicalUnit;
    }

    @Override
    public String print(int radix, boolean stripLeadingZeroes, int width, boolean useLowerCaseMaskType, boolean structAssignPattern) {
        return String.valueOf(super.print(radix, stripLeadingZeroes, width, useLowerCaseMaskType, structAssignPattern)) + " " + this.physicalUnit;
    }
}

