/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigDecimal;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.dvt.utils.VlogShortrealNumber;

public abstract class VlogAbstractRealNumber
extends DVTNumber {
    @Override
    public boolean isAmbiguous() {
        return this.isUnknown();
    }

    public abstract VlogBitVector toBitVectorNumber(boolean var1, int var2);

    protected BigDecimal bigDecimalValue() {
        return new BigDecimal(this.doubleValue());
    }

    @Override
    public VlogBitVector toBitVector() {
        return VlogBitVector.create(true, this.getSize() - 1, 0, null, false, false, false, false, null, null, this.bigIntegerValue());
    }

    public static VlogAbstractRealNumber createZeroForSize(int size) {
        return size == 32 ? VlogShortrealNumber.ZERO : VlogRealNumber.ZERO;
    }

    public static VlogAbstractRealNumber negate(VlogAbstractRealNumber number) {
        return number.getSize() == 32 ? VlogShortrealNumber.create(-number.floatValue()) : VlogRealNumber.create(-number.doubleValue());
    }

    public static boolean isInfinite(DVTNumber number) {
        return Double.isInfinite(number.doubleValue());
    }

    public static boolean isNaN(DVTNumber number) {
        return Double.isNaN(number.doubleValue());
    }
}

