/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.msgpack.core.MessagePacker;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.csp.utils.MutableBigInteger;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidNameAndSelects;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IllegalPartSelectIndexException;
import ro.amiq.dvt.model.reflection.semantic.extension.OutOfBoundsSelectException;
import ro.amiq.dvt.model.reflection.semantic.extension.ReversedPartSelectException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitSetUtils;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.DVTUnpackedStruct;
import ro.amiq.dvt.utils.IDVTMemberSelectable;
import ro.amiq.dvt.utils.IDVTRangeSelectable;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.StructMemberContextInfo;
import ro.amiq.dvt.utils.VhdlEnum;
import ro.amiq.dvt.utils.VlogAbstractRealNumber;
import ro.amiq.dvt.utils.VlogBitVector__mask__structMemberInfo;
import ro.amiq.dvt.utils.VlogBitVector__structMemberInfo;
import ro.amiq.dvt.utils.XGlobalCache;

public class VlogBitVector
extends DVTNumber
implements IDVTRangeSelectable {
    private static final int INT_CACHE_SIZE = 128;
    private static final int[][][] INT_CACHE = new int[128][128][1];
    private static final int TWO_POW_CACHE_SIZE = 1024;
    private static final BigInteger[] TWO_POW;
    private static final BigInteger[] TWO_POW_NEG;
    private static final BigInteger[] TWO_POW_MASK;
    public static final VlogBitVector ZERO;
    public static final VlogBitVector ZERO64;
    public static final VlogBitVector ONE;
    public static final VlogBitVector NEGATIVE_ONE;
    public static final VlogBitVector BIT_ZERO;
    public static final VlogBitVector BIT_ONE;
    public static final VlogBitVector BIT_X;
    public static final VlogBitVector BIT_Z;
    public static final VlogBitVector BIT_U;
    public static final VlogBitVector BIT_UNKNOWN;
    public static final VlogBitVector FALSE;
    public static final VlogBitVector TRUE;
    public static final VlogBitVector EMPTY_STRING_CHARACTER;
    public static final VlogBitVector UNKNOWN_STRING_CHARACTER;
    public static final VlogBitVector EMPTY_CONCATENATION;
    protected final boolean is4State;
    protected final boolean sign;
    protected final int left;
    protected final int right;
    protected int[] packed;
    private BigInteger number;

    static {
        int i = 0;
        while (i < 128) {
            int j = 0;
            while (j < 128) {
                VlogBitVector.INT_CACHE[i][j] = new int[]{i, j};
                ++j;
            }
            ++i;
        }
        TWO_POW = new BigInteger[1024];
        TWO_POW_NEG = new BigInteger[1024];
        TWO_POW_MASK = new BigInteger[1024];
        VlogBitVector.TWO_POW[0] = BigInteger.ONE;
        VlogBitVector.TWO_POW_NEG[0] = TWO_POW[0].negate();
        VlogBitVector.TWO_POW_MASK[0] = BigInteger.ZERO;
        i = 1;
        while (i < 1024) {
            VlogBitVector.TWO_POW[i] = BigInteger.ONE.shiftLeft(i);
            VlogBitVector.TWO_POW_NEG[i] = TWO_POW[i].negate();
            VlogBitVector.TWO_POW_MASK[i] = TWO_POW[i].subtract(BigInteger.ONE);
            ++i;
        }
        ZERO = VlogBitVector.create(true, 31, 0, null, false, false);
        ZERO64 = VlogBitVector.create(true, 63, 0, null, false, false);
        ONE = VlogBitVector.create(true, 31, 0, null, false, false, BigInteger.ONE);
        NEGATIVE_ONE = VlogBitVector.create(true, 31, 0, null, false, false, BigInteger.valueOf(-1L));
        BIT_ZERO = VlogBitVector.create(false, 0, 0, null, false, false);
        BIT_ONE = VlogBitVector.create(false, 0, 0, null, false, false, BigInteger.ONE);
        BIT_X = VlogBitVector.create(false, 0, 0, null, true, false, false, false, null, VlogBitVector.createOneBitMaskOfType(MaskType.X));
        BIT_Z = VlogBitVector.create(false, 0, 0, null, true, false, false, false, null, VlogBitVector.createOneBitMaskOfType(MaskType.Z));
        BIT_U = VlogBitVector.create(false, 0, 0, null, true, false, false, false, null, VlogBitVector.createOneBitMaskOfType(MaskType.U));
        BIT_UNKNOWN = VlogBitVector.create(false, 0, 0, null, true, false, false, false, null, VlogBitVector.createOneBitMaskOfType(MaskType.UNKNOWN));
        FALSE = BIT_ZERO;
        TRUE = BIT_ONE;
        EMPTY_STRING_CHARACTER = VlogBitVector.create(true, 7, 0, null, false, true);
        UNKNOWN_STRING_CHARACTER = VlogBitVector.create(false, 7, 0, null, false, true, false, false, null, VlogBitVector.createMaskOfType(MaskType.UNKNOWN, 8));
        EMPTY_CONCATENATION = VlogBitVector.create(false, 0, 0, null, false, false);
    }

    public BigInteger getNumber() {
        return this.number;
    }

    public void setNumber(BigInteger number) {
        this.number = number;
    }

    public static VlogBitVector copy(VlogBitVector bs) {
        return VlogBitVector.create(bs.hasSign(), bs.getLeft(), bs.getRight(), bs.getArrayDimensions(), bs.is4State(), bs.isString(), bs.isUnion(), bs.hasUnknownSize(), bs.getMemberInfoByName(), VlogBitVector.copyMasks(bs.getMasks()), bs.bigIntegerValue());
    }

    public static VlogBitVector copy(VlogBitVector bs, boolean signed) {
        return VlogBitVector.create(signed, bs.getLeft(), bs.getRight(), bs.getArrayDimensions(), bs.is4State(), bs.isString(), bs.isUnion(), bs.hasUnknownSize(), bs.getMemberInfoByName(), VlogBitVector.copyMasks(bs.getMasks()), bs.bigIntegerValue());
    }

    public static VlogBitVector copy(VlogBitVector bs, EnumMap<MaskType, BitSet> masks) {
        boolean is4State = bs.is4State || masks != null && !masks.isEmpty() && !masks.containsKey((Object)MaskType.UNKNOWN);
        return VlogBitVector.create(bs.hasSign(), bs.getLeft(), bs.getRight(), bs.getArrayDimensions(), is4State, bs.isString(), bs.isUnion(), bs.hasUnknownSize(), bs.getMemberInfoByName(), VlogBitVector.copyMasks(masks), bs.bigIntegerValue());
    }

    public static VlogBitVector copy(VlogBitVector bs, BigInteger number) {
        return VlogBitVector.create(bs.hasSign(), bs.getLeft(), bs.getRight(), bs.getArrayDimensions(), bs.is4State(), bs.isString(), bs.isUnion(), bs.hasUnknownSize(), bs.getMemberInfoByName(), VlogBitVector.copyMasks(bs.getMasks()), number);
    }

    public static VlogBitVector copy(VlogBitVector bs, BigInteger newNumber, EnumMap<MaskType, BitSet> masks) {
        boolean is4State = bs.is4State || masks != null && !masks.isEmpty() && !masks.containsKey((Object)MaskType.UNKNOWN);
        return VlogBitVector.create(bs.sign, bs.getLeft(), bs.getRight(), bs.packed, is4State, bs.isString(), bs.isUnion(), bs.hasUnknownSize(), bs.getMemberInfoByName(), VlogBitVector.copyMasks(masks), newNumber);
    }

    public static VlogBitVector copy(VlogBitVector bs, boolean hasUnknownSize, EnumMap<MaskType, BitSet> masks) {
        if (hasUnknownSize) {
            return new VlogBitVector__unknownSize(bs.sign, bs.is4State, bs.isString());
        }
        return VlogBitVector.copy(bs, masks);
    }

    public static VlogBitVector create(boolean signed, int left, int right, BigInteger number) {
        return new VlogBitVector(signed, left, right, null, false, number);
    }

    public static VlogBitVector create(boolean signed, int left, int right, int[] packed, boolean is4State) {
        return new VlogBitVector(signed, left, right, packed, is4State, BigInteger.ZERO);
    }

    public static VlogBitVector create(boolean signed, int left, int right, int[] packed, boolean is4State, boolean isString) {
        return VlogBitVector.create(signed, left, right, packed, is4State, isString, BigInteger.ZERO);
    }

    public static VlogBitVector create(boolean signed, int left, int right, int[] packed, boolean is4State, boolean isString, BigInteger number) {
        return VlogBitVector.create(signed, left, right, packed, is4State, isString, false, false, null, null, number);
    }

    public static VlogBitVector create(boolean signed, int left, int right, int[] packed, boolean is4State, boolean isString, boolean isUnion, boolean hasUnknownSize, Map<String, StructMemberContextInfo> memberInfoByName, EnumMap<MaskType, BitSet> masks) {
        return VlogBitVector.create(signed, left, right, packed, is4State, isString, isUnion, hasUnknownSize, memberInfoByName, masks, BigInteger.ZERO);
    }

    public static VlogBitVector create(boolean signed, int left, int right, int[] packed, boolean is4State, boolean isString, boolean isUnion, boolean hasUnknownSize, Map<String, StructMemberContextInfo> memberInfoByName, EnumMap<MaskType, BitSet> masks, BigInteger number) {
        if (hasUnknownSize) {
            return new VlogBitVector__unknownSize(signed, is4State, isString);
        }
        boolean isStructInfo = memberInfoByName != null && !memberInfoByName.isEmpty();
        boolean hasMasks = VlogBitVector.hasMasks(masks);
        if (hasMasks) {
            if (isString) {
                return new VlogBitVector__mask__string(signed, left, right, packed, is4State, masks, number);
            }
            if (isStructInfo) {
                return new VlogBitVector__mask__structMemberInfo(signed, left, right, packed, is4State, isUnion, memberInfoByName, masks, number);
            }
            return new VlogBitVector__mask(signed, left, right, packed, is4State, masks, number);
        }
        if (isString) {
            return new VlogBitVector__string(false, left, right, packed, false, number);
        }
        if (isStructInfo) {
            return new VlogBitVector__structMemberInfo(signed, left, right, packed, is4State, isUnion, memberInfoByName, number);
        }
        return new VlogBitVector(signed, left, right, packed, is4State, number);
    }

    public static VlogBitVector createForSize(boolean signed, int left, int right, int[] packed, boolean is4State, boolean isString, boolean isUnion, boolean hasUnknownSize, Map<String, StructMemberContextInfo> memberInfoByName, EnumMap<MaskType, BitSet> masks) {
        return VlogBitVector.create(signed, left, right, packed, is4State, isString, isUnion, hasUnknownSize, memberInfoByName, masks, BigInteger.ZERO);
    }

    private static boolean hasMasks(EnumMap<MaskType, BitSet> masks) {
        if (masks == null) {
            return false;
        }
        for (BitSet mask : masks.values()) {
            if (mask == null || mask.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static int[] getIntPair(int i0, int i1) {
        if (i0 < 0 || i0 >= 128) {
            return new int[]{i0, i1};
        }
        if (i1 < 0 || i1 >= 128) {
            return new int[]{i0, i1};
        }
        int[] result = INT_CACHE[i0][i1];
        if (result[0] != i0 || result[1] != i1) {
            throw new UnsupportedOperationException("Cache integrity in VlogBitVector!");
        }
        return result;
    }

    protected VlogBitVector(boolean signed, int left, int right, int[] packed, boolean is4State, BigInteger number) {
        this.sign = signed;
        this.left = left;
        this.right = right;
        this.packed = packed != null && packed.length > 0 ? (packed.length > 2 ? packed : VlogBitVector.getIntPair(packed[0], packed[1])) : null;
        this.is4State = is4State;
        this.number = this.isString() ? number : VlogBitVector.convertInRange(number, this.sign, this.getSize());
    }

    protected VlogBitVector(boolean signed, int left, int right, int[] packed, boolean is4State) {
        this(signed, left, right, packed, is4State, BigInteger.ZERO);
    }

    public static VlogBitVector mergeBitVector(int elementSize, List<VlogBitVector> bitVectors, int[] arrayDimensions) {
        VlogBitVector bitVectorResult = BIT_ZERO;
        int nofBits = 0;
        int i = 0;
        while (i < bitVectors.size()) {
            VlogBitVector bitVector = bitVectors.get(i);
            int crtNofBits = elementSize < 0 ? bitVector.getSize() : elementSize;
            nofBits += crtNofBits;
            if (i > 0) {
                bitVectorResult = (VlogBitVector)DVTNumber.shiftLeft(bitVectorResult, crtNofBits, nofBits + crtNofBits);
            }
            bitVectorResult = bitVectorResult.concatenate(bitVector, nofBits);
            ++i;
        }
        if (arrayDimensions != null) {
            bitVectorResult.setArrayDimensions(arrayDimensions);
        }
        return bitVectorResult;
    }

    protected static VlogBitVector createArrayFromStructValue(VlogBitVector from, VlogBitVector initialValue, int structElementSize) {
        if (!from.isStruct(true)) {
            return VlogBitVector.create(false, from.getSize() - 1, 0, null, true, false, false, false, null, null);
        }
        LinkedHashMap<String, StructMemberContextInfo> newContextInfo = new LinkedHashMap<String, StructMemberContextInfo>();
        Map<String, StructMemberContextInfo> memberInfoByName = from.getMemberInfoByName();
        for (Map.Entry<String, StructMemberContextInfo> entry : memberInfoByName.entrySet()) {
            StructMemberContextInfo value = entry.getValue();
            StructMemberContextInfo newValue = new StructMemberContextInfo(value.startingIndex, entry.getKey(), value.context);
            newContextInfo.put(entry.getKey(), newValue);
        }
        VlogBitVector result = from instanceof VlogBitVector__mask__structMemberInfo ? new VlogBitVector__mask__structMemberInfo(from.sign, from.getLeft(), from.getRight(), from.packed, from.is4State, from.isUnion(), newContextInfo, from.getMasks()) : new VlogBitVector__structMemberInfo(from.sign, from.getLeft(), from.getRight(), from.packed, from.is4State, from.isUnion(), newContextInfo);
        int start = from.getLeft();
        while (start > from.getRight()) {
            result = result.updateSlice(start - structElementSize + 1, start, initialValue, 0, 0);
            start -= structElementSize;
        }
        return result;
    }

    public static VlogBitVector defaultFrom(BitVectorContext context, VlogBitVector defaultValue) {
        if (defaultValue == null || context == null) {
            return null;
        }
        if (!(context.getContextNumber() instanceof VlogBitVector)) {
            return null;
        }
        VlogBitVector contextNumber = (VlogBitVector)context.getContextNumber();
        if (contextNumber.isStruct(true)) {
            int structSize = ((IDVTMemberSelectable)((Object)contextNumber)).getSizeIgnoreDimensions();
            VlogBitVector structWithDefaultValue = VlogBitVector.getStructDefaultValueFrom(contextNumber, structSize, defaultValue);
            int[] structPacked = contextNumber.getArrayDimensions();
            if (structPacked.length == 2) {
                return structWithDefaultValue;
            }
            return VlogBitVector.createArrayFromStructValue(contextNumber, structWithDefaultValue, structSize);
        }
        int[] firstDimension = contextNumber.getFirstDimension();
        if (firstDimension == null) {
            return null;
        }
        int firstDimensionSize = Math.abs(firstDimension[0] - firstDimension[1]) + 1;
        int expectedElementSize = contextNumber.getElementSize();
        int actualElementSize = defaultValue.getSize();
        List<VlogBitVector> result = null;
        if (expectedElementSize == actualElementSize) {
            result = Collections.nCopies(firstDimensionSize, defaultValue);
        } else {
            if (expectedElementSize == 1) {
                return (VlogBitVector)context.transform(defaultValue);
            }
            VlogBitVector newContextNumber = contextNumber.decreaseDimension();
            if (newContextNumber == null) {
                return null;
            }
            VlogBitVector defaultFrom = VlogBitVector.defaultFrom(BitVectorContext.of(newContextNumber, context.getOrigin()), defaultValue);
            result = Collections.nCopies(firstDimensionSize, defaultFrom);
        }
        return VlogBitVector.mergeBitVector(expectedElementSize, result, null);
    }

    protected static VlogBitVector getStructDefaultValueFrom(VlogBitVector struct, int structSize, VlogBitVector defaultValue) {
        if (!struct.isStruct(true)) {
            return VlogBitVector.create(false, struct.getSize() - 1, 0, null, true, false, false, false, null, null);
        }
        Map<String, StructMemberContextInfo> memberInfoByName = struct.getMemberInfoByName();
        int[] structPacked = struct.getArrayDimensions();
        boolean hasExtraPacked = structPacked.length > 2;
        int[] newPacked = new int[2];
        System.arraycopy(structPacked, hasExtraPacked ? structPacked.length - 2 : 0, newPacked, 0, 2);
        VlogBitVector result = struct instanceof VlogBitVector__mask__structMemberInfo ? new VlogBitVector__mask__structMemberInfo(struct.hasSign(), structSize - 1, 0, newPacked, struct.is4State(), false, memberInfoByName, VlogBitVector.copyMasks(struct.getMasks())) : new VlogBitVector__structMemberInfo(struct.hasSign(), structSize - 1, 0, newPacked, struct.is4State(), false, memberInfoByName);
        for (Map.Entry<String, StructMemberContextInfo> entry : memberInfoByName.entrySet()) {
            String name = entry.getKey();
            StructMemberContextInfo info = entry.getValue();
            VlogBitVector structMemberUpdateValue = VlogBitVector.defaultFrom(info.context, defaultValue);
            result = (VlogBitVector)((IDVTMemberSelectable)((Object)result)).updateMemberSelects(new IHidEvaluator.NullHidEvaluator(), structMemberUpdateValue, Arrays.asList(new HidNameAndSelects(name)), null);
        }
        return result;
    }

    public static VlogBitVector all(MaskType type, int resultSize) {
        BitSet mask = VlogBitVector.createMask(resultSize, BitSetUtils.getPowerOfTwoMask(resultSize));
        EnumMap<MaskType, BitSet> masks = new EnumMap<MaskType, BitSet>(MaskType.class);
        masks.put(type, mask);
        return VlogBitVector.create(false, resultSize - 1, 0, null, true, false, false, false, null, masks);
    }

    public static EnumMap<MaskType, BitSet> copyMasks(EnumMap<MaskType, BitSet> masks) {
        return VlogBitVector.copyMasks(masks, MaskType.AllMasks);
    }

    public static EnumMap<MaskType, BitSet> copyMasks(EnumMap<MaskType, BitSet> masks, Set<MaskType> masksToInclude) {
        if (masks == null || masks.isEmpty()) {
            return null;
        }
        EnumMap<MaskType, BitSet> masksCopy = null;
        for (Map.Entry<MaskType, BitSet> maskEntry : masks.entrySet()) {
            BitSet mask = maskEntry.getValue();
            if (mask == null || mask.isEmpty() || !masksToInclude.contains((Object)maskEntry.getKey())) continue;
            if (masksCopy == null) {
                masksCopy = new EnumMap<MaskType, BitSet>(MaskType.class);
            }
            masksCopy.put(maskEntry.getKey(), (BitSet)mask.clone());
        }
        return masksCopy;
    }

    public boolean hasMask(MaskType type, int index) {
        return false;
    }

    public static EnumMap<MaskType, BitSet> createOneBitMaskOfType(MaskType type) {
        EnumMap<MaskType, BitSet> masks = new EnumMap<MaskType, BitSet>(MaskType.class);
        masks.put(type, VlogBitVector.createMask(1, BitSetUtils.valueOf(1)));
        return masks;
    }

    public static EnumMap<MaskType, BitSet> createMaskOfType(MaskType type, int size) {
        EnumMap<MaskType, BitSet> masks = new EnumMap<MaskType, BitSet>(MaskType.class);
        masks.put(type, VlogBitVector.createMask(size, BitSetUtils.getPowerOfTwoMask(size)));
        return masks;
    }

    public static BitSet createMask(int size, BitSet mask) {
        if (mask == null || mask.isEmpty()) {
            return null;
        }
        return VlogBitVector.convertInRange(mask, size);
    }

    public VlogBitVector getAmbiguousBitResult() {
        return null;
    }

    public VlogBitVector getAmbiguousBitResult(VlogBitVector bs) {
        return bs.getAmbiguousBitResult();
    }

    @Override
    public int getSize() {
        return Math.abs(this.getLeft() - this.getRight()) + 1;
    }

    @Override
    public boolean hasSign() {
        return this.sign;
    }

    public boolean isReversed() {
        int[] firstDimension = this.getFirstDimension();
        if (firstDimension == null) {
            return false;
        }
        return firstDimension[0] < firstDimension[1];
    }

    @Override
    public boolean is4State() {
        return this.is4State;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.getNumber();
    }

    @Override
    public int intValue() {
        int intValue = this.getNumber().intValue();
        if (!this.sign && intValue < 0) {
            return intValue & Integer.MAX_VALUE;
        }
        return intValue;
    }

    public int[] getArrayDimensions() {
        if (this.packed == null) {
            this.packed = VlogBitVector.getIntPair(this.getSize() - 1, 0);
        }
        return this.packed;
    }

    protected void setArrayDimensions(int[] packed) {
        if (packed != null && packed.length == 1) {
            packed = VlogBitVector.getIntPair(packed[0], packed[1]);
        }
        this.packed = packed;
    }

    public int[][] getArrayUnpackedDimensions() {
        return null;
    }

    @Override
    protected int pack(DVTNumber[] result, int resultSize) {
        result[0] = this;
        return resultSize;
    }

    private void decreaseDimensionNoNewObject() {
        if (this.packed == null) {
            return;
        }
        if (this.packed.length == 1) {
            this.packed = null;
        } else {
            this.packed = Arrays.copyOfRange(this.packed, 2, this.packed.length);
            if (this.packed.length == 2) {
                this.packed = VlogBitVector.getIntPair(this.packed[0], this.packed[1]);
            }
        }
    }

    @Override
    public DVTNumber getDefaultValue(boolean force4State) {
        if (force4State || this.is4State()) {
            return VlogBitVector.copy(this, VlogBitVector.createMaskOfType(MaskType.X, this.getSize()));
        }
        return VlogBitVector.copy(this);
    }

    @Override
    public boolean isString() {
        return false;
    }

    public boolean isEmptyString() {
        return false;
    }

    @Override
    public DVTNumber from(DVTNumber number, boolean isCast) {
        if (number instanceof VlogBitVector) {
            return this.from((VlogBitVector)number);
        }
        if (number instanceof VlogAbstractRealNumber) {
            return this.from((VlogAbstractRealNumber)number);
        }
        if (number instanceof DVTUnpackedArray || number instanceof DVTUnpackedStruct) {
            return isCast ? this.from(VlogBitVector.pack(number), isCast) : DVTNumber.UNDEFINED;
        }
        return number;
    }

    protected VlogBitVector from(VlogAbstractRealNumber bs) {
        if (bs.isUnknown()) {
            int size = this.getSize();
            return new VlogBitVector__mask(this.hasSign(), size - 1, 0, this.packed, this.is4State(), VlogBitVector.createMaskOfType(MaskType.UNKNOWN, size), BigInteger.ZERO);
        }
        return new VlogBitVector(this.hasSign(), this.getSize() - 1, 0, this.packed, this.is4State, bs.bigIntegerValue());
    }

    public VlogBitVector from(VlogBitVector bs) {
        int end;
        int start;
        int resultSize = this.getSize() - 1;
        if (bs.getLeft() >= bs.getRight()) {
            start = resultSize;
            end = 0;
        } else {
            start = 0;
            end = resultSize;
        }
        VlogBitVector result = bs.getRange(start, end, this.hasSign(), false, this.is4State(), this.isString(), this.getMemberInfoByName());
        result.setArrayDimensions(this.getArrayDimensions());
        result.convertInRangeNoNewObject();
        return result;
    }

    public VlogBitVector fromXUnsizedLiteral(VlogBitVector bs) {
        int end;
        int start;
        int resultSize = this.getSize() - 1;
        if (bs.getLeft() >= bs.getRight()) {
            start = resultSize;
            end = 0;
        } else {
            start = 0;
            end = resultSize;
        }
        VlogBitVector result = bs.getRange(start, end, this.hasSign(), true, this.is4State(), this.isString(), this.getMemberInfoByName());
        result.setArrayDimensions(this.getArrayDimensions());
        result.convertInRangeNoNewObject();
        return result;
    }

    public VlogBitVector not() {
        BigInteger finalNumber = this.getNumber().not();
        EnumMap<MaskType, BitSet> masks = null;
        if (this.isAmbiguous()) {
            BitSet rxMask = BitSetUtils.valueOf(0);
            BitSet ruMask = BitSetUtils.valueOf(0);
            BitSet rUnknownMask = BitSetUtils.valueOf(0);
            int i = this.getSize() - 1;
            while (i >= 0) {
                if (this.hasMask(MaskType.UNKNOWN, i)) {
                    rUnknownMask.set(i);
                    finalNumber = finalNumber.clearBit(i);
                } else if (this.hasMask(MaskType.X, i) || this.hasMask(MaskType.Z, i) || this.hasMask(MaskType.W, i) || this.hasMask(MaskType.DASH, i)) {
                    rxMask.set(i);
                    finalNumber = finalNumber.clearBit(i);
                } else if (this.hasMask(MaskType.U, i)) {
                    ruMask.set(i);
                    finalNumber = finalNumber.clearBit(i);
                } else if (this.hasMask(MaskType.H, i)) {
                    finalNumber = finalNumber.clearBit(i);
                } else if (this.hasMask(MaskType.L, i)) {
                    finalNumber = finalNumber.setBit(i);
                }
                --i;
            }
            masks = new EnumMap<MaskType, BitSet>(MaskType.class);
            if (!rxMask.isEmpty()) {
                masks.put(MaskType.X, rxMask);
            }
            if (!ruMask.isEmpty()) {
                masks.put(MaskType.U, ruMask);
            }
            if (!rUnknownMask.isEmpty()) {
                masks.put(MaskType.UNKNOWN, rUnknownMask);
            }
            if (masks.isEmpty()) {
                masks = null;
            }
        }
        return VlogBitVector.create(this.sign, this.getLeft(), this.getRight(), this.packed, this.is4State, false, this.isUnion(), this.hasUnknownSize(), this.getMemberInfoByName(), masks, finalNumber);
    }

    private BitSet getDefaultMask(MaskType type) {
        BitSet mask = this.getMask(type);
        if (mask != null) {
            return mask;
        }
        return BitSetUtils.valueOf(0);
    }

    public VlogBitVector plus(VlogBitVector bs) {
        return this.plus(bs, Integer.max(this.getSize(), bs.getSize()));
    }

    public VlogBitVector concatenate(VlogBitVector bs, int resultSize) {
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = bs;
        EnumMap<MaskType, BitSet> resultMasks = new EnumMap<MaskType, BitSet>(MaskType.class);
        if (thisBS.isAmbiguous() || otherBS.isAmbiguous()) {
            for (MaskType maskType : MaskType.NonDriveStrengthMasks) {
                if (thisBS.getMask(maskType) == null && otherBS.getMask(maskType) == null) continue;
                BitSet thisMask = (BitSet)thisBS.getDefaultMask(maskType).clone();
                BitSet otherMask = otherBS.getDefaultMask(maskType);
                thisMask.or(otherMask);
                resultMasks.put(maskType, thisMask);
            }
        }
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        return VlogBitVector.create(resultSign, resultSize - 1, 0, null, this.is4State(), this.isString(), false, false, this.getMemberInfoByName(), resultMasks, thisNumber.add(otherNumber));
    }

    public VlogBitVector plus(VlogBitVector bs, int resultSize) {
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        VlogBitVector create = VlogBitVector.create(resultSign, resultSize - 1, 0, this.packed, this.is4State, false, false, false, this.getMemberInfoByName(), null, thisNumber.add(otherNumber));
        return create;
    }

    public VlogBitVector minus(VlogBitVector bs) {
        return this.minus(bs, Integer.max(this.getSize(), bs.getSize()));
    }

    public VlogBitVector minus(VlogBitVector bs, int resultSize) {
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        return VlogBitVector.create(resultSign, resultSize - 1, 0, this.packed, this.is4State, false, false, false, this.getMemberInfoByName(), null, thisNumber.subtract(otherNumber));
    }

    public VlogBitVector multiply(VlogBitVector bs) {
        return this.multiply(bs, Integer.max(this.getSize(), bs.getSize()));
    }

    public VlogBitVector multiply(VlogBitVector bs, int resultSize) {
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        return VlogBitVector.create(resultSign, resultSize - 1, 0, this.packed, this.is4State, false, false, false, this.getMemberInfoByName(), null, thisNumber.multiply(otherNumber));
    }

    public VlogBitVector divide(VlogBitVector bs) {
        return this.divide(bs, Integer.max(this.getSize(), bs.getSize()));
    }

    public VlogBitVector divide(VlogBitVector bs, int resultSize) {
        if (bs.equals(ZERO)) {
            return VlogBitVector.all(MaskType.X, resultSize);
        }
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        return VlogBitVector.create(resultSign, resultSize - 1, 0, this.packed, this.is4State, false, false, false, this.getMemberInfoByName(), null, thisNumber.divide(otherNumber));
    }

    public VlogBitVector mod(VlogBitVector bs) {
        return this.mod(bs, Integer.max(this.getSize(), bs.getSize()));
    }

    public VlogBitVector mod(VlogBitVector bs, int resultSize) {
        if (bs.equals(ZERO)) {
            return VlogBitVector.all(MaskType.X, resultSize);
        }
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        return VlogBitVector.create(resultSign, resultSize - 1, 0, this.packed, this.is4State, false, false, false, this.getMemberInfoByName(), null, thisNumber.remainder(otherNumber));
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    public VlogBitVector pow(int exponent, int resultSize) {
        VlogBitVector result = VlogBitVector.create(this.sign, resultSize - 1, 0, this.packed, this.is4State, false, false, false, this.getMemberInfoByName(), null, this.getNumber());
        if (exponent == 0) {
            return result.from(ONE);
        }
        VlogBitVector thisBS = this;
        BigInteger thisNumber = thisBS.getNumber();
        if (thisNumber.compareTo(BigInteger.ONE) == 0) {
            return result.from(ONE);
        }
        if (exponent < 0 && (thisNumber.compareTo(BigInteger.valueOf(-1L)) < 0 || thisNumber.compareTo(BigInteger.ONE) > 0)) {
            return result.from(ZERO);
        }
        if (thisNumber.compareTo(BigInteger.ZERO) == 0) {
            if (exponent > 0) {
                return result.from(ZERO);
            }
            if (exponent < 0) {
                return VlogBitVector.all(MaskType.X, resultSize);
            }
        }
        if (thisNumber.compareTo(BigInteger.valueOf(-1L)) == 0 && exponent < 0) {
            if (exponent % 2 == 0) {
                return result.from(ONE);
            }
            return result.from(NEGATIVE_ONE);
        }
        BigInteger finalNumber = thisNumber.modPow(BigInteger.valueOf(exponent), VlogBitVector.getPowerOfTwo(resultSize));
        return VlogBitVector.create(this.sign, resultSize - 1, 0, this.packed, this.is4State, false, false, false, this.getMemberInfoByName(), null, finalNumber);
    }

    public VlogBitVector and(VlogBitVector bs, int resultSize) {
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        BigInteger finalNumber = thisNumber.and(otherNumber);
        EnumMap<MaskType, BitSet> masks = null;
        if (thisBS.isAmbiguous() || otherBS.isAmbiguous()) {
            BitSet rxMask = BitSetUtils.valueOf(0);
            BitSet ruMask = BitSetUtils.valueOf(0);
            BitSet rUnknownMask = BitSetUtils.valueOf(0);
            int i = resultSize - 1;
            while (i >= 0) {
                boolean otherHasXZWDash;
                boolean thisHasU = thisBS.hasMask(MaskType.U, i);
                boolean thisHasH = thisBS.hasMask(MaskType.H, i);
                boolean thisHasUnknown = thisBS.hasMask(MaskType.UNKNOWN, i);
                boolean thisHasXZWDash = thisBS.hasMask(MaskType.X, i) || thisBS.hasMask(MaskType.Z, i) || thisBS.hasMask(MaskType.W, i) || thisBS.hasMask(MaskType.DASH, i);
                boolean otherHasU = otherBS.hasMask(MaskType.U, i);
                boolean otherHasH = otherBS.hasMask(MaskType.H, i);
                boolean otherHasUnknown = otherBS.hasMask(MaskType.UNKNOWN, i);
                boolean bl = otherHasXZWDash = otherBS.hasMask(MaskType.X, i) || otherBS.hasMask(MaskType.Z, i) || otherBS.hasMask(MaskType.W, i) || otherBS.hasMask(MaskType.DASH, i);
                if (thisHasUnknown) {
                    if (otherHasXZWDash | otherHasUnknown | otherHasU | otherHasH || otherNumber.testBit(i)) {
                        rUnknownMask.set(i);
                    }
                } else if (otherHasUnknown) {
                    if (thisHasXZWDash | thisHasUnknown | thisHasU | thisHasH || thisNumber.testBit(i)) {
                        rUnknownMask.set(i);
                    }
                } else if (thisHasU) {
                    if (otherHasXZWDash | otherHasU | otherHasH || otherNumber.testBit(i)) {
                        ruMask.set(i);
                    }
                } else if (otherHasU) {
                    if (thisHasXZWDash | thisHasU | thisHasH || thisNumber.testBit(i)) {
                        ruMask.set(i);
                    }
                } else if (thisHasXZWDash) {
                    if (otherHasXZWDash || otherNumber.testBit(i)) {
                        rxMask.set(i);
                    }
                } else if (thisHasH || thisNumber.testBit(i)) {
                    if (otherHasXZWDash) {
                        rxMask.set(i);
                    }
                } else if (thisBS.hasMask(MaskType.L, i) || otherBS.hasMask(MaskType.L, i)) {
                    finalNumber = finalNumber.clearBit(i);
                }
                --i;
            }
            masks = new EnumMap<MaskType, BitSet>(MaskType.class);
            if (!rxMask.isEmpty()) {
                masks.put(MaskType.X, rxMask);
            }
            if (!ruMask.isEmpty()) {
                masks.put(MaskType.U, ruMask);
            }
            if (!rUnknownMask.isEmpty()) {
                masks.put(MaskType.UNKNOWN, rUnknownMask);
            }
            if (masks.isEmpty()) {
                masks = null;
            }
        }
        return VlogBitVector.create(resultSign, resultSize - 1, 0, this.packed, this.is4State, false, false, false, this.getMemberInfoByName(), masks, finalNumber);
    }

    public VlogBitVector or(VlogBitVector bs) {
        return this.or(bs, Integer.max(this.getSize(), bs.getSize()));
    }

    public VlogBitVector or(VlogBitVector bs, int resultSize) {
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        BigInteger finalNumber = thisNumber.or(otherNumber);
        EnumMap<MaskType, BitSet> masks = null;
        if (thisBS.isAmbiguous() || otherBS.isAmbiguous()) {
            BitSet rxMask = BitSetUtils.valueOf(0);
            BitSet ruMask = BitSetUtils.valueOf(0);
            BitSet rUnknownMask = BitSetUtils.valueOf(0);
            int i = resultSize - 1;
            while (i >= 0) {
                boolean otherHasXZWDash;
                boolean thisHasU = thisBS.hasMask(MaskType.U, i);
                boolean thisHasL = thisBS.hasMask(MaskType.L, i);
                boolean thisHasUnknown = thisBS.hasMask(MaskType.UNKNOWN, i);
                boolean thisHasXZWDash = thisBS.hasMask(MaskType.X, i) || thisBS.hasMask(MaskType.Z, i) || thisBS.hasMask(MaskType.W, i) || thisBS.hasMask(MaskType.DASH, i);
                boolean otherHasU = otherBS.hasMask(MaskType.U, i);
                boolean otherHasL = otherBS.hasMask(MaskType.L, i);
                boolean otherHasUnknown = otherBS.hasMask(MaskType.UNKNOWN, i);
                boolean bl = otherHasXZWDash = otherBS.hasMask(MaskType.X, i) || otherBS.hasMask(MaskType.Z, i) || otherBS.hasMask(MaskType.W, i) || otherBS.hasMask(MaskType.DASH, i);
                if (thisHasUnknown) {
                    if (otherHasXZWDash | otherHasUnknown | otherHasU | otherHasL || !otherNumber.testBit(i)) {
                        rUnknownMask.set(i);
                    }
                } else if (otherHasUnknown) {
                    if (thisHasXZWDash | thisHasUnknown | thisHasU | thisHasL || !thisNumber.testBit(i)) {
                        rUnknownMask.set(i);
                    }
                } else if (thisHasU) {
                    if (otherHasXZWDash | otherHasU | otherHasL || !otherNumber.testBit(i)) {
                        ruMask.set(i);
                    }
                } else if (otherHasU) {
                    if (thisHasXZWDash | thisHasU | thisHasL || !thisNumber.testBit(i)) {
                        ruMask.set(i);
                    }
                } else if (thisHasXZWDash) {
                    if (otherHasXZWDash || !otherNumber.testBit(i)) {
                        rxMask.set(i);
                    }
                } else if (thisHasL || !thisNumber.testBit(i)) {
                    if (otherHasXZWDash) {
                        rxMask.set(i);
                    }
                } else if (thisBS.hasMask(MaskType.H, i) || otherBS.hasMask(MaskType.H, i)) {
                    finalNumber = finalNumber.setBit(i);
                }
                --i;
            }
            masks = new EnumMap<MaskType, BitSet>(MaskType.class);
            if (!rxMask.isEmpty()) {
                masks.put(MaskType.X, rxMask);
            }
            if (!ruMask.isEmpty()) {
                masks.put(MaskType.U, ruMask);
            }
            if (!rUnknownMask.isEmpty()) {
                masks.put(MaskType.UNKNOWN, rUnknownMask);
            }
            if (masks.isEmpty()) {
                masks = null;
            }
        }
        return VlogBitVector.create(resultSign, resultSize - 1, 0, this.packed, this.is4State, false, false, false, this.getMemberInfoByName(), masks, finalNumber);
    }

    public DVTNumber wildEqual(VlogBitVector bs) {
        VlogBitVector left = this;
        VlogBitVector right = bs;
        int leftSize = left.getSize();
        boolean isLeftAmbigous = this.isAmbiguous();
        boolean isRightAmbigous = bs.isAmbiguous();
        if (!isLeftAmbigous && !isRightAmbigous) {
            return VlogBitVector.eq(left, right) ? BIT_ONE : BIT_ZERO;
        }
        boolean isUnknownEqual = false;
        boolean isXEqual = false;
        int i = 0;
        while (i < leftSize) {
            boolean rightHasZ;
            boolean rightHasUnknown = right.hasMask(MaskType.UNKNOWN, i);
            if (rightHasUnknown) {
                return BIT_UNKNOWN;
            }
            boolean rightHasX = right.hasMask(MaskType.X, i);
            if (!rightHasX && !(rightHasZ = right.hasMask(MaskType.Z, i))) {
                boolean leftHasUnknown = left.hasMask(MaskType.UNKNOWN, i);
                if (leftHasUnknown) {
                    isUnknownEqual = true;
                } else {
                    boolean leftHasX = left.hasMask(MaskType.X, i);
                    if (leftHasX) {
                        isXEqual = true;
                    } else {
                        boolean leftHasZ = left.hasMask(MaskType.Z, i);
                        if (leftHasZ) {
                            isXEqual = true;
                        } else {
                            boolean rightBitValue;
                            boolean leftBitValue = left.getNumber().testBit(i);
                            if (leftBitValue != (rightBitValue = right.getNumber().testBit(i))) {
                                return BIT_ZERO;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return isUnknownEqual ? BIT_UNKNOWN : (isXEqual ? BIT_X : BIT_ONE);
    }

    public VlogBitVector xor(VlogBitVector bs) {
        return this.xor(bs, Integer.max(this.getSize(), bs.getSize()));
    }

    public VlogBitVector xor(VlogBitVector bs, int resultSize) {
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        BigInteger finalNumber = thisNumber.xor(otherNumber);
        EnumMap<MaskType, BitSet> masks = null;
        if (thisBS.isAmbiguous() || otherBS.isAmbiguous()) {
            BitSet rxMask = BitSetUtils.valueOf(0);
            BitSet ruMask = BitSetUtils.valueOf(0);
            BitSet rUnknownMask = BitSetUtils.valueOf(0);
            int i = resultSize - 1;
            while (i >= 0) {
                if (thisBS.hasMask(MaskType.UNKNOWN, i) || otherBS.hasMask(MaskType.UNKNOWN, i)) {
                    rUnknownMask.set(i);
                    finalNumber = finalNumber.clearBit(i);
                } else if (thisBS.hasMask(MaskType.U, i) || otherBS.hasMask(MaskType.U, i)) {
                    ruMask.set(i);
                    finalNumber = finalNumber.clearBit(i);
                } else if (thisBS.hasMask(MaskType.X, i) || thisBS.hasMask(MaskType.Z, i) || thisBS.hasMask(MaskType.W, i) || thisBS.hasMask(MaskType.DASH, i) || otherBS.hasMask(MaskType.X, i) || otherBS.hasMask(MaskType.Z, i) || otherBS.hasMask(MaskType.W, i) || otherBS.hasMask(MaskType.DASH, i)) {
                    rxMask.set(i);
                    finalNumber = finalNumber.clearBit(i);
                } else if (thisBS.hasMask(MaskType.H, i)) {
                    if (otherBS.hasMask(MaskType.H, i)) {
                        finalNumber = finalNumber.clearBit(i);
                    } else if (otherBS.hasMask(MaskType.L, i)) {
                        finalNumber = finalNumber.setBit(i);
                    }
                } else if (thisBS.hasMask(MaskType.L, i)) {
                    if (otherBS.hasMask(MaskType.H, i)) {
                        finalNumber = finalNumber.setBit(i);
                    } else if (otherBS.hasMask(MaskType.L, i)) {
                        finalNumber = finalNumber.clearBit(i);
                    }
                }
                --i;
            }
            masks = new EnumMap<MaskType, BitSet>(MaskType.class);
            if (!rxMask.isEmpty()) {
                masks.put(MaskType.X, rxMask);
            }
            if (!ruMask.isEmpty()) {
                masks.put(MaskType.U, ruMask);
            }
            if (!rUnknownMask.isEmpty()) {
                masks.put(MaskType.UNKNOWN, rUnknownMask);
            }
            if (masks.isEmpty()) {
                masks = null;
            }
        }
        return VlogBitVector.create(resultSign, resultSize - 1, 0, this.packed, this.is4State, false, false, false, this.getMemberInfoByName(), masks, finalNumber);
    }

    public VlogBitVector shiftLeft(int shl) {
        return this.shiftLeft(shl, this.getSize());
    }

    public VlogBitVector shiftLeft(int shl, int resultSize) {
        EnumMap<MaskType, BitSet> masks = this.getMasks();
        EnumMap<MaskType, BitSet> resultMasks = null;
        if (masks != null && !masks.isEmpty()) {
            for (Map.Entry<MaskType, BitSet> entry : masks.entrySet()) {
                BitSet shiftLeftMask;
                BitSet mask = entry.getValue();
                if (mask == null || mask.isEmpty() || (shiftLeftMask = BitSetUtils.shiftLeft(mask, shl)).isEmpty()) continue;
                if (resultMasks == null) {
                    resultMasks = new EnumMap<MaskType, BitSet>(MaskType.class);
                }
                resultMasks.put(entry.getKey(), shiftLeftMask);
            }
        }
        BigInteger finalNumber = this.getNumber();
        try {
            finalNumber = finalNumber.shiftLeft(shl);
        }
        catch (Exception exception) {}
        return VlogBitVector.create(this.sign, resultSize - 1, 0, null, this.is4State(), false, this.isUnion(), false, null, resultMasks, finalNumber);
    }

    public VlogBitVector shiftRight(int shr, boolean keepSign) {
        return this.shiftRight(shr, keepSign, this.getSize());
    }

    public VlogBitVector shiftRight(int shr, boolean keepSign, int resultSize) {
        EnumMap<MaskType, BitSet> resultMasks = null;
        EnumMap<MaskType, BitSet> masks = this.getMasks();
        if (masks != null && !masks.isEmpty()) {
            BitSet signExtMask = null;
            int size = this.getSize();
            for (Map.Entry<MaskType, BitSet> entry : masks.entrySet()) {
                boolean isExtendSign;
                BitSet currentMask = entry.getValue();
                if (currentMask == null || currentMask.isEmpty()) continue;
                BitSet finalMaskNumber = BitSetUtils.shiftAndMask(currentMask, shr, resultSize);
                MaskType maskType = entry.getKey();
                boolean bl = isExtendSign = keepSign && this.hasSign();
                if (isExtendSign && resultSize > size - shr && currentMask.get(size - 1) && (maskType == MaskType.Z || maskType == MaskType.X)) {
                    if (signExtMask == null) {
                        signExtMask = BitSetUtils.getPowerOfTwoMaskShiftLeft(shr, size - shr);
                    }
                    finalMaskNumber.or(signExtMask);
                }
                if (finalMaskNumber.isEmpty()) continue;
                if (resultMasks == null) {
                    resultMasks = new EnumMap<MaskType, BitSet>(MaskType.class);
                }
                resultMasks.put(entry.getKey(), finalMaskNumber);
            }
        }
        BigInteger resultNumber = VlogBitVector.convertInRange(this.getNumber(), keepSign && this.hasSign(), resultSize);
        return VlogBitVector.create(this.hasSign(), resultSize - 1, 0, null, this.is4State(), false, this.isUnion(), false, null, resultMasks, resultNumber.shiftRight(shr));
    }

    public VlogBitVector abs() {
        return VlogBitVector.copy(this, this.getNumber().abs(), this.getMasks());
    }

    public VlogBitVector min(DVTNumber value) {
        return VlogBitVector.copy(this, this.getNumber().min(value.bigIntegerValue()), this.getMasks());
    }

    public VlogBitVector max(DVTNumber value) {
        return VlogBitVector.copy(this, this.getNumber().max(value.bigIntegerValue()), this.getMasks());
    }

    public VlogBitVector band() {
        boolean isUnknown = false;
        boolean isX = false;
        boolean isU = false;
        int i = Math.min(this.getLeft(), this.getRight());
        while (i < this.getSize() + Math.min(this.getLeft(), this.getRight())) {
            if (this.hasMask(MaskType.UNKNOWN, i)) {
                isUnknown |= true;
            } else if (this.hasMask(MaskType.U, i)) {
                isU |= true;
            } else if (this.hasMask(MaskType.X, i) || this.hasMask(MaskType.Z, i) || this.hasMask(MaskType.W, i) || this.hasMask(MaskType.DASH, i)) {
                isX |= true;
            } else if (!this.getNumber().testBit(i) || this.hasMask(MaskType.L, i)) {
                return BIT_ZERO;
            }
            ++i;
        }
        return isUnknown ? BIT_UNKNOWN : (isU ? BIT_U : (isX ? BIT_X : BIT_ONE));
    }

    public VlogBitVector nband() {
        return this.band().not();
    }

    public VlogBitVector bor() {
        boolean isUnknown = false;
        boolean isX = false;
        boolean isU = false;
        int i = Math.min(this.getLeft(), this.getRight());
        while (i < this.getSize() + Math.min(this.getLeft(), this.getRight())) {
            if (this.getNumber().testBit(i) || this.hasMask(MaskType.H, i)) {
                return BIT_ONE;
            }
            if (this.hasMask(MaskType.UNKNOWN, i)) {
                isUnknown |= true;
            } else if (this.hasMask(MaskType.U, i)) {
                isU |= true;
            } else if (this.hasMask(MaskType.X, i) || this.hasMask(MaskType.Z, i) || this.hasMask(MaskType.W, i) || this.hasMask(MaskType.DASH, i)) {
                isX |= true;
            }
            ++i;
        }
        return isUnknown ? BIT_UNKNOWN : (isU ? BIT_U : (isX ? BIT_X : BIT_ZERO));
    }

    public VlogBitVector nbor() {
        return this.bor().not();
    }

    public VlogBitVector bxor() {
        boolean isX = false;
        boolean result = false;
        int i = Math.min(this.getLeft(), this.getRight());
        while (i <= Math.max(this.getLeft(), this.getRight())) {
            if (this.hasMask(MaskType.UNKNOWN, i)) {
                return BIT_UNKNOWN;
            }
            if (this.hasMask(MaskType.U, i)) {
                return BIT_U;
            }
            if (this.hasMask(MaskType.X, i) || this.hasMask(MaskType.Z, i) || this.hasMask(MaskType.W, i) || this.hasMask(MaskType.DASH, i)) {
                isX |= true;
            }
            result ^= this.getNumber().testBit(i);
            ++i;
        }
        return isX ? BIT_X : (result ? BIT_ONE : BIT_ZERO);
    }

    public VlogBitVector nbxor() {
        return this.bxor().not();
    }

    public boolean gte(VlogBitVector bs) {
        return this.equals(bs) || this.gt(bs);
    }

    public boolean gt(VlogBitVector bs) {
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        return thisNumber.compareTo(otherNumber) > 0;
    }

    public boolean lte(VlogBitVector bs) {
        return this.equals(bs) || this.lt(bs);
    }

    public boolean lt(VlogBitVector bs) {
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        return thisNumber.compareTo(otherNumber) < 0;
    }

    public VlogBitVector clog2() {
        BigInteger intermediate = this.hasSign() && this.getNumber().signum() < 0 ? this.getNumber().and(VlogBitVector.getPowerOfTwoMask(this.getSize())) : this.getNumber();
        double finalValue = StrictMath.log(intermediate.doubleValue()) / StrictMath.log(2.0);
        VlogBitVector result = VlogBitVector.create(true, 31, 0, null, false, false, BigInteger.valueOf(finalValue == 0.0 ? 0L : (long)StrictMath.ceil(finalValue)));
        return result;
    }

    public int countBits(CONTROL_BIT bit) {
        if (this.getLeft() < 0 || this.getRight() < 0) {
            throw new IllegalArgumentException(this.getLeft() < 0 ? "Left index is negative" : "Right index is negative");
        }
        if (bit != CONTROL_BIT.ONE && bit != CONTROL_BIT.ZERO && bit != CONTROL_BIT.X && bit != CONTROL_BIT.Z) {
            return -1;
        }
        int left = Integer.max(this.getLeft(), this.getRight());
        int right = Integer.min(this.getLeft(), this.getRight());
        int result = 0;
        if (bit == CONTROL_BIT.X || bit == CONTROL_BIT.Z) {
            bit = CONTROL_BIT.ONE;
            BitSet mask = null;
            if (bit == CONTROL_BIT.X) {
                mask = this.getMask(MaskType.X);
            } else if (bit == CONTROL_BIT.Z) {
                mask = this.getMask(MaskType.Z);
            }
            if (mask == null) {
                return 0;
            }
            int i = left;
            while (i >= right) {
                result += mask.get(i) ? 1 : 0;
                --i;
            }
            return result;
        }
        BigInteger value = this.getNumber();
        int i = left;
        while (i >= right) {
            result += value.testBit(i) ^ bit == CONTROL_BIT.ONE ? 0 : 1;
            --i;
        }
        return result;
    }

    @Override
    public DVTNumber updateSelects(DVTNumber updateValue, ListContainer<XComputedSelect> computedSelects) {
        if (this.packed == null) {
            this.packed = VlogBitVector.getIntPair(this.getSize() - 1, 0);
        }
        if (this.packed == null || this.packed.length == 0 || computedSelects == null || computedSelects.isEmpty()) {
            return this;
        }
        int index = 0;
        int[] arrayDimensions = this.getArrayDimensions();
        int size = this.getSize();
        int[] nArray = new int[2];
        nArray[1] = size - 1;
        int[] finalSelect = nArray;
        boolean isString = this.isString();
        int ignoreBitsLeft = 0;
        int ignoreBitsRight = 0;
        for (XComputedSelect select : computedSelects) {
            int select1IntValue;
            DVTNumber select1Number;
            if (index + 1 >= arrayDimensions.length) {
                return this;
            }
            int thisDimension0 = arrayDimensions[index];
            int thisDimension1 = arrayDimensions[index + 1];
            size /= Math.abs(thisDimension0 - thisDimension1) + 1;
            if (isString) {
                size *= 8;
            }
            DVTNumber select0Number = select.computedValues[0].getDVTNumber();
            DVTNumber dVTNumber = select1Number = select.computedValues.length == 2 ? select.computedValues[1].getDVTNumber() : select0Number;
            if (select0Number.isAmbiguous() || select1Number.isAmbiguous()) {
                if (select0Number.isUnknown() || select1Number.isUnknown()) {
                    return VlogBitVector.copy(this, VlogBitVector.createMaskOfType(MaskType.UNKNOWN, this.getSize()));
                }
                return this;
            }
            int select0IntValue = select0Number.intValue();
            int n = select1IntValue = select.computedValues.length == 2 ? select1Number.intValue() : select0IntValue;
            if (select.isPlusIndexPartSelect || select.isMinusIndexPartSelect) {
                if (select1IntValue <= 0) {
                    return this;
                }
                int maxSelect = 0;
                int minSelect = 0;
                if (select.isPlusIndexPartSelect) {
                    maxSelect = select0IntValue + select1IntValue - 1;
                    minSelect = select0IntValue;
                } else if (select.isMinusIndexPartSelect) {
                    maxSelect = select0IntValue;
                    minSelect = select0IntValue - select1IntValue + 1;
                }
                if (thisDimension0 > thisDimension1) {
                    select0IntValue = maxSelect;
                    select1IntValue = minSelect;
                } else {
                    select0IntValue = minSelect;
                    select1IntValue = maxSelect;
                }
            }
            if (thisDimension0 < thisDimension1) {
                if (select0IntValue < thisDimension0) {
                    ignoreBitsLeft += (thisDimension0 - select0IntValue) * this.getElementSize();
                    select0IntValue = thisDimension0;
                } else if (select0IntValue > thisDimension1) {
                    return this;
                }
                if (select1IntValue > thisDimension1) {
                    ignoreBitsRight += (select1IntValue - thisDimension1) * this.getElementSize();
                    select1IntValue = thisDimension1;
                }
            } else {
                if (select0IntValue > thisDimension0) {
                    ignoreBitsLeft += (select0IntValue - thisDimension0) * this.getElementSize();
                    select0IntValue = thisDimension0;
                }
                if (select1IntValue < thisDimension1) {
                    ignoreBitsRight += (thisDimension1 - select1IntValue) * this.getElementSize();
                    select1IntValue = thisDimension1;
                } else if (select1IntValue > thisDimension0) {
                    return this;
                }
            }
            int thisSelectSize = Math.abs(select0IntValue - select1IntValue) + 1;
            finalSelect[1] = finalSelect[1] - size * Math.abs(thisDimension0 - select0IntValue);
            finalSelect[0] = thisSelectSize == 1 && size == 1 ? finalSelect[1] : finalSelect[1] - size * thisSelectSize + 1;
            index += 2;
        }
        return this.updateSlice(finalSelect[0], finalSelect[1], (VlogBitVector)updateValue, ignoreBitsLeft, ignoreBitsRight);
    }

    public DVTNumber substring(IELParamValue[] args, IHidEvaluationGuardian guardian) {
        return this;
    }

    public VlogBitVector updateSlice(int lsb, int msb, VlogBitVector updated, int ignoreBitsMsb, int ignoreBitsLsb) {
        return this.updateSlice(lsb, msb, updated, ignoreBitsMsb, ignoreBitsLsb, false);
    }

    public VlogBitVector updateSlice(int lsb, int msb, VlogBitVector updated, int ignoreBitsMsb, int ignoreBitsLsb, boolean isDoNotClear) {
        updated = updated.hasSign() ? updated.signedToUnsigned() : updated;
        BigInteger sliceNumber = updated.getNumber();
        BigInteger thisNumber = this.getNumber();
        if (ignoreBitsLsb > 0) {
            sliceNumber = sliceNumber.shiftRight(ignoreBitsLsb);
        }
        BigInteger ignoreBitsMsbMask = null;
        if (ignoreBitsMsb > 0) {
            ignoreBitsMsbMask = VlogBitVector.getPowerOfTwoMask(ignoreBitsMsb).shiftLeft(updated.getSize() - ignoreBitsMsb - ignoreBitsLsb);
            sliceNumber = sliceNumber.andNot(ignoreBitsMsbMask);
        }
        BigInteger[] sliceClearCache = new BigInteger[1];
        thisNumber = isDoNotClear ? thisNumber : this.sliceClear(lsb, msb, thisNumber, sliceClearCache);
        sliceNumber = sliceNumber.shiftLeft(lsb);
        thisNumber = sliceNumber.signum() == 0 ? thisNumber : thisNumber.or(sliceNumber);
        EnumMap<MaskType, BitSet> masks = this.getMasks();
        EnumMap<MaskType, BitSet> updateMasks = updated.getMasks();
        if (masks == null && updateMasks == null) {
            return VlogBitVector.copy(this, thisNumber, null);
        }
        EnumMap<MaskType, BitSet> resultMasks = new EnumMap<MaskType, BitSet>(MaskType.class);
        MaskType[] maskTypeArray = MaskType.values();
        int n = maskTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MaskType maskType = maskTypeArray[n2];
            BitSet sliceMask = updated.getMask(maskType);
            BitSet thisMask = this.getMask(maskType);
            if (sliceMask != null || thisMask != null) {
                BitSet resultMaskNumber = null;
                if (sliceMask == null) {
                    resultMaskNumber = this.sliceClear(lsb, msb, thisMask);
                } else {
                    BitSet sliceMaskNumber = (BitSet)sliceMask.clone();
                    if (ignoreBitsLsb > 0) {
                        sliceMaskNumber = BitSetUtils.shiftRight(sliceMaskNumber, ignoreBitsLsb);
                    }
                    if (ignoreBitsMsb > 0) {
                        sliceMaskNumber.andNot(BitSetUtils.toBitSet(ignoreBitsMsbMask));
                    }
                    sliceMaskNumber = BitSetUtils.shiftLeft(sliceMaskNumber, lsb);
                    if (thisMask == null) {
                        resultMaskNumber = sliceMaskNumber;
                    } else {
                        resultMaskNumber = this.sliceClear(lsb, msb, thisMask);
                        resultMaskNumber.or(sliceMaskNumber);
                    }
                }
                if (!resultMaskNumber.isEmpty()) {
                    if (resultMasks == null) {
                        resultMasks = new EnumMap(MaskType.class);
                    }
                    resultMasks.put(maskType, resultMaskNumber);
                }
            }
            ++n2;
        }
        return VlogBitVector.create(this.sign, this.getLeft(), this.getRight(), this.packed, this.is4State, this.isString(), this.isUnion(), false, this.getMemberInfoByName(), resultMasks, thisNumber);
    }

    private BigInteger sliceClear(int lsb, int msb, BigInteger number, BigInteger[] cache) {
        BigInteger sliceClear;
        int actualLsb;
        if (number.signum() == 0) {
            return number;
        }
        if (lsb < 0 && msb < 0) {
            return number;
        }
        if (lsb < 0) {
            lsb = 0;
        }
        if (msb < 0) {
            msb = 0;
        }
        if (msb == lsb) {
            return number.clearBit(lsb);
        }
        int bitLength = number.bitLength();
        if (lsb >= bitLength) {
            return number;
        }
        int lowestSetBit = number.getLowestSetBit();
        if (lowestSetBit > msb) {
            return number;
        }
        if (msb >= bitLength && lsb < lowestSetBit) {
            return BigInteger.ZERO;
        }
        int actualMsb = Math.min(msb, bitLength - 1);
        if (actualMsb == (actualLsb = Math.max(lsb, lowestSetBit))) {
            return number.clearBit(actualLsb);
        }
        if (actualMsb < 63) {
            long mask = (1L << (int)((long)(actualMsb - actualLsb) + 1L)) - 1L << actualLsb;
            if (bitLength < 64) {
                long numberLong = number.longValue();
                long cleared = numberLong & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                return BigInteger.valueOf(cleared);
            }
            return number.andNot(BigInteger.valueOf(mask));
        }
        cache[0] = sliceClear = cache[0] == null ? VlogBitVector.getPowerOfTwoMask(msb - lsb + 1).shiftLeft(lsb) : cache[0];
        number = number.andNot(sliceClear);
        return number;
    }

    private BitSet sliceClear(int lsb, int msb, BitSet number) {
        if (number.isEmpty()) {
            return number;
        }
        if (lsb < 0 && msb < 0) {
            return number;
        }
        if (lsb < 0) {
            lsb = 0;
        }
        if (msb < 0) {
            msb = 0;
        }
        number = (BitSet)number.clone();
        int i = lsb;
        while (i <= msb) {
            number.clear(i);
            ++i;
        }
        return number;
    }

    protected boolean isOutOfRangeSelect(int i, int[] dimension) {
        boolean increasing;
        boolean bl = increasing = dimension[0] <= dimension[1];
        return increasing && (i < dimension[0] || i > dimension[1]) || !increasing && (i > dimension[0] || i < dimension[1]);
    }

    @Override
    public DVTNumber getBitSelect(int startPos, int size) {
        int myBitSize = this.getSize();
        if (startPos < 0 || startPos + size - 1 >= myBitSize) {
            return null;
        }
        int[] myPacked = this.getPacked();
        if (myPacked.length < 2) {
            return null;
        }
        int elementSize = this.getElementSize();
        boolean isIncreasing = myPacked[0] < myPacked[1];
        int counter = 0;
        int nr = 0;
        while (nr <= this.getArraySize()) {
            if (counter > startPos) {
                return null;
            }
            if (counter == startPos) {
                int rhSelect;
                int lhSelect;
                int n = lhSelect = isIncreasing ? myPacked[0] + nr : myPacked[0] - nr;
                int n2 = size == 1 ? lhSelect : (rhSelect = isIncreasing ? lhSelect + size / elementSize - 1 : lhSelect - size / elementSize + 1);
                if (isIncreasing && rhSelect > myPacked[1] || !isIncreasing && rhSelect < myPacked[1]) {
                    return null;
                }
                XComputedSelect computedSelect = new XComputedSelect(null, ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(lhSelect))), ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(rhSelect))));
                VlogBitVector rangeSelect = (VlogBitVector)this.getRangeSelect(computedSelect, false, LanguageKind.VHDL);
                return rangeSelect;
            }
            if (counter + elementSize > startPos) {
                int lhSelect = isIncreasing ? myPacked[0] + nr : myPacked[0] - nr;
                XComputedSelect computedSelect = new XComputedSelect(null, ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(lhSelect))));
                VlogBitVector rangeSelect = (VlogBitVector)this.getRangeSelect(computedSelect, false, LanguageKind.VHDL);
                return rangeSelect.getBitSelect(startPos - counter, size);
            }
            counter += elementSize;
            ++nr;
        }
        return null;
    }

    @Override
    public DVTNumber getRangeSelect(XComputedSelect computedSelect, boolean evaluateForSize, LanguageKind languageKind) {
        VlogBitVector rangeSelect;
        int newRH;
        boolean isBitSelect;
        boolean increasing;
        boolean isVhdl;
        if (this.packed == null) {
            this.packed = VlogBitVector.getIntPair(this.getSize() - 1, 0);
        }
        if (this.packed == null || this.packed.length == 0) {
            throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
        }
        IELParamValue[] numberSelects = computedSelect.computedValues;
        if (numberSelects.length == 1) {
            if (ELUtils.isUnsuccessfulEval(numberSelects[0])) {
                throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
            }
        } else if (numberSelects.length == 2) {
            if (ELUtils.isUnsuccessfulEval(numberSelects[0]) || ELUtils.isUnsuccessfulEval(numberSelects[1])) {
                throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
            }
        } else {
            throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
        }
        boolean bl = isVhdl = languageKind == LanguageKind.VHDL;
        if (!isVhdl && numberSelects.length == 2 && this.isString()) {
            throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
        }
        int elementSize = this.getElementSize();
        boolean isIndexPartSelect = computedSelect.isPlusIndexPartSelect || computedSelect.isMinusIndexPartSelect;
        boolean bl2 = increasing = this.packed[0] < this.packed[1];
        if (!isVhdl && numberSelects.length == 1 && numberSelects[0].isAmbiguous()) {
            if (numberSelects[0].isUnknown()) {
                if (this.isString()) {
                    return UNKNOWN_STRING_CHARACTER;
                }
                return VlogBitVector.create(false, elementSize - 1, 0, this.packed.length > 2 ? Arrays.copyOfRange(this.packed, 2, this.packed.length) : null, this.is4State(), false, false, false, this.getMemberInfoByName(), VlogBitVector.createMaskOfType(MaskType.UNKNOWN, elementSize));
            }
            if (this.isString()) {
                return EMPTY_STRING_CHARACTER;
            }
            if (!this.is4State()) {
                return VlogBitVector.create(false, elementSize - 1, 0, this.packed.length > 2 ? Arrays.copyOfRange(this.packed, 2, this.packed.length) : null, false, false, false, false, this.getMemberInfoByName(), null);
            }
            return VlogBitVector.create(false, elementSize - 1, 0, this.packed.length > 2 ? Arrays.copyOfRange(this.packed, 2, this.packed.length) : null, true, false, false, false, this.getMemberInfoByName(), VlogBitVector.createMaskOfType(MaskType.X, elementSize));
        }
        if (!isVhdl && numberSelects.length == 2) {
            if (numberSelects[1].isAmbiguous()) {
                if (numberSelects[1].isUnknown()) {
                    return new VlogBitVector__unknownSize(this.sign, this.is4State, this.isString());
                }
                throw new IllegalPartSelectIndexException(computedSelect.getSelectObject());
            }
            if (numberSelects[0].isAmbiguous()) {
                if (!isIndexPartSelect || VlogBitVector.intValueNoExceptionOnUndefinedNumber(numberSelects[1]) <= 0) {
                    if (numberSelects[0].isUnknown()) {
                        return new VlogBitVector__unknownSize(false, this.is4State, this.isString());
                    }
                    throw new IllegalPartSelectIndexException(computedSelect.getSelectObject());
                }
                if (this.isString()) {
                    return numberSelects[0].isUnknown() ? UNKNOWN_STRING_CHARACTER : EMPTY_STRING_CHARACTER;
                }
                int width = VlogBitVector.intValueNoExceptionOnUndefinedNumber(numberSelects[1]);
                int[] newPacked = Arrays.copyOfRange(this.packed, 0, this.packed.length);
                if (newPacked.length >= 2) {
                    newPacked[1] = increasing ? this.packed[0] + width - 1 : this.packed[0] - width + 1;
                }
                if (numberSelects[0].isUnknown()) {
                    return VlogBitVector.create(this.hasSign(), width * elementSize - 1, 0, newPacked, this.is4State(), false, false, false, this.getMemberInfoByName(), VlogBitVector.createMaskOfType(MaskType.UNKNOWN, width * elementSize));
                }
                if (!this.is4State()) {
                    return VlogBitVector.create(false, width * elementSize - 1, 0, newPacked, false, false, false, false, this.getMemberInfoByName(), null);
                }
                return VlogBitVector.create(false, width * elementSize - 1, 0, newPacked, true, false, false, false, this.getMemberInfoByName(), VlogBitVector.createMaskOfType(MaskType.X, width * elementSize));
            }
        }
        int[] selects = new int[2];
        int i = 0;
        while (i < numberSelects.length) {
            selects[i] = VlogBitVector.intValueNoExceptionOnUndefinedNumber(numberSelects[i]);
            ++i;
        }
        if (numberSelects.length == 1) {
            selects[1] = selects[0];
        }
        if (this.packed.length >= 2 && numberSelects.length == 2 && this.packed[0] == selects[0] && this.packed[1] == selects[1]) {
            return this.signedToUnsigned();
        }
        if (isIndexPartSelect) {
            boolean isDecreasing;
            if (selects[1] <= 0) {
                throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
            }
            boolean bl3 = isDecreasing = this.packed[0] > this.packed[1];
            if (computedSelect.isPlusIndexPartSelect) {
                if (isDecreasing) {
                    firstSelectValue = evaluateForSize ? this.packed[1] : selects[0];
                    selects = new int[]{firstSelectValue + selects[1] - 1, firstSelectValue};
                } else {
                    firstSelectValue = evaluateForSize ? this.packed[0] : selects[0];
                    selects = new int[]{firstSelectValue, firstSelectValue + selects[1] - 1};
                }
            } else if (computedSelect.isMinusIndexPartSelect) {
                if (isDecreasing) {
                    firstSelectValue = evaluateForSize ? this.packed[0] : selects[0];
                    selects = new int[]{firstSelectValue, firstSelectValue - selects[1] + 1};
                } else {
                    firstSelectValue = evaluateForSize ? this.packed[1] : selects[0];
                    selects = new int[]{firstSelectValue - selects[1] + 1, firstSelectValue};
                }
            }
        }
        int[] firstDimension = this.getFirstDimension();
        if (this.isString()) {
            int nofElems = Math.abs(selects[1] - selects[0]) + 1;
            if (increasing && selects[0] > selects[1] || !increasing && selects[0] < selects[1]) {
                if (this.isUnknown()) {
                    return new VlogBitVector__unknownSize(false, this.is4State, this.isString());
                }
                throw new ReversedPartSelectException(computedSelect.getSelectObject());
            }
            if (this.isOutOfRangeSelect(selects[0], firstDimension)) {
                if (isVhdl) {
                    throw new OutOfBoundsSelectException(computedSelect.getSelectObject(), this.toStringDimensions(firstDimension, isVhdl), String.valueOf(selects[0]));
                }
                return EMPTY_STRING_CHARACTER;
            }
            if (this.isOutOfRangeSelect(selects[1], firstDimension)) {
                if (isVhdl) {
                    throw new OutOfBoundsSelectException(computedSelect.getSelectObject(), this.toStringDimensions(firstDimension, isVhdl), String.valueOf(selects[1]));
                }
                return EMPTY_STRING_CHARACTER;
            }
            if (increasing) {
                origLow = this.packed[0];
                int msb = origLow + 8 * Math.abs(selects[0] - origLow);
                int lsb = msb + 8 * nofElems - 1;
                selects = new int[]{msb, lsb};
            } else {
                origLow = this.packed[1];
                int lsb = origLow + 8 * Math.abs(selects[1] - origLow);
                int msb = lsb + 8 * nofElems - 1;
                selects = new int[]{msb, lsb};
            }
        }
        if (increasing && selects[0] > selects[1] || !increasing && selects[0] < selects[1]) {
            if (this.isUnknown()) {
                return new VlogBitVector__unknownSize(false, this.is4State, this.isString());
            }
            throw new ReversedPartSelectException(computedSelect.getSelectObject());
        }
        int selectSize = Math.abs(selects[0] - selects[1]) + 1;
        int dimensionSize = this.isString() ? 1 : elementSize;
        boolean bl4 = isBitSelect = selects[0] == selects[1];
        if (evaluateForSize) {
            if (this.packed.length > 2) {
                if (isBitSelect) {
                    int[] newPacked = Arrays.copyOfRange(this.packed, 2, this.packed.length);
                    return VlogBitVector.create(this.isString(), selectSize * dimensionSize - 1, 0, newPacked, this.is4State(), this.isString(), false, false, this.getMemberInfoByName(), this.getMasks());
                }
                int[] newPacked = Arrays.copyOfRange(this.packed, 0, this.packed.length);
                newPacked[0] = selects[0];
                newPacked[1] = selects[1];
                return VlogBitVector.create(this.isString(), selectSize * dimensionSize - 1, 0, newPacked, this.is4State(), false, false, false, this.getMemberInfoByName(), this.getMasks());
            }
            return VlogBitVector.create(this.isString(), selectSize - 1, 0, null, this.is4State(), false, BigInteger.ZERO);
        }
        int fullSize = this.getSize();
        DVTNumber result = DVTNumber.UNDEFINED;
        if (isBitSelect) {
            int selectValue = selects[0];
            if (this.isOutOfRangeSelect(selectValue, this.packed)) {
                if (isVhdl) {
                    throw new OutOfBoundsSelectException(computedSelect.getSelectObject(), this.toStringDimensions(firstDimension, isVhdl), String.valueOf(selectValue));
                }
                if (this.is4State) {
                    EnumMap<MaskType, BitSet> masks = VlogBitVector.createMaskOfType(MaskType.X, dimensionSize);
                    return VlogBitVector.create(false, dimensionSize - 1, 0, Arrays.copyOfRange(this.packed, 2, this.packed.length), true, false, false, false, this.getMemberInfoByName(), masks);
                }
                return VlogBitVector.create(false, dimensionSize - 1, 0, Arrays.copyOfRange(this.packed, 2, this.packed.length), false, false, false, false, this.getMemberInfoByName(), null);
            }
            if (increasing) {
                int msb = (selectValue - this.packed[0]) * dimensionSize;
                int lsb = msb + dimensionSize - 1;
                result = this.getRange(fullSize - msb - 1, fullSize - lsb - 1, false, false, this.is4State(), false, this.getMemberInfoByName());
            } else {
                int lsb = (selectValue - this.packed[1]) * dimensionSize;
                int msb = lsb + dimensionSize - 1;
                result = this.getRange(msb, lsb, false, false, this.is4State(), false, this.getMemberInfoByName());
            }
            ((VlogBitVector)result).decreaseDimensionNoNewObject();
            return result.hasSign() ? ((VlogBitVector)result).signedToUnsigned() : result;
        }
        int lhValue = selects[0];
        int rhValue = selects[1];
        int[] newPacked = Arrays.copyOfRange(this.packed, 0, this.packed.length);
        newPacked[0] = lhValue;
        newPacked[1] = rhValue;
        if (increasing && (lhValue > this.packed[1] || rhValue < this.packed[0]) || !increasing && (lhValue < this.packed[1] || rhValue > this.packed[0])) {
            if (isVhdl) {
                throw new OutOfBoundsSelectException(computedSelect.getSelectObject(), this.toStringDimensions(firstDimension, isVhdl), String.valueOf(lhValue), String.valueOf(rhValue));
            }
            return VlogBitVector.create(this.isString(), selectSize * dimensionSize - 1, 0, newPacked, true, this.isString(), false, false, this.getMemberInfoByName(), VlogBitVector.createMaskOfType(MaskType.X, selectSize * dimensionSize));
        }
        int newLH = increasing ? Math.max(lhValue, this.packed[0]) : Math.min(lhValue, this.packed[0]);
        int n = newRH = increasing ? Math.min(rhValue, this.packed[1]) : Math.max(rhValue, this.packed[1]);
        if (increasing) {
            msb = (newLH - this.packed[0]) * dimensionSize;
            lsb = msb + dimensionSize * (newRH - newLH + 1) - 1;
            rangeSelect = this.getRange(fullSize - msb - 1, fullSize - lsb - 1, false, false, this.is4State(), false, null);
        } else {
            msb = (newRH - this.packed[1]) * dimensionSize;
            lsb = msb + dimensionSize * (newLH - newRH + 1) - 1;
            rangeSelect = this.getRange(lsb, msb, false, false, this.is4State(), false, null);
        }
        boolean isOutOfRangeLH = this.isOutOfRangeSelect(lhValue, this.packed);
        boolean isOutOfRangeRH = this.isOutOfRangeSelect(rhValue, this.packed);
        if (!isOutOfRangeLH && !isOutOfRangeRH) {
            rangeSelect.setArrayDimensions(newPacked);
            if (!this.isString()) {
                return rangeSelect.hasSign() ? rangeSelect.signedToUnsigned() : rangeSelect;
            }
            return VlogBitVector.create(true, rangeSelect.getLeft(), rangeSelect.getRight(), rangeSelect.getArrayDimensions(), rangeSelect.is4State(), rangeSelect.isString(), rangeSelect.isUnion(), rangeSelect.hasUnknownSize(), rangeSelect.getMemberInfoByName(), rangeSelect.getMasks(), rangeSelect.bigIntegerValue());
        }
        if (isVhdl) {
            String[] stringArray;
            if (isOutOfRangeLH && isOutOfRangeRH) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = String.valueOf(lhValue);
                stringArray = stringArray2;
                stringArray2[1] = String.valueOf(rhValue);
            } else if (isOutOfRangeLH) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = String.valueOf(lhValue);
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = String.valueOf(rhValue);
            }
            String[] outsideValues = stringArray;
            throw new OutOfBoundsSelectException(computedSelect.getSelectObject(), this.toStringDimensions(firstDimension, isVhdl), outsideValues);
        }
        result = VlogBitVector.create(this.isString(), selectSize * dimensionSize - 1, 0, newPacked, this.is4State, this.isString(), false, false, this.getMemberInfoByName(), this.is4State ? VlogBitVector.createMaskOfType(MaskType.X, selectSize * dimensionSize) : null);
        VlogBitVector lhXSelect = VlogBitVector.createConstant(newLH);
        VlogBitVector rhXSelect = VlogBitVector.createConstant(newRH);
        IELParamValue[] xSelectVector = new IELParamValue[]{ELParamValues.ParamValueNumber.of(lhXSelect), ELParamValues.ParamValueNumber.of(rhXSelect)};
        XComputedSelect computedSelect2 = new XComputedSelect(null, xSelectVector);
        result = ((IDVTRangeSelectable)((Object)result)).updateSelects(rangeSelect, OptimizedUtils.listContainerCreate(Arrays.asList(computedSelect2), true));
        if (!this.isString()) {
            return result.hasSign() ? ((VlogBitVector)result).signedToUnsigned() : result;
        }
        return VlogBitVector.create(true, rangeSelect.getLeft(), rangeSelect.getRight(), rangeSelect.getArrayDimensions(), rangeSelect.is4State(), rangeSelect.isString(), rangeSelect.isUnion(), rangeSelect.hasUnknownSize(), rangeSelect.getMemberInfoByName(), rangeSelect.getMasks(), rangeSelect.bigIntegerValue());
    }

    private static int intValueNoExceptionOnUndefinedNumber(IELParamValue value) {
        return value.getDVTNumber().intValue();
    }

    public static VlogBitVector createConstant(int constant) {
        return VlogBitVector.create(true, 31, 0, BigInteger.valueOf(constant));
    }

    protected VlogBitVector getRange(int rangeLeft, int rangeRight, boolean forceSign, boolean forceSignExtension, boolean is4State, boolean isString, Map<String, StructMemberContextInfo> membersInfoByName) {
        if (this.getLeft() > this.getRight() && rangeLeft < rangeRight) {
            throw new IllegalArgumentException("Range of part-select is reversed!");
        }
        int max = Math.max(rangeLeft, rangeRight) - Math.min(this.getLeft(), this.getRight());
        int min = Math.min(rangeLeft, rangeRight) - Math.min(this.getLeft(), this.getRight());
        int resultSize = max - min + 1;
        int newLeft = this.getLeft() > this.getRight() ? resultSize - 1 : 0;
        int newRight = this.getLeft() > this.getRight() ? 0 : resultSize - 1;
        int maskBitLength = max - min + 1;
        BigInteger mask = VlogBitVector.getPowerOfTwoMask(maskBitLength);
        EnumMap<MaskType, BitSet> resultMasks = null;
        EnumMap<MaskType, BitSet> masks = this.getMasks();
        if (masks != null && !masks.isEmpty()) {
            int size = this.getSize();
            boolean hasSign = this.hasSign();
            BitSet signExtMask = null;
            for (Map.Entry<MaskType, BitSet> entry : masks.entrySet()) {
                BitSet currentMask = entry.getValue();
                if (currentMask == null) continue;
                BitSet finalMaskNumber = BitSetUtils.shiftAndMask(currentMask, min, maskBitLength);
                MaskType maskType = entry.getKey();
                if ((hasSign || forceSignExtension) && resultSize > size && currentMask.get(this.getLeft()) && (maskType == MaskType.Z || maskType == MaskType.X)) {
                    if (signExtMask == null) {
                        signExtMask = BitSetUtils.getPowerOfTwoMaskShiftLeft(resultSize - size, size);
                    }
                    finalMaskNumber.or(signExtMask);
                }
                if (finalMaskNumber.isEmpty()) continue;
                if (resultMasks == null) {
                    resultMasks = new EnumMap<MaskType, BitSet>(MaskType.class);
                }
                resultMasks.put(maskType, finalMaskNumber);
            }
        }
        BigInteger resultNumber = VlogBitVector.shiftAndMask(this.getNumber(), min, mask, maskBitLength);
        return VlogBitVector.create(forceSign, newLeft, newRight, this.packed, is4State, isString, this.isUnion(), false, membersInfoByName, resultMasks, resultNumber);
    }

    private static BigInteger shiftAndMask(BigInteger number, int shiftBits, BigInteger mask, int maskBitLength) {
        BigInteger result;
        if (number.signum() == 0) {
            return BigInteger.ZERO;
        }
        BigInteger bigInteger = result = shiftBits == 0 ? number : number.shiftRight(shiftBits);
        if (result.signum() > 0 && result.bitLength() < maskBitLength) {
            return result;
        }
        return result.and(mask);
    }

    public VlogBitVector getRange(int left, int right) {
        return this.getRange(left, right, false, false, false, false, null);
    }

    public VlogBitVector getRangeAbsolute(int start, int size) {
        int rangeRight;
        int rangeLeft;
        int right;
        int left = this.getLeft();
        if (left > (right = this.getRight())) {
            rangeLeft = left - start;
            rangeRight = rangeLeft - size + 1;
        } else {
            rangeLeft = start;
            rangeRight = start + size - 1;
        }
        return this.getRange(rangeLeft, rangeRight, false, false, false, false, null);
    }

    private final void convertInRangeNoNewObject() {
        this.number = VlogBitVector.convertInRange(this.getNumber(), this.sign, this.getSize());
    }

    private static BigInteger convertInRange(BigInteger number, boolean sign, int size) {
        if (number.signum() == 0) {
            return BigInteger.ZERO;
        }
        int bitLength = number.bitLength();
        if (number.signum() < 0 || bitLength > size) {
            BigInteger powerOfTwoMask = VlogBitVector.getPowerOfTwoMask(size);
            number = number.and(powerOfTwoMask);
        }
        if (number.signum() > 0 && !sign) {
            return number;
        }
        if (number.testBit(size - 1) && !sign) {
            return number.clearBit(size - 1);
        }
        if (number.testBit(size - 1) && sign) {
            BigInteger powerOfTwo = VlogBitVector.getPowerOfTwo(size);
            return number.subtract(powerOfTwo);
        }
        return number;
    }

    private static BitSet convertInRange(BitSet number, int size) {
        if (number.isEmpty()) {
            return BitSetUtils.valueOf(0);
        }
        int index = size;
        while ((index = number.nextSetBit(index)) > 0) {
            number.clear(index);
        }
        return number;
    }

    public VlogBitVector signedToUnsigned() {
        return VlogBitVector.create(false, this.left, this.right, this.getPacked(), this.is4State, this.isString(), this.isUnion(), this.hasUnknownSize(), this.getMemberInfoByName(), VlogBitVector.copyMasks(this.getMasks()), VlogBitVector.signedToUnsigned(this.getNumber(), this.getSize()));
    }

    public static final BigInteger signedToUnsigned(BigInteger number, int size) {
        if (number.signum() >= 0) {
            return number;
        }
        return number.and(VlogBitVector.getPowerOfTwoMask(size));
    }

    public static BigInteger getPowerOfTwo(int exponent) {
        if (exponent <= 0) {
            return TWO_POW[0];
        }
        if (exponent < 1024) {
            return TWO_POW[exponent];
        }
        return BigInteger.ONE.shiftLeft(exponent);
    }

    public static BigInteger getPowerOfTwoNegate(int exponent) {
        if (exponent <= 0) {
            return TWO_POW_NEG[0];
        }
        if (exponent < 1024) {
            return TWO_POW_NEG[exponent];
        }
        return BigInteger.ONE.shiftLeft(exponent).negate();
    }

    public static BigInteger getPowerOfTwoMask(int exponent) {
        if (exponent <= 0) {
            return TWO_POW_MASK[0];
        }
        if (exponent < 1024) {
            return TWO_POW_MASK[exponent];
        }
        return BigInteger.ONE.shiftLeft(exponent).subtract(BigInteger.ONE);
    }

    @Override
    public boolean isStruct(boolean isStructOrUnion) {
        return false;
    }

    @Override
    public boolean isUnion() {
        return false;
    }

    public final int getLeft() {
        return this.left;
    }

    public final boolean isBigEndian() {
        return this.getLeft() > this.getRight();
    }

    public final int getRight() {
        return this.right;
    }

    public Map<String, StructMemberContextInfo> getMemberInfoByName() {
        return null;
    }

    @Override
    public int[] getPacked() {
        if (this.packed == null) {
            this.packed = VlogBitVector.getIntPair(this.getSize() - 1, 0);
        }
        return this.packed;
    }

    @Override
    public int[] getFirstDimension() {
        if (this.packed == null) {
            return VlogBitVector.getIntPair(this.getSize() - 1, 0);
        }
        if (this.packed.length == 0) {
            return null;
        }
        return VlogBitVector.getIntPair(this.packed[0], this.packed[1]);
    }

    @Override
    public int getArraySize() {
        return this.getFirstDimensionSize();
    }

    public int getFirstDimensionSize() {
        int[] firstDimension = this.getFirstDimension();
        if (firstDimension == null) {
            return -1;
        }
        return Math.abs(firstDimension[0] - firstDimension[1]) + 1;
    }

    @Override
    public int getElementSize() {
        if (this.packed == null) {
            return 1;
        }
        return this.getSize() / (this.packed == null || this.packed.length == 0 ? 1 : Math.abs(this.packed[1] - this.packed[0]) + 1);
    }

    @Override
    public DVTNumber getElementType() {
        return this.decreaseDimension();
    }

    public VlogBitVector decreaseDimension() {
        if (this.packed == null) {
            this.packed = VlogBitVector.getIntPair(this.getSize() - 1, 0);
        }
        if (this.packed.length == 0) {
            return null;
        }
        if (this.packed.length == 2) {
            return VlogBitVector.create(this.sign, 0, 0, VlogBitVector.getIntPair(0, 0), this.is4State, false, BigInteger.ZERO);
        }
        int[] newDimension = Arrays.copyOfRange(this.packed, 2, this.packed.length);
        int newSize = this.getSize() / (Math.abs(this.packed[1] - this.packed[0]) + 1);
        return VlogBitVector.create(this.hasSign(), newSize - 1, 0, newDimension, this.is4State(), this.isString(), this.isUnion(), false, this.getMemberInfoByName(), this.getMasks(), this.getNumber());
    }

    public List<StructMemberContextInfo> getMembersInfoOrdered() {
        if (!this.isStruct(true)) {
            return Collections.emptyList();
        }
        ArrayList<StructMemberContextInfo> result = new ArrayList<StructMemberContextInfo>();
        result.addAll(this.getMemberInfoByName().values());
        result.sort((o1, o2) -> o1.startingIndex - o2.startingIndex);
        return result;
    }

    public VlogBitVector toVlogStringCompatibleBitVector() {
        if (this.isUnknown()) {
            return this;
        }
        byte[] bytes = this.getNumber().toByteArray();
        byte[] result = new byte[bytes.length];
        int size = 0;
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b != 0) {
                result[size++] = b;
            }
            ++n2;
        }
        if (size == 0) {
            return EMPTY_STRING_CHARACTER;
        }
        byte[] finalBytes = Arrays.copyOfRange(result, 0, size);
        return VlogBitVector.create(this.hasSign(), 0, size * 8 - 1, null, this.is4State(), this.isString(), new BigInteger(finalBytes));
    }

    public VlogBitVector createNoMaskEquivalent() {
        if (this instanceof VlogBitVector__mask) {
            return VlogBitVector.create(this.sign, this.getLeft(), this.getRight(), this.packed, this.is4State, this.isString(), this.getNumber());
        }
        return this;
    }

    public static VlogBitVector stringToValue(String text) {
        if (text.isEmpty()) {
            return EMPTY_STRING_CHARACTER;
        }
        int nofBits = text.length() * 8;
        int[] nArray = new int[2];
        nArray[1] = nofBits - 1;
        return new VlogBitVector__string(false, 0, nofBits - 1, nArray, false, text);
    }

    public String stringValue(boolean isUnquoted) {
        if (this.isEmptyString()) {
            return isUnquoted ? "" : "\"\"";
        }
        if (!this.isString()) {
            throw new UnsupportedOperationException("Not a string!");
        }
        String text = new String(this.toByteArrayIgnoreLeadingZeros(), IDVTConstants.ASCII);
        return isUnquoted ? text : "\"" + text + "\"";
    }

    public byte[] toByteArrayIgnoreLeadingZeros() {
        byte[] byteArray = this.getNumber().toByteArray();
        int i = 0;
        while (i < byteArray.length) {
            if (byteArray[i] != 0) {
                return Arrays.copyOfRange(byteArray, i, byteArray.length);
            }
            ++i;
        }
        return new byte[0];
    }

    @Override
    public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        try {
            DVTNumber contextNumber;
            if (this.isString()) {
                return this.stringValue(false);
            }
            if (this.packed == null) {
                this.packed = VlogBitVector.getIntPair(this.getSize() - 1, 0);
            }
            DVTNumber dVTNumber = contextNumber = context != null ? context.getContextNumber() : null;
            if (contextNumber instanceof VhdlEnum) {
                VhdlEnum vhdlEnum = (VhdlEnum)contextNumber;
                IRfNamedElement enumValue = vhdlEnum.getEnumValue();
                IRfSingleLangProject rfProject = enumValue.getRfProject();
                boolean isBit = enumValue != null && enumValue.equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.BIT));
                boolean isStdLogic = !isBit && enumValue != null && enumValue.equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.STD_ULOGIC));
                return this.toNiceStringVhdl(vhdlEnum, radix, isBit, isStdLogic, useCharLimit, true);
            }
            if (-1 == radix) {
                return this.toString(10, useCharLimit, useLowerCaseMaskType);
            }
            StringBuilder niceSb = new StringBuilder();
            String value = this.toString(radix, useCharLimit, useLowerCaseMaskType);
            boolean negativeDecimal = value.startsWith("-");
            if (negativeDecimal) {
                niceSb.append("-");
            }
            niceSb.append(this.getSize()).append("'").append(DVTStringUtil.getParamRadixPrefix(radix)).append(negativeDecimal ? value.substring(1) : value);
            return niceSb.toString();
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return "";
        }
    }

    public String toNiceStringVhdl(VhdlEnum vhdlEnum, int radix, boolean isBit, boolean isStdLogic, boolean useCharLimit, boolean baseSizeInfo) {
        if (this.packed == null || this.packed.length <= 2) {
            if (!isStdLogic) {
                IRfNamedElement enumValueAtOrdinal = vhdlEnum.getEnumValueFromOrdinal(this.intValue());
                return enumValueAtOrdinal != null ? enumValueAtOrdinal.getName() : this.toString(radix, useCharLimit, false);
            }
            for (MaskType maskType : MaskType.NonDriveStrengthMasks) {
                BitSet mask = this.getMask(maskType);
                if (mask == null || mask.isEmpty()) continue;
                return "'" + maskType.toNiceString(false) + "'";
            }
            return this.equals(ZERO) ? "'0'" : "'1'";
        }
        if (this.packed != null && this.packed.length == 4 && (isBit || isStdLogic)) {
            if (!baseSizeInfo) {
                return this.toString(radix, useCharLimit, false);
            }
            String baseString = radix == 2 ? "B" : (radix == 16 ? "X" : (radix == 8 ? "O" : "D"));
            String sizeString = Integer.toString(this.getSize());
            return sizeString + baseString + "\"" + this.toString(radix, useCharLimit, false) + "\"";
        }
        StringBuilder result = new StringBuilder("(");
        if (this.packed[0] < this.packed[1]) {
            int i = this.packed[0];
            while (i <= this.packed[1]) {
                XComputedSelect computedSelect = new XComputedSelect(null, ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(i)));
                VlogBitVector rangeSelect = (VlogBitVector)this.getRangeSelect(computedSelect, false, LanguageKind.VHDL);
                result.append(rangeSelect.toNiceStringVhdl(vhdlEnum, radix, isBit, isStdLogic, useCharLimit, baseSizeInfo)).append(i != this.packed[1] ? "," : ")");
                if (useCharLimit && result.length() > 8100) {
                    result.append("...)");
                    return result.toString();
                }
                ++i;
            }
        } else {
            int i = this.packed[0];
            while (i >= this.packed[1]) {
                XComputedSelect computedSelect = new XComputedSelect(null, ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(i)));
                VlogBitVector rangeSelect = (VlogBitVector)this.getRangeSelect(computedSelect, false, LanguageKind.VHDL);
                result.append(rangeSelect.toNiceStringVhdl(vhdlEnum, radix, isBit, isStdLogic, useCharLimit, baseSizeInfo)).append(i != this.packed[1] ? "," : ")");
                if (useCharLimit && result.length() > 8100) {
                    result.append("...)");
                    return result.toString();
                }
                --i;
            }
        }
        return result.toString();
    }

    @Override
    public String toString(int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        if (radix == 10 || radix < 2 || radix > 36) {
            for (MaskType maskType : MaskType.NonDriveStrengthMasks) {
                BitSet mask;
                if (maskType == MaskType.H || maskType == MaskType.L || (mask = this.getMask(maskType)) == null || mask.isEmpty()) continue;
                return maskType.toNiceString(useLowerCaseMaskType);
            }
            String result = this.getNumber().toString(radix);
            if (useCharLimit && result.length() > 8100) {
                result = result.substring(0, 8100);
            }
            return result;
        }
        if (radix == 2) {
            return this.toString2(false, -1, useCharLimit, useLowerCaseMaskType);
        }
        if (radix == 8) {
            return this.toString8(false, -1, useCharLimit, useLowerCaseMaskType);
        }
        if (radix == 16) {
            return this.toString16(false, -1, useCharLimit, useLowerCaseMaskType);
        }
        String result = this.getNumber().toString(radix);
        if (useCharLimit && result.length() > 8100) {
            result = result.substring(0, 8100);
        }
        return result;
    }

    @Override
    public String print(int radix, boolean stripLeadingZeroes, int width, boolean useLowerCaseMaskType, boolean structAssignPattern) {
        Map<String, StructMemberContextInfo> memberInfoByName = this.getMemberInfoByName();
        if (structAssignPattern && memberInfoByName != null) {
            if (this.isUnion()) {
                return super.toString();
            }
            StringBuilder result = new StringBuilder("'{");
            for (Map.Entry<String, StructMemberContextInfo> entry : memberInfoByName.entrySet()) {
                if (result.length() > 2) {
                    result.append(", ");
                }
                StructMemberContextInfo memberContextInfo = entry.getValue();
                int dimensionHigh = this.getLeft();
                int lh = dimensionHigh - memberContextInfo.startingIndex;
                int rh = dimensionHigh - (memberContextInfo.startingIndex + memberContextInfo.context.getSize()) + 1;
                String stringValue = memberContextInfo.context.transform(this.getRange(lh, rh)).print(radix, stripLeadingZeroes, width, useLowerCaseMaskType, structAssignPattern);
                result.append(entry.getKey()).append(":").append(radix == 16 ? "'h" : (radix == 8 ? "'o" : (radix == 2 ? "'b" : ""))).append(stringValue);
            }
            result.append("}");
            return result.toString();
        }
        if (radix == 10 || radix < 2 || radix > 36) {
            BitSet maskX = this.getMask(MaskType.X);
            BitSet maskZ = this.getMask(MaskType.Z);
            String result = "x";
            result = maskX != null && !maskX.isEmpty() ? "x" : (maskZ != null && !maskZ.isEmpty() ? "z" : this.getNumber().toString(radix));
            if (width < 0 && stripLeadingZeroes) {
                return result;
            }
            return this.prepend(stripLeadingZeroes ? "0" : " ", width < 0 ? this.numOfChars10(this.hasSign(), this.getSize()) : width, result);
        }
        if (radix == 2) {
            return this.prepend(" ", width, this.toString2(stripLeadingZeroes, width, false, useLowerCaseMaskType));
        }
        if (radix == 8) {
            return this.prepend(" ", width, this.toString8(stripLeadingZeroes, width, false, useLowerCaseMaskType));
        }
        if (radix == 16) {
            return this.prepend(" ", width, this.toString16(stripLeadingZeroes, width, false, useLowerCaseMaskType));
        }
        return this.prepend(" ", width, this.getNumber().toString(radix));
    }

    public String printBinaryNoMasks(int radix, boolean stripLeadingZeroes, int width, boolean useLowerCaseMaskType) {
        if (radix == 2) {
            VlogBitVector copy = VlogBitVector.copy(this, this.bigIntegerValue(), null);
            return this.prepend(" ", width, copy.toString2(stripLeadingZeroes, width, false, useLowerCaseMaskType));
        }
        return "x";
    }

    private int numOfChars10(boolean hasSign, int size) {
        int numOfChars10 = XGlobalCache.INSTANCE.getNumOfChars10(hasSign, size);
        if (numOfChars10 > 0) {
            return numOfChars10;
        }
        BigInteger number = hasSign ? BigInteger.ONE.shiftLeft(size - 1).negate() : VlogBitVector.getPowerOfTwoMask(size);
        numOfChars10 = number.toString(10).length();
        XGlobalCache.INSTANCE.putNumOfChars10(hasSign, size, numOfChars10);
        return numOfChars10;
    }

    protected String prepend(String prefixChar, int length, String value) {
        if (length <= 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length - value.length()) {
            sb.append(prefixChar);
            ++i;
        }
        return sb.append(value).toString();
    }

    private String toString8(boolean stripLeadingZeroes, int width, boolean useCharLimit, boolean useLowerCaseMaskType) {
        int left = Integer.max(this.getLeft(), this.getRight());
        int right = Integer.min(this.getLeft(), this.getRight());
        StringBuilder bits = new StringBuilder();
        int bits3 = 0;
        int bitsCount = 0;
        MaskType firstFound = null;
        int i = right;
        while (i <= (width > 0 ? Math.min(Math.max(this.getNumber().bitLength(), width * 4 - 1), left) : left)) {
            MaskType maskAtIndex = null;
            for (MaskType maskType : MaskType.NonDriveStrengthMasks) {
                if (!this.hasMask(maskType, i)) continue;
                maskAtIndex = maskType;
                break;
            }
            if (maskAtIndex != null && firstFound == null) {
                firstFound = maskAtIndex;
            } else if (this.getNumber().testBit(i)) {
                bits3 = (byte)(bits3 | 1 << bitsCount);
            }
            if (bitsCount == 2) {
                bits.append(firstFound != null ? firstFound.toNiceString(useLowerCaseMaskType) : Integer.toString(bits3, 8));
                if (useCharLimit && bits.length() > 8100) {
                    bits.append("...");
                    return bits.toString();
                }
                firstFound = null;
                bitsCount = 0;
                bits3 = 0;
            } else {
                ++bitsCount;
            }
            ++i;
        }
        if (bitsCount > 0) {
            bits.append(firstFound != null ? firstFound.toNiceString(useLowerCaseMaskType) : Integer.toString(bits3, 8));
        }
        StringBuilder result = new StringBuilder(bits.length());
        int i2 = bits.length() - 1;
        while (i2 >= 0) {
            char ch = bits.charAt(i2);
            if (!stripLeadingZeroes || ch != '0' || result.length() != 0) {
                result.append(ch);
            }
            --i2;
        }
        return result.length() == 0 ? "0" : result.toString();
    }

    private String toString16(boolean stripLeadingZeroes, int width, boolean useCharLimit, boolean useLowerCaseMaskType) {
        StringBuilder bits = new StringBuilder();
        int bits4 = 0;
        int left = Integer.max(this.getLeft(), this.getRight());
        int right = Integer.min(this.getLeft(), this.getRight());
        int hexCount = 0;
        MaskType firstFound = null;
        int i = right;
        while (i <= (width > 0 ? Math.min(Math.max(this.getNumber().bitLength(), width * 4 - 1), left) : left)) {
            MaskType maskAtIndex = null;
            for (MaskType maskType : MaskType.NonDriveStrengthMasks) {
                if (!this.hasMask(maskType, i)) continue;
                maskAtIndex = maskType;
                break;
            }
            if (maskAtIndex != null) {
                firstFound = maskAtIndex;
            } else if (this.getNumber().testBit(i)) {
                bits4 = (byte)(bits4 | 1 << hexCount);
            }
            if (hexCount == 3) {
                bits.append(firstFound != null ? firstFound.toNiceString(useLowerCaseMaskType) : Integer.toString(bits4, 16));
                if (useCharLimit && bits.length() > 8100) {
                    bits.append("...");
                    return bits.toString();
                }
                firstFound = null;
                hexCount = 0;
                bits4 = 0;
            } else {
                ++hexCount;
            }
            ++i;
        }
        if (hexCount > 0) {
            bits.append(firstFound != null ? firstFound.toNiceString(useLowerCaseMaskType) : Integer.toString(bits4, 16));
        }
        StringBuilder result = new StringBuilder(bits.length());
        int i2 = bits.length() - 1;
        while (i2 >= 0) {
            char ch = bits.charAt(i2);
            if (!stripLeadingZeroes || ch != '0' || result.length() != 0) {
                result.append(ch);
            }
            --i2;
        }
        return result.length() == 0 ? "0" : result.toString();
    }

    private String toString2(boolean stripLeadingZeroes, int width, boolean useCharLimit, boolean useLowerCaseMaskType) {
        StringBuilder bits = new StringBuilder();
        int left = Integer.max(this.getLeft(), this.getRight());
        int right = Integer.min(this.getLeft(), this.getRight());
        int i = width > 0 ? Math.min(Math.max(this.getNumber().bitLength(), width - 1), left) : left;
        while (i >= right) {
            block8: {
                String bitValue;
                block6: {
                    block7: {
                        bitValue = null;
                        for (MaskType maskType : MaskType.NonDriveStrengthMasks) {
                            if (!this.hasMask(maskType, i)) continue;
                            bitValue = maskType.toNiceString(useLowerCaseMaskType);
                            break;
                        }
                        if (bitValue != null) break block6;
                        if (!this.number.testBit(i)) break block7;
                        bitValue = "1";
                        break block6;
                    }
                    if (stripLeadingZeroes && bits.length() == 0) break block8;
                    bitValue = "0";
                }
                bits.append(bitValue);
                if (useCharLimit && bits.length() > 8100) {
                    bits.append("...");
                    return bits.toString();
                }
            }
            --i;
        }
        return bits.length() == 0 ? "0" : bits.toString();
    }

    public String toString() {
        return this.toString(2, false, false);
    }

    private String toStringAsMultidimensionalArray(String bitOrHexVector) {
        if (this.packed == null) {
            this.packed = VlogBitVector.getIntPair(this.getSize() - 1, 0);
        }
        return new Converter(bitOrHexVector, this.sign, 10, this.packed).getString();
    }

    public String replicateNumber(int factor) {
        String toString2;
        StringBuilder bits = new StringBuilder();
        int left = Integer.max(this.getLeft(), this.getRight());
        int right = Integer.min(this.getLeft(), this.getRight());
        int i = left;
        while (i >= right) {
            String value = null;
            for (MaskType maskType : MaskType.NonDriveStrengthMasks) {
                if (!this.hasMask(maskType, i)) continue;
                value = maskType.toString();
                break;
            }
            bits.append(value != null ? value : (this.getNumber().testBit(i) ? "1" : "0"));
            --i;
        }
        String string = toString2 = bits.length() == 0 ? "0" : bits.toString();
        if ("0".equals(toString2)) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < factor) {
            sb.append(toString2);
            ++i2;
        }
        return sb.toString();
    }

    public VlogBitVector vlogEq(VlogBitVector obj) {
        if (obj == null) {
            return BIT_ZERO;
        }
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = obj;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        if (!thisBS.isAmbiguous() && !otherBS.isAmbiguous()) {
            return thisNumber.equals(otherNumber) ? BIT_ONE : BIT_ZERO;
        }
        boolean unknownResult = false;
        boolean ambiguousResult = false;
        int i = this.getSize() - 1;
        while (i >= 0) {
            if (thisBS.hasMask(MaskType.UNKNOWN, i) || otherBS.hasMask(MaskType.UNKNOWN, i)) {
                unknownResult = true;
            } else if (thisBS.hasMask(MaskType.X, i) || otherBS.hasMask(MaskType.X, i) || thisBS.hasMask(MaskType.Z, i) || otherBS.hasMask(MaskType.Z, i)) {
                ambiguousResult = true;
            } else {
                boolean otherTest;
                boolean thisTest = thisNumber.testBit(i);
                if (thisTest ^ (otherTest = otherNumber.testBit(i))) {
                    return BIT_ZERO;
                }
            }
            --i;
        }
        return unknownResult ? BIT_UNKNOWN : (ambiguousResult ? BIT_X : BIT_ONE);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.packed);
        result = 31 * result + (this.getNumber() == null ? 0 : this.getNumber().hashCode());
        return result;
    }

    public boolean equals(VlogBitVector obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = obj;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        if (thisBS.isAmbiguous() || otherBS.isAmbiguous()) {
            if (thisBS.hasUnknownSize() || otherBS.hasUnknownSize()) {
                return thisBS.hasUnknownSize() && otherBS.hasUnknownSize();
            }
            for (MaskType maskType : MaskType.NonDriveStrengthMasks) {
                BitSet thisBSMask = thisBS.getMask(maskType);
                BitSet otherBSMask = otherBS.getMask(maskType);
                if (!(thisBSMask != null ? otherBSMask == null && !thisBSMask.isEmpty() || otherBSMask != null && !thisBSMask.equals(otherBSMask) : otherBSMask != null && !otherBSMask.isEmpty())) continue;
                return false;
            }
        }
        return thisNumber.equals(otherNumber);
    }

    public boolean equalsNoMask(VlogBitVector obj) {
        if (this == obj) {
            return true;
        }
        VlogBitVector thisBS = this;
        VlogBitVector otherBS = obj;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BigInteger thisNumber = thisBS.getNumber();
        BigInteger otherNumber = otherBS.getNumber();
        if (!resultSign && thisBS.hasSign()) {
            thisNumber = VlogBitVector.signedToUnsigned(thisNumber, thisBS.getSize());
        }
        if (!resultSign && otherBS.hasSign()) {
            otherNumber = VlogBitVector.signedToUnsigned(otherNumber, otherBS.getSize());
        }
        return thisNumber.equals(otherNumber);
    }

    @Override
    public boolean isUnconstrainedFirstDimension() {
        return this.packed != null && this.packed.length != 0 && this.packed[0] == -1 && this.packed[1] == -1;
    }

    @Override
    public String xGetRawString() {
        if (!this.isString()) {
            return "";
        }
        return new String(this.getNumber().toByteArray(), IDVTConstants.ASCII);
    }

    @Override
    public VlogBitVector copy() {
        return VlogBitVector.copy(this);
    }

    public void packDPICSVLogicVecVal(MessagePacker buffer) throws IOException {
        int size = this.getSize();
        int chuncksSize = size / 32 + (size % 32 == 0 ? 0 : 1);
        buffer.packInt(chuncksSize);
        int i = 0;
        while (i < size) {
            int aVal = 0;
            int bVal = 0;
            int j = 0;
            while (j < 32) {
                if (this.hasMask(MaskType.X, i + j)) {
                    aVal |= 1 << j;
                    bVal |= 1 << j;
                } else if (this.hasMask(MaskType.Z, i + j)) {
                    bVal |= 1 << j;
                } else if (this.getNumber().testBit(i + j)) {
                    aVal |= 1 << j;
                }
                ++j;
            }
            buffer.packInt(aVal).packInt(bVal);
            i += 32;
        }
    }

    public void packDPICSVBitVecVal(MessagePacker buffer) throws IOException {
        BigInteger temp = this.getNumber();
        int size = this.getSize();
        int chuncksSize = size / 32 + (size % 32 == 0 ? 0 : 1);
        buffer.packInt(chuncksSize);
        int i = 0;
        while (i < size) {
            int chunk = temp.intValue();
            temp = temp.shiftRight(32);
            buffer.packInt(chunk);
            i += 32;
        }
    }

    public DriveStrength getDriveStrengthsAtIndex(int index) {
        EnumMap<MaskType, BitSet> masks = this.getMasks();
        if (masks == null || masks.isEmpty()) {
            return DriveStrength.STRONG;
        }
        DriveStrength result = null;
        for (Map.Entry<MaskType, BitSet> maskEntry : masks.entrySet()) {
            BitSet mask;
            MaskType maskType = maskEntry.getKey();
            if (maskType.ordinal() < MaskType.supply0.ordinal() || (mask = maskEntry.getValue()) == null || mask.isEmpty() || !mask.get(index)) continue;
            if (result == null) {
                result = new DriveStrength(MaskType.strong0, MaskType.strong1);
            }
            if (maskType.ordinal() > MaskType.highz0.ordinal()) {
                result.strength1 = maskType;
                continue;
            }
            result.strength0 = maskType;
        }
        if (result == null) {
            return DriveStrength.STRONG;
        }
        return result;
    }

    public VlogBitVector transformWithDriveStrength(MaskType drive0, MaskType drive1) {
        EnumMap<MaskType, BitSet> masks = VlogBitVector.copyMasks(this.getMasks(), MaskType.NonDriveStrengthMasks);
        if (masks == null) {
            masks = new EnumMap(MaskType.class);
        }
        BigInteger newNumber = this.number;
        int i = Math.min(this.getLeft(), this.getRight());
        while (i <= Math.max(this.getLeft(), this.getRight())) {
            if (this.hasMask(MaskType.X, i)) {
                MaskType.updateMaskBit(masks, drive0, i);
                MaskType.updateMaskBit(masks, drive1, i);
            } else {
                MaskType maskType = this.number.testBit(i) ? drive1 : drive0;
                MaskType.updateMaskBit(masks, maskType, i);
                if (maskType == MaskType.highz0 || maskType == MaskType.highz1) {
                    MaskType.updateMaskBit(masks, MaskType.Z, i);
                    newNumber = newNumber.clearBit(i);
                }
            }
            ++i;
        }
        return VlogBitVector.copy(this, newNumber, masks);
    }

    @Override
    public VlogBitVector toBitVector() {
        return this;
    }

    public VlogBitVector reverse(int chunkSize) {
        BigInteger value = this.bigIntegerValue();
        int size = this.getSize();
        BigInteger reversed = this.reverseNumber(value, chunkSize);
        EnumMap<MaskType, BitSet> masks = this.getMasks();
        EnumMap<MaskType, BitSet> resultMasks = null;
        if (masks != null && !masks.isEmpty()) {
            for (Map.Entry<MaskType, BitSet> entry : masks.entrySet()) {
                BitSet mask = entry.getValue();
                if (mask == null) continue;
                if (resultMasks == null) {
                    resultMasks = new EnumMap<MaskType, BitSet>(MaskType.class);
                }
                BitSet resultMask = this.reverseNumber(mask, chunkSize);
                resultMasks.put(entry.getKey(), resultMask);
            }
        }
        return VlogBitVector.create(false, size - 1, 0, this.packed, this.is4State, this.isString(), this.sign, false, null, resultMasks, reversed);
    }

    public static VlogBitVector getNetTypeDefault(IRfNamedElement.NetType type, VlogBitVector context) {
        EnumMap<MaskType, BitSet> masks = new EnumMap<MaskType, BitSet>(MaskType.class);
        switch (type) {
            case TRI_0: {
                masks.put(MaskType.pull0, BitSetUtils.getPowerOfTwoMask(context.getSize()));
                return VlogBitVector.copy(context, BigInteger.ZERO, masks);
            }
            case TRI_1: {
                masks.put(MaskType.pull1, BitSetUtils.getPowerOfTwoMask(context.getSize()));
                return VlogBitVector.copy(context, VlogBitVector.getPowerOfTwoMask(context.getSize()), masks);
            }
            case SUPPLY0: {
                masks.put(MaskType.supply0, BitSetUtils.getPowerOfTwoMask(context.getSize()));
                return VlogBitVector.copy(context, BigInteger.ZERO, masks);
            }
            case SUPPLY1: {
                masks.put(MaskType.supply1, BitSetUtils.getPowerOfTwoMask(context.getSize()));
                return VlogBitVector.copy(context, VlogBitVector.getPowerOfTwoMask(context.getSize()), masks);
            }
        }
        return null;
    }

    private BigInteger reverseNumber(BigInteger value, int chunkSize) {
        MutableBigInteger mb = MutableBigInteger.from((BigInteger)BigInteger.ZERO);
        int left = Integer.max(this.getLeft(), this.getRight());
        int right = Integer.min(this.getLeft(), this.getRight());
        int bitIndex = left;
        int i = right;
        while (i <= left) {
            int j = i + chunkSize - 1;
            while (j >= i) {
                if (value.testBit(j)) {
                    mb.setBit(bitIndex);
                }
                --bitIndex;
                --j;
            }
            i += chunkSize;
        }
        return mb.toBigInteger();
    }

    private BitSet reverseNumber(BitSet value, int chunkSize) {
        BitSet result = BitSetUtils.valueOf(0);
        int left = Integer.max(this.getLeft(), this.getRight());
        int right = Integer.min(this.getLeft(), this.getRight());
        int bitIndex = left;
        int i = right;
        while (i <= left) {
            int j = i + chunkSize - 1;
            while (j >= i) {
                if (value.get(j)) {
                    result.set(bitIndex);
                }
                --bitIndex;
                --j;
            }
            i += chunkSize;
        }
        return result;
    }

    public static enum CONTROL_BIT {
        ZERO,
        ONE,
        X,
        Z;

    }

    static class Converter {
        private boolean isSigned;
        private int radix;
        private int offset;
        private int[] lengths;
        private String bitOrHexVector;

        public Converter(String bitOrHexVector, boolean isSigned, int radix, int[] packedDims) {
            this.isSigned = isSigned;
            this.radix = radix;
            this.offset = 0;
            this.bitOrHexVector = bitOrHexVector;
            this.lengths = new int[packedDims.length];
            int rank = packedDims.length - 1;
            int i = 0;
            while (i < packedDims.length) {
                this.lengths[rank--] = packedDims[i + 1] - packedDims[i] + 1;
                i += 2;
            }
            this.lengths[0] = radix == 16 ? this.lengths[0] >> 2 : this.lengths[0];
        }

        public String getString() {
            return this.getString(this.lengths.length - 1);
        }

        private String getString(int rank) {
            if (rank == 0) {
                String number = this.bitOrHexVector.substring(this.offset, this.offset + this.lengths[0]);
                this.offset += this.lengths[0];
                if (this.radix == 10) {
                    return this.isSigned ? this.toStringAsSignedRadixTen(number) : this.toStringAsUnsignedRadixTen(number);
                }
                return number;
            }
            StringBuilder multiDimArray = new StringBuilder();
            multiDimArray.append('[');
            int i = 0;
            while (i < this.lengths[rank]) {
                multiDimArray.append(this.getString(rank - 1));
                multiDimArray.append(',');
                ++i;
            }
            multiDimArray.deleteCharAt(multiDimArray.length() - 1);
            multiDimArray.append(']');
            return multiDimArray.toString();
        }

        private String toStringAsUnsignedRadixTen(String binary) {
            return new BigInteger(binary, 2).toString(10);
        }

        private String toStringAsSignedRadixTen(String binary) {
            char[] bits = binary.toCharArray();
            if (bits[0] != '0') {
                int index = 0;
                while (index < bits.length) {
                    bits[index] = bits[index] == '0' ? 49 : 48;
                    ++index;
                }
                return new BigInteger(new String(bits), 2).add(BigInteger.ONE).negate().toString(10);
            }
            return new BigInteger(binary, 2).toString(10);
        }
    }

    public static class DriveStrength {
        public static final DriveStrength STRONG = new DriveStrength(MaskType.strong0, MaskType.strong1);
        public static final DriveStrength PULL = new DriveStrength(MaskType.pull0, MaskType.pull1);
        public static final DriveStrength SUPPLY = new DriveStrength(MaskType.supply0, MaskType.supply1);
        public MaskType strength0;
        public MaskType strength1;

        public DriveStrength(MaskType strength0, MaskType strength1) {
            this.strength0 = strength0;
            this.strength1 = strength1;
        }
    }

    public static class VlogBitVector__mask
    extends VlogBitVector {
        protected final EnumMap<MaskType, BitSet> masks;

        protected VlogBitVector__mask(boolean signed, int left, int right, int[] packed, boolean is4State, EnumMap<MaskType, BitSet> masks) {
            this(signed, left, right, packed, is4State, masks, BigInteger.ZERO);
        }

        protected VlogBitVector__mask(boolean signed, int left, int right, int[] packed, boolean is4State, EnumMap<MaskType, BitSet> masks, BigInteger number) {
            super(signed, left, right, packed, is4State, number);
            this.masks = Objects.requireNonNull(masks, "Mask cannot be null!");
        }

        @Override
        public BitSet getMask(MaskType type) {
            return this.masks.get((Object)type);
        }

        @Override
        public BitSet removeMask(MaskType type) {
            return this.masks.remove((Object)type);
        }

        @Override
        public EnumMap<MaskType, BitSet> getMasks() {
            return this.masks;
        }

        @Override
        public boolean hasMask(MaskType type, int index) {
            BitSet mask = this.masks.get((Object)type);
            return mask != null && mask.get(index);
        }

        @Override
        public boolean hasMask(MaskType ... types) {
            MaskType[] maskTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                MaskType maskType = maskTypeArray[n2];
                BitSet mask = this.masks.get((Object)maskType);
                if (mask != null && !mask.isEmpty()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public boolean isAmbiguous() {
            for (MaskType maskType : MaskType.NonDriveStrengthMasks) {
                BitSet mask = this.masks.get((Object)maskType);
                if (mask == null || mask.isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isUnknown() {
            return this.masks.get((Object)MaskType.UNKNOWN) != null;
        }

        @Override
        public int countBits(CONTROL_BIT bit) {
            if (this.getLeft() < 0 || this.getRight() < 0) {
                throw new IllegalArgumentException(this.getLeft() < 0 ? "Left index is negative" : "Right index is negative");
            }
            boolean isZeroOrOne = bit == CONTROL_BIT.ONE || bit == CONTROL_BIT.ZERO;
            int left = Integer.max(this.getLeft(), this.getRight());
            int right = Integer.min(this.getLeft(), this.getRight());
            BitSet orMask = new BitSet();
            for (MaskType maskType : MaskType.NonDriveStrengthMasks) {
                BitSet mask = this.masks.get((Object)maskType);
                if (mask == null || mask.isEmpty()) continue;
                orMask.or(mask);
            }
            int result = 0;
            int i = left;
            while (i >= right) {
                if (isZeroOrOne) {
                    if (!orMask.get(i)) {
                        result += this.getNumber().testBit(i) ^ bit == CONTROL_BIT.ONE ? 0 : 1;
                    }
                } else {
                    result += this.hasMask(bit == CONTROL_BIT.Z ? MaskType.Z : MaskType.X, i) ? 1 : 0;
                }
                --i;
            }
            return result;
        }

        @Override
        public VlogBitVector getAmbiguousBitResult() {
            boolean isUnknown = this.isUnknown();
            if (isUnknown) {
                return BIT_UNKNOWN;
            }
            for (MaskType maskType : MaskType.NonDriveStrengthMasks) {
                BitSet mask = this.getMask(maskType);
                if (mask == null || mask.isEmpty()) continue;
                return BIT_X;
            }
            return null;
        }

        @Override
        public VlogBitVector getAmbiguousBitResult(VlogBitVector bs) {
            VlogBitVector ambiguousBit1 = this.getAmbiguousBitResult();
            if (ambiguousBit1 == BIT_UNKNOWN) {
                return BIT_UNKNOWN;
            }
            VlogBitVector ambiguousBit2 = bs.getAmbiguousBitResult();
            if (ambiguousBit2 == BIT_UNKNOWN) {
                return BIT_UNKNOWN;
            }
            if (ambiguousBit1 != null || ambiguousBit2 != null) {
                return BIT_X;
            }
            return null;
        }
    }

    private static class VlogBitVector__mask__string
    extends VlogBitVector__mask {
        protected VlogBitVector__mask__string(boolean signed, int left, int right, int[] packed, boolean is4State, EnumMap<MaskType, BitSet> masks, BigInteger number) {
            super(signed, left, right, packed, is4State, masks.size() != 1 || !masks.containsKey((Object)MaskType.UNKNOWN) ? VlogBitVector__mask__string.createMaskOfType(MaskType.UNKNOWN, Math.abs(right - left + 1)) : masks, number);
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public boolean isEmptyString() {
            return false;
        }

        @Override
        public int getElementSize() {
            return 8;
        }

        @Override
        public DVTNumber substring(IELParamValue[] args, IHidEvaluationGuardian guardian) {
            if (args.length != 2 || DVTNumber.isUndefined(args[0].getDVTNumber()) || DVTNumber.isUndefined(args[1].getDVTNumber())) {
                return null;
            }
            if (args[0].isUnknown() || args[1].isUnknown()) {
                return new VlogBitVector__unknownSize(this.sign, this.is4State, true);
            }
            int arg0 = args[0].intValue();
            int arg1 = args[1].intValue();
            if (arg0 < 0 || arg0 > arg1) {
                return EMPTY_STRING_CHARACTER;
            }
            int[] firstDimension = this.getFirstDimension();
            if (this.isOutOfRangeSelect(arg0, firstDimension)) {
                return EMPTY_STRING_CHARACTER;
            }
            if (this.isOutOfRangeSelect(arg1, firstDimension)) {
                return EMPTY_STRING_CHARACTER;
            }
            int nofCharsSelected = Math.abs(arg1 - arg0) + 1;
            VlogBitVector select0 = VlogBitVector__mask__string.createConstant(arg0 * 8);
            VlogBitVector select1 = VlogBitVector__mask__string.createConstant(select0.intValue() + nofCharsSelected * 8 - 1);
            VlogBitVector nonStringBitVector = VlogBitVector__mask__string.create(this.sign, this.getLeft(), this.getRight(), this.packed, this.is4State, false, this.is4State, this.hasUnknownSize(), this.getMemberInfoByName(), this.getMasks(), this.getNumber());
            XComputedSelect computedSelect = new XComputedSelect(null, ELParamValues.ParamValueNumber.of(select0), ELParamValues.ParamValueNumber.of(select1));
            VlogBitVector result = (VlogBitVector)nonStringBitVector.getRangeSelect(computedSelect, false, LanguageKind.VLOG);
            result.packed[1] = result.packed[1] - result.packed[0];
            result.packed[0] = 0;
            return VlogBitVector__mask__string.create(result.sign, result.getLeft(), result.getRight(), result.packed, result.is4State, true, result.is4State, false, result.getMemberInfoByName(), result.getMasks(), result.getNumber());
        }

        @Override
        public DVTNumber getDefaultValue(boolean force4State) {
            return this.copy();
        }

        @Override
        public int[] getFirstDimension() {
            this.getNumber();
            if (this.packed == null) {
                this.packed = VlogBitVector.getIntPair(this.getSize() - 1, 0);
            }
            if (this.packed.length == 0) {
                return null;
            }
            if (this.packed[0] == -1 && this.packed[1] == -1) {
                return VlogBitVector.getIntPair(this.packed[0], this.packed[1]);
            }
            if (this.packed[0] < this.packed[1]) {
                return VlogBitVector.getIntPair(this.packed[0], this.packed[1] / 8);
            }
            return VlogBitVector.getIntPair(this.packed[0] / 8, this.packed[1]);
        }

        @Override
        public VlogBitVector decreaseDimension() {
            return new VlogBitVector__mask__string(false, 7, 0, VlogBitVector.getIntPair(7, 0), this.is4State, this.masks, BigInteger.ZERO);
        }
    }

    private static class VlogBitVector__string
    extends VlogBitVector {
        private String cachedString;

        public VlogBitVector__string(boolean signed, int left, int right, int[] packed, boolean is4State, BigInteger number) {
            super(signed, left, right, packed, is4State, number);
            this.cachedString = null;
        }

        public VlogBitVector__string(boolean signed, int left, int right, int[] packed, boolean is4State, String cachedString) {
            super(signed, left, right, packed, is4State, BigInteger.ZERO);
            this.cachedString = cachedString;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public VlogBitVector getRangeAbsolute(int start, int size) {
            this.getNumber();
            return super.getRangeAbsolute(start, size);
        }

        @Override
        public VlogBitVector getRange(int left, int right) {
            this.getNumber();
            return super.getRange(left, right);
        }

        @Override
        protected VlogBitVector getRange(int rangeLeft, int rangeRight, boolean forceSign, boolean forceSignExtension, boolean is4State, boolean isString, Map<String, StructMemberContextInfo> membersInfoByName) {
            this.getNumber();
            return super.getRange(rangeLeft, rangeRight, forceSign, forceSignExtension, is4State, isString, membersInfoByName);
        }

        @Override
        public DVTNumber getBitSelect(int startPos, int size) {
            this.getNumber();
            return super.getBitSelect(startPos, size);
        }

        @Override
        public int getSize() {
            if (this.cachedString == null) {
                return super.getSize();
            }
            return this.cachedString.length() * 8;
        }

        @Override
        public int[] getArrayDimensions() {
            if (this.cachedString == null) {
                if (this.packed == null) {
                    this.packed = VlogBitVector.getIntPair(0, this.getSize() - 1);
                }
                return this.packed;
            }
            byte[] specifiedBytes = this.cachedString.getBytes(IDVTConstants.ASCII);
            return VlogBitVector.getIntPair(0, specifiedBytes.length * 8 - 1);
        }

        @Override
        public DVTNumber getRangeSelect(XComputedSelect computedSelect, boolean evaluateForSize, LanguageKind languageKind) {
            this.getNumber();
            return super.getRangeSelect(computedSelect, evaluateForSize, languageKind);
        }

        @Override
        public boolean isEmptyString() {
            return this.cachedString == null ? BigInteger.ZERO.compareTo(this.getNumber()) == 0 : this.cachedString.isEmpty();
        }

        @Override
        public VlogBitVector toVlogStringCompatibleBitVector() {
            if (this.cachedString == null) {
                return super.toVlogStringCompatibleBitVector();
            }
            return this;
        }

        @Override
        public BigInteger getNumber() {
            if (this.cachedString == null) {
                return super.getNumber();
            }
            byte[] specifiedBytes = this.cachedString.getBytes(IDVTConstants.ASCII);
            this.setNumber(new BigInteger(specifiedBytes));
            this.setArrayDimensions(new int[]{this.getLeft(), specifiedBytes.length * 8 - 1});
            this.cachedString = null;
            return super.getNumber();
        }

        @Override
        public DVTNumber substring(IELParamValue[] args, IHidEvaluationGuardian guardian) {
            if (args.length != 2 || DVTNumber.isUndefined(args[0].getDVTNumber()) || DVTNumber.isUndefined(args[1].getDVTNumber())) {
                return null;
            }
            if (args[0].isUnknown() || args[1].isUnknown()) {
                return new VlogBitVector__unknownSize(this.sign, this.is4State, true);
            }
            int arg0 = args[0].intValue();
            int arg1 = args[1].intValue();
            if (arg0 < 0 || arg0 > arg1) {
                return EMPTY_STRING_CHARACTER;
            }
            int[] firstDimension = this.getFirstDimension();
            if (this.isOutOfRangeSelect(arg0, firstDimension)) {
                return EMPTY_STRING_CHARACTER;
            }
            if (this.isOutOfRangeSelect(arg1, firstDimension)) {
                return EMPTY_STRING_CHARACTER;
            }
            int[] arrayDimensions = this.getArrayDimensions();
            boolean increasing = arrayDimensions[0] < arrayDimensions[1];
            int nofCharsSelected = Math.abs(arg1 - arg0) + 1;
            VlogBitVector select0 = VlogBitVector__string.createConstant(arg0 * 8);
            VlogBitVector select1 = VlogBitVector__string.createConstant(select0.intValue() + nofCharsSelected * 8 - 1);
            VlogBitVector nonStringBitVector = VlogBitVector__string.create(this.sign, this.getLeft(), this.getRight(), arrayDimensions, this.is4State, false, this.is4State, this.hasUnknownSize(), this.getMemberInfoByName(), this.getMasks(), this.getNumber());
            XComputedSelect computedSelect = increasing ? new XComputedSelect(null, ELParamValues.ParamValueNumber.of(select0), ELParamValues.ParamValueNumber.of(select1)) : new XComputedSelect(null, ELParamValues.ParamValueNumber.of(select1), ELParamValues.ParamValueNumber.of(select0));
            VlogBitVector result = (VlogBitVector)nonStringBitVector.getRangeSelect(computedSelect, false, LanguageKind.VLOG);
            result.packed[1] = result.packed[1] - result.packed[0];
            result.packed[0] = 0;
            return VlogBitVector__string.create(result.sign, result.getLeft(), result.getRight(), result.packed, result.is4State, true, result.is4State, false, result.getMemberInfoByName(), result.getMasks(), result.getNumber());
        }

        @Override
        public int getElementSize() {
            return 8;
        }

        @Override
        public DVTNumber getDefaultValue(boolean force4State) {
            if (this.cachedString != null) {
                if (this.cachedString.isEmpty()) {
                    return EMPTY_STRING_CHARACTER;
                }
                return VlogBitVector__string.create(false, this.cachedString.length() * 8 - 1, 0, null, false, true, BigInteger.ZERO);
            }
            if (this.getSize() < 8) {
                return EMPTY_STRING_CHARACTER;
            }
            return VlogBitVector__string.create(false, this.getLeft(), this.getRight(), this.getArrayDimensions(), false, true, BigInteger.ZERO);
        }

        @Override
        public int[] getFirstDimension() {
            this.getNumber();
            if (this.packed == null) {
                this.packed = VlogBitVector.getIntPair(this.getSize() - 1, 0);
            }
            if (this.packed.length == 0) {
                return null;
            }
            if (this.packed[0] == -1 && this.packed[1] == -1) {
                return VlogBitVector.getIntPair(this.packed[0], this.packed[1]);
            }
            if (this.packed[0] < this.packed[1]) {
                return VlogBitVector.getIntPair(this.packed[0], this.packed[1] / 8);
            }
            return VlogBitVector.getIntPair(this.packed[0] / 8, this.packed[1]);
        }

        @Override
        public VlogBitVector decreaseDimension() {
            return new VlogBitVector__string(false, 7, 0, VlogBitVector.getIntPair(7, 0), this.is4State, BigInteger.ZERO);
        }

        @Override
        public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return this.stringValue(radix == -2);
        }

        @Override
        public String stringValue(boolean isUnquoted) {
            if (this.isEmptyString()) {
                return isUnquoted ? "" : "\"\"";
            }
            if (!this.isString()) {
                throw new UnsupportedOperationException("Not a string!");
            }
            if (this.cachedString != null) {
                return isUnquoted ? this.cachedString : "\"" + this.cachedString + "\"";
            }
            return super.stringValue(isUnquoted);
        }

        @Override
        public String toString() {
            return this.stringValue(false);
        }

        @Override
        public DVTNumber updateSelects(DVTNumber updateValue, ListContainer<XComputedSelect> computedSelects) {
            this.getNumber();
            return super.updateSelects(updateValue, computedSelects);
        }

        @Override
        public String toString(int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return radix == -1 ? super.toString(2, useCharLimit, useLowerCaseMaskType) : this.stringValue(false);
        }

        @Override
        public String print(int radix, boolean stripLeadingZeroes, int width, boolean useLowerCaseMaskType, boolean structAssignPattern) {
            return radix == -1 ? super.print(2, stripLeadingZeroes, width, useLowerCaseMaskType, structAssignPattern) : this.prepend(" ", width, this.stringValue(false));
        }

        @Override
        public int hashCode() {
            return this.toNiceString(null, -1, false, false).hashCode();
        }

        @Override
        public boolean equals(VlogBitVector obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof VlogBitVector__string) {
                VlogBitVector__string meString = this;
                VlogBitVector__string objString = (VlogBitVector__string)obj;
                if (meString.cachedString == null && objString.cachedString == null) {
                    return super.equals(obj);
                }
                String meCachedString = meString.cachedString != null ? meString.cachedString : this.stringValue(true);
                String objCachedString = objString.cachedString != null ? objString.cachedString : objString.stringValue(true);
                return meCachedString.equals(objCachedString);
            }
            return super.equals(obj);
        }
    }

    private static class VlogBitVector__unknownSize
    extends VlogBitVector {
        private final boolean isString;

        protected VlogBitVector__unknownSize(boolean signed, boolean is4State, boolean isString) {
            super(signed, 0, 0, null, is4State, BigInteger.ZERO);
            this.isString = isString;
        }

        @Override
        public BitSet getMask(MaskType type) {
            return type == MaskType.UNKNOWN ? BitSetUtils.valueOf(1) : null;
        }

        @Override
        public EnumMap<MaskType, BitSet> getMasks() {
            EnumMap<MaskType, BitSet> masks = new EnumMap<MaskType, BitSet>(MaskType.class);
            masks.put(MaskType.UNKNOWN, BitSetUtils.valueOf(1));
            return masks;
        }

        @Override
        public boolean hasMask(MaskType type, int index) {
            return type == MaskType.UNKNOWN;
        }

        @Override
        public boolean hasMask(MaskType ... types) {
            MaskType[] maskTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                MaskType type = maskTypeArray[n2];
                if (type == MaskType.UNKNOWN) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public boolean isAmbiguous() {
            return true;
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public boolean isString() {
            return this.isString;
        }

        @Override
        public boolean hasUnknownSize() {
            return true;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public int countBits(CONTROL_BIT bit) {
            return 0;
        }

        @Override
        public VlogBitVector getAmbiguousBitResult() {
            return BIT_UNKNOWN;
        }

        @Override
        public VlogBitVector getAmbiguousBitResult(VlogBitVector bs) {
            return BIT_UNKNOWN;
        }

        @Override
        public int getElementSize() {
            return this.isString ? 8 : 1;
        }

        @Override
        public VlogBitVector from(VlogBitVector bs) {
            return new VlogBitVector__unknownSize(this.hasSign(), this.is4State(), this.isString());
        }

        @Override
        public VlogBitVector from(VlogAbstractRealNumber bs) {
            return new VlogBitVector__unknownSize(this.hasSign(), this.is4State(), this.isString());
        }

        @Override
        public DVTNumber getRangeSelect(XComputedSelect computedSelect, boolean evaluateForSize, LanguageKind languageKind) {
            if (this.packed == null) {
                this.packed = VlogBitVector.getIntPair(this.getSize() - 1, 0);
            }
            if (this.packed == null || this.packed.length == 0) {
                throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
            }
            IELParamValue[] numberSelects = computedSelect.computedValues;
            if (numberSelects.length == 1) {
                if (ELUtils.isUnsuccessfulEval(numberSelects[0])) {
                    throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
                }
            } else if (numberSelects.length == 2) {
                if (ELUtils.isUnsuccessfulEval(numberSelects[0]) || ELUtils.isUnsuccessfulEval(numberSelects[1])) {
                    throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
                }
            } else {
                throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
            }
            int elementSize = this.getElementSize();
            int[] selects = new int[2];
            boolean isIndexPartSelect = computedSelect.isPlusIndexPartSelect || computedSelect.isMinusIndexPartSelect;
            boolean increasing = this.isString;
            if (numberSelects.length == 1 && numberSelects[0].isAmbiguous()) {
                if (this.isString) {
                    return numberSelects[0].isUnknown() ? UNKNOWN_STRING_CHARACTER : EMPTY_STRING_CHARACTER;
                }
                return this;
            }
            if (numberSelects.length == 2) {
                if (numberSelects[1].isAmbiguous()) {
                    return this;
                }
                if (numberSelects[0].isAmbiguous()) {
                    if (!isIndexPartSelect || VlogBitVector.intValueNoExceptionOnUndefinedNumber(numberSelects[1]) <= 0 || !this.isString) {
                        return this;
                    }
                    return numberSelects[0].isUnknown() ? UNKNOWN_STRING_CHARACTER : EMPTY_STRING_CHARACTER;
                }
            }
            int i = 0;
            while (i < numberSelects.length) {
                selects[i] = VlogBitVector.intValueNoExceptionOnUndefinedNumber(numberSelects[i]);
                ++i;
            }
            if (numberSelects.length == 1) {
                selects = new int[]{selects[0], selects[0]};
            }
            boolean bl = evaluateForSize ? increasing : (increasing = selects[0] < selects[1]);
            if (isIndexPartSelect) {
                if (selects[1] <= 0) {
                    return this;
                }
                if (computedSelect.isPlusIndexPartSelect) {
                    if (!increasing) {
                        firstSelectValue = evaluateForSize ? this.packed[1] : selects[0];
                        selects = new int[]{firstSelectValue + selects[1] - 1, firstSelectValue};
                    } else {
                        firstSelectValue = evaluateForSize ? this.packed[0] : selects[0];
                        selects = new int[]{firstSelectValue, firstSelectValue + selects[1] - 1};
                    }
                } else if (computedSelect.isMinusIndexPartSelect) {
                    if (!increasing) {
                        firstSelectValue = evaluateForSize ? this.packed[0] : selects[0];
                        selects = new int[]{firstSelectValue, firstSelectValue - selects[1] + 1};
                    } else {
                        firstSelectValue = evaluateForSize ? this.packed[1] : selects[0];
                        selects = new int[]{firstSelectValue - selects[1] + 1, firstSelectValue};
                    }
                }
            }
            if (this.isString) {
                int nofElems = Math.abs(selects[1] - selects[0]) + 1;
                if (increasing) {
                    origLow = this.packed[0];
                    int msb = origLow + 8 * Math.abs(selects[0] - origLow);
                    int lsb = msb + 8 * nofElems - 1;
                    selects = new int[]{msb, lsb};
                } else {
                    origLow = this.packed[1];
                    int lsb = origLow + 8 * Math.abs(selects[1] - origLow);
                    int msb = lsb + 8 * nofElems - 1;
                    selects = new int[]{msb, lsb};
                }
            }
            int selectSize = Math.abs(selects[0] - selects[1]) + 1;
            if (evaluateForSize) {
                return VlogBitVector.create(false, selectSize - 1, 0, null, this.is4State(), false, BigInteger.ZERO);
            }
            boolean isBitSelect = selects[0] == selects[1];
            int dimensionSize = this.isString ? 1 : elementSize;
            int fullSize = this.getSize();
            DVTNumber result = DVTNumber.UNDEFINED;
            if (isBitSelect) {
                int selectValue = selects[0];
                if (increasing) {
                    int msb = (selectValue - this.packed[0]) * dimensionSize;
                    int lsb = msb + dimensionSize - 1;
                    result = this.getRange(fullSize - msb - 1, fullSize - lsb - 1, false, false, this.is4State(), false, this.getMemberInfoByName());
                } else {
                    int lsb = (selectValue - this.packed[1]) * dimensionSize;
                    int msb = lsb + dimensionSize - 1;
                    result = this.getRange(msb, lsb, false, false, this.is4State(), false, this.getMemberInfoByName());
                }
                return result;
            }
            int newLH = selects[0];
            int newRH = selects[1];
            if (increasing) {
                int msb = (selects[0] - newLH) * dimensionSize;
                int lsb = msb + dimensionSize * (newRH - newLH + 1) - 1;
                result = this.getRange(fullSize - msb - 1, fullSize - lsb - 1, false, false, this.is4State(), false, null);
            } else {
                int msb = (selects[1] - newRH) * dimensionSize;
                int lsb = msb + dimensionSize * (newLH - newRH + 1) - 1;
                result = this.getRange(lsb, msb, false, false, this.is4State(), false, null);
            }
            return result;
        }

        @Override
        protected VlogBitVector getRange(int rangeLeft, int rangeRight, boolean forceSign, boolean forceSignExtension, boolean is4State, boolean isString, Map<String, StructMemberContextInfo> membersInfoByName) {
            int resultSize = Math.max(rangeLeft, rangeRight) - Math.min(rangeLeft, rangeRight) + 1;
            int newLeft = rangeLeft > rangeRight ? resultSize - 1 : 0;
            int newRight = rangeLeft > rangeRight ? 0 : resultSize - 1;
            return VlogBitVector__unknownSize.create(forceSign, newLeft, newRight, null, is4State, isString, false, false, membersInfoByName, VlogBitVector__unknownSize.createMaskOfType(MaskType.UNKNOWN, resultSize), this.getNumber());
        }

        @Override
        protected boolean isOutOfRangeSelect(int i, int[] dimension) {
            return false;
        }

        @Override
        public VlogBitVector updateSlice(int lsb, int msb, VlogBitVector updated, int ignoreBitsMsb, int ignoreBitsLsb) {
            return this;
        }

        @Override
        public VlogBitVector reverse(int chunkSize) {
            return this;
        }

        @Override
        public String toString(int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return "?...?";
        }
    }
}

