/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.interpreter.XNamedComputedSelect;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidNameAndSelects;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.IDVTMemberSelectable;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.StructMemberContextInfo;
import ro.amiq.dvt.utils.VlogBitVector;

public class VlogBitVector__structMemberInfo
extends VlogBitVector
implements IDVTMemberSelectable {
    private final Map<String, StructMemberContextInfo> memberInfoByName;
    private final boolean isUnion;
    private int structSize;

    public VlogBitVector__structMemberInfo(boolean signed, int left, int right, int[] packed, boolean is4State, boolean isUnion, Map<String, StructMemberContextInfo> memberInfoByName) {
        super(signed, left, right, packed, is4State);
        this.memberInfoByName = memberInfoByName;
        this.isUnion = isUnion;
    }

    public VlogBitVector__structMemberInfo(boolean signed, int left, int right, int[] packed, boolean is4State, boolean isUnion, Map<String, StructMemberContextInfo> memberInfoByName, BigInteger number) {
        super(signed, left, right, packed, is4State, number);
        this.memberInfoByName = memberInfoByName;
        this.isUnion = isUnion;
    }

    @Override
    public ElementPath getInstancePath() {
        return super.getInstancePath();
    }

    @Override
    public boolean is4State() {
        for (Map.Entry<String, StructMemberContextInfo> entry : this.memberInfoByName.entrySet()) {
            if (entry.getValue().context == null || entry.getValue().context.getContextNumber() == null || !entry.getValue().context.getContextNumber().is4State()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStruct(boolean isStructOrUnion) {
        return !this.isUnion || isStructOrUnion;
    }

    @Override
    public boolean isUnion() {
        return this.isUnion;
    }

    @Override
    public Map<String, StructMemberContextInfo> getMemberInfoByName() {
        return this.memberInfoByName;
    }

    @Override
    public int getSizeIgnoreDimensions() {
        if (this.structSize <= 0) {
            if (this.packed.length == 2) {
                this.structSize = this.getSize();
                return this.structSize;
            }
            this.structSize = 0;
            for (Map.Entry<String, StructMemberContextInfo> entry : this.memberInfoByName.entrySet()) {
                this.structSize += entry.getValue().context.getContextNumber().getSize();
            }
        }
        return this.structSize;
    }

    @Override
    public DVTNumber getDefaultValue(boolean force4State) {
        if (this.left < this.right) {
            throw new UnsupportedOperationException("Packed structs bit vectors should have decreasing packed dimension!");
        }
        int structSize = this.getSizeIgnoreDimensions();
        VlogBitVector structInitialValue = this.getStructInitialValue(structSize, force4State);
        if (this.packed.length == 2) {
            return structInitialValue;
        }
        return VlogBitVector.createArrayFromStructValue(this, structInitialValue, structSize);
    }

    private VlogBitVector getStructInitialValue(int structSize, boolean force4State) {
        boolean hasExtraPacked = this.packed.length > 2;
        boolean is4StateStruct = force4State || this.is4State();
        int[] newPacked = new int[2];
        System.arraycopy(this.packed, hasExtraPacked ? this.packed.length - 2 : 0, newPacked, 0, 2);
        VlogBitVector result = new VlogBitVector__structMemberInfo(this.sign, structSize - 1, 0, newPacked, is4StateStruct, false, this.memberInfoByName);
        for (Map.Entry<String, StructMemberContextInfo> entry : this.memberInfoByName.entrySet()) {
            String name = entry.getKey();
            StructMemberContextInfo info = entry.getValue();
            DVTNumber structMemberUpdateValue = info.context.getContextNumber().getDefaultValue(is4StateStruct);
            result = (VlogBitVector)((IDVTMemberSelectable)((Object)result)).updateMemberSelects(new IHidEvaluator.NullHidEvaluator(), structMemberUpdateValue, Arrays.asList(new HidNameAndSelects(name)), null);
        }
        return result;
    }

    @Override
    public DVTNumber updateMemberSelects(IHidEvaluator evaluator, DVTNumber updateValue, List<HidNameAndSelects> nameSelects, IHidEvaluationGuardian guardian) {
        if (this.left < this.right) {
            throw new UnsupportedOperationException("Packed structs bit vectors should have decreasing packed dimension!");
        }
        DVTNumber nextContext = this;
        int dimensionHigh = this.left;
        int dimensionLow = this.right;
        int extraPackedIndex = 0;
        int i = 0;
        while (i < nameSelects.size()) {
            block15: {
                boolean isNotStruct;
                HidNameAndSelects hidNameAndSelects;
                block13: {
                    StructMemberContextInfo memberContextInfo;
                    block16: {
                        block14: {
                            hidNameAndSelects = nameSelects.get(i);
                            String name = hidNameAndSelects.name;
                            isNotStruct = false;
                            if (name == null) break block13;
                            if (!(nextContext instanceof VlogBitVector)) {
                                return this;
                            }
                            Map<String, StructMemberContextInfo> memberInfoByName = ((VlogBitVector)nextContext).getMemberInfoByName();
                            if (memberInfoByName == null) {
                                return this;
                            }
                            memberContextInfo = memberInfoByName.get(name);
                            if (memberContextInfo != null && memberContextInfo.context != null) break block14;
                            if (i != 0) {
                                return this;
                            }
                            break block15;
                        }
                        if (!((DVTNumber)nextContext).isUnion()) break block16;
                        dimensionHigh -= memberContextInfo.startingIndex;
                        nextContext = memberContextInfo.context.getContextNumber();
                        break block15;
                    }
                    nextContext = memberContextInfo.context.getContextNumber();
                    dimensionLow = (dimensionHigh -= memberContextInfo.startingIndex) - memberContextInfo.context.getSize() + 1;
                    extraPackedIndex = 0;
                    boolean bl = isNotStruct = !(nextContext instanceof VlogBitVector) && !((VlogBitVector)nextContext).isStruct(true);
                    if (i != nameSelects.size() - 1 && isNotStruct) break block15;
                }
                if (hidNameAndSelects.selects != null) {
                    if (isNotStruct) {
                        return this;
                    }
                    int[] extraPacked = ((VlogBitVector)nextContext).getArrayDimensions();
                    if (extraPacked == null || extraPacked.length == 0) {
                        return this;
                    }
                    ListContainer<XComputedSelect> computeSelects = hidNameAndSelects.selects;
                    for (XComputedSelect select : computeSelects) {
                        int leftPacked = extraPacked[extraPackedIndex];
                        int rightPacked = extraPacked[extraPackedIndex + 1];
                        int elementSize = (Math.abs(dimensionLow - dimensionHigh) + 1) / (Math.abs(rightPacked - leftPacked) + 1);
                        int select0IntValue = select.computedValues[0].intValue();
                        int select1IntValue = select.computedValues.length == 2 ? select.computedValues[1].intValue() : select0IntValue;
                        int skipHigh = Math.abs(select0IntValue - leftPacked) * elementSize;
                        int skipLow = Math.abs(select1IntValue - rightPacked) * elementSize;
                        dimensionHigh -= skipHigh;
                        dimensionLow += skipLow;
                        extraPackedIndex += 2;
                    }
                }
            }
            ++i;
        }
        return this.updateSlice(dimensionLow, dimensionHigh, (VlogBitVector)updateValue, 0, 0);
    }

    @Override
    public DVTNumber updateSelects(DVTNumber updateValue, ListContainer<XComputedSelect> computedSelects) {
        ArrayList<HidNameAndSelects> namesAndSelects = new ArrayList<HidNameAndSelects>();
        for (XComputedSelect select : computedSelects) {
            if (select instanceof XNamedComputedSelect) {
                if (select.getSelectObject() == null || !HidUtils.isHid(select.getSelectObject())) {
                    return DVTNumber.UNDEFINED;
                }
                namesAndSelects.add(new HidNameAndSelects(((Hid)select.getSelectObject()).getName()));
                continue;
            }
            namesAndSelects.add(new HidNameAndSelects(null, OptimizedUtils.listContainerCreate(Arrays.asList(select), true)));
        }
        return this.updateMemberSelects(null, updateValue, namesAndSelects, null);
    }

    @Override
    public DVTNumber getMemberSelect(IHid hidSelect, boolean evaluateForSize) {
        if (this.left < this.right) {
            throw new UnsupportedOperationException("Packed structs bit vectors should have decreasing packed dimension!");
        }
        Map<String, StructMemberContextInfo> membersInfo = this.getMemberInfoByName();
        if (hidSelect == null || membersInfo == null || membersInfo.isEmpty() || this.packed == null || this.packed.length == 0) {
            return DVTNumber.UNDEFINED;
        }
        int dimensionHigh = this.left;
        int dimensionLow = this.right;
        String selectedName = hidSelect.getName();
        StructMemberContextInfo memberContextInfo = membersInfo.get(selectedName);
        if (memberContextInfo == null || memberContextInfo.context == null) {
            return DVTNumber.UNDEFINED;
        }
        if (this.isUnion) {
            return memberContextInfo.context.transform(this.getRange(dimensionHigh, dimensionLow));
        }
        int lh = dimensionHigh - memberContextInfo.startingIndex;
        int rh = dimensionHigh - (memberContextInfo.startingIndex + memberContextInfo.context.getSize()) + 1;
        return memberContextInfo.context.transform(this.getRange(lh, rh));
    }
}

