/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigInteger;
import java.math.RoundingMode;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VlogAbstractRealNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class VlogRealNumber
extends VlogAbstractRealNumber {
    public static final VlogRealNumber ZERO = ConstVlogRealNumber.create(0.0);
    public static final VlogRealNumber MINUS_ZERO = ConstVlogRealNumber.create(-0.0);
    public static final VlogRealNumber ONE = ConstVlogRealNumber.create(1.0);
    public static final VlogRealNumber UNKNOWN = ConstVlogRealNumber.create(0.0);
    public static final VlogRealNumber INFINITY = ConstVlogRealNumber.create(Double.POSITIVE_INFINITY);
    public static final VlogRealNumber NEGATIVE_INFINITY = ConstVlogRealNumber.create(Double.NEGATIVE_INFINITY);
    public static final VlogRealNumber NAN = ConstVlogRealNumber.create(Double.NaN);
    private double number;

    public static VlogRealNumber copy(VlogRealNumber realNumber) {
        return new VlogRealNumber(realNumber.number);
    }

    public static VlogRealNumber create(double number) {
        if (number == Double.POSITIVE_INFINITY) {
            return INFINITY;
        }
        if (number == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (Double.isNaN(number)) {
            return NAN;
        }
        if (Double.compare(number, 0.0) == 0) {
            return ZERO;
        }
        if (Double.compare(number, -0.0) == 0) {
            return MINUS_ZERO;
        }
        return new VlogRealNumber(number);
    }

    public VlogRealNumber(double number) {
        this.number = number;
    }

    @Override
    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    @Override
    public double doubleValue() {
        return this.number;
    }

    public VlogRealNumber setValue(double number) {
        return VlogRealNumber.create(number);
    }

    @Override
    public BigInteger bigIntegerValue() {
        if (Double.isInfinite(this.number) || Double.isNaN(this.number)) {
            return BigInteger.ZERO;
        }
        return this.bigDecimalValue().setScale(0, RoundingMode.HALF_UP).toBigInteger();
    }

    @Override
    public DVTNumber from(DVTNumber number, boolean isCast) {
        return number != null ? (number.isUnknown() ? UNKNOWN : new VlogRealNumber(number.doubleValue())) : null;
    }

    @Override
    public VlogBitVector toBitVectorNumber(boolean sign, int size) {
        if (this == UNKNOWN) {
            return VlogBitVector.create(sign, size - 1, 0, null, false, false, false, false, null, VlogBitVector.createMaskOfType(MaskType.UNKNOWN, size));
        }
        if (Double.isInfinite(this.number) || Double.isNaN(this.number)) {
            return VlogBitVector.create(sign, size - 1, 0, BigInteger.ZERO);
        }
        BigInteger bigInteger = this.bigDecimalValue().toBigInteger();
        return VlogBitVector.create(sign, size - 1, 0, bigInteger);
    }

    @Override
    public int getSize() {
        return 64;
    }

    @Override
    public String print(int radix, boolean stripLeadingZeroes, int width, boolean useLowerCaseMaskType, boolean structAssignPattern) {
        return this == UNKNOWN ? "?.?" : Double.toString(this.number);
    }

    public String toString() {
        return this.toString(10, false, false);
    }

    @Override
    public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        return this.toString();
    }

    @Override
    public String toString(int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        return this == UNKNOWN ? "?.?" : Double.toString(this.number);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + Double.hashCode(this.number);
        return result;
    }

    @Override
    public VlogRealNumber copy() {
        VlogRealNumber result = new VlogRealNumber(this.number);
        result.uniqueId = this.uniqueId;
        return result;
    }

    @Override
    public DVTNumber getDefaultValue(boolean force4State) {
        return VlogRealNumber.create(0.0);
    }

    public static class ConstVlogRealNumber
    extends VlogRealNumber {
        public static VlogRealNumber create(double number) {
            return new ConstVlogRealNumber(number);
        }

        protected ConstVlogRealNumber(double number) {
            super(number);
        }
    }
}

