/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigInteger;
import java.math.RoundingMode;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VlogAbstractRealNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class VlogShortrealNumber
extends VlogAbstractRealNumber {
    public static final VlogShortrealNumber ZERO = ConstVlogShortrealNumber.create(0.0f);
    public static final VlogShortrealNumber MINUS_ZERO = ConstVlogShortrealNumber.create(-0.0f);
    public static final VlogShortrealNumber ONE = ConstVlogShortrealNumber.create(1.0f);
    public static final VlogShortrealNumber UNKNOWN = ConstVlogShortrealNumber.create(0.0f);
    public static final VlogShortrealNumber INFINITY = ConstVlogShortrealNumber.create(Float.POSITIVE_INFINITY);
    public static final VlogShortrealNumber NEGATIVE_INFINITY = ConstVlogShortrealNumber.create(Float.NEGATIVE_INFINITY);
    public static final VlogShortrealNumber NAN = ConstVlogShortrealNumber.create(Float.NaN);
    private float number;

    public static VlogShortrealNumber copy(VlogShortrealNumber realNumber) {
        return new VlogShortrealNumber(realNumber.number);
    }

    public static VlogShortrealNumber create(float number) {
        if (number == Float.POSITIVE_INFINITY) {
            return INFINITY;
        }
        if (number == Float.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (Float.isNaN(number)) {
            return NAN;
        }
        if (Float.compare(number, 0.0f) == 0) {
            return ZERO;
        }
        if (Float.compare(number, -0.0f) == 0) {
            return MINUS_ZERO;
        }
        return new VlogShortrealNumber(number);
    }

    public VlogShortrealNumber(float number) {
        this.number = number;
    }

    @Override
    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    @Override
    public double doubleValue() {
        return this.number;
    }

    @Override
    public float floatValue() {
        return this.number;
    }

    public VlogShortrealNumber setValue(float number) {
        return VlogShortrealNumber.create(number);
    }

    @Override
    public BigInteger bigIntegerValue() {
        if (Float.isInfinite(this.number) || Float.isNaN(this.number)) {
            return BigInteger.ZERO;
        }
        return this.bigDecimalValue().setScale(0, RoundingMode.HALF_UP).toBigInteger();
    }

    @Override
    public DVTNumber from(DVTNumber number, boolean isCast) {
        return number != null ? (number.isUnknown() ? UNKNOWN : new VlogShortrealNumber(number.floatValue())) : null;
    }

    @Override
    public VlogBitVector toBitVectorNumber(boolean sign, int size) {
        if (this == UNKNOWN) {
            return VlogBitVector.create(sign, size - 1, 0, null, false, false, false, false, null, VlogBitVector.createMaskOfType(MaskType.UNKNOWN, size));
        }
        if (Float.isInfinite(this.number) || Float.isNaN(this.number)) {
            return VlogBitVector.create(sign, size - 1, 0, BigInteger.ZERO);
        }
        BigInteger bigInteger = this.bigDecimalValue().toBigInteger();
        return VlogBitVector.create(sign, size - 1, 0, bigInteger);
    }

    @Override
    public int getSize() {
        return 32;
    }

    @Override
    public String print(int radix, boolean stripLeadingZeroes, int width, boolean useLowerCaseMaskType, boolean structAssignPattern) {
        return this == UNKNOWN ? "?.?" : Float.toString(this.number);
    }

    public String toString() {
        return this.toString(10, false, false);
    }

    @Override
    public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        return this.toString();
    }

    @Override
    public String toString(int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        return this == UNKNOWN ? "?.?" : Float.toString(this.number);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + Float.hashCode(this.number);
        return result;
    }

    @Override
    public VlogShortrealNumber copy() {
        VlogShortrealNumber result = new VlogShortrealNumber(this.number);
        result.uniqueId = this.uniqueId;
        return result;
    }

    @Override
    public DVTNumber getDefaultValue(boolean force4State) {
        return VlogShortrealNumber.create(0.0f);
    }

    public static class ConstVlogShortrealNumber
    extends VlogShortrealNumber {
        public static VlogShortrealNumber create(float number) {
            return new ConstVlogShortrealNumber(number);
        }

        protected ConstVlogShortrealNumber(float number) {
            super(number);
        }
    }
}

