/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigInteger;
import java.util.List;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.IDVTRangeSelectable;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.XBitVectorContext;

public class XArrayAssignmentPatternBitVectorContext
extends XBitVectorContext {
    public XArrayAssignmentPatternBitVectorContext(IELParamValue leftValue) {
        super(leftValue);
    }

    @Override
    public XArrayValueHolder getLeftValue() {
        return (XArrayValueHolder)super.getLeftValue();
    }

    @Override
    public IELParamValue transform(IELParamValue paramValue) {
        if (this.isCast()) {
            if (paramValue instanceof ELParamValues.ParamValueNumber) {
                DVTNumber number = paramValue.getDVTNumber();
                if (number instanceof VlogBitVector) {
                    XArrayValueHolder contextArray = this.getLeftValue();
                    if (contextArray.getItemElementContext() == null) {
                        return paramValue;
                    }
                    if (contextArray.getItemElementContext().getSize() == ((VlogBitVector)number).getElementSize()) {
                        return this.convertDVTNumberToXArray((IDVTRangeSelectable)((Object)number), null);
                    }
                    int contextSize = contextArray.getSize();
                    int streamSize = number.getSize();
                    if (contextSize > 0 && contextSize != streamSize) {
                        return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                    }
                    return this.convertDVTNumberToXArray((IDVTRangeSelectable)((Object)number), null);
                }
            } else if (paramValue instanceof XArrayValueHolder) {
                XArrayValueHolder contextArray = this.getLeftValue();
                XArrayValueHolder paramArray = (XArrayValueHolder)paramValue;
                if (contextArray.getItemElementContext() == null || paramArray.getItemElementContext() == null) {
                    return paramValue;
                }
                if (contextArray.getItemElementContext().getSize() == paramArray.getItemElementContext().getSize()) {
                    return paramValue;
                }
                DVTNumber result = VlogBitVector.BIT_ZERO;
                List<IELParamValue> valuesToEvaluate = paramArray.getZValues();
                for (IELParamValue tempOpValue : valuesToEvaluate) {
                    if (tempOpValue instanceof XArrayValueHolder && ((XArrayValueHolder)tempOpValue).isEmpty()) continue;
                    DVTNumber operandNumber = tempOpValue.getDVTNumber();
                    if (DVTNumber.isUndefined(operandNumber)) {
                        return paramValue;
                    }
                    VlogBitVector tempOp = operandNumber.toBitVector();
                    if (tempOp == null) {
                        return paramValue;
                    }
                    result = DVTNumber.concatenate(result, tempOp, null);
                }
                int contextSize = contextArray.getSize();
                int streamSize = ((DVTNumber)result).getSize();
                if (contextSize > 0 && contextSize != streamSize) {
                    return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                }
                return this.convertDVTNumberToXArray((IDVTRangeSelectable)((Object)result), null);
            }
        }
        return super.transform(paramValue);
    }

    public IELParamValue convertDVTNumberToXArray(IDVTRangeSelectable number, IHidEvaluationGuardian guardian) {
        int arrayItemIndex;
        IELParamValue newValue = ((XValueHolder)this.leftValue).newHolder();
        if (!(newValue instanceof XArrayValueHolder)) {
            if (guardian != null) {
                guardian.logError("Fail to convert number into array");
            }
            return IELParamValue.UNDEFINED_VALUE;
        }
        IELParamValue arrayItemValue = ((XArrayValueHolder)newValue).createElementValueHolder();
        XArrayValueHolder arrayValueHolder = (XArrayValueHolder)newValue;
        boolean hasBounds = arrayValueHolder.getLeftBound() != -1 && arrayValueHolder.getRightBound() != -1;
        int indexStep = hasBounds && arrayValueHolder.getLeftBound() > arrayValueHolder.getRightBound() ? -1 : 1;
        int[] firstDimension = number.getFirstDimension();
        int xArrayElementSize = arrayItemValue.getDVTNumber().getSize();
        int n = arrayItemIndex = hasBounds ? arrayValueHolder.getLeftBound() : 0;
        if (firstDimension[0] > firstDimension[1]) {
            int j = firstDimension[0];
            while (j >= firstDimension[1]) {
                IELParamValue indexKey = ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(arrayItemIndex)));
                XComputedSelect computedSelect = new XComputedSelect(null, ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(j)), ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(j - xArrayElementSize + 1)));
                IELParamValue sliceValue = ELParamValues.ParamValueNumber.of(number.getRangeSelect(computedSelect, false, LanguageKind.VLOG));
                ((XArrayValueHolder)newValue).put(indexKey, sliceValue);
                arrayItemIndex += indexStep;
                j -= xArrayElementSize;
            }
        } else {
            int j = firstDimension[0];
            while (j < firstDimension[1]) {
                IELParamValue indexKey = ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(arrayItemIndex)));
                XComputedSelect computedSelect = new XComputedSelect(null, ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(j + xArrayElementSize - 1)), ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(j)));
                IELParamValue sliceValue = ELParamValues.ParamValueNumber.of(number.getRangeSelect(computedSelect, false, LanguageKind.VLOG));
                ((XArrayValueHolder)newValue).put(indexKey, sliceValue);
                arrayItemIndex += indexStep;
                j += xArrayElementSize;
            }
        }
        return newValue;
    }
}

