/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.model.reflection.IRfClockingBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.utils.DVTNumber;

public enum XGlobalCache {
    INSTANCE;

    private final Map<IRfNamedElement, TimeScale> cachedTimeScales = new ConcurrentHashMap<IRfNamedElement, TimeScale>();
    private final Map<String, DVTNumber> cachedImplicitNumbers = new ConcurrentHashMap<String, DVTNumber>();
    private final Map<Attributes, Integer> cachedNumOfChars10 = new HashMap<Attributes, Integer>();
    private final Map<IRfNamedElement, Boolean> cachedHasMembers = new IdentityHashMap<IRfNamedElement, Boolean>();
    private final Map<IProject, IXSim> cachedXSimMap = new IdentityHashMap<IProject, IXSim>();
    private final Map<IRfClockingBlockElement, HidOperator> cachedCBEventControl = new IdentityHashMap<IRfClockingBlockElement, HidOperator>();

    public void clearCache() {
        this.cachedTimeScales.clear();
        this.cachedImplicitNumbers.clear();
        this.cachedNumOfChars10.clear();
        this.cachedHasMembers.clear();
        this.cachedCBEventControl.clear();
    }

    public DVTNumber getImplicit(String name) {
        if (name == null) {
            return null;
        }
        return this.cachedImplicitNumbers.get(name);
    }

    public DVTNumber putImplicit(String name, DVTNumber number) {
        if (number == null) {
            return null;
        }
        return this.cachedImplicitNumbers.computeIfAbsent(name, key -> number);
    }

    public TimeScale getTimeScale(IRfNamedElement module) {
        if (module == null) {
            return null;
        }
        return this.cachedTimeScales.get(module);
    }

    public TimeScale putTimeScale(IRfNamedElement module, int unitExponent, int scaleExponent) {
        if (module == null) {
            return null;
        }
        return this.cachedTimeScales.computeIfAbsent(module, key -> new TimeScale(unitExponent, scaleExponent));
    }

    public int getNumOfChars10(boolean hasSign, int size) {
        if (hasSign && size == 32) {
            return 11;
        }
        if (hasSign && size == 64) {
            return 20;
        }
        Integer cached = this.cachedNumOfChars10.get(new Attributes(hasSign, size));
        if (cached == null) {
            return -1;
        }
        return cached;
    }

    public void putNumOfChars10(boolean hasSign, int size, int numOfChars10) {
        if (hasSign && (size == 32 || size == 64)) {
            return;
        }
        this.cachedNumOfChars10.put(new Attributes(hasSign, size), numOfChars10);
    }

    public int hasMambers(IRfNamedElement actionBlockElement) {
        Boolean hasMembers = this.cachedHasMembers.get(actionBlockElement);
        if (hasMembers == null) {
            return -1;
        }
        return hasMembers != false ? 1 : 0;
    }

    public void hasMambers(IRfNamedElement actionBlockElement, boolean hasMembers) {
        this.cachedHasMembers.put(actionBlockElement, hasMembers);
    }

    public IXSim getXSim(IProject project) {
        return this.cachedXSimMap.get(project);
    }

    public void setXSim(IProject project, IXSim xSim) {
        this.cachedXSimMap.put(project, xSim);
    }

    public IXSim removeXSim(IProject project) {
        return this.cachedXSimMap.remove(project);
    }

    public void cacheCBEventControl(IRfClockingBlockElement clockingBlock, HidOperator eventControl) {
        this.cachedCBEventControl.put(clockingBlock, eventControl);
    }

    public HidOperator getCBEventControl(IRfClockingBlockElement clockingBlock) {
        return this.cachedCBEventControl.get(clockingBlock);
    }

    private static class Attributes {
        private boolean hasSign;
        private int size;

        public Attributes(boolean hasSign, int size) {
            this.hasSign = hasSign;
            this.size = size;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.hasSign ? 1231 : 1237);
            result = 31 * result + this.size;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Attributes other = (Attributes)obj;
            if (this.hasSign != other.hasSign) {
                return false;
            }
            return this.size == other.size;
        }
    }

    public static class TimeScale {
        public static final TimeScale DEFAULT_TIME_SCALE = new TimeScale(6, 0);
        public BigDecimal unit;
        public BigDecimal scale;
        public BigDecimal precision;
        public int unitExponent;
        public int scaleExponent;

        public TimeScale(int unitExponent, int scaleExponent) {
            this.unitExponent = unitExponent;
            this.scaleExponent = scaleExponent;
            this.unit = BigDecimal.valueOf(Math.pow(10.0, unitExponent));
            this.scale = BigDecimal.valueOf(Math.pow(10.0, scaleExponent));
            this.precision = BigDecimal.valueOf(Math.pow(10.0, this.getPrecision()));
        }

        public int getPrecision() {
            return this.unitExponent - this.scaleExponent;
        }
    }
}

