/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.utils.XMLException;

public class XMLValidator {
    public static void checkChildren(Element element, Set<String> validChildrenNames, String filePath) {
        if (element == null) {
            return;
        }
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element child;
            if (children.item(i) instanceof Element && !validChildrenNames.contains((child = (Element)children.item(i)).getNodeName())) {
                Object lineNumber = child.getUserData("lineNumber");
                int line = 0;
                if (lineNumber instanceof String) {
                    line = Integer.parseInt((String)lineNumber);
                }
                SAXParseException exception = new SAXParseException("Element '" + element.getNodeName() + "' contains invalid child '" + child.getNodeName() + "'", filePath, filePath, line, 0);
                throw new XMLException(exception, filePath);
            }
            ++i;
        }
    }

    public static void checkAttributes(Element element, Set<String> validAttributesNames, String filePath) {
        if (element == null) {
            return;
        }
        NamedNodeMap attributes = element.getAttributes();
        Object lineNumber = element.getUserData("lineNumber");
        int line = 0;
        if (lineNumber instanceof String) {
            line = Integer.parseInt((String)lineNumber);
        }
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            if (!validAttributesNames.contains(attribute.getNodeName())) {
                SAXParseException exception = new SAXParseException("Element '" + element.getNodeName() + "' contains invalid attribute '" + attribute.getNodeName() + "'", filePath, filePath, line, 0);
                throw new XMLException(exception, filePath);
            }
            ++i;
        }
    }

    public static String checkMandatoryAttribute(Element element, String mandatoryAttributeName, String filePath) {
        if (element == null) {
            return null;
        }
        int line = XMLValidator.getLineFromElement(element);
        String attrValue = element.getAttribute(mandatoryAttributeName);
        if (attrValue != null && !(attrValue = attrValue.trim()).isEmpty()) {
            return attrValue;
        }
        SAXParseException exception = new SAXParseException("Element '" + element.getNodeName() + "' doesn't contain mandatory attribute '" + mandatoryAttributeName + "'!", filePath, filePath, line, 0);
        throw new XMLException(exception, filePath);
    }

    public static void checkAtLeastOneElement(NodeList node, String tag, String parent, Element parentElement, String filePath) {
        if (node == null || node.getLength() == 0) {
            Object lineNumber = parentElement.getUserData("lineNumber");
            int line = 0;
            if (lineNumber instanceof String) {
                line = Integer.parseInt((String)lineNumber);
            }
            SAXParseException exception = new SAXParseException("Element '" + parent + "' must contain at least one '" + tag + "' element", filePath, filePath, line, 0);
            throw new XMLException(exception, filePath);
        }
    }

    public static void checkOptionalOneElement(NodeList node, String tag, String parent, Element parentElement, String filePath) {
        if (node == null) {
            return;
        }
        if (node.getLength() > 1) {
            Object lineNumber = parentElement.getUserData("lineNumber");
            int line = 0;
            if (lineNumber instanceof String) {
                line = Integer.parseInt((String)lineNumber);
            }
            SAXParseException exception = new SAXParseException("Element '" + parent + "' must not contain more than one '" + tag + "' element", filePath, filePath, line, 0);
            throw new XMLException(exception, filePath);
        }
    }

    public static void checkUniqueRootNode(NodeList rulesetNode, String rootTagName, String filePath) {
        if (rulesetNode == null || rulesetNode.getLength() == 0) {
            SAXParseException exception = new SAXParseException("The XML file must contain exactly one '" + rootTagName + "' root element", filePath, filePath, 0, 0);
            throw new XMLException(exception, filePath);
        }
        if (rulesetNode.getLength() > 1) {
            SAXParseException exception = new SAXParseException("The XML file must contain exactly one '" + rootTagName + "' root element", filePath, filePath, 0, 0);
            throw new XMLException(exception, filePath);
        }
    }

    public static void checkMandatoryUniqueElement(NodeList node, String tag, String parent, Element parentElement, String filePath) {
        if (node == null || node.getLength() != 1) {
            Object lineNumber = parentElement.getUserData("lineNumber");
            int line = 0;
            if (lineNumber instanceof String) {
                line = Integer.parseInt((String)lineNumber);
            }
            SAXParseException exception = new SAXParseException("Element '" + parent + "' must contain exactly one '" + tag + "' element", filePath, filePath, line, 0);
            throw new XMLException(exception, filePath);
        }
    }

    public static int getLineFromElement(Element element) {
        Object lineNumber = element.getUserData("lineNumber");
        if (lineNumber instanceof String) {
            return Integer.parseInt((String)lineNumber);
        }
        return 0;
    }

    public static void checkValidRegexString(String text, String tag, String filePath, int line) {
        String[] tokens;
        String[] stringArray = tokens = text.split(",");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            try {
                Pattern.compile(token);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                SAXParseException exception = new SAXParseException("Attribute '" + tag + "' contains invalid regular expression '" + token + "'!", filePath, filePath, line, 0);
                throw new XMLException(exception, filePath);
            }
            ++n2;
        }
    }

    public static void checkRegexElement(Element element, String filePath) {
        if (element == null) {
            return;
        }
        int line = XMLValidator.getLineFromElement(element);
        String text = element.getTextContent();
        String tag = element.getTagName();
        if (text == null) {
            SAXParseException exception = new SAXParseException("Element '" + tag + "' is null!", filePath, filePath, line, 0);
            throw new XMLException(exception, filePath);
        }
        XMLValidator.checkValidRegexString(text, tag, filePath, line);
    }

    public static void checkNodeValue(Element element, String filePath, Set<String> validValues) {
        if (element == null || element.getFirstChild() == null) {
            return;
        }
        int line = XMLValidator.getLineFromElement(element);
        String elementType = element.getTextContent();
        if (elementType == null || !validValues.contains(elementType)) {
            SAXParseException exception = new SAXParseException("Element '" + element.getNodeName() + "' has invalid value '" + elementType + "'!", filePath, filePath, line, 0);
            throw new XMLException(exception, filePath);
        }
    }

    public static void checkUnresolvableVariable(String replacedText, String text, String filePath, int line) {
        if (replacedText == null) {
            SAXParseException exception = new SAXParseException("Path '" + text + "' contains unresolved environment variables!", filePath, filePath, line, 0);
            throw new XMLException(exception, filePath);
        }
    }
}

