/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.utils.DVTExceptionHandler;

public class XMLValidatorBatchUtils {
    public static void showError(final Exception e, final String fileName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (e.getMessage().startsWith("COMPILE WAIVER CONFIG ERROR ")) {
                    Status status = new Status(4, "ro.amiq.dvt", 0, "Compile waivers contains errors. For more details, inspect the console/build.log.", null);
                    DVTExceptionHandler.handle(new CoreException((IStatus)status), Display.getDefault().getActiveShell(), "XML Syntax Error", "Error in Compile Waivers");
                    return;
                }
                if (e.getMessage().startsWith("VERISSIMO WAIVER CONFIG ERROR ")) {
                    Status status = new Status(4, "ro.amiq.dvt", 0, "Verissimo waivers contains errors. For more details, inspect the console/build.log.", null);
                    DVTExceptionHandler.handle(new CoreException((IStatus)status), Display.getDefault().getActiveShell(), "XML Syntax Error", "Error in Verissimo Waivers");
                    return;
                }
                if (e.getMessage().startsWith("RULESET CONFIG ERROR ")) {
                    Status status = new Status(4, "ro.amiq.dvt", 0, "Verissimo ruleset contains errors. For more details, inspect the console/build.log.", null);
                    DVTExceptionHandler.handle(new CoreException((IStatus)status), Display.getDefault().getActiveShell(), "XML Syntax Error", "Error in Verissimo Ruleset");
                    return;
                }
                String additionalInfo = ".";
                Exception temp = null;
                if (e instanceof SAXParseException) {
                    additionalInfo = " at line " + ((SAXParseException)e).getLineNumber() + ".";
                    temp = new SAXParseException(String.valueOf(e.getMessage()) + "\nin " + fileName + additionalInfo, ((SAXParseException)e).getPublicId(), ((SAXParseException)e).getSystemId(), ((SAXParseException)e).getLineNumber(), ((SAXParseException)e).getColumnNumber(), null);
                }
                Status status = new Status(4, "ro.amiq.dvt", 0, "\t" + e.getMessage() + "\n\tin " + fileName + additionalInfo, (Throwable)(temp == null ? e : temp));
                DVTExceptionHandler.handle(new CoreException((IStatus)status), Display.getDefault().getActiveShell(), "XML Syntax Error", "Error in  '" + Path.fromOSString((String)fileName).lastSegment() + "'" + additionalInfo);
            }
        });
    }
}

