/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils.benchmark;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import ro.amiq.dvt.test.TestHelper;

public class Counter {
    private long count;
    private String tag;
    private static Map<String, Counter> counters = new LinkedHashMap<String, Counter>();

    public Counter(String tag) {
        this.tag = tag;
    }

    public static Counter get(String tag) {
        Counter counter;
        if (tag == null) {
            tag = Thread.currentThread().getName();
        }
        if ((counter = counters.get(tag)) == null) {
            counter = new Counter(tag);
            counters.put(tag, counter);
        }
        return counter;
    }

    public static void inc(String tag) {
        ++Counter.get((String)tag).count;
    }

    public static void print(String tag, String message) {
        message = message != null && !message.isEmpty() ? "[" + message + "] " : "";
        Counter counter = Counter.get(tag);
        TestHelper.out.println("[CNT]" + counter.tag + " " + message + " " + counter.count);
    }

    public static void printAll(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        TestHelper.out.println("=========== Counter report ===========");
        for (String tag : counters.keySet()) {
            if (!tag.startsWith(prefix)) continue;
            Counter.print(tag, "");
        }
        TestHelper.out.println("======================================");
    }

    public static void clearAll(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            counters.clear();
        } else {
            Iterator<String> iterator = counters.keySet().iterator();
            while (iterator.hasNext()) {
                String tag = iterator.next();
                if (!tag.startsWith(prefix)) continue;
                iterator.remove();
            }
        }
    }

    public long getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0L;
    }

    public static long getCount(String tag) {
        Counter counter;
        if (tag == null) {
            tag = Thread.currentThread().getName();
        }
        if ((counter = counters.get(tag)) == null) {
            return 0L;
        }
        return counter.getCount();
    }
}

