/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils.benchmark;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;

public final class StopWatch {
    public static final String BUILD_TAG = "[BUILD] ";
    public static final String BUILD_TAG_TOTAL = "[BUILD]  total";
    public static final String BUILD_TAG_ELAB = "[BUILD]  elab";
    public static final String BUILD_TAG_MIXEDMODE = "[BUILD]  mixedmode";
    public static final String BUILD_TAG_INCREMENTAL = "[BUILD]  incremental";
    public static final String BUILD_TAG_Y = "[BUILD]  libdir";
    public static final String BUILD_TAG_V = "[BUILD]  libfile";
    public static final String SIM_TAG_TOTAL = "[SIM] total";
    public static final String CLI_TAG = "[DVT-CLI] ";
    public static final String CLI_ARGUMENTS_VALIDATION = "[DVT-CLI]  checkfiles";
    public static final String CLI_CREATE_BUILD_FILES = "[DVT-CLI]  createbuildfiles";
    public static final String CLI_DELETE_OLD_PROJECT_FILES = "[DVT-CLI]  deleteoldprojectfiles";
    public static final String CLI_CREATE_DOT_PROJECT = "[DVT-CLI]  createdotproject";
    public static final String CLI_FILE_SYSTEM_CHECK = "[DVT-CLI]  fscheck";
    public static final String CLI_COMPUTE_INCLUDE_AUTO_FILTERS = "[DVT-CLI]  computeincludeautofilters";
    public static final String CLI_APPLY_FILTERS = "[DVT-CLI]  applyfilters";
    public static final String CLI_OPEN_PROJECT = "[DVT-CLI]  openproject";
    public static final String CLI_REFRESH_PROJECT = "[DVT-CLI]  refreshproject";
    public static final String CLI_CREATE_LINK_RESOURCES = "[DVT-CLI]  createlinkresources";
    public static final long MILLION = 1000000L;
    private static Map<String, StopWatch> times = Collections.synchronizedMap(new LinkedHashMap());
    private static final Set<String> STW_GC_NAMES = Stream.of("Copy", "MarkSweepCompact", "PS Scavenge", "PS MarkSweep", "MarkSweepCompact", "G1 Old Generation", "ZGC Pauses").collect(Collectors.toCollection(LinkedHashSet::new));
    private long fStartTime;
    private long fElapsedTime;
    private long fGCStartTime;
    private long fGCElapsedTime;
    private long fGCStartEvents;
    private long fGCElapsedEvents;
    private boolean fRunning;
    private final String fTag;

    public StopWatch(String tag) {
        this.fTag = tag;
    }

    public String getTag() {
        return this.fTag;
    }

    public boolean isRunning() {
        return this.fRunning;
    }

    private boolean checkRunning(boolean shouldRun, String operation) {
        if (shouldRun && !this.fRunning || !shouldRun && this.fRunning) {
            if (DVTLogger.INSTANCE.isDebugMode()) {
                DVTLogger.INSTANCE.logDebug(String.valueOf(operation) + ": stopwatch " + (this.fRunning ? "is" : "is not") + " running for tag '" + this.fTag + "'");
            }
            return false;
        }
        return true;
    }

    public static StopWatch get(String tag) {
        StopWatch watch;
        if (tag == null) {
            tag = Thread.currentThread().getName();
        }
        if ((watch = times.get(tag)) == null) {
            watch = new StopWatch(tag);
            times.put(tag, watch);
        }
        return watch;
    }

    public static StopWatch start(String tag) {
        return StopWatch.get(tag).start();
    }

    public StopWatch start() {
        this.checkRunning(false, "START");
        this.fRunning = true;
        this.fStartTime = System.nanoTime();
        this.fGCStartTime = StopWatch.getTotalCollectionTime();
        this.fGCStartEvents = StopWatch.getTotalCollectionEvents();
        return this;
    }

    public static StopWatch stop(String tag) {
        return StopWatch.get(tag).stop();
    }

    public StopWatch stop() {
        if (!this.checkRunning(true, "STOP")) {
            return this;
        }
        this.fGCElapsedEvents += StopWatch.getTotalCollectionEvents() - this.fGCStartEvents;
        this.fGCElapsedTime += StopWatch.getTotalCollectionTime() - this.fGCStartTime;
        this.fElapsedTime += System.nanoTime() - this.fStartTime;
        this.fRunning = false;
        return this;
    }

    public static StopWatch reset(String tag) {
        return StopWatch.get(tag).reset();
    }

    public StopWatch reset() {
        this.fRunning = false;
        this.fStartTime = 0L;
        this.fElapsedTime = 0L;
        this.fGCStartTime = 0L;
        this.fGCElapsedTime = 0L;
        this.fGCStartEvents = 0L;
        this.fGCElapsedEvents = 0L;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAll(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            times.clear();
        } else {
            Map<String, StopWatch> map = times;
            synchronized (map) {
                Iterator<String> iterator = times.keySet().iterator();
                while (iterator.hasNext()) {
                    String tag = iterator.next();
                    if (!tag.startsWith(prefix)) continue;
                    iterator.remove();
                }
            }
        }
    }

    public static long timeNanos(String tag) {
        return StopWatch.get(tag).timeNanos();
    }

    public long timeNanos() {
        return this.fElapsedTime + (this.fRunning ? System.nanoTime() - this.fStartTime : 0L);
    }

    public static long timeMillis(String tag) {
        return StopWatch.get(tag).timeMillis();
    }

    public long timeMillis() {
        return this.timeNanos() / 1000000L;
    }

    public static long timeMillisGCInvariant(String tag) {
        return StopWatch.get(tag).timeMillisGCInvariant();
    }

    public long timeMillisGCInvariant() {
        return this.timeMillis() - this.timeMillisInGC();
    }

    public static long timeMillisInGC(String tag) {
        return StopWatch.get(tag).timeMillisInGC();
    }

    public long timeMillisInGC() {
        return this.fGCElapsedTime + (this.fRunning ? StopWatch.getTotalCollectionTime() - this.fGCStartTime : 0L);
    }

    public static long gcEvents(String tag) {
        return StopWatch.get(tag).gcEvents();
    }

    public long gcEvents() {
        return this.fGCElapsedEvents + (this.fRunning ? StopWatch.getTotalCollectionEvents() - this.fGCStartEvents : 0L);
    }

    public static String timeFormatted(String tag) {
        return StopWatch.get(tag).timeFormatted();
    }

    public String timeFormatted() {
        return StopWatch.formatTime(this.timeMillis());
    }

    public static String formatTime(long timeInMillis) {
        long remainS = timeInMillis / 1000L;
        long remainM = remainS / 60L;
        long remainH = remainM / 60L;
        long remainMS = timeInMillis - remainS * 1000L;
        remainS -= remainM * 60L;
        remainM -= remainH * 60L;
        if (remainH > 0L) {
            return String.format("%01dh:%02dm:%02ds", remainH, remainM, remainS);
        }
        if (remainM > 0L) {
            return String.format("%01dm:%02ds", remainM, remainS);
        }
        if (remainS > 0L) {
            return String.format("%01ds.%03dms", remainS, remainMS);
        }
        return String.format("%01d ms", remainMS);
    }

    public static StopWatch print(String tag, String message) {
        return StopWatch.get(tag).print(message);
    }

    public StopWatch print(String message) {
        message = message != null && !message.isEmpty() ? "[" + message + "] " : "";
        this.checkRunning(false, "PRINT");
        TestHelper.out.println("[SW]" + this.fTag + " " + message + this.timeMillis() + " ms");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printAll(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        TestHelper.out.println("========== StopWatch report ==========");
        Map<String, StopWatch> map = times;
        synchronized (map) {
            for (String tag : times.keySet()) {
                if (!tag.startsWith(prefix)) continue;
                StopWatch.print(tag, "");
            }
        }
        TestHelper.out.println("======================================");
    }

    private static long getTotalCollectionTime() {
        return ManagementFactory.getGarbageCollectorMXBeans().stream().filter(gc -> STW_GC_NAMES.contains(gc.getName())).map(gc -> gc.getCollectionTime()).reduce(0L, Long::sum);
    }

    private static long getTotalCollectionEvents() {
        return ManagementFactory.getGarbageCollectorMXBeans().stream().filter(gc -> STW_GC_NAMES.contains(gc.getName())).map(gc -> gc.getCollectionCount()).reduce(0L, Long::sum);
    }
}

