/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils.buildconfig;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class BuildConfigGenerator {
    private Template getTemplate() throws IOException {
        BeansWrapper wrapper = new BeansWrapper();
        wrapper.setSimpleMapWrapper(true);
        Configuration freeMarkerConfig = new Configuration();
        freeMarkerConfig.setTemplateUpdateDelay(0);
        freeMarkerConfig.setObjectWrapper((ObjectWrapper)wrapper);
        freeMarkerConfig.setClassForTemplateLoading(BuildConfigGenerator.class, "");
        return freeMarkerConfig.getTemplate(this.getTemplateFileName());
    }

    public String getContent() {
        try {
            StringWriter stringWriter = new StringWriter();
            this.getTemplate().process((Object)this, (Writer)stringWriter);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (TemplateException | IOException e) {
            DVTLogger.INSTANCE.logError(e);
            return "";
        }
    }

    public void writeFile(File projectLocation, String fileName) {
        try {
            File dotDvt = new File(projectLocation, ".dvt");
            if (!dotDvt.exists()) {
                dotDvt.mkdir();
            }
            File activeBuildConfigFile = new File(dotDvt, fileName);
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter fileWriter = new BufferedWriter(new FileWriter(activeBuildConfigFile));){
                this.getTemplate().process((Object)this, (Writer)fileWriter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TemplateException | IOException e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public abstract String getTemplateFileName();
}

