/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils.buildconfig;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.utils.buildconfig.DefaultBuildConfigGenerator;
import ro.amiq.dvt.utils.buildconfig.Utils;

public class NothingToCompileDialog {
    private static boolean fDisableForThisSession;

    public static void openWarning(final IProject project) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (new Boolean(System.getProperty("ro.amiq.dvt.disable_nothing_to_build_dialog")).booleanValue()) {
                    return;
                }
                if (fDisableForThisSession) {
                    return;
                }
                String message = "No source files were compiled for project [" + project.getName() + "]";
                String title = "Nothing compiled";
                try {
                    if (project.getSessionProperty(DVTStartupConstants.QN_DVT_FIRST_BUILD_AFTER_CREATION) != null) {
                        project.setSessionProperty(DVTStartupConstants.QN_DVT_FIRST_BUILD_AFTER_CREATION, null);
                        return;
                    }
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                if (!BuildConfigManager.hasActiveBuildConfig(project)) {
                    DefaultBuildConfigGenerator generator = new DefaultBuildConfigGenerator(){

                        @Override
                        public boolean isE() {
                            try {
                                return project.hasNature("ro.amiq.edt.enature");
                            }
                            catch (CoreException coreException) {
                                return false;
                            }
                        }

                        @Override
                        public boolean isSLN() {
                            try {
                                return project.hasNature("ro.amiq.slndt.slnnature");
                            }
                            catch (CoreException coreException) {
                                return false;
                            }
                        }

                        @Override
                        public boolean isMSDL() {
                            try {
                                return project.hasNature("ro.amiq.msdldt.msdlnature");
                            }
                            catch (CoreException coreException) {
                                return false;
                            }
                        }

                        @Override
                        public boolean isPSS() {
                            try {
                                return project.hasNature("ro.amiq.pssdt.pssnature");
                            }
                            catch (CoreException coreException) {
                                return false;
                            }
                        }

                        @Override
                        public boolean isVlog() {
                            try {
                                return project.hasNature("ro.amiq.vlogdt.VlogNature");
                            }
                            catch (CoreException coreException) {
                                return false;
                            }
                        }

                        @Override
                        public boolean isVhdl() {
                            try {
                                return project.hasNature("ro.amiq.vhdldt.VhdlNature");
                            }
                            catch (CoreException coreException) {
                                return false;
                            }
                        }

                        @Override
                        public boolean isAutoconfig() {
                            return true;
                        }
                    };
                    generator.writeFile(project.getLocation().toFile(), String.valueOf(BuildConfigManager.getActiveBuildConfigName(project)) + ".build");
                }
                Utils.openBuildConfigFile(project);
                new MessageDialog(DVTUiUtils.getActiveWorkbenchWindow().getShell(), title, null, message, 4, new String[]{IDialogConstants.OK_LABEL}, 0){
                    private Button dontShowAgain;

                    protected Control createMessageArea(Composite composite) {
                        Image image = this.getImage();
                        if (image != null) {
                            this.imageLabel = new Label(composite, 0);
                            image.setBackground(this.imageLabel.getBackground());
                            this.imageLabel.setImage(image);
                            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
                        }
                        Composite wrapper = new Composite(composite, 0);
                        wrapper.setLayout((Layout)new RowLayout());
                        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)wrapper);
                        if (this.message != null) {
                            this.messageLabel = new Label(wrapper, this.getMessageLabelStyle());
                            this.messageLabel.setText(this.message);
                        }
                        Link topFilesLink = new Link(wrapper, 0);
                        String topFilePath = BuildConfigManager.getActiveBuildConfigRelPath(project);
                        topFilesLink.setText("Please review the project's build configuration by editing <a>" + topFilePath + "</a>");
                        DVTUiUtils.setPlatformLinkColor((Link)topFilesLink);
                        topFilesLink.setToolTipText("Open '" + topFilePath + "'");
                        topFilesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                Utils.openBuildConfigFile(project);
                                this.close();
                            }
                        });
                        this.dontShowAgain = new Button(wrapper, 32);
                        this.dontShowAgain.setText("Don't show me this message again during this session");
                        return composite;
                    }

                    protected void buttonPressed(int buttonId) {
                        if (buttonId == 0 && this.dontShowAgain.getSelection()) {
                            fDisableForThisSession = true;
                        }
                        super.buttonPressed(buttonId);
                    }
                }.open();
            }
        });
    }
}

