/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils.parser;

import java.io.Serializable;
import ro.amiq.dvt.utils.parser.DVTLexerStack;

public class Comment
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Comment EMPTY_LINE_INFO = new Comment(CommentStyle.NONE_KIND, 0, 0, "EMPTY_LINE_INFO", null, 0);
    public static final Comment CODE_LINE_INFO = new Comment(CommentStyle.NONE_KIND, 0, 0, "CODE_LINE_INFO", null, 0);
    public static final Comment CODE_USELIB_INFO = new Comment(CommentStyle.NONE_KIND, 0, 0, "USELIB_LINE_INFO", null, 0);
    public static final int VHDL = 1;
    public static final int VLOG = 2;
    protected String fComment;
    private boolean fIsInline;
    private int fStartLine;
    private int fEndLine;
    private CommentStyle fKind;
    protected boolean fProtected;
    private int fPluginType;

    public Comment(CommentStyle kind, int startLine, int endLine, String rawComment, DVTLexerStack lS, int pluginType) {
        this.fStartLine = startLine;
        this.fEndLine = endLine;
        if (lS != null && lS.getLastLine() == startLine) {
            this.fIsInline = true;
            this.fEndLine = startLine;
        }
        this.fPluginType = pluginType;
        if (rawComment != null) {
            this.setKind(kind == CommentStyle.ML_KIND && rawComment.startsWith("*") ? CommentStyle.ML2_KIND : kind);
            if (rawComment.trim().equals("protected")) {
                this.fProtected = true;
            }
        }
        this.fComment = rawComment;
    }

    public String getComment() {
        return this.fComment == null ? null : this.fComment.trim();
    }

    public String getRawComment() {
        return this.fComment;
    }

    public boolean isProtected() {
        return this.fProtected;
    }

    public void setProtected(boolean isProtected) {
        this.fProtected = isProtected;
    }

    public void setKind(CommentStyle kind) {
        this.fKind = kind;
    }

    public CommentStyle getKind() {
        return this.fKind;
    }

    public boolean isInline() {
        return this.fIsInline;
    }

    public int getStartLine() {
        return this.fStartLine;
    }

    public int getEndLine() {
        return this.fEndLine;
    }

    public void setPluginType(int pluginType) {
        this.fPluginType = pluginType;
    }

    public int getPluginType() {
        return this.fPluginType;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    public static boolean isComment(Comment comment) {
        if (comment == null) {
            return false;
        }
        if (comment == EMPTY_LINE_INFO) {
            return false;
        }
        return comment != CODE_LINE_INFO;
    }

    public static boolean isEmptyLine(Comment comment) {
        return comment == EMPTY_LINE_INFO;
    }

    public static boolean isVhdlComment(Comment comment) {
        if (comment == null) {
            return false;
        }
        if (comment == EMPTY_LINE_INFO) {
            return false;
        }
        if (comment == CODE_LINE_INFO) {
            return false;
        }
        return comment != CODE_USELIB_INFO;
    }

    public static boolean isVhdlLibraryClause(Comment comment) {
        return comment == CODE_USELIB_INFO;
    }

    public void setIsInline(boolean isInline) {
        if (isInline) {
            this.fIsInline = isInline;
        }
    }

    public static enum CommentStyle {
        NONE_KIND,
        SL_KIND,
        ML_KIND,
        ML2_KIND;

    }
}

