/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils.parser;

import java.io.Serializable;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.utils.parser.Comment;

public class CommentBlock
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fInlineComment;
    private String fAboveComment;
    private int fAboveCommentStartLine;
    private boolean fProtected;
    private Comment.CommentStyle fAboveCommentStyle;
    private Comment.CommentStyle fInlineCommentStyle;

    public CommentBlock(String inlineComment, String aboveComment, boolean isProtected) {
        this(inlineComment, aboveComment, -1, isProtected, Comment.CommentStyle.NONE_KIND, Comment.CommentStyle.NONE_KIND);
    }

    public CommentBlock(String inlineComment, String aboveComment, int startLine, boolean isProtected) {
        this(inlineComment, aboveComment, startLine, isProtected, Comment.CommentStyle.NONE_KIND, Comment.CommentStyle.NONE_KIND);
    }

    public CommentBlock(String inlineComment, String aboveComment, int startLine, boolean isProtected, Comment.CommentStyle inlineCommentStyle, Comment.CommentStyle aboveCommentStyle) {
        this.fInlineComment = inlineComment == null || CommentBlock.getTrimmedComment(inlineComment).isEmpty() ? null : inlineComment;
        this.fAboveComment = aboveComment == null || CommentBlock.getTrimmedComment(aboveComment).isEmpty() ? null : aboveComment;
        this.fProtected = isProtected;
        this.fAboveCommentStartLine = startLine;
        this.fInlineCommentStyle = inlineCommentStyle;
        this.fAboveCommentStyle = aboveCommentStyle;
    }

    public String getRawUntrimmedInlineComment() {
        return this.fInlineComment;
    }

    public String getRawUntrimmedAboveComment() {
        return this.fAboveComment;
    }

    public String getInlineComment() {
        return Utils.formatComment(CommentBlock.getTrimmedComment(this.fInlineComment));
    }

    public String getAboveComment() {
        return Utils.formatComment(CommentBlock.getTrimmedComment(this.fAboveComment));
    }

    public String getRawInlineComment() {
        return CommentBlock.getTrimmedComment(this.fInlineComment);
    }

    public String getRawAboveComment() {
        return CommentBlock.getTrimmedComment(this.fAboveComment);
    }

    public void setInlineComment(String inlineComment) {
        this.fInlineComment = inlineComment == null || CommentBlock.getTrimmedComment(inlineComment).isEmpty() ? null : inlineComment;
    }

    public boolean hasInlineComment() {
        return this.fInlineComment != null;
    }

    public void setHeaderComment(String headerComment) {
        if (headerComment == null || headerComment.trim().isEmpty()) {
            return;
        }
        this.fAboveComment = this.fAboveComment == null ? headerComment : (headerComment.contains(CommentBlock.getTrimmedComment(this.fAboveComment)) ? headerComment : DVTStringUtil.appendString(headerComment, "\n", this.fAboveComment));
    }

    public int getAboveCommentStartLine() {
        return this.fAboveCommentStartLine;
    }

    public void setStartLine(int line) {
        this.fAboveCommentStartLine = line;
    }

    public String toString() {
        String result = "";
        if (this.fAboveComment != null) {
            result = Utils.formatComment(CommentBlock.getTrimmedComment(this.fAboveComment));
            if (this.fInlineComment != null) {
                result = DVTStringUtil.appendString(result, result.endsWith(".") ? " " : "; ", Utils.formatComment(CommentBlock.getTrimmedComment(this.fInlineComment)));
            }
        } else if (this.fInlineComment != null) {
            result = Utils.formatComment(CommentBlock.getTrimmedComment(this.fInlineComment));
        }
        return result;
    }

    public String toRawString() {
        String result = "";
        if (this.fAboveComment != null) {
            result = CommentBlock.getTrimmedComment(this.fAboveComment);
            if (this.fInlineComment != null) {
                result = DVTStringUtil.appendString(result, result.endsWith(".") ? " " : "; ", CommentBlock.getTrimmedComment(this.fInlineComment));
            }
        } else if (this.fInlineComment != null) {
            result = CommentBlock.getTrimmedComment(this.fInlineComment);
        }
        if (result == null) {
            return "";
        }
        return result;
    }

    public String toRawUntrimmedString(String inlineAboveDelimiter) {
        String result = "";
        if (this.fAboveComment != null) {
            result = this.fAboveComment;
            if (this.fInlineComment != null) {
                result = DVTStringUtil.appendString(result, inlineAboveDelimiter, this.fInlineComment);
            }
        } else if (this.fInlineComment != null) {
            result = this.fInlineComment;
        }
        if (result == null) {
            return "";
        }
        return result;
    }

    public boolean isEmpty() {
        return this.fAboveComment == null && this.fInlineComment == null;
    }

    public boolean isDeprecated() {
        return this.fAboveComment != null && CommentBlock.getTrimmedComment(this.fAboveComment).startsWith("@deprecated") || this.fInlineComment != null && CommentBlock.getTrimmedComment(this.fInlineComment).startsWith("@deprecated");
    }

    public boolean contains(String text) {
        return this.fAboveComment != null && CommentBlock.getTrimmedComment(this.fAboveComment).contains(text) || this.fInlineComment != null && CommentBlock.getTrimmedComment(this.fInlineComment).contains(text);
    }

    public boolean isProtected() {
        return this.fProtected;
    }

    public boolean isNonStandard() {
        return this.fAboveComment != null && CommentBlock.getTrimmedComment(this.fAboveComment).startsWith("@non_standard") || this.fInlineComment != null && CommentBlock.getTrimmedComment(this.fInlineComment).startsWith("@non_standard");
    }

    public Comment.CommentStyle getAboveCommentStyle() {
        return this.fAboveCommentStyle;
    }

    public Comment.CommentStyle getInlineCommentStyle() {
        return this.fInlineCommentStyle;
    }

    private static String getTrimmedComment(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int wsIndex1 = -1;
        int wsIndex2 = -1;
        boolean hasNewLine = false;
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            boolean isWhitespace1 = Character.isWhitespace(ch);
            boolean isWhitespace2 = ch != '\n' && isWhitespace1;
            int currIndex = result.length();
            if (!isWhitespace1 && wsIndex1 == 0) {
                result.delete(wsIndex1, currIndex);
                wsIndex1 = -1;
                wsIndex2 = -1;
                hasNewLine = false;
                result.append(ch);
            } else {
                if (!isWhitespace2 && (ch == '\n' || hasNewLine)) {
                    if (wsIndex2 >= 0 && wsIndex2 < currIndex) {
                        result.delete(wsIndex2, currIndex);
                        wsIndex2 = -1;
                    }
                    boolean bl = hasNewLine = ch == '\n';
                }
                if (isWhitespace2 && wsIndex2 < 0) {
                    wsIndex2 = currIndex;
                    if (isWhitespace1 && wsIndex1 < 0) {
                        wsIndex1 = currIndex;
                    }
                } else if (isWhitespace1 && wsIndex1 < 0) {
                    wsIndex1 = currIndex;
                } else if (!isWhitespace1) {
                    hasNewLine = false;
                    wsIndex1 = -1;
                    wsIndex2 = -1;
                }
                result.append(ch);
            }
            ++i;
        }
        if (wsIndex1 >= 0) {
            result.delete(wsIndex1, result.length());
        }
        return result.toString();
    }
}

