/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils.parser;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Serializable;
import ro.amiq.dvt.utils.parser.Comment;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.utils.parser.HeaderCommentBlock;

public class CommentsTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IntSet emptyLineInfos = new IntOpenHashSet();
    private IntSet codeLineInfos = new IntOpenHashSet();
    private Int2ObjectMap<Comment> commentLineInfos = new Int2ObjectOpenHashMap();
    private HeaderCommentBlock headerCommentBlockCandidate = null;
    private int firstLineOfCode = -1;

    public CommentsTable() {
    }

    public CommentsTable(CommentsTable commentsTable) {
        if (commentsTable == null) {
            return;
        }
        if (commentsTable.emptyLineInfos != null) {
            this.emptyLineInfos = new IntOpenHashSet((IntCollection)commentsTable.emptyLineInfos);
        }
        if (commentsTable.codeLineInfos != null) {
            this.codeLineInfos = new IntOpenHashSet((IntCollection)commentsTable.codeLineInfos);
        }
        if (commentsTable.commentLineInfos != null) {
            this.commentLineInfos = new Int2ObjectOpenHashMap(commentsTable.commentLineInfos);
        }
        if (commentsTable.headerCommentBlockCandidate != null) {
            this.headerCommentBlockCandidate = new HeaderCommentBlock(commentsTable.headerCommentBlockCandidate);
        }
        this.firstLineOfCode = commentsTable.firstLineOfCode;
    }

    public synchronized Comment add(Comment comment, int line) {
        if (comment == Comment.EMPTY_LINE_INFO) {
            if (!this.isCodeLine(line) && !this.isCommentLine(line)) {
                this.emptyLineInfos.add(line);
            }
            return null;
        }
        if (comment == Comment.CODE_LINE_INFO) {
            if (this.isEmptyLine(line)) {
                this.emptyLineInfos.remove(line);
                this.codeLineInfos.add(line);
            }
            this.firstLineOfCode = this.firstLineOfCode < 0 ? line : this.firstLineOfCode;
            return null;
        }
        boolean isInline = this.isCodeLine(line);
        comment.setIsInline(isInline);
        this.emptyLineInfos.remove(line);
        this.codeLineInfos.remove(line);
        return (Comment)this.commentLineInfos.put(line, (Object)comment);
    }

    public synchronized void remove(int line) {
        this.emptyLineInfos.remove(line);
        this.codeLineInfos.remove(line);
        this.commentLineInfos.remove(line);
    }

    public synchronized Comment get(int line) {
        if (this.isEmptyLine(line)) {
            return Comment.EMPTY_LINE_INFO;
        }
        if (this.isCodeLine(line)) {
            return Comment.CODE_LINE_INFO;
        }
        return (Comment)this.commentLineInfos.get(line);
    }

    public boolean isEmptyLine(int line) {
        return this.emptyLineInfos.contains(line);
    }

    public boolean isCodeLine(int line) {
        return this.codeLineInfos.contains(line);
    }

    public boolean isCommentLine(int line) {
        return this.commentLineInfos.containsKey(line);
    }

    public synchronized void clear() {
        this.emptyLineInfos.clear();
        this.emptyLineInfos = null;
        this.codeLineInfos.clear();
        this.codeLineInfos = null;
        this.commentLineInfos.clear();
        this.commentLineInfos = null;
    }

    public int getFirstLineOfCode() {
        return this.firstLineOfCode;
    }

    public HeaderCommentBlock getHeaderCandidateOnce() {
        HeaderCommentBlock toReturn = this.headerCommentBlockCandidate;
        this.headerCommentBlockCandidate = null;
        return toReturn;
    }

    public void setHeaderCommentBlock(CommentBlock commentResult) {
        if (commentResult instanceof HeaderCommentBlock) {
            this.headerCommentBlockCandidate = (HeaderCommentBlock)commentResult;
        }
    }
}

