/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.webview;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.webview.IRemoteProxySetter;
import ro.amiq.dvt.webview.WebSocketLauncherBuilder;

public class WebServer<T>
extends AbstractVerticle {
    private static final String HOST = "127.0.0.1";
    private static final int PORT = 0;
    private static final String STATIC_SERVING_ROUTE = "static";
    private static final String WEBSOCKETS_ROUTE = "ws";
    private static final boolean JSONRPC_MESSAGE_TRACING = false;
    private static final int BLOCKED_THREAD_CHECK_INTERVAL = 5000;
    private String sessionURLIdentifier;
    private Integer actualPort;
    private IRemoteProxySetter<T> plugin;
    private Class<T> webviewInterface;
    private Vertx myVertx;
    private String indexHtml;
    private final CountDownLatch initializationLatch = new CountDownLatch(1);

    public WebServer(IRemoteProxySetter<T> plugin, Class<T> webviewInterface, String indexHtml) {
        this.plugin = plugin;
        this.webviewInterface = webviewInterface;
        this.indexHtml = indexHtml;
        this.initVertxServer();
        this.awaitInitialization();
    }

    private void initVertxServer() {
        VertxOptions options = new VertxOptions().setBlockedThreadCheckInterval(5000L);
        this.myVertx = Vertx.vertx((VertxOptions)options);
        this.myVertx.deployVerticle((Verticle)this);
    }

    private void awaitInitialization() {
        try {
            this.initializationLatch.await();
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void close() {
        if (this.myVertx == null) {
            return;
        }
        this.myVertx.close();
    }

    public void start() throws Exception {
        Router router = Router.router((Vertx)this.vertx);
        this.sessionURLIdentifier = UUID.randomUUID().toString();
        String staticBaseRoute = this.getStaticServingRoute();
        router.route(String.valueOf(staticBaseRoute) + "/*").handler(this::fileServing);
        HttpServerOptions options = new HttpServerOptions().setHost(HOST).setPort(0);
        this.vertx.createHttpServer(options).webSocketHandler(this::handleWebSocket).requestHandler((Handler)router).listen(this::handleServerListening);
    }

    private void fileServing(RoutingContext context) {
        String normalizedPath = context.normalizedPath();
        String filePath = null;
        try {
            filePath = normalizedPath.substring(this.getStaticServingRoute().length() + 1);
        }
        catch (Exception exception) {
            context.response().setStatusCode(404).end(String.format("File '%s' not found", filePath));
            return;
        }
        if (filePath.isEmpty()) {
            context.reroute(String.valueOf(this.getStaticServingRoute()) + this.indexHtml);
            return;
        }
        HttpServerResponse response = context.response();
        response.setChunked(true);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream fileStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filePath);){
                int bytesRead;
                if (fileStream == null) {
                    context.response().setStatusCode(404).end(String.format("File '%s' not found", filePath));
                    return;
                }
                byte[] buffer = new byte[4096];
                while ((bytesRead = fileStream.read(buffer)) != -1) {
                    Buffer vertxBuffer = Buffer.buffer((int)bytesRead);
                    vertxBuffer.setBytes(0, buffer, 0, bytesRead);
                    response.write((Object)vertxBuffer);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            context.response().setStatusCode(500).end(String.format("Error serving file '%s'", filePath));
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        response.end();
    }

    private void handleServerListening(AsyncResult<HttpServer> result) {
        if (!result.succeeded()) {
            DVTLogger.INSTANCE.logError("Failed to launch server: " + result.cause().getMessage() + "\n");
            return;
        }
        this.actualPort = ((HttpServer)result.result()).actualPort();
        DVTLogger.INSTANCE.logInfo("HTTP server started on port " + this.actualPort + "\n");
        this.initializationLatch.countDown();
    }

    private void handleWebSocket(ServerWebSocket wsServer) {
        if (!wsServer.path().equals("/" + this.sessionURLIdentifier + "/" + WEBSOCKETS_ROUTE)) {
            wsServer.reject();
            return;
        }
        WebSocketLauncherBuilder builder = new WebSocketLauncherBuilder();
        Launcher.Builder launcherBuilder = builder.setServerWebSocket(wsServer).setLocalService(this.plugin).setRemoteInterface(this.webviewInterface);
        Launcher launcher = launcherBuilder.create();
        this.plugin.setRemoteProxy(launcher.getRemoteProxy());
    }

    public String getStaticServingURL() {
        return String.valueOf(this.getBaseURL()) + this.getStaticServingRoute() + "/";
    }

    private String getStaticServingRoute() {
        return "/" + this.sessionURLIdentifier + "/" + STATIC_SERVING_ROUTE;
    }

    private String getBaseURL() {
        return "http://127.0.0.1:" + this.actualPort;
    }
}

