/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.webview;

import io.vertx.core.Handler;
import io.vertx.core.http.ServerWebSocket;
import java.util.Collection;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueHandler;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import ro.amiq.dvt.webview.WebSocketMessageConsumer;
import ro.amiq.dvt.webview.WebSocketMessageHandler;

public class WebSocketLauncherBuilder<T>
extends Launcher.Builder<T> {
    private ServerWebSocket serverWebSocket;

    protected WebSocketLauncherBuilder<T> setServerWebSocket(ServerWebSocket serverWebSocket) {
        this.serverWebSocket = serverWebSocket;
        return this;
    }

    public Launcher<T> create() {
        if (this.localServices == null) {
            throw new IllegalStateException("Local service must be configured.");
        }
        if (this.remoteInterfaces == null) {
            throw new IllegalStateException("Remote interface must be configured.");
        }
        MessageJsonHandler jsonHandler = this.createJsonHandler();
        RemoteEndpoint remoteEndpoint = this.createRemoteEndpoint(jsonHandler);
        this.addMessageHandlers(jsonHandler, remoteEndpoint);
        Object remoteProxy = this.createProxy(remoteEndpoint);
        return this.createLauncher(null, remoteProxy, remoteEndpoint, null);
    }

    protected RemoteEndpoint createRemoteEndpoint(MessageJsonHandler jsonHandler) {
        WebSocketMessageConsumer outgoingMessageStream = new WebSocketMessageConsumer(this.serverWebSocket, jsonHandler);
        outgoingMessageStream = this.wrapMessageConsumer(outgoingMessageStream);
        Endpoint localEndpoint = ServiceEndpoints.toEndpoint((Collection)this.localServices);
        RemoteEndpoint remoteEndpoint = this.exceptionHandler == null ? new RemoteEndpoint((MessageConsumer)outgoingMessageStream, localEndpoint) : new RemoteEndpoint((MessageConsumer)outgoingMessageStream, localEndpoint, this.exceptionHandler);
        jsonHandler.setMethodProvider((MethodProvider)remoteEndpoint);
        return remoteEndpoint;
    }

    private void addMessageHandlers(MessageJsonHandler jsonHandler, RemoteEndpoint remoteEndpoint) {
        MessageConsumer messageConsumer = this.wrapMessageConsumer((MessageConsumer)remoteEndpoint);
        this.serverWebSocket.textMessageHandler((Handler)new WebSocketMessageHandler(messageConsumer, jsonHandler, (MessageIssueHandler)remoteEndpoint));
    }
}

