/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.webview;

import io.vertx.core.http.ServerWebSocket;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.messages.Message;

public class WebSocketMessageConsumer
implements MessageConsumer {
    private final MessageJsonHandler jsonHandler;
    private final ServerWebSocket serverWebSocket;

    protected WebSocketMessageConsumer(ServerWebSocket serverWebSocket, MessageJsonHandler jsonHandler) {
        this.serverWebSocket = serverWebSocket;
        this.jsonHandler = jsonHandler;
    }

    public void consume(Message message) {
        String content = this.jsonHandler.serialize(message);
        this.sendMessage(content);
    }

    private void sendMessage(String message) {
        if (this.serverWebSocket.isClosed()) {
            return;
        }
        this.serverWebSocket.writeTextMessage(message);
    }
}

