/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.webview.browser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum DVTBrowserUtils {
    INSTANCE;

    private Shell hiddenShell;
    private static final String SHOW_DEV_TOOLS_METHOD_NAME = "showDevTools";

    public Browser initializeBrowser() {
        return new Browser((Composite)this.getHiddenShell(), 0);
    }

    public void openDevTools(Browser browser) {
        if (browser == null) {
            return;
        }
        Object webBrowser = browser.getWebBrowser();
        Class<?> chromiumBrowserClass = webBrowser.getClass();
        Method showDevToolsMethod = null;
        try {
            showDevToolsMethod = chromiumBrowserClass.getMethod(SHOW_DEV_TOOLS_METHOD_NAME, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        if (showDevToolsMethod == null) {
            return;
        }
        try {
            showDevToolsMethod.setAccessible(true);
            showDevToolsMethod.invoke(webBrowser, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Shell getHiddenShell() {
        if (this.hiddenShell != null) {
            return this.hiddenShell;
        }
        this.hiddenShell = new Shell(PlatformUI.getWorkbench().getDisplay(), 0);
        this.hiddenShell.setSize(0, 0);
        this.hiddenShell.setVisible(false);
        return this.hiddenShell;
    }
}

