/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.guifilters;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.ViewsUtils;

public class NewGUIFiltersXML
extends Wizard
implements INewWizard {
    private static final String GUI_FILTERS_XML = "content_filters.xml";
    private static final String DIALOG_TITLE = "Content Filters XML File already exists";
    private static final String DIALOG_MESSAGE = "Will not overwrite Content Filters XML File for project ''{0}'':\n\n{1}";
    public static final String ID = "ro.amiq.dvt.wizards.guifilters.NewGUIFiltersXMLLaunch";
    private IStructuredSelection fSelection;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.fSelection = selection;
    }

    public boolean performFinish() {
        IProject project = null;
        Object selection = this.fSelection.getFirstElement();
        if (selection instanceof IProject) {
            project = (IProject)selection;
        } else if (selection instanceof IFolder) {
            project = ((IFolder)selection).getProject();
        } else if (selection instanceof IFile) {
            project = ((IFile)selection).getProject();
        }
        if (project == null) {
            project = Utils.selectProject(new String[]{"ro.amiq.vhdldt.VhdlNature", "ro.amiq.vlogdt.VlogNature", "ro.amiq.edt.enature", "ro.amiq.slndt.slnnature", "ro.amiq.msdldt.msdlnature", "ro.amiq.pssdt.pssnature", "ro.amiq.dvt.dvtnature"}, "For which project do you want to create a content_filters.xml?", null, DVTPlugin.getSelectionManager().getLastSelectedProject() == null ? null : DVTPlugin.getSelectionManager().getLastSelectedProject());
        }
        if (project == null) {
            return false;
        }
        try {
            IFile filtersFile = project.getFile(".dvt/content_filters.xml");
            filtersFile.refreshLocal(2, null);
            if (!filtersFile.exists()) {
                filtersFile.create(NewGUIFiltersXML.class.getResource(GUI_FILTERS_XML).openStream(), false, null);
                IDE.openEditor((IWorkbenchPage)Utils.getActiveWorkbenchWindow().getActivePage(), (IFile)filtersFile);
                DVTViewManager.getInstanceByCurrentWorkbenchWindow().notifyViewsWithBuildEvents(BuildEvents.GUI_FILTERS_PROJECT, project, ViewsUtils.ALL_VIEWS);
            } else {
                MessageDialog dialog = new MessageDialog(Utils.getActiveWorkbenchWindow().getShell(), DIALOG_TITLE, null, MessageFormat.format(DIALOG_MESSAGE, project.getName(), filtersFile.getLocation().toOSString()), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
                IDE.openEditor((IWorkbenchPage)Utils.getActiveWorkbenchWindow().getActivePage(), (IFile)filtersFile);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }
}

