/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.linkedresources;

import java.io.File;
import java.util.regex.Pattern;
import org.eclipse.core.internal.resources.LocationValidator;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.ui.ContainerSelectionDialog;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.wizards.linkedresources.CreateLinkedResourcesModel;

public class CreateLinkedResourcesFirstPage
extends WizardPage {
    private CreateLinkedResourcesModel fModel;
    private Text fDirectoryName;
    private Text fLocationDir;
    private Text fTargetDir;

    protected CreateLinkedResourcesFirstPage(String pageName, CreateLinkedResourcesModel model) {
        super(pageName);
        this.fModel = model;
        this.setTitle("Linked Resource");
        this.setDescription("Create a new resource linked to a directory in the file system");
        this.setImageDescriptor(DVTImages.CREATE_LINKED_FOLDER_WIZ);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label linksToLabel = new Label(composite, 0);
        linksToLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        linksToLabel.setText("Target:");
        this.fTargetDir = new Text(composite, 2048);
        this.fTargetDir.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.fModel.getTargetPath() != null) {
            this.fTargetDir.setText(this.fModel.getTargetPath());
        }
        this.fTargetDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLinkedResourcesFirstPage.this.updatePageState();
            }
        });
        Button linksToDirBrowse = new Button(composite, 0);
        linksToDirBrowse.setLayoutData((Object)new GridData(131072, 4, false, false));
        linksToDirBrowse.setText("Browse");
        linksToDirBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String filterPath = DVTFileUtils.getInstance().getLastDirectory();
                DirectoryDialog directoryDialog = new DirectoryDialog(CreateLinkedResourcesFirstPage.this.getShell());
                directoryDialog.setFilterPath(filterPath);
                String selectedDirectory = directoryDialog.open();
                if (selectedDirectory != null) {
                    CreateLinkedResourcesFirstPage.this.fTargetDir.setText(selectedDirectory);
                    CreateLinkedResourcesFirstPage.this.fDirectoryName.setText(new File(selectedDirectory).getName());
                    DVTFileUtils.getInstance().setLastDirectory(selectedDirectory);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label folderNameLabel = new Label(composite, 0);
        folderNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        folderNameLabel.setText("Name:");
        this.fDirectoryName = new Text(composite, 2048);
        this.fDirectoryName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.fModel.getFolderName() != null) {
            this.fDirectoryName.setText(this.fModel.getFolderName());
        }
        this.fDirectoryName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLinkedResourcesFirstPage.this.updatePageState();
            }
        });
        new Label(composite, 0);
        Label locationLabel = new Label(composite, 0);
        locationLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        locationLabel.setText("Location:");
        this.fLocationDir = new Text(composite, 2048);
        this.fLocationDir.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.fModel.getIProject() != null) {
            this.fLocationDir.setText(this.fModel.getIProject().getFullPath().toOSString());
        }
        this.fLocationDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLinkedResourcesFirstPage.this.updatePageState();
            }
        });
        String targetPath = this.fModel.getLocationPath();
        if (targetPath != null) {
            this.fLocationDir.setText(this.fModel.getLocationPath());
        }
        this.fLocationDir.setEditable(false);
        this.fLocationDir.setEnabled(false);
        Button targetDirBrowse = new Button(composite, 0);
        targetDirBrowse.setLayoutData((Object)new GridData(131072, 4, false, false));
        targetDirBrowse.setText("Browse");
        targetDirBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IProject iProject;
                IProject selectedResource = iProject = CreateLinkedResourcesFirstPage.this.fModel.getIProject();
                String location = CreateLinkedResourcesFirstPage.this.fLocationDir.getText();
                if (iProject != null && !location.isEmpty()) {
                    String locationRoot = location.replace(String.valueOf(File.separator) + iProject.getName(), "");
                    if (locationRoot.startsWith(File.separator)) {
                        locationRoot = locationRoot.substring(1);
                    }
                    if (!locationRoot.isEmpty()) {
                        selectedResource = selectedResource.getFolder(Path.fromOSString((String)locationRoot));
                    }
                }
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(CreateLinkedResourcesFirstPage.this.getShell(), null, (IContainer)selectedResource, true, "Select location:", "Select location:");
                dialog.setBlockOnOpen(true);
                dialog.showClosedProjects(false);
                dialog.showLinkedResources(false);
                dialog.showVirtualResources(false);
                dialog.setTitle("Location Selection");
                dialog.open();
                Object[] result = dialog.getResult();
                if (result == null || result.length != 1) {
                    return;
                }
                Object file = result[0];
                if (file instanceof IPath) {
                    String relativePath = ((IPath)file).toOSString();
                    String[] parts = relativePath.split(Pattern.quote(File.separator));
                    String projectPath = String.valueOf(File.separator) + parts[1];
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IProject project = root.getProject(projectPath);
                    CreateLinkedResourcesFirstPage.this.fModel.setIProject(project);
                    CreateLinkedResourcesFirstPage.this.fLocationDir.setText(relativePath);
                    CreateLinkedResourcesFirstPage.this.fModel.setLocationPath(CreateLinkedResourcesFirstPage.this.getLocationPath(relativePath, CreateLinkedResourcesFirstPage.this.fDirectoryName.getText()));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.updatePageState();
        this.setControl((Control)composite);
    }

    private void updatePageState() {
        boolean pageComplete = true;
        if (this.fDirectoryName == null || this.fTargetDir == null || this.fLocationDir == null) {
            this.setPageComplete(false);
            return;
        }
        String folderName = this.fDirectoryName.getText();
        String linksTo = ResourceFilterUtils.expandDvtEnvVars(ResourceFilterUtils.toDvtEnvVars(this.fTargetDir.getText()));
        String targetDir = this.fLocationDir.getText();
        String fullTargetPath = this.getLocationPath(targetDir, folderName);
        IProject iProject = this.fModel.getIProject();
        if (folderName.isEmpty()) {
            this.setErrorMessage("\"Name\" must not be empty!");
            pageComplete = false;
        } else if (iProject != null && iProject.getFolder((IPath)new Path(fullTargetPath)).exists()) {
            this.setErrorMessage("There is another directory with the same name under this project !");
            pageComplete = false;
        }
        if (linksTo.isEmpty()) {
            this.setErrorMessage("\"Target\" directory path must not be empty!");
            pageComplete = false;
        } else {
            File linksToFile = new File(linksTo);
            if (!linksToFile.exists()) {
                this.setErrorMessage("'" + linksTo + "' is an invalid location!");
                pageComplete = false;
            } else if (!linksToFile.canRead()) {
                this.setErrorMessage("You don't have permission to read '" + linksTo + "' directory!");
                pageComplete = false;
            } else if (!linksToFile.isDirectory()) {
                this.setErrorMessage("'" + linksTo + "' location is not a directory!");
                pageComplete = false;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath workspacePath = workspace.getRoot().getLocation();
            if (Path.fromOSString((String)linksTo).equals((Object)workspacePath)) {
                this.setErrorMessage("'" + linksTo + "' directory overlaps eclipse workspace location!");
                pageComplete = false;
            } else if (Path.fromOSString((String)linksTo).isPrefixOf(workspacePath)) {
                this.setErrorMessage("'" + linksTo + "' directory is a parent of eclipse workspace location!");
                pageComplete = false;
            } else if (workspacePath.isPrefixOf(Path.fromOSString((String)linksTo))) {
                this.setErrorMessage("'" + linksTo + "' directory is inside the eclipse workspace location!");
                pageComplete = false;
            } else if (iProject != null && iProject.getLocation().toOSString().startsWith(linksTo)) {
                this.setErrorMessage("'" + linksTo + "' directory overlaps the location of the project that contains the linked resource!");
                pageComplete = false;
            }
            if (iProject != null && !fullTargetPath.isEmpty()) {
                IFolder linkedFolder = iProject.getFolder((IPath)new Path(fullTargetPath));
                Path linkTarget = new Path(linksTo);
                LocationValidator lv = new LocationValidator((Workspace)ResourcesPlugin.getWorkspace());
                IStatus status = lv.validateLinkLocation((IResource)linkedFolder, (IPath)linkTarget);
                if (!status.isOK()) {
                    this.setErrorMessage(status.getMessage());
                    pageComplete = false;
                }
            }
        }
        if (targetDir.isEmpty()) {
            this.setErrorMessage("\"Location\" path must not be empty!");
            pageComplete = false;
        }
        if (pageComplete) {
            this.setErrorMessage(null);
            this.setMessage(null);
            this.savePaths();
        }
        this.setPageComplete(pageComplete);
    }

    private void savePaths() {
        this.fModel.setDirectoryName(this.fDirectoryName.getText());
        this.fModel.setTargetPath(ResourceFilterUtils.toDvtEnvVars(this.fTargetDir.getText()));
        this.fModel.setLocationPath(this.getLocationPath(this.fLocationDir.getText(), this.fDirectoryName.getText()));
    }

    private String getLocationPath(String path, String folderName) {
        IProject iProject = this.fModel.getIProject();
        if (iProject == null) {
            return "";
        }
        String projectName = iProject.getName();
        if ((path = path.replace(String.valueOf(File.separator) + projectName, "")).startsWith(File.separator)) {
            path = path.substring(File.separator.length());
        }
        if (path.isEmpty()) {
            return folderName;
        }
        return String.valueOf(path) + File.separator + folderName;
    }
}

