/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.linkedresources;

import java.io.File;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.resourcefilters.NewProjectResourceFiltersWrapper;
import ro.amiq.dvt.resourcefilters.ResourceFilterMessageDialog;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.wizards.linkedresources.CreateLinkedResourcesFirstPage;
import ro.amiq.dvt.wizards.linkedresources.CreateLinkedResourcesModel;

public class CreateLinkedResourcesWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String ID = "ro.amiq.dvt.ui.wizards.createlinkedresources";
    private static final String CREATE_LINK_RESOURCE_CALLER_NAME = "Create Linked Resource";
    private CreateLinkedResourcesModel fModel = new CreateLinkedResourcesModel();
    private CreateLinkedResourcesFirstPage fFirstPage;
    private IWorkbench fWorkbench;
    private IResource fSelectedResource;

    public void addPages() {
        this.setWindowTitle("Create New Linked Resource");
        this.addPage((IWizardPage)this.fFirstPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        ISelection newSelection;
        this.fWorkbench = workbench;
        if (selection == null && (newSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection()) instanceof IStructuredSelection) {
            selection = (IStructuredSelection)newSelection;
        }
        this.fSelectedResource = this.getSelectedTarget(selection);
        if (this.fSelectedResource != null) {
            IPath targetIPath = this.fSelectedResource.getFullPath();
            if (this.fSelectedResource.isVirtual() && this.fSelectedResource.getProjectRelativePath().segment(0).equals("DVT Auto-Linked")) {
                this.fModel.setTargetPath(DVTFileUtils.getInstance().resolveAutoLinkPath(this.fSelectedResource).toOSString());
                this.fModel.setDirectoryName(this.getAutoRootDirectoryName());
            } else if (!this.fSelectedResource.isAccessible() || this.fSelectedResource.isLinked() || this.fSelectedResource.isVirtual()) {
                this.fModel.setLocationPath("");
            } else {
                this.fModel.setLocationPath(targetIPath.toFile().getAbsolutePath());
            }
            if (this.fSelectedResource.getProject().isAccessible()) {
                this.fModel.setIProject(this.fSelectedResource.getProject());
            } else {
                this.fModel.setIProject(null);
            }
        }
        this.fFirstPage = new CreateLinkedResourcesFirstPage("Create Linked Resources", this.fModel);
        this.setNeedsProgressMonitor(true);
    }

    public String getAutoRootDirectoryName() {
        String folderName = this.fSelectedResource.getProjectRelativePath().lastSegment();
        if (!this.fSelectedResource.getProject().getFolder(folderName).isAccessible()) {
            return folderName;
        }
        int i = 1;
        while (i < 1001) {
            String newFolderName = String.valueOf(folderName) + i;
            if (!this.fSelectedResource.getProject().getFolder(newFolderName).isAccessible()) {
                return newFolderName;
            }
            ++i;
        }
        return String.valueOf(folderName) + "1";
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public boolean performFinish() {
        Set<String> filteredPaths;
        block6: {
            this.checkLinksToDirectory();
            filteredPaths = this.fModel.getFilteredPaths();
            if (filteredPaths != null) break block6;
            return false;
        }
        try {
            String targetPath = this.fModel.getLocationPath();
            if (!filteredPaths.isEmpty()) {
                HashSet<String> newFilteredPaths = new HashSet<String>();
                for (String path : filteredPaths) {
                    newFilteredPaths.add(String.valueOf(targetPath) + File.separator + path);
                }
                ResourceFilterUtils.appendDvtFilters(this.fModel.getIProject(), newFilteredPaths, true);
            }
            if (this.fSelectedResource.isVirtual() && this.fSelectedResource instanceof IFolder) {
                IProject project = this.fSelectedResource.getProject();
                DVTAutoLinkManager.getInstance().dirtyAutoLink(project, (IFolder)this.fSelectedResource);
            }
            IFolder linkedFolder = this.fModel.getIProject().getFolder((IPath)new Path(targetPath));
            Path linkTarget = new Path(this.fModel.getLinksToPath());
            linkedFolder.createLink(URIUtil.toURI((IPath)linkTarget), 16, (IProgressMonitor)new NullProgressMonitor());
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ISchedulingRule rule = workspace.getRuleFactory().createRule((IResource)linkedFolder);
            workspace.run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    final IProject project = CreateLinkedResourcesWizard.this.fModel.getIProject();
                    DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

                        @Override
                        public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                            DVTAutoLinkManager.getInstance().removeDirtyAutoLink(project, "DVT Auto-Linked", cachedLinksMap);
                        }
                    };
                    DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, CreateLinkedResourcesWizard.CREATE_LINK_RESOURCE_CALLER_NAME, op, false);
                }
            }, rule, 1, (IProgressMonitor)new NullProgressMonitor());
            BasicNewResourceWizard.selectAndReveal((IResource)linkedFolder, (IWorkbenchWindow)this.fWorkbench.getActiveWorkbenchWindow());
            return true;
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private IResource getSelectedTarget(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        if (selection.toArray().length == 0 || selection.toArray().length > 1) {
            return null;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IContainer) {
            return (IContainer)firstElement;
        }
        if (firstElement instanceof IFile) {
            return ((IFile)firstElement).getParent();
        }
        return null;
    }

    private void checkLinksToDirectory() {
        File dir = new File(ResourceFilterUtils.expandDvtEnvVars(this.fModel.getLinksToPath()));
        long startTimeMillis = System.currentTimeMillis();
        int nrOfFiles = ResourceFilterUtils.countChildrenRecursively(dir, 50000, 10000L, true);
        if (System.currentTimeMillis() - startTimeMillis >= 10000L) {
            DecimalFormat formatter = new DecimalFormat("#.##");
            ResourceFilterMessageDialog messageDialog = new ResourceFilterMessageDialog("The project directory seems to be located on a slow filesystem (file access average: " + formatter.format(10000.0f / (float)nrOfFiles) + " ms) and this may slow down the platform.", dir.getAbsolutePath(), null, true, true);
            NewProjectResourceFiltersWrapper resourceFilterWrapper = messageDialog.openCustom();
            this.fModel.setFilteredPaths(resourceFilterWrapper.getExcludedPaths());
        } else if (nrOfFiles >= 50000) {
            ResourceFilterMessageDialog messageDialog = new ResourceFilterMessageDialog("The project directory contains more than 50000 children and this may slow down the platform.", dir.getAbsolutePath(), null, true, true);
            NewProjectResourceFiltersWrapper resourceFilterWrapper = messageDialog.openCustom();
            this.fModel.setFilteredPaths(resourceFilterWrapper.getExcludedPaths());
        }
    }
}

