/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.newfile;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTQuickAssistUtil;
import ro.amiq.dvt.wizards.newfile.FormatNewFileContentPatternType;
import ro.amiq.dvt.wizards.newfile.IOperationType;
import ro.amiq.dvt.wizards.newfile.NewFileWithCustomContentWizardPage;
import ro.amiq.dvt.wizards.newfile.NewFileWizard;

public class NewFileWithCustomContentWizard
extends NewFileWizard {
    private String customContent;
    private FormatNewFileContentPatternType patternType;
    private IPath customDirectoryPath;
    private IOperationType operationType;
    private String fileNamePattern;

    public NewFileWithCustomContentWizard(String customContent, IPath customDirectoryPath, FormatNewFileContentPatternType patternType, IOperationType operationType, String fileNamePattern) {
        super(true);
        this.customContent = customContent;
        this.patternType = patternType;
        this.customDirectoryPath = customDirectoryPath;
        this.operationType = operationType;
        this.fileNamePattern = fileNamePattern;
    }

    @Override
    public void addPages() {
        this.setWindowTitle(this.operationType.getPattern());
        this.setPage(new NewFileWithCustomContentWizardPage(this.getSelection(), this.customDirectoryPath, this.operationType, this.fileNamePattern));
        this.addPage((IWizardPage)this.getPage());
    }

    @Override
    protected InputStream openContentStream() {
        StringBuilder buf = new StringBuilder();
        switch (this.patternType) {
            case FILE_NAME: {
                Map<String, String> substMap = DVTQuickAssistUtil.makeCommentSubstMap(Arrays.asList(this.patternType.getPattern()), Arrays.asList(this.getFileNameWithoutExtension()));
                this.customContent = StrSubstitutor.replace((Object)this.customContent, substMap, (String)DVTQuickAssistUtil.STR_SUBSTITUTOR_PREFIX, (String)DVTQuickAssistUtil.STR_SUBSTITUTOR_SUFFIX);
                break;
            }
        }
        buf.append(this.customContent);
        return new ByteArrayInputStream(buf.toString().getBytes());
    }

    public IPath getDirectoryProjectRelativePath() {
        IFile file = this.getFile();
        if (file == null) {
            return Path.EMPTY;
        }
        IContainer parent = file.getParent();
        if (parent == null) {
            return Path.EMPTY;
        }
        return parent.getProjectRelativePath();
    }
}

