/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.newfile;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.DVTExceptionHandler;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.wizards.newfile.NewFileWizardPage;

public class NewFileWizard
extends Wizard
implements INewWizard {
    private NewFileWizardPage fPage;
    public static final String ID = "ro.amiq.dvt.wizards.newfile.NewFileWizardLaunch";
    private IWorkbench fWorkbench;
    private ISelection fSelection;
    private IFile fFile;
    private boolean fIsCreateFromTemplateDisabled;

    public NewFileWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public NewFileWizard(boolean isCreateFromTemplateDisabled) {
        this.setNeedsProgressMonitor(true);
        this.fIsCreateFromTemplateDisabled = isCreateFromTemplateDisabled;
    }

    public void addPages() {
        this.setWindowTitle("New File");
        this.fPage = new NewFileWizardPage(this.fSelection);
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        this.fPage.serializeTemplates();
        final String containerName = this.fPage.removeFileSeparatorForAutoLinkedNetworkPath(this.fPage.getDirectoryName());
        final String fileName = this.fPage.getFileNameWithExtension();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewFileWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            DVTExceptionHandler.handle(e, this.getShell(), "Error", e.getMessage());
            return false;
        }
        BasicNewResourceWizard.selectAndReveal((IResource)this.fFile, (IWorkbenchWindow)this.fWorkbench.getActiveWorkbenchWindow());
        NewFileWizardPage.fLastSelectionExtension = this.fPage.getFileExtension();
        final TemplateContextType contextType = this.getContextType();
        final Template template = this.fPage.getSelectedTemplate();
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)NewFileWizard.this.fFile, (boolean)true);
                    if (editorPart == null) {
                        return;
                    }
                    if (!(editorPart instanceof DVTEditor)) {
                        return;
                    }
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IDocumentProvider docProvider = textEditor.getDocumentProvider();
                    if (docProvider == null) {
                        return;
                    }
                    IEditorInput editorInput = editorPart.getEditorInput();
                    if (editorInput == null) {
                        return;
                    }
                    if (!NewFileWizard.this.fIsCreateFromTemplateDisabled) {
                        IDocument doc = docProvider.getDocument((Object)editorInput);
                        if (doc == null) {
                            return;
                        }
                        if (contextType == null) {
                            return;
                        }
                        if (template == null) {
                            return;
                        }
                        DocumentTemplateContext context = new DocumentTemplateContext(contextType, doc, (Position)new DVTPosition(0));
                        TemplateProposal templateProposal = new TemplateProposal(template, (TemplateContext)context, (IRegion)new Region(doc.getLength(), doc.getLength()), null, 0);
                        templateProposal.apply(((DVTEditor)editorPart).getTextViewer(), '\u0000', 0, doc.getLength());
                    }
                    editorPart.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IResource container = root.findMember((IPath)new Path(containerName));
        if (!container.exists() || !(container instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        this.fFile = DVTAutoLinkManager.getInstance().getFile((IContainer)container, fileName, monitor);
        InputStream stream = this.openContentStream();
        try {
            if (this.fFile.exists()) {
                this.fFile.setContents(stream, true, true, monitor);
            } else {
                this.fFile.create(stream, true, monitor);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        DVTUtilsCommon.INSTANCE.closeClosable(stream);
        monitor.worked(1);
    }

    protected InputStream openContentStream() {
        StringBuilder buf = new StringBuilder();
        try {
            TemplateContextType contextType = this.getContextType();
            contextType.addResolver((TemplateVariableResolver)new FileName());
            DocumentTemplateContext context = new DocumentTemplateContext(contextType, (IDocument)new Document(), (Position)new DVTPosition(0));
            TemplateBuffer templateBuffer = context.evaluate(this.fPage.getSelectedTemplate());
            buf.append(templateBuffer.getString());
        }
        catch (Exception exception) {
            buf.delete(0, buf.length());
            buf.append(NewFileWizardPage.DEFAULT_TEMPLATE.getPattern());
        }
        return new ByteArrayInputStream(buf.toString().getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        this.setNeedsProgressMonitor(true);
        this.fSelection = selection;
    }

    public TemplateContextType getContextType() {
        String currentFileTemplateContext = this.fPage.getCurrentFileTemplateContext();
        if (currentFileTemplateContext == null) {
            return null;
        }
        String currentFileNature = this.fPage.getCurrentFileNature();
        if (currentFileNature.isEmpty()) {
            return null;
        }
        return TemplatesViewUtils.getContextTypeRegistry(currentFileNature).getContextType(currentFileTemplateContext);
    }

    public IFile getFile() {
        return this.fFile;
    }

    public String getFileName() {
        if (this.fFile == null) {
            return null;
        }
        return this.fFile.getName();
    }

    public String getFileNameWithoutExtension() {
        if (this.fFile == null) {
            return null;
        }
        IPath path = this.fFile.getFullPath();
        if (path == null) {
            return null;
        }
        return Path.fromOSString((String)path.toOSString()).removeFileExtension().lastSegment();
    }

    protected void setPage(NewFileWizardPage fPage) {
        this.fPage = fPage;
    }

    protected NewFileWizardPage getPage() {
        return this.fPage;
    }

    protected ISelection getSelection() {
        return this.fSelection;
    }

    public class FileName
    extends SimpleTemplateVariableResolver {
        public FileName() {
            super("file_name", "File name");
        }

        protected String resolve(TemplateContext context) {
            return NewFileWizard.this.fFile.getName().substring(0, NewFileWizard.this.fFile.getName().lastIndexOf("."));
        }
    }
}

