/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.newfile;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.refactor.connect.CustomTextContentAdapter;
import ro.amiq.dvt.ui.refactor.connect.ViewerContentProposalProvider;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.wizards.newfile.AIOperationType;
import ro.amiq.dvt.wizards.newfile.IOperationType;
import ro.amiq.dvt.wizards.newfile.QuickFixOrAssistType;
import ro.amiq.dvt.wizards.util.FileTemplateSelector;

public class NewFileWizardPage
extends WizardPage {
    private static final String NATURE_SEPARATOR = "<nature>";
    private static final String TEMPLATE_SEPARATOR = "<template>";
    private static final String DEFAULT_FILE_TEMPLATE_NAME = "default";
    private static final String DEFAULT_FILE_TEMPLATE_NOTE = "NOTE: ";
    private static final Map<String, String> fTitles = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("ro.amiq.vlogdt.VlogNature", "New Verilog/SystemVerilog File");
            this.put("ro.amiq.edt.enature", "New e Module");
            this.put("ro.amiq.slndt.slnnature", "New SLN Module");
            this.put("ro.amiq.msdldt.msdlnature", "New M-SDL File");
            this.put("ro.amiq.pssdt.pssnature", "New PSS File");
            this.put("ro.amiq.vhdldt.VhdlNature", "New VHDL File");
        }
    };
    private static final String VLOG_DEFAULT_EXTENSION = ".sv";
    private static final String E_DEFAULT_EXTENSION = ".e";
    private static final String SLN_DEFAULT_EXTENSION = ".sln";
    private static final String MSDL_DEFAULT_EXTENSION = ".sdl";
    private static final String PSS_DEFAULT_EXTENSION = ".pss";
    private static final String VHDL_DEFAULT_EXTENSION = ".vhd";
    public static String fLastSelectionExtension;
    public static final Template DEFAULT_TEMPLATE;
    public final List<String> VLOG_EXTENSIONS = new ArrayList<String>();
    public final List<String> E_EXTENSIONS;
    public final List<String> SLN_EXTENSIONS;
    public final List<String> MSDL_EXTENSIONS;
    public final List<String> PSS_EXTENSIONS;
    public final List<String> VHDL_EXTENSIONS;
    public final List<String> fCurrentProjectExtensions;
    public final AtomicBoolean fCustomExtension;
    private final List<String> fTemplateContexts;
    public String fCurrentFileExtension;
    private Template fCurrentSelectedTemplate;
    private final Map<String, String> fSerializedTemplates;
    private Template[] fTemplates;
    private Text fDirectoryText;
    private Text fFileNameText;
    private ISelection fSelection;
    private IProject fIProject;
    private Text fCurrentTemplateName;
    private Button fTemplateSelectorButton;
    private Label fEmptyTemplateNote;
    private Combo fExtensionCombo;
    private ViewerContentProposalProvider fFindProposer;
    private boolean fIsCreateFromTemplateDisabled;
    private IPath fCustomDirectoryPath;
    private IOperationType foperationType;
    private String fFileNamePattern;

    static {
        DEFAULT_TEMPLATE = new Template("Default template", "Default template", "ro.amiq.vlogdt.templates.contextType.file_content", "", true);
    }

    public NewFileWizardPage(ISelection selection) {
        super("NewFileWizardPage");
        this.VLOG_EXTENSIONS.addAll(this.getFileExtensions("ro.amiq.vlogdt.VlogSource"));
        this.VLOG_EXTENSIONS.addAll(this.getFileExtensions("ro.amiq.vlogdt.VlogAmsSource"));
        this.E_EXTENSIONS = this.getFileExtensions("ro.amiq.edt.ESource");
        this.SLN_EXTENSIONS = this.getFileExtensions("ro.amiq.slndt.SLNSource");
        this.MSDL_EXTENSIONS = this.getFileExtensions("ro.amiq.msdldt.MSDLSource");
        this.PSS_EXTENSIONS = this.getFileExtensions("ro.amiq.pssdt.PSSSource");
        this.VHDL_EXTENSIONS = this.getFileExtensions("ro.amiq.vhdldt.VhdlSource");
        this.fCurrentProjectExtensions = new ArrayList<String>();
        this.fCustomExtension = new AtomicBoolean(false);
        this.fTemplateContexts = new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("ro.amiq.vlogdt.templates.contextType.file_content");
                this.add("ro.amiq.edt.templates.contextType.file_content");
                this.add("ro.amiq.msdldt.templates.contextType.file_content");
                this.add("ro.amiq.slndt.templates.contextType.file_content");
                this.add("ro.amiq.vhdldt.templates.contextType.file_content");
            }
        };
        this.fCurrentFileExtension = "";
        this.fSerializedTemplates = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("ro.amiq.vlogdt.VlogNature", NewFileWizardPage.DEFAULT_FILE_TEMPLATE_NAME);
                this.put("ro.amiq.edt.enature", NewFileWizardPage.DEFAULT_FILE_TEMPLATE_NAME);
                this.put("ro.amiq.slndt.slnnature", NewFileWizardPage.DEFAULT_FILE_TEMPLATE_NAME);
                this.put("ro.amiq.msdldt.msdlnature", NewFileWizardPage.DEFAULT_FILE_TEMPLATE_NAME);
                this.put("ro.amiq.vhdldt.VhdlNature", NewFileWizardPage.DEFAULT_FILE_TEMPLATE_NAME);
            }
        };
        this.setTitle("Name and Location");
        this.setDescription("Creates a new file");
        this.setImageDescriptor(DVTImages.NEW_EMPTY_FILE_WIZ);
        this.fSelection = selection;
    }

    public void createControl(Composite parent) {
        this.initCurrentFileExtension();
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(container, 0);
        label.setFont(parent.getFont());
        label.setText("&Name:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fFileNameText = new Text(container, 2052);
        this.fFileNameText.setFont(parent.getFont());
        this.fFileNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fFileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewFileWizardPage.this.fCustomExtension.set(NewFileWizardPage.this.fFileNameText.getText().contains("."));
                NewFileWizardPage.this.dialogChanged();
                boolean enabled = !NewFileWizardPage.this.fCustomExtension.get();
                NewFileWizardPage.this.fExtensionCombo.setEnabled(enabled);
                if (enabled) {
                    List<String> currentProjectNatures = NewFileWizardPage.this.getCurrentProjectNatures();
                    if (currentProjectNatures.isEmpty()) {
                        return;
                    }
                    String currentExtNature = NewFileWizardPage.this.getExtensionNature(NewFileWizardPage.this.fCurrentFileExtension);
                    if (NewFileWizardPage.this.fCurrentFileExtension.isEmpty() && !currentProjectNatures.contains(currentExtNature)) {
                        String nature = currentProjectNatures.get(0);
                        if (nature.equals("ro.amiq.edt.enature")) {
                            NewFileWizardPage.this.fCurrentFileExtension = NewFileWizardPage.E_DEFAULT_EXTENSION;
                        } else if (nature.equals("ro.amiq.slndt.slnnature")) {
                            NewFileWizardPage.this.fCurrentFileExtension = NewFileWizardPage.SLN_DEFAULT_EXTENSION;
                        } else if (nature.equals("ro.amiq.msdldt.msdlnature")) {
                            NewFileWizardPage.this.fCurrentFileExtension = NewFileWizardPage.MSDL_DEFAULT_EXTENSION;
                        } else if (nature.equals("ro.amiq.pssdt.pssnature")) {
                            NewFileWizardPage.this.fCurrentFileExtension = NewFileWizardPage.PSS_DEFAULT_EXTENSION;
                        } else if (nature.equals("ro.amiq.vlogdt.VlogNature")) {
                            NewFileWizardPage.this.fCurrentFileExtension = NewFileWizardPage.VLOG_DEFAULT_EXTENSION;
                        } else if (nature.equals("ro.amiq.vhdldt.VhdlNature")) {
                            NewFileWizardPage.this.fCurrentFileExtension = NewFileWizardPage.VHDL_DEFAULT_EXTENSION;
                        }
                    }
                    NewFileWizardPage.this.fExtensionCombo.setItems(NewFileWizardPage.this.getAllFileExtensions().toArray(new String[0]));
                    NewFileWizardPage.this.fExtensionCombo.setText(NewFileWizardPage.this.fCurrentFileExtension);
                } else {
                    String ext = NewFileWizardPage.this.getFileExtension();
                    String newNature = NewFileWizardPage.this.getExtensionNature(ext);
                    String currentNature = NewFileWizardPage.this.getExtensionNature(NewFileWizardPage.this.fCurrentFileExtension);
                    NewFileWizardPage.this.fCurrentFileExtension = ext;
                    if (!newNature.equals(currentNature)) {
                        NewFileWizardPage.this.updateSelectedTemplate();
                        NewFileWizardPage.this.updatePageTitle();
                    }
                    NewFileWizardPage.this.dialogChanged();
                }
            }
        });
        this.fExtensionCombo = new Combo(container, 8);
        this.fExtensionCombo.setItems(this.getAllFileExtensions().toArray(new String[0]));
        this.fExtensionCombo.setText(this.fCurrentFileExtension);
        GridData layoutData = new GridData(4, 4, false, false);
        layoutData.widthHint = 100;
        this.fExtensionCombo.setLayoutData((Object)layoutData);
        this.fExtensionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String ext = NewFileWizardPage.this.fExtensionCombo.getItem(NewFileWizardPage.this.fExtensionCombo.getSelectionIndex());
                String newNature = NewFileWizardPage.this.getExtensionNature(ext);
                String currentNature = NewFileWizardPage.this.getExtensionNature(NewFileWizardPage.this.fCurrentFileExtension);
                NewFileWizardPage.this.fCurrentFileExtension = ext;
                if (!newNature.equals(currentNature)) {
                    NewFileWizardPage.this.fTemplates = NewFileWizardPage.this.getTemplates();
                    NewFileWizardPage.this.updateTemplateProposals();
                    NewFileWizardPage.this.updateSelectedTemplate();
                    NewFileWizardPage.this.updatePageTitle();
                }
                NewFileWizardPage.this.dialogChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        label = new Label(container, 0);
        label.setFont(parent.getFont());
        label.setText("&Directory:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fDirectoryText = new Text(container, 2052);
        this.fDirectoryText.setFont(parent.getFont());
        this.fDirectoryText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewFileWizardPage.this.dialogChanged();
                List<String> currentProjectNatures = NewFileWizardPage.this.getCurrentProjectNatures();
                if (currentProjectNatures.isEmpty()) {
                    return;
                }
                String currentExtNature = NewFileWizardPage.this.getExtensionNature(NewFileWizardPage.this.fCurrentFileExtension);
                if (NewFileWizardPage.this.fCurrentFileExtension.isEmpty() && !currentProjectNatures.contains(currentExtNature)) {
                    String nature = currentProjectNatures.get(0);
                    if (nature.equals("ro.amiq.edt.enature")) {
                        NewFileWizardPage.this.fCurrentFileExtension = NewFileWizardPage.E_DEFAULT_EXTENSION;
                    } else if (nature.equals("ro.amiq.slndt.slnnature")) {
                        NewFileWizardPage.this.fCurrentFileExtension = NewFileWizardPage.SLN_DEFAULT_EXTENSION;
                    } else if (nature.equals("ro.amiq.msdldt.msdlnature")) {
                        NewFileWizardPage.this.fCurrentFileExtension = NewFileWizardPage.MSDL_DEFAULT_EXTENSION;
                    } else if (nature.equals("ro.amiq.pssdt.pssnature")) {
                        NewFileWizardPage.this.fCurrentFileExtension = NewFileWizardPage.PSS_DEFAULT_EXTENSION;
                    } else if (nature.equals("ro.amiq.vlogdt.VlogNature")) {
                        NewFileWizardPage.this.fCurrentFileExtension = NewFileWizardPage.VLOG_DEFAULT_EXTENSION;
                    } else if (nature.equals("ro.amiq.vhdldt.VhdlNature")) {
                        NewFileWizardPage.this.fCurrentFileExtension = NewFileWizardPage.VHDL_DEFAULT_EXTENSION;
                    }
                }
                if (NewFileWizardPage.this.fCurrentFileExtension != null && !NewFileWizardPage.this.fCurrentFileExtension.isEmpty() && !NewFileWizardPage.this.fFileNameText.getText().contains(".")) {
                    NewFileWizardPage.this.fExtensionCombo.setItems(NewFileWizardPage.this.getAllFileExtensions().toArray(new String[0]));
                    NewFileWizardPage.this.fExtensionCombo.setText(NewFileWizardPage.this.fCurrentFileExtension);
                }
            }
        });
        Button button = new Button(container, 8);
        button.setLayoutData((Object)layoutData);
        button.setFont(parent.getFont());
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewFileWizardPage.this.handleBrowse();
            }
        });
        this.fTemplateSelectorButton = null;
        if (QuickFixOrAssistType.EXTRACT_TO_MODULE_TYPE.equals(this.foperationType) || QuickFixOrAssistType.MOVE_SELECTION_TO_NEW_FILE_TYPE.equals(this.foperationType) || AIOperationType.COPY_CODE_TO_NEW_FILE.equals(this.foperationType)) {
            this.initialize();
            this.dialogChanged();
            this.setControl((Control)container);
            return;
        }
        Label currentTemplateLabel = new Label(container, 0);
        currentTemplateLabel.setText("Template:");
        currentTemplateLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fCurrentTemplateName = new Text(container, 2048);
        if (this.fCurrentSelectedTemplate != null) {
            this.fCurrentTemplateName.setText(this.fCurrentSelectedTemplate.getName());
        }
        this.fCurrentTemplateName.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fCurrentTemplateName.setEditable(true);
        this.fCurrentTemplateName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String templateName = ((Text)event.widget).getText();
                LinkedHashMap<String, Template> templates = new LinkedHashMap<String, Template>();
                Template[] templateArray = NewFileWizardPage.this.fTemplates;
                int n = NewFileWizardPage.this.fTemplates.length;
                int n2 = 0;
                while (n2 < n) {
                    Template template = templateArray[n2];
                    templates.put(template.getName(), template);
                    ++n2;
                }
                NewFileWizardPage.this.fCurrentSelectedTemplate = (Template)templates.get(templateName);
                NewFileWizardPage.this.setCurrentTemplateName(templateName);
                NewFileWizardPage.this.updateEmptyTemplateMessage();
                NewFileWizardPage.this.dialogChanged();
            }
        });
        this.fCurrentTemplateName.setEnabled(!this.fIsCreateFromTemplateDisabled);
        CustomTextContentAdapter contentAdapter = new CustomTextContentAdapter();
        this.fFindProposer = new ViewerContentProposalProvider(null);
        new ContentAssistCommandAdapter((Control)this.fCurrentTemplateName, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)this.fFindProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", this.getAutoactivationChars(), true);
        this.fTemplateSelectorButton = new Button(container, 0);
        this.fTemplateSelectorButton.setLayoutData((Object)layoutData);
        this.fTemplateSelectorButton.setText("Pick...");
        this.fTemplateSelectorButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List list;
                Template template;
                NewFileWizardPage.this.fTemplates = NewFileWizardPage.this.getTemplates();
                LinkedHashMap<String, Template> templates = new LinkedHashMap<String, Template>();
                Template[] templateArray = NewFileWizardPage.this.fTemplates;
                int n = NewFileWizardPage.this.fTemplates.length;
                int n2 = 0;
                while (n2 < n) {
                    Template template2 = templateArray[n2];
                    templates.put(template2.getName(), template2);
                    ++n2;
                }
                String currentFileNature = NewFileWizardPage.this.getCurrentFileNature();
                if (currentFileNature.isEmpty()) {
                    return;
                }
                FileTemplateSelector fts = new FileTemplateSelector(NewFileWizardPage.this.fTemplateContexts, NewFileWizardPage.this.fCurrentSelectedTemplate, NewFileWizardPage.this.fIProject, currentFileNature);
                fts.open();
                if (fts.getFirstResult() != null && (template = (Template)(list = (List)fts.getFirstResult()).get(0)) != null) {
                    NewFileWizardPage.this.fCurrentSelectedTemplate = template;
                    NewFileWizardPage.this.setCurrentTemplateName(template.getName());
                    NewFileWizardPage.this.fCurrentTemplateName.setText(NewFileWizardPage.this.fCurrentSelectedTemplate.getName());
                    NewFileWizardPage.this.updateEmptyTemplateMessage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fTemplateSelectorButton.setEnabled(!this.fIsCreateFromTemplateDisabled);
        new Label(container, 0);
        this.fEmptyTemplateNote = new Label(container, 0);
        this.fEmptyTemplateNote.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.updateEmptyTemplateMessage();
        this.fEmptyTemplateNote.setEnabled(!this.fIsCreateFromTemplateDisabled);
        new Label(container, 0);
        Link codeTemplatesMesage = new Link(container, 0);
        codeTemplatesMesage.setLayoutData((Object)new GridData(4, 1024, true, true, 3, 1));
        codeTemplatesMesage.setText("To add/modify templates go to the <a href=\"globalTemplates\">Code templates preference page</a> for global templates (saved in the workspace directory)\nor to the <a href=\"projectTemplates\">Project templates property page</a> for project templates (saved in the my_project/.dvt directory)");
        DVTUiUtils.setPlatformLinkColor((Link)codeTemplatesMesage);
        codeTemplatesMesage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.text.equals("globalTemplates")) {
                    NewFileWizardPage.this.openGlobalTemplatesPage();
                } else if (e.text.equals("projectTemplates")) {
                    NewFileWizardPage.this.openProjectTemplatesPage();
                }
            }
        });
        codeTemplatesMesage.setEnabled(!this.fIsCreateFromTemplateDisabled);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void updateTemplateProposals() {
        int i = 0;
        String[] templatesProposals = new String[this.fTemplates.length];
        Template[] templateArray = this.fTemplates;
        int n = this.fTemplates.length;
        int n2 = 0;
        while (n2 < n) {
            Template t = templateArray[n2];
            templatesProposals[i++] = t.getName();
            ++n2;
        }
        this.fFindProposer.setProposals(templatesProposals);
    }

    private void updateEmptyTemplateMessage() {
        if (this.fCurrentSelectedTemplate == null) {
            return;
        }
        String description = this.fCurrentSelectedTemplate.getDescription();
        if (description == null) {
            description = "";
        }
        if (this.fCurrentSelectedTemplate.getName().equals(DEFAULT_FILE_TEMPLATE_NAME)) {
            this.fEmptyTemplateNote.setText(DEFAULT_FILE_TEMPLATE_NOTE + description);
        } else {
            this.fEmptyTemplateNote.setText("");
        }
    }

    protected char[] getAutoactivationChars() {
        String lowercaseLetters = "abcdefghijklmnopqrstuvwxyz";
        String uppercaseLetters = lowercaseLetters.toUpperCase();
        String numbers = "0123456789";
        String delete = new String(new char[]{'\b'});
        String allChars = String.valueOf(lowercaseLetters) + uppercaseLetters + numbers + delete;
        return allChars.toCharArray();
    }

    private void initialize() {
        try {
            this.updatePageTitle();
            this.updatePageDescription();
            this.initSerializedTemplates();
            if (this.foperationType != null) {
                this.fFileNameText.setText(this.fFileNamePattern.replaceAll(" ", "_").toLowerCase());
                this.fFileNameText.setSelection(0, this.foperationType.getPattern().length());
            }
            if (this.fSelection != null && !this.fSelection.isEmpty() && this.fSelection instanceof IStructuredSelection) {
                IStructuredSelection ssel = (IStructuredSelection)this.fSelection;
                if (ssel.size() > 1) {
                    return;
                }
                Object obj = ssel.getFirstElement();
                if (obj instanceof IResource) {
                    IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                    if (this.fCustomDirectoryPath != null) {
                        this.fDirectoryText.setText(DVTAutoLinkManager.getInstance().translateAutoLinkedFileFullPath(this.addFileSeparatorForAutoLinkedNetworkPath(this.fCustomDirectoryPath)));
                    } else {
                        this.fDirectoryText.setText(DVTAutoLinkManager.getInstance().translateAutoLinkedFileFullPath(this.addFileSeparatorForAutoLinkedNetworkPath(container.getFullPath())));
                    }
                    this.fIProject = container.getProject();
                }
            } else {
                IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
                if (project != null && project.isAccessible()) {
                    this.fIProject = project;
                }
                if (this.fIProject == null) {
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    if (projects.length == 0) {
                        this.fIProject = null;
                    } else {
                        IProject[] iProjectArray = projects;
                        int n = projects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject iProject = iProjectArray[n2];
                            if (iProject.isAccessible() && (iProject.hasNature("ro.amiq.edt.enature") || iProject.hasNature("ro.amiq.slndt.slnnature") || iProject.hasNature("ro.amiq.vhdldt.VhdlNature") || iProject.hasNature("ro.amiq.vlogdt.VlogNature"))) {
                                this.fIProject = iProject;
                            }
                            ++n2;
                        }
                    }
                }
                if (this.fIProject == null) {
                    return;
                }
                if (this.fCustomDirectoryPath != null) {
                    this.fDirectoryText.setText(DVTAutoLinkManager.getInstance().translateAutoLinkedFileFullPath(this.addFileSeparatorForAutoLinkedNetworkPath(this.fCustomDirectoryPath)));
                } else {
                    IResource res = DVTPlugin.getSelectionManager().getLastSelectedResource();
                    if (res != null) {
                        if (res instanceof IContainer) {
                            this.fDirectoryText.setText(DVTAutoLinkManager.getInstance().translateAutoLinkedFileFullPath(this.addFileSeparatorForAutoLinkedNetworkPath(res.getFullPath())));
                        } else if (res instanceof IFile) {
                            this.fDirectoryText.setText(DVTAutoLinkManager.getInstance().translateAutoLinkedFileFullPath(this.addFileSeparatorForAutoLinkedNetworkPath(res.getParent().getFullPath())));
                        }
                    } else {
                        this.fDirectoryText.setText(DVTAutoLinkManager.getInstance().translateAutoLinkedFileFullPath(this.addFileSeparatorForAutoLinkedNetworkPath(this.fIProject.getFullPath())));
                    }
                }
            }
            if (this.foperationType != null && (QuickFixOrAssistType.EXTRACT_TO_MODULE_TYPE.equals(this.foperationType) || QuickFixOrAssistType.MOVE_SELECTION_TO_NEW_FILE_TYPE.equals(this.foperationType) || AIOperationType.COPY_CODE_TO_NEW_FILE.equals(this.foperationType))) {
                return;
            }
            this.fTemplates = this.getTemplates();
            this.updateTemplateProposals();
            String lastTemplateName = this.getCurrentTemplateName();
            int i = 0;
            while (i < this.fTemplates.length) {
                if (this.fTemplates[i].getName().equals(lastTemplateName)) {
                    this.fCurrentSelectedTemplate = this.fTemplates[i];
                    break;
                }
                if (this.fTemplates[i].getName().equalsIgnoreCase(DEFAULT_FILE_TEMPLATE_NAME)) {
                    this.fCurrentSelectedTemplate = this.fTemplates[i];
                }
                ++i;
            }
            if (this.fCurrentSelectedTemplate != null) {
                if (lastTemplateName != null && !lastTemplateName.equals(this.fCurrentSelectedTemplate.getName())) {
                    this.setCurrentTemplateName(this.fCurrentSelectedTemplate.getName());
                }
                this.fCurrentTemplateName.setText(this.fCurrentSelectedTemplate.getName());
            }
            this.updateEmptyTemplateMessage();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String addFileSeparatorForAutoLinkedNetworkPath(IPath path) {
        if (path == null || path.toOSString() == null) {
            return "";
        }
        String directoryPath = path.toOSString();
        String autolinkFolderName = "DVT Auto-Linked";
        if (DVTAutoLinkManager.getInstance().isWindows() && directoryPath.contains(autolinkFolderName) && directoryPath.indexOf(58) == -1 && directoryPath.indexOf(5011) == -1) {
            directoryPath = String.valueOf(directoryPath.substring(0, directoryPath.indexOf(autolinkFolderName) + autolinkFolderName.length())) + DVTFileUtils.FILE_SEPARATOR + directoryPath.substring(directoryPath.indexOf(autolinkFolderName) + autolinkFolderName.length());
        }
        return directoryPath;
    }

    public String removeFileSeparatorForAutoLinkedNetworkPath(String path) {
        if (DVTAutoLinkManager.getInstance().isWindows() && path.contains("DVT Auto-Linked") && path.contains(String.valueOf(DVTFileUtils.FILE_SEPARATOR) + DVTFileUtils.FILE_SEPARATOR) && path.indexOf(58) == -1 && path.indexOf(5011) == -1) {
            return path.replace(String.valueOf(DVTFileUtils.FILE_SEPARATOR) + DVTFileUtils.FILE_SEPARATOR, DVTFileUtils.FILE_SEPARATOR);
        }
        return path;
    }

    private void handleBrowse() {
        Object[] result;
        IWorkspaceRoot container = ResourcesPlugin.getWorkspace().getRoot();
        String directoryName = this.getDirectoryName();
        if (this.fIProject != null && !directoryName.isEmpty()) {
            try {
                IFile eFile = this.fIProject.getFile(new Path(String.valueOf(directoryName) + File.separator + this.getFileNameWithExtension()).removeFirstSegments(1));
                IContainer tmp = eFile.getParent();
                if (tmp != null && tmp.isAccessible()) {
                    container = tmp;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                container = this.fIProject;
            }
        }
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)container, false, "Select parent directory for the new file");
        dialog.setValidator(DVTFileUtils.getInstance().makeContainerSelectionValidator());
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.fDirectoryText.setText(DVTAutoLinkManager.getInstance().translateAutoLinkedFileFullPath(this.addFileSeparatorForAutoLinkedNetworkPath((IPath)((Path)result[0]))));
        }
    }

    private void dialogChanged() {
        try {
            String fileName;
            this.setMessage(null);
            this.setErrorMessage(null);
            IProject newProject = this.getProjectFromDirectoryLocation();
            if (newProject == null || !newProject.isAccessible()) {
                this.updateStatus("Directory path is not valid! The path must be relative to a project from the current workspace.");
                return;
            }
            if (newProject.isAccessible() && !newProject.getName().equals(this.fIProject.getName())) {
                this.fIProject = newProject;
                this.initCurrentFileExtension();
                this.updatePageTitle();
                if (!(QuickFixOrAssistType.EXTRACT_TO_MODULE_TYPE.equals(this.foperationType) || QuickFixOrAssistType.MOVE_SELECTION_TO_NEW_FILE_TYPE.equals(this.foperationType) || AIOperationType.COPY_CODE_TO_NEW_FILE.equals(this.foperationType))) {
                    this.updateSelectedTemplate();
                }
            }
            if ((fileName = this.getFileName()).length() == 0) {
                this.updateStatus("File name must be specified.");
                this.disableTemplateSelectorButton();
                return;
            }
            if (fileName.indexOf(32) != -1 || fileName.replace('\\', '/').indexOf(47) != -1) {
                this.updateStatus("Invalid file name.");
                this.disableTemplateSelectorButton();
                return;
            }
            if (this.fCurrentFileExtension.isEmpty() || this.getFileExtension().isEmpty()) {
                this.fExtensionCombo.setEnabled(false);
            } else {
                this.fExtensionCombo.setEnabled(!fileName.contains("."));
            }
            if (this.fTemplateSelectorButton != null) {
                this.fTemplateSelectorButton.setEnabled(!this.fIsCreateFromTemplateDisabled && !this.getCurrentFileNature().isEmpty());
            }
            if (this.getDirectoryName().length() == 0) {
                this.updateStatus("Directory must be specified.");
                this.disableTemplateSelectorButton();
                return;
            }
            String eFileName = this.getFileNameWithExtension();
            String eDir = this.getDirectoryName();
            Path path = new Path(String.valueOf(eDir) + File.separator + eFileName);
            if (path.segmentCount() < 2) {
                this.updateStatus("Invalid file name.");
                this.disableTemplateSelectorButton();
                return;
            }
            IFile eFile = this.fIProject.getFile(path.removeFirstSegments(1));
            IContainer eFileParent = eFile.getParent();
            if (eFile.exists()) {
                this.updateStatus("File already exists.");
                this.disableTemplateSelectorButton();
                return;
            }
            if (eFileParent != null && eFileParent.getResourceAttributes() != null && eFileParent.getResourceAttributes().isReadOnly()) {
                this.updateStatus("Directory path does not have write permission.");
                this.disableTemplateSelectorButton();
                return;
            }
            if (eFileParent != null && !eFile.getParent().isAccessible()) {
                this.updateStatus("Directory path does not exist.");
                this.disableTemplateSelectorButton();
                return;
            }
            if (eFile.isVirtual() || eFile.getParent().isVirtual()) {
                File file;
                int indexAutoLinked = eDir.indexOf("DVT Auto-Linked");
                if (indexAutoLinked == -1) {
                    this.updateStatus("Directory path is virtual.");
                    this.disableTemplateSelectorButton();
                    return;
                }
                eDir = eDir.substring(indexAutoLinked + "DVT Auto-Linked".length());
                eDir = DVTAutoLinkManager.getInstance().translateAutoLinkedFileFullPath(eDir);
                IPath filePath = Path.fromOSString((String)(String.valueOf(eDir) + '/' + eFileName));
                String aliasCandidate = filePath.segment(0);
                Map<String, AutoLinkRoot> autoLinkedRoots = BuildConfigManager.getAutoLinkedRoots(eFile.getProject());
                if (autoLinkedRoots.containsKey(aliasCandidate)) {
                    filePath = autoLinkedRoots.get(aliasCandidate).getExpandedPath().append(filePath.removeFirstSegments(1));
                }
                if ((file = filePath.toFile()).exists()) {
                    this.updateStatus("File already exists.");
                    this.disableTemplateSelectorButton();
                    return;
                }
                if (!file.getParentFile().exists()) {
                    this.updateStatus("Directory path does not exist.");
                    this.disableTemplateSelectorButton();
                    return;
                }
                if (file.getParentFile() != null && file.getParentFile().exists() && !file.getParentFile().canWrite()) {
                    this.updateStatus("Directory path does not have write permission.");
                    this.disableTemplateSelectorButton();
                    return;
                }
            } else if (!(this.fTemplates == null || this.fTemplates.length <= 0 || Arrays.asList(this.fTemplates).contains(this.fCurrentSelectedTemplate) || QuickFixOrAssistType.EXTRACT_TO_MODULE_TYPE.equals(this.foperationType) || QuickFixOrAssistType.MOVE_SELECTION_TO_NEW_FILE_TYPE.equals(this.foperationType) || AIOperationType.COPY_CODE_TO_NEW_FILE.equals(this.foperationType))) {
                this.updateStatus("Template does not exist.");
                return;
            }
            this.updateStatus(null);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void disableTemplateSelectorButton() {
        if (this.fTemplateSelectorButton != null) {
            this.fTemplateSelectorButton.setEnabled(false);
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getDirectoryName() {
        return DVTAutoLinkManager.getInstance().inverseTranslateAutoLinkedFileFullPath(this.fDirectoryText.getText());
    }

    public String getFileName() {
        return this.fFileNameText.getText();
    }

    public String getFileExtension() {
        if (this.fFileNameText != null && this.fFileNameText.getText().contains(".")) {
            String[] parts = this.fFileNameText.getText().split("\\.");
            if (parts.length < 2) {
                return "";
            }
            String fileExt = "." + parts[parts.length - 1];
            return fileExt;
        }
        return this.fExtensionCombo.getText();
    }

    public String getFileNameWithExtension() {
        if (this.fCustomExtension.get()) {
            return this.getFileName();
        }
        return String.valueOf(this.getFileName()) + this.getFileExtension();
    }

    public List<String> getFileExtensions(String type) {
        String[] exts = DVTFileUtils.getInstance().getExtensionsForContentType(type, true);
        ArrayList<String> result = new ArrayList<String>();
        if (exts == null) {
            return result;
        }
        String[] stringArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            result.add(ext.replace("*", ""));
            ++n2;
        }
        return result;
    }

    public List<String> getAllFileExtensions() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> natures = this.getCurrentProjectNatures();
        for (String nature : natures) {
            if (nature.equals("ro.amiq.vlogdt.VlogNature")) {
                result.addAll(this.getFileExtensions("ro.amiq.vlogdt.VlogSource"));
                result.addAll(this.getFileExtensions("ro.amiq.vlogdt.VlogAmsSource"));
                continue;
            }
            if (nature.equals("ro.amiq.edt.enature")) {
                result.addAll(this.getFileExtensions("ro.amiq.edt.ESource"));
                continue;
            }
            if (nature.equals("ro.amiq.slndt.slnnature")) {
                result.addAll(this.getFileExtensions("ro.amiq.slndt.SLNSource"));
                continue;
            }
            if (nature.equals("ro.amiq.vhdldt.VhdlNature")) {
                result.addAll(this.getFileExtensions("ro.amiq.vhdldt.VhdlSource"));
                continue;
            }
            if (nature.equals("ro.amiq.msdldt.msdlnature")) {
                result.addAll(this.getFileExtensions("ro.amiq.msdldt.MSDLSource"));
                continue;
            }
            if (!nature.equals("ro.amiq.pssdt.pssnature")) continue;
            result.addAll(this.getFileExtensions("ro.amiq.pssdt.PSSSource"));
        }
        Collections.sort(result);
        String selectedFileExtenstion = this.getSelectedFileExtenstion();
        if (!selectedFileExtenstion.isEmpty()) {
            if (result.contains(selectedFileExtenstion)) {
                result.remove(result.indexOf(selectedFileExtenstion));
            }
            result.add(0, selectedFileExtenstion);
        }
        return result;
    }

    public IPath getFileFullPath() {
        IPath folderPath;
        String str = this.fFileNameText.getText();
        Path path = null;
        if (str.length() > 0 && !(path = new Path(str)).isAbsolute() && (folderPath = this.getDirectoryFullPath()) != null) {
            path = folderPath.append((IPath)path);
        }
        return path;
    }

    public IPath getDirectoryFullPath() {
        String text = DVTAutoLinkManager.getInstance().inverseTranslateAutoLinkedFileFullPath(this.fDirectoryText.getText());
        if (text.length() > 0) {
            return new Path(text).makeAbsolute();
        }
        return null;
    }

    public IProject getProjectFromDirectoryLocation() {
        IPath dirPath = this.getDirectoryFullPath();
        if (dirPath == null || dirPath.segmentCount() < 1) {
            return null;
        }
        String pName = dirPath.segment(0);
        if (pName == null || pName.isEmpty()) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(pName);
    }

    public Template getSelectedTemplate() {
        return this.fCurrentSelectedTemplate;
    }

    private void updatePageTitle() {
        if (this.foperationType != null) {
            this.setTitle(this.foperationType.getSubtitle());
            return;
        }
        String nature = this.getCurrentFileNature();
        if (nature.isEmpty()) {
            this.setTitle("New File");
        } else {
            this.setTitle(fTitles.get(nature));
        }
    }

    private void updatePageDescription() {
        if (this.foperationType != null) {
            this.setDescription(this.foperationType.getDescription());
        }
    }

    private Template[] getTemplates() {
        if (this.fIProject == null) {
            return new Template[0];
        }
        String currentFileNature = this.getCurrentFileNature();
        if (currentFileNature.isEmpty()) {
            return new Template[0];
        }
        List<Template> fileContextTemplates = TemplatesViewUtils.getGlobalTemplates(currentFileNature);
        List<Template> projectTemplates = TemplatesViewUtils.getProjectTemplates(this.fIProject, currentFileNature);
        ArrayList<Template> allTemplates = new ArrayList<Template>();
        int numberOfTemplates = 0;
        for (Template template : fileContextTemplates) {
            if (!this.fTemplateContexts.contains(template.getContextTypeId())) continue;
            allTemplates.add(template);
            ++numberOfTemplates;
        }
        for (Template template : projectTemplates) {
            if (!this.fTemplateContexts.contains(template.getContextTypeId())) continue;
            allTemplates.add(template);
            ++numberOfTemplates;
        }
        return allTemplates.toArray(new Template[numberOfTemplates]);
    }

    private void updateSelectedTemplate() {
        Template[] templates = this.getTemplates();
        if (templates.length == 0) {
            return;
        }
        String tname = this.getCurrentTemplateName();
        if (tname.isEmpty()) {
            tname = DEFAULT_FILE_TEMPLATE_NAME;
        }
        Template emptyFileTemplate = null;
        boolean found = false;
        Template[] templateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            if (template.getName().equals(tname)) {
                this.fCurrentSelectedTemplate = template;
                found = true;
                break;
            }
            if (template.getName().equals(DEFAULT_FILE_TEMPLATE_NAME)) {
                emptyFileTemplate = template;
            }
            ++n2;
        }
        if (!found) {
            this.fCurrentSelectedTemplate = emptyFileTemplate;
        }
        if (this.fCurrentSelectedTemplate != null && !tname.equals(this.fCurrentSelectedTemplate.getName())) {
            this.setCurrentTemplateName(this.fCurrentSelectedTemplate.getName());
        }
        this.updateEmptyTemplateMessage();
        if (this.fCurrentSelectedTemplate != null) {
            this.fCurrentTemplateName.setText(this.fCurrentSelectedTemplate.getName());
        }
    }

    private void initCurrentFileExtension() {
        String lastNature;
        List<String> currentProjectNatures;
        if (this.fIProject == null) {
            this.fIProject = DVTPlugin.getSelectionManager().getLastSelectedProject();
        }
        if ((currentProjectNatures = this.getCurrentProjectNatures()).isEmpty()) {
            this.fCurrentFileExtension = "";
            return;
        }
        if (!QuickFixOrAssistType.EXTRACT_TO_MODULE_TYPE.equals(this.foperationType) && !QuickFixOrAssistType.MOVE_SELECTION_TO_NEW_FILE_TYPE.equals(this.foperationType) && fLastSelectionExtension != null && !fLastSelectionExtension.isEmpty() && currentProjectNatures.contains(lastNature = this.getExtensionNature(fLastSelectionExtension))) {
            this.fCurrentFileExtension = fLastSelectionExtension;
            return;
        }
        String selectedFileExtension = this.getSelectedFileExtenstion();
        this.fCurrentFileExtension = !selectedFileExtension.isEmpty() ? selectedFileExtension : (currentProjectNatures.contains("ro.amiq.edt.enature") && Platform.getBundle((String)"ro.amiq.edt") != null ? E_DEFAULT_EXTENSION : (currentProjectNatures.contains("ro.amiq.vhdldt.VhdlNature") && Platform.getBundle((String)"ro.amiq.vhdldt") != null ? VHDL_DEFAULT_EXTENSION : (currentProjectNatures.contains("ro.amiq.slndt.slnnature") && Platform.getBundle((String)"ro.amiq.slndt") != null ? SLN_DEFAULT_EXTENSION : (currentProjectNatures.contains("ro.amiq.msdldt.msdlnature") && Platform.getBundle((String)"ro.amiq.msdldt") != null ? MSDL_DEFAULT_EXTENSION : (currentProjectNatures.contains("ro.amiq.vlogdt.VlogNature") && Platform.getBundle((String)"ro.amiq.vlogdt") != null ? VLOG_DEFAULT_EXTENSION : "")))));
    }

    private String getSelectedFileExtenstion() {
        if (this.fSelection == null || this.fSelection.isEmpty() || !(this.fSelection instanceof IStructuredSelection)) {
            return "";
        }
        IStructuredSelection ssel = (IStructuredSelection)this.fSelection;
        if (ssel.size() > 1) {
            return "";
        }
        Object obj = ssel.getFirstElement();
        if (!(obj instanceof IFile) || !((IFile)obj).getName().contains(".")) {
            return "";
        }
        String[] parts = ((IFile)obj).getName().split("\\.");
        if (parts.length < 2) {
            return "";
        }
        return "." + parts[parts.length - 1];
    }

    public String getExtensionNature(String extension) {
        if (this.VLOG_EXTENSIONS.contains(extension) && DVTNature.hasNature(this.fIProject, "ro.amiq.vlogdt.VlogNature")) {
            return "ro.amiq.vlogdt.VlogNature";
        }
        if (this.E_EXTENSIONS.contains(extension) && DVTNature.hasNature(this.fIProject, "ro.amiq.edt.enature")) {
            return "ro.amiq.edt.enature";
        }
        if (this.SLN_EXTENSIONS.contains(extension) && DVTNature.hasNature(this.fIProject, "ro.amiq.slndt.slnnature")) {
            return "ro.amiq.slndt.slnnature";
        }
        if (this.MSDL_EXTENSIONS.contains(extension) && DVTNature.hasNature(this.fIProject, "ro.amiq.msdldt.msdlnature")) {
            return "ro.amiq.msdldt.msdlnature";
        }
        if (this.PSS_EXTENSIONS.contains(extension) && DVTNature.hasNature(this.fIProject, "ro.amiq.pssdt.pssnature")) {
            return "ro.amiq.pssdt.pssnature";
        }
        if (this.VHDL_EXTENSIONS.contains(extension) && DVTNature.hasNature(this.fIProject, "ro.amiq.vhdldt.VhdlNature")) {
            return "ro.amiq.vhdldt.VhdlNature";
        }
        return "";
    }

    public String getCurrentFileNature() {
        return this.getExtensionNature(this.getFileExtension());
    }

    public String getCurrentFileTemplateContext() {
        String nature = this.getCurrentFileNature();
        if (nature.equals("ro.amiq.vlogdt.VlogNature")) {
            return "ro.amiq.vlogdt.templates.contextType.file_content";
        }
        if (nature.equals("ro.amiq.edt.enature")) {
            return "ro.amiq.edt.templates.contextType.file_content";
        }
        if (nature.equals("ro.amiq.slndt.slnnature")) {
            return "ro.amiq.edt.templates.contextType.file_content";
        }
        if (nature.equals("ro.amiq.pssdt.pssnature")) {
            return "ro.amiq.pssdt.templates.contextType.file_content";
        }
        if (nature.equals("ro.amiq.msdldt.msdlnature")) {
            return "ro.amiq.msdldt.templates.contextType.file_content";
        }
        if (nature.equals("ro.amiq.vhdldt.VhdlNature")) {
            return "ro.amiq.vhdldt.templates.contextType.file_content";
        }
        return "";
    }

    private List<String> getCurrentProjectNatures() {
        ArrayList<String> natures = new ArrayList<String>();
        try {
            if (this.fIProject == null) {
                return natures;
            }
            if (this.fIProject.hasNature("ro.amiq.vlogdt.VlogNature")) {
                natures.add("ro.amiq.vlogdt.VlogNature");
            }
            if (this.fIProject.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                natures.add("ro.amiq.vhdldt.VhdlNature");
            }
            if (this.fIProject.hasNature("ro.amiq.slndt.slnnature")) {
                natures.add("ro.amiq.slndt.slnnature");
            }
            if (this.fIProject.hasNature("ro.amiq.msdldt.msdlnature")) {
                natures.add("ro.amiq.msdldt.msdlnature");
            }
            if (this.fIProject.hasNature("ro.amiq.pssdt.pssnature")) {
                natures.add("ro.amiq.pssdt.pssnature");
            }
            if (this.fIProject.hasNature("ro.amiq.edt.enature")) {
                natures.add("ro.amiq.edt.enature");
            }
            return natures;
        }
        catch (Exception exception) {
            return natures;
        }
    }

    public void openGlobalTemplatesPage() {
        PreferenceDialog pref = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"ro.amiq.dvt.ui.codetemplates.TemplatesPreferencePage", null, null);
        if (pref != null) {
            pref.open();
        }
    }

    public void openProjectTemplatesPage() {
        if (this.fIProject == null) {
            return;
        }
        PreferenceDialog prop = PreferencesUtil.createPropertyDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IAdaptable)this.fIProject, (String)"ro.amiq.dvt.ui.codetemplates.CodeTemplatesPropertyPage", null, null);
        if (prop != null) {
            prop.open();
        }
    }

    public void initSerializedTemplates() {
        String lastTemplateName = PrefConst.getLastNewFileTemplate();
        try {
            String[] templates = lastTemplateName.split(TEMPLATE_SEPARATOR);
            if (templates.length == 3) {
                int i = 0;
                while (i < templates.length) {
                    String[] tmp = templates[i].split(NATURE_SEPARATOR);
                    if (tmp.length != 2) break;
                    this.fSerializedTemplates.put(tmp[0], tmp[1]);
                    ++i;
                }
                return;
            }
            this.setDefaultTemplateNames();
        }
        catch (Exception exception) {
            this.setDefaultTemplateNames();
        }
    }

    private void setDefaultTemplateNames() {
        this.fSerializedTemplates.put("ro.amiq.vlogdt.VlogNature", DEFAULT_FILE_TEMPLATE_NAME);
        this.fSerializedTemplates.put("ro.amiq.edt.enature", DEFAULT_FILE_TEMPLATE_NAME);
        this.fSerializedTemplates.put("ro.amiq.slndt.slnnature", DEFAULT_FILE_TEMPLATE_NAME);
        this.fSerializedTemplates.put("ro.amiq.msdldt.msdlnature", DEFAULT_FILE_TEMPLATE_NAME);
        this.fSerializedTemplates.put("ro.amiq.pssdt.pssnature", DEFAULT_FILE_TEMPLATE_NAME);
        this.fSerializedTemplates.put("ro.amiq.vhdldt.VhdlNature", DEFAULT_FILE_TEMPLATE_NAME);
    }

    public void serializeTemplates() {
        StringBuilder sb = new StringBuilder();
        sb.append("ro.amiq.vlogdt.VlogNature").append(NATURE_SEPARATOR).append(this.fSerializedTemplates.get("ro.amiq.vlogdt.VlogNature")).append(TEMPLATE_SEPARATOR);
        sb.append("ro.amiq.edt.enature").append(NATURE_SEPARATOR).append(this.fSerializedTemplates.get("ro.amiq.edt.enature")).append(TEMPLATE_SEPARATOR);
        sb.append("ro.amiq.slndt.slnnature").append(NATURE_SEPARATOR).append(this.fSerializedTemplates.get("ro.amiq.slndt.slnnature")).append(TEMPLATE_SEPARATOR);
        sb.append("ro.amiq.msdldt.msdlnature").append(NATURE_SEPARATOR).append(this.fSerializedTemplates.get("ro.amiq.msdldt.msdlnature")).append(TEMPLATE_SEPARATOR);
        sb.append("ro.amiq.pssdt.pssnature").append(NATURE_SEPARATOR).append(this.fSerializedTemplates.get("ro.amiq.pssdt.pssnature")).append(TEMPLATE_SEPARATOR);
        sb.append("ro.amiq.vhdldt.VhdlNature").append(NATURE_SEPARATOR).append(this.fSerializedTemplates.get("ro.amiq.vhdldt.VhdlNature"));
        PrefConst.setLastNewFileTemplate(sb.toString());
    }

    private String getCurrentTemplateName() {
        String curentNature = this.getCurrentFileNature();
        if (curentNature.isEmpty()) {
            return DEFAULT_FILE_TEMPLATE_NAME;
        }
        String result = this.fSerializedTemplates.get(curentNature);
        if (result == null) {
            return DEFAULT_FILE_TEMPLATE_NAME;
        }
        return result;
    }

    private void setCurrentTemplateName(String name) {
        String curentNature = this.getCurrentFileNature();
        if (curentNature.isEmpty()) {
            return;
        }
        this.fSerializedTemplates.put(curentNature, name);
    }

    protected void setDisableTemplate(boolean isDisable) {
        this.fIsCreateFromTemplateDisabled = isDisable;
    }

    protected void setDirectory(IPath path) {
        this.fCustomDirectoryPath = path;
    }

    protected void setOperationType(IOperationType assistType) {
        this.foperationType = assistType;
    }

    protected void setFileNamePattern(String fileNamePattern) {
        this.fFileNamePattern = fileNamePattern;
    }
}

