/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.newfile;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.resourcefilters.ApplyFilterOnNewResourceJob;
import ro.amiq.dvt.startup.core.DVTLogger;

public class NewResourceListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        IResource[] newResource = new IResource[1];
        AtomicBoolean moreThanOneResourceCreated = new AtomicBoolean(false);
        try {
            IResourceDelta delta = event.getDelta();
            delta.accept(resourceDelta -> {
                if (moreThanOneResourceCreated.get()) {
                    return false;
                }
                if (resourceDelta.getKind() != 1) {
                    return true;
                }
                IResource resource = resourceDelta.getResource();
                if (resource == null) {
                    return false;
                }
                if (resource.getType() == 1 || resource.getType() == 2) {
                    if (newResource[0] != null) {
                        moreThanOneResourceCreated.set(true);
                        return false;
                    }
                    iResourceArray[0] = resource;
                }
                return true;
            });
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (moreThanOneResourceCreated.get() || newResource[0] == null) {
            return;
        }
        ApplyFilterOnNewResourceJob.runJob(newResource[0], false);
    }
}

