/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.newproject;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.AlteraAutoconfigUtils;
import ro.amiq.dvt.buildconfig.AutoconfigCompilationRootInfo;
import ro.amiq.dvt.buildconfig.XilinxAutoconfigUtils;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.nature.INatureContributor;
import ro.amiq.dvt.nature.NatureContributors;
import ro.amiq.dvt.resourcefilters.NewProjectResourceFiltersWrapper;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.wizards.newproject.NewProjectModel;
import ro.amiq.dvt.wizards.newproject.NewProjectWizard;

public class NewProjectFirstPage
extends WizardPage {
    private static final String DIR_HELP = "If the directory doesn't exist, it will be created.\n\nDVT doesn't copy any files or directories.\nA project corresponds to a directory on the disk and it shows its content as is.\nAny directory content changes done in DVT are visible outside.\nAny directory content changes done outside are visible in DVT upon refresh.\nRefresh must be explicitly triggered, unless Eclipse is configured to do it automatically.";
    private NewProjectWizard fWizard;
    private NewProjectModel fModel;
    private IProjectDescription fDescription;
    private String fDirectoryString = "";
    private String fProjectName = "";
    private Label fDirectoryLabel;
    private Text fDirectoryText;
    private Button fDirectoryButton;
    private Label fProjectNameLabel;
    private Text fProjectNameText;
    private Button fProjectNameEdit;
    private Group fNaturesGroup;
    private CheckboxTableViewer fNaturesViewer;
    private LocationGroup fLocationGroup;
    private Set<String> fSelectedNatures = new HashSet<String>();
    private AutoconfigCompilationRootInfo directoryInfo;
    private String xilinxProjectMessage;
    private String quartusProjectMessage;
    private static final LabelProvider NATURES_LABEL_PROVIDER = new LabelProvider(){

        public String getText(Object element) {
            if (element != null && element instanceof INatureContributor) {
                return ((INatureContributor)element).getName();
            }
            return super.getText(element);
        }
    };

    protected NewProjectFirstPage() {
        super("NewProjectFirstPage");
        this.setTitle("Project Location");
        this.setDescription("Specify project location");
        this.setImageDescriptor(DVTImages.NEW_PROJECT_WIZ);
    }

    public void setPageComplete(boolean complete) {
        this.saveDataToModel();
        super.setPageComplete(complete);
        this.fWizard.canFinish();
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        this.fWizard = (NewProjectWizard)this.getWizard();
        this.fModel = this.fWizard.fModel;
    }

    private void setNaturesGroupVisible(boolean visible) {
        ro.amiq.dvt.ui.Utils.setEnabledRecursive((Composite)this.fNaturesGroup, visible);
    }

    protected void saveDataToModel() {
        IPath projectPath = this.getLocationPath();
        this.fModel.setLocation(projectPath);
        this.fModel.setName(this.fProjectName);
        this.fModel.setProjectDescription(this.fDescription);
        if (this.fDescription != null && DVTNature.hasAnyDVTNature(this.fDescription)) {
            this.fModel.setNatures(this.fDescription.getNatureIds());
        } else {
            this.fModel.setNatures(this.fSelectedNatures.toArray(new String[this.fSelectedNatures.size()]));
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.initializeDialogUnits((Control)parent);
        this.fLocationGroup = new LocationGroup(composite);
        this.fLocationGroup.setLayoutData(new GridData(4, 128, true, false));
        this.fNaturesGroup = new Group(composite, 0);
        this.fNaturesGroup.setText("Select one or more project language natures");
        this.fNaturesGroup.setLayout((Layout)new GridLayout());
        this.fNaturesGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fNaturesViewer = CheckboxTableViewer.newCheckList((Composite)this.fNaturesGroup, (int)2048);
        this.fNaturesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fNaturesViewer.setLabelProvider((IBaseLabelProvider)NATURES_LABEL_PROVIDER);
        this.fNaturesViewer.setInput(NatureContributors.getContributors());
        this.fNaturesViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fNaturesViewer.addCheckStateListener(event -> {
            Object element = event.getElement();
            if (!(element instanceof INatureContributor)) {
                return;
            }
            INatureContributor natureContributor = (INatureContributor)element;
            if (event.getChecked()) {
                this.fSelectedNatures.add(natureContributor.getLanguageKind().NATURE_ID);
            } else {
                this.fSelectedNatures.remove(natureContributor.getLanguageKind().NATURE_ID);
            }
            if (this.fSelectedNatures.contains("ro.amiq.dvt.cdt.cppextnature") && !this.fSelectedNatures.contains("ro.amiq.dvt.cdt.cppnature")) {
                this.fNaturesViewer.setChecked((Object)NatureContributors.getContributor(LanguageKind.CPP), true);
                this.fSelectedNatures.add("ro.amiq.dvt.cdt.cppnature");
            }
            this.updatePageComplete();
        });
        Label fNaturesInfo = new Label((Composite)this.fNaturesGroup, 0);
        fNaturesInfo.setLayoutData((Object)new GridData(4, 1024, true, false));
        fNaturesInfo.setText("Source files are compiled only if the project has the corresponding language enabled.\nA specific license will be checked-out for each of the selected languages.");
        this.setNaturesGroupVisible(false);
        Link exampleProjLink = new Link(composite, 0);
        exampleProjLink.setText("You can also choose from <a>Predefined Projects</a>.");
        DVTUiUtils.setPlatformLinkColor((Link)exampleProjLink);
        exampleProjLink.setLayoutData((Object)new GridData(4, 1024, true, false));
        exampleProjLink.addListener(13, event -> {
            String fRemoteWizardID = "ro.amiq.dvt.wizards.PredefinedProjectsWizard";
            IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(fRemoteWizardID);
            try {
                if (descriptor != null) {
                    IWorkbenchWizard wizard = descriptor.createWizard();
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    if (shell != null) {
                        WizardDialog wd = new WizardDialog(shell, (IWizard)wizard);
                        wd.setTitle(wizard.getWindowTitle());
                        int answer = wd.open();
                        if (answer == 0) {
                            this.fWizard.getShell().close();
                        }
                    }
                }
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
        Dialog.applyDialogFont((Control)parent);
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    private IPath getLocationPath() {
        return Path.fromOSString((String)ResourceFilterUtils.expandDvtEnvVars(ResourceFilterUtils.toDvtEnvVars(this.fDirectoryString.trim())));
    }

    private void updatePageComplete() {
        this.setMessage(null);
        this.setErrorMessage(null);
        this.fProjectNameEdit.setEnabled(true);
        this.fProjectNameText.setEnabled(this.fProjectNameEdit.isEnabled() && this.fProjectNameEdit.getSelection());
        IPath projectPath = this.getLocationPath();
        String location = projectPath.toOSString();
        File directory = new File(location);
        String name = this.fProjectName;
        this.fDescription = null;
        this.setNaturesGroupVisible(false);
        try {
            boolean caseSensitive;
            if (location.length() == 0) {
                this.setMessage("Enter a location for the project.", 3);
                this.setPageComplete(false);
                return;
            }
            if (ResourcesPlugin.getWorkspace().validateName(location, 2).equals(Status.OK_STATUS)) {
                this.setMessage("Invalid location.", 3);
                this.setPageComplete(false);
                return;
            }
            if (!directory.exists()) {
                File parent = directory.getParentFile();
                while (parent != null && !parent.exists()) {
                    parent = parent.getParentFile();
                }
                if (parent != null && !parent.canWrite()) {
                    this.setMessage("Location is marked as read-only!", 3);
                    this.setPageComplete(false);
                    return;
                }
            } else {
                if (!directory.canWrite()) {
                    this.setMessage("Location is marked as read-only!", 3);
                    this.setPageComplete(false);
                    return;
                }
                if (!directory.isDirectory()) {
                    this.setMessage("Location is a file (expecting a directory)!", 3);
                    this.setPageComplete(false);
                    return;
                }
            }
            if (!directory.exists()) {
                if (this.fProjectNameText.isEnabled() && name.length() == 0) {
                    this.setMessage("Enter a name for the project.", 3);
                    this.setPageComplete(false);
                    return;
                }
                this.setNaturesGroupVisible(true);
                if (!this.validateSelectedNatures()) {
                    this.setPageComplete(false);
                    return;
                }
                this.setMessage("Existing source directory not found, it will be created!", 2);
            }
            File dotProjectFile = null;
            if (directory.isDirectory()) {
                dotProjectFile = Utils.getProjectFileFromDirectory(directory);
            }
            if (dotProjectFile != null) {
                this.fDescription = Utils.getProjectDescription(dotProjectFile);
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath workspacePath = workspace.getRoot().getLocation();
            if (Path.fromOSString((String)this.fDirectoryString).equals((Object)workspacePath)) {
                this.setMessage("Project path overlaps eclipse workspace location!", 3);
                this.setPageComplete(false);
                return;
            }
            if (Path.fromOSString((String)this.fDirectoryString).isPrefixOf(workspacePath)) {
                this.setMessage("Project path is a parent of eclipse workspace location!", 3);
                this.setPageComplete(false);
                return;
            }
            if (workspacePath.isPrefixOf(Path.fromOSString((String)this.fDirectoryString))) {
                this.setMessage("Project path is inside the eclipse workspace location!", 3);
                this.setPageComplete(false);
                return;
            }
            boolean bl = "macosx".equals(Platform.getOS()) ? false : (caseSensitive = new File("a").compareTo(new File("A")) != 0);
            if (caseSensitive) {
                projectPath = new Path(projectPath.toOSString().toLowerCase());
            }
            if (this.fDescription != null) {
                IProject project = workspace.getRoot().getProject(this.fDescription.getName());
                IStatus nameStatus = workspace.validateName(project.getName(), 4);
                if (!nameStatus.isOK()) {
                    this.setErrorMessage(nameStatus.getMessage());
                    this.setPageComplete(false);
                    return;
                }
                IStatus locationStatus = workspace.validateProjectLocation(project, projectPath);
                if (!locationStatus.isOK()) {
                    this.setErrorMessage(locationStatus.getMessage());
                    this.setPageComplete(false);
                    return;
                }
                if (project.exists()) {
                    this.setErrorMessage("There is another project with the same name in the current workspace! Please try to rename or remove the existing project before importing this one.");
                    this.fProjectNameText.setEnabled(false);
                    this.fProjectNameEdit.setSelection(false);
                    this.fProjectNameEdit.setEnabled(false);
                    this.fProjectName = this.fDescription.getName();
                    this.fProjectNameText.setText(this.fProjectName);
                    this.setPageComplete(false);
                    return;
                }
                this.setMessage("Existing project '" + this.fDescription.getName() + "' will be imported!", 1);
                this.fProjectNameText.setEnabled(false);
                this.fProjectNameEdit.setSelection(false);
                this.fProjectNameEdit.setEnabled(false);
                this.fProjectName = this.fDescription.getName();
                this.fProjectNameText.setText(this.fProjectName);
                this.fNaturesViewer.setAllChecked(false);
                if (!this.fSelectedNatures.isEmpty()) {
                    for (String nature2 : this.fSelectedNatures) {
                        INatureContributor contributor = NatureContributors.getContributor(LanguageKind.from(nature2));
                        if (contributor == null) continue;
                        this.fNaturesViewer.setChecked((Object)contributor, true);
                    }
                }
                Arrays.asList(this.fDescription.getNatureIds()).stream().forEach(nature -> {
                    INatureContributor contributor = NatureContributors.getContributor(LanguageKind.from(nature));
                    if (contributor != null) {
                        this.fNaturesViewer.setChecked((Object)contributor, true);
                        this.fSelectedNatures.add((String)nature);
                    }
                });
                if (!DVTNature.hasAnyDVTNature(this.fDescription)) {
                    this.setNaturesGroupVisible(true);
                    if (!this.validateSelectedNatures()) {
                        this.setPageComplete(false);
                        return;
                    }
                }
                this.setPageComplete(true);
                return;
            }
            if (this.fProjectNameText.isEnabled() && name.length() == 0) {
                this.setMessage("Enter a name for the project.", 3);
                this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                this.setErrorMessage(nameStatus.getMessage());
                this.setPageComplete(false);
                return;
            }
            IProject handle = workspace.getRoot().getProject(name);
            IStatus locationStatus = workspace.validateProjectLocation(handle, projectPath);
            if (!locationStatus.isOK()) {
                this.setErrorMessage(locationStatus.getMessage());
                this.setPageComplete(false);
                return;
            }
            if (handle.exists()) {
                this.setErrorMessage("There is another project with the same name in the current workspace! You can change the name of this project by clicking on the \"Custom\" check box below.");
                this.setPageComplete(false);
                return;
            }
            this.setNaturesGroupVisible(true);
            if (!this.validateSelectedNatures()) {
                this.setPageComplete(false);
                return;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
        if (this.directoryInfo == null) {
            this.setMessage(null);
        } else if (this.directoryInfo.isQuartusProject) {
            this.setMessage(this.quartusProjectMessage, 1);
        } else if (this.directoryInfo.isVivadoProject || this.directoryInfo.isISEProject) {
            this.setMessage(this.xilinxProjectMessage, 1);
        }
    }

    private boolean validateSelectedNatures() {
        if (this.fSelectedNatures.isEmpty()) {
            this.setMessage("You must specify at least one nature for this project!", 3);
            return false;
        }
        if (this.fSelectedNatures.contains("ro.amiq.dvt.pfnature") && !this.fSelectedNatures.contains("ro.amiq.vlogdt.VlogNature") && !this.fSelectedNatures.contains("ro.amiq.vhdldt.VhdlNature")) {
            this.setMessage("You must specify at least one of Verilog or VHDL along with Power Format!", 3);
            return false;
        }
        return true;
    }

    private void clearWizardProjectInfo() {
        this.fNaturesViewer.setAllChecked(false);
        this.fSelectedNatures.clear();
        this.directoryInfo = null;
    }

    private void updateAlteraProjectInformation() {
        AlteraAutoconfigUtils.QuartusProjectInfo quartusProjectInfo = this.directoryInfo.quartusProjectInfo;
        if (quartusProjectInfo != null) {
            this.fProjectNameText.setText(quartusProjectInfo.projectName);
            this.fProjectName = quartusProjectInfo.projectName;
        }
        this.fNaturesViewer.setChecked((Object)NatureContributors.getContributor(LanguageKind.VLOG), true);
        this.fNaturesViewer.setChecked((Object)NatureContributors.getContributor(LanguageKind.VHDL), true);
        this.fSelectedNatures.addAll(Arrays.asList(LanguageKind.VLOG.NATURE_ID, LanguageKind.VHDL.NATURE_ID));
    }

    private void updateXilinxProjectInformation(XilinxAutoconfigUtils.XilinxProjectInfo xilinxProjectInfo) {
        if (xilinxProjectInfo.projectName != null) {
            this.fProjectNameText.setText(xilinxProjectInfo.projectName);
            this.fProjectName = xilinxProjectInfo.projectName;
        }
        if (xilinxProjectInfo.dvtNatures == null) {
            return;
        }
        String[] stringArray = xilinxProjectInfo.dvtNatures;
        int n = xilinxProjectInfo.dvtNatures.length;
        int n2 = 0;
        while (n2 < n) {
            String dvtNature = stringArray[n2];
            INatureContributor contributor = NatureContributors.getContributor(LanguageKind.from(dvtNature));
            if (contributor != null) {
                this.fNaturesViewer.setChecked((Object)contributor, true);
            }
            ++n2;
        }
        this.fSelectedNatures.addAll(Arrays.asList(xilinxProjectInfo.dvtNatures));
    }

    protected void checkProjectDirectory() {
        IProjectDescription description = this.fModel.getProjectDescription();
        String projectName = description != null ? description.getName() : this.fProjectName;
        NewProjectResourceFiltersWrapper filtersWrapper = ResourceFilterUtils.checkProjectDirectory(this.fDirectoryString, projectName);
        this.fModel.setFilteredPaths(filtersWrapper.getExcludedPaths());
        this.fModel.setFiltersSelection(filtersWrapper.getFiltersSelection());
    }

    private class LocationGroup
    extends Composite {
        private Job fValidateJob;

        public LocationGroup(Composite parent) {
            super(parent, 0);
            this.fValidateJob = new Job("Validate New Project Wizard path"){

                public IStatus run(IProgressMonitor pm) {
                    try {
                        String currentText = ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.fDirectoryString;
                        IPath locationPath = NewProjectFirstPage.this.getLocationPath();
                        ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.directoryInfo = AutoconfigCompilationRootInfo.computeInfoForDirectory(locationPath.toFile(), null);
                        if (pm.isCanceled()) {
                            return Status.OK_STATUS;
                        }
                        DVTUiUtils.getActiveWorkbenchShell().getDisplay().asyncExec(() -> {
                            if (!currentText.equals(((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.fDirectoryString)) {
                                ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.directoryInfo = null;
                                return;
                            }
                            if (((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.directoryInfo != null) {
                                if (((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.directoryInfo.isQuartusProject) {
                                    ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.quartusProjectMessage = "Intel(Altera) Quartus project '" + ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.directoryInfo.quartusProjectInfo.projectName + "' found!";
                                    NewProjectFirstPage.this.updateAlteraProjectInformation();
                                } else if (((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.directoryInfo.isVivadoProject) {
                                    XilinxAutoconfigUtils.XilinxProjectInfo xilinxProjectInfo = ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.directoryInfo.vivadoProjectInfo;
                                    ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.xilinxProjectMessage = "Xilinx " + xilinxProjectInfo.projectType.getXilinxTool() + " project '" + xilinxProjectInfo.projectName + "' found!";
                                    NewProjectFirstPage.this.updateXilinxProjectInformation(xilinxProjectInfo);
                                } else if (((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.directoryInfo.isISEProject) {
                                    XilinxAutoconfigUtils.XilinxProjectInfo xilinxProjectInfo = ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.directoryInfo.iseProjectInfo;
                                    ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.xilinxProjectMessage = "Xilinx " + xilinxProjectInfo.projectType.getXilinxTool() + " project '" + xilinxProjectInfo.projectName + "' found!";
                                    NewProjectFirstPage.this.updateXilinxProjectInformation(xilinxProjectInfo);
                                }
                            }
                            NewProjectFirstPage.this.updatePageComplete();
                        });
                    }
                    catch (Exception ex) {
                        ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.directoryInfo = null;
                        DVTLogger.INSTANCE.logError((Throwable)ex);
                    }
                    return Status.OK_STATUS;
                }
            };
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            this.setLayout((Layout)layout);
            NewProjectFirstPage.this.fDirectoryLabel = new Label((Composite)this, 0);
            NewProjectFirstPage.this.fDirectoryLabel.setText("Directory:");
            NewProjectFirstPage.this.fDirectoryLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            NewProjectFirstPage.this.fDirectoryText = new Text((Composite)this, 2048);
            GridData directoryTextGridData = new GridData(4, 0x1000000, true, false);
            NewProjectFirstPage.this.fDirectoryText.setLayoutData((Object)directoryTextGridData);
            NewProjectFirstPage.this.fDirectoryText.addModifyListener(e -> {
                this.fValidateJob.cancel();
                NewProjectFirstPage.this.fDirectoryString = NewProjectFirstPage.this.fDirectoryText.getText();
                IPath locationPath = NewProjectFirstPage.this.getLocationPath();
                String location = locationPath.lastSegment();
                if (location == null) {
                    location = "";
                }
                if (!NewProjectFirstPage.this.fProjectNameEdit.getSelection()) {
                    NewProjectFirstPage.this.fProjectNameText.setText(location);
                }
                NewProjectFirstPage.this.clearWizardProjectInfo();
                this.fValidateJob.setUser(false);
                this.fValidateJob.setSystem(true);
                this.fValidateJob.schedule(500L);
                NewProjectFirstPage.this.updatePageComplete();
            });
            NewProjectFirstPage.this.fDirectoryButton = new Button((Composite)this, 8);
            NewProjectFirstPage.this.fDirectoryButton.setText("Browse...");
            NewProjectFirstPage.this.fDirectoryButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            NewProjectFirstPage.this.fDirectoryButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String filterPath = DVTFileUtils.getInstance().getLastDirectory();
                    DirectoryDialog directoryDialog = new DirectoryDialog(LocationGroup.this.getShell());
                    directoryDialog.setFilterPath(filterPath);
                    String selectedDirectory = directoryDialog.open();
                    if (selectedDirectory != null) {
                        ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.fDirectoryText.setText(selectedDirectory);
                        ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.fDirectoryString = selectedDirectory;
                        DVTFileUtils.getInstance().setLastDirectory(selectedDirectory);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            DVTUiUtils.installQuickTooltip((Control)NewProjectFirstPage.this.fDirectoryButton, (String)NewProjectFirstPage.DIR_HELP);
            DVTUiUtils.installQuickTooltip((Control)NewProjectFirstPage.this.fDirectoryText, (String)NewProjectFirstPage.DIR_HELP);
            NewProjectFirstPage.this.fProjectNameLabel = new Label((Composite)this, 0);
            NewProjectFirstPage.this.fProjectNameLabel.setText("Project Name:");
            NewProjectFirstPage.this.fProjectNameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            NewProjectFirstPage.this.fProjectNameText = new Text((Composite)this, 2048);
            NewProjectFirstPage.this.fProjectNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            NewProjectFirstPage.this.fProjectNameText.setEnabled(false);
            NewProjectFirstPage.this.fProjectNameText.addModifyListener(e -> {
                NewProjectFirstPage.this.fProjectName = NewProjectFirstPage.this.fProjectNameText.getText();
                if (NewProjectFirstPage.this.fProjectNameText.isEnabled()) {
                    NewProjectFirstPage.this.updatePageComplete();
                }
            });
            NewProjectFirstPage.this.fProjectNameEdit = new Button((Composite)this, 32);
            NewProjectFirstPage.this.fProjectNameEdit.setText("Custom");
            NewProjectFirstPage.this.fProjectNameEdit.setSelection(false);
            NewProjectFirstPage.this.fProjectNameEdit.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.fProjectNameText.setEnabled(((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.fProjectNameEdit.getSelection());
                    if (!((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.fProjectNameEdit.getSelection()) {
                        String location = NewProjectFirstPage.this.getLocationPath().lastSegment();
                        if (location == null) {
                            location = "";
                        }
                        if (!((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.fProjectNameEdit.getSelection()) {
                            ((LocationGroup)LocationGroup.this).NewProjectFirstPage.this.fProjectNameText.setText(location);
                        }
                        NewProjectFirstPage.this.updatePageComplete();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
    }
}

