/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.newproject;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import ro.amiq.dvt.DVTEclipseCDTUtils;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigXml;
import ro.amiq.dvt.nature.INatureContributor;
import ro.amiq.dvt.nature.NatureContributors;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.resourcefilters.autofilters.BuildConfigParseMode;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.utils.DVTExceptionHandler;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.buildconfig.DefaultBuildConfigGenerator;
import ro.amiq.dvt.wizards.newproject.NewProjectFirstPage;
import ro.amiq.dvt.wizards.newproject.NewProjectModel;

public class NewProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String ID = "ro.amiq.dvt.wizards.NewProjectWizard";
    static final int FINISH = 0;
    static final int CANCEL = 1;
    private IWorkbench fWorkbench;
    private IConfigurationElement fConfigElement;
    protected final NewProjectModel fModel = new NewProjectModel();
    protected NewProjectFirstPage fFirstPage;
    private IProject fProject;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.setWindowTitle("New Project");
        this.fFirstPage = new NewProjectFirstPage();
        this.addPage((IWizardPage)this.fFirstPage);
    }

    public boolean canFinish() {
        return this.fModel.getNatures().length > 0 && this.fFirstPage.isPageComplete();
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) throws CoreException {
        this.fConfigElement = cfig;
    }

    public boolean performFinish() {
        this.fFirstPage.checkProjectDirectory();
        if (this.fModel.getFilteredPaths() == null) {
            return false;
        }
        boolean success = true;
        IRunnableWithProgress createProjectRunnable = this.fModel.getProjectDescription() != null ? this.createExistingProjectOpRunnable() : this.createNewProjectOpRunnable();
        WorkspaceModifyDelegatingOperation newProjectOp = new WorkspaceModifyDelegatingOperation(createProjectRunnable);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)newProjectOp);
        }
        catch (InvocationTargetException e) {
            DVTExceptionHandler.handle(e, this.getShell(), "Error", e.getMessage());
            success = false;
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            success = false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        DVTPlugin.getSelectionManager().selectAndReveal((IResource)this.fProject, this.fWorkbench.getActiveWorkbenchWindow());
        BuildConfigManager.updateActiveBuildConfig(this.fProject);
        return success;
    }

    private IRunnableWithProgress createExistingProjectOpRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IProjectDescription description = NewProjectWizard.this.fModel.getProjectDescription();
                    if (description == null) {
                        monitor.done();
                        return;
                    }
                    try {
                        String projectName = description.getName();
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        NewProjectWizard.this.fProject = workspace.getRoot().getProject(projectName);
                        String[] existingNatures = NewProjectWizard.this.fModel.getProjectDescription().getNatureIds();
                        String[] newNatures = NewProjectWizard.this.fModel.getNatures();
                        ArrayList<String> existingNaturesList = new ArrayList<String>(Arrays.asList(existingNatures));
                        ArrayList<String> newNaturesList = new ArrayList<String>(Arrays.asList(newNatures));
                        boolean newNaturesAdded = false;
                        for (String nature : newNaturesList) {
                            if (existingNaturesList.contains(nature)) continue;
                            existingNaturesList.add(nature);
                            newNaturesAdded = true;
                        }
                        if (newNatures.length > 1) {
                            existingNaturesList.add(0, "ro.amiq.dvt.dvtnature");
                        }
                        NewProjectWizard.this.createProjectFolder(newNaturesList);
                        monitor.beginTask("Creating Project...", 100);
                        if (!NewProjectWizard.this.fProject.exists()) {
                            NewProjectWizard.this.fProject.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                            if (newNaturesAdded) {
                                ProjectDescription dddd = ((Project)NewProjectWizard.this.fProject).internalGetDescription();
                                dddd.setNatureIds(existingNaturesList.toArray(new String[existingNaturesList.size()]));
                                ((Project)NewProjectWizard.this.fProject).writeDescription(0);
                            }
                            if (!NewProjectWizard.this.fModel.getFilteredPaths().isEmpty()) {
                                ResourceFilterUtils.applyDvtFilters(NewProjectWizard.this.fProject, NewProjectWizard.this.fModel.getFilteredPaths(), true);
                            }
                            ResourceFilterUtils.applyFiltersSelection(NewProjectWizard.this.fProject, NewProjectWizard.this.fModel.getFiltersSelection(), BuildConfigParseMode.FORCE_PARSE);
                            NewProjectWizard.this.fProject.open(0, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                            if (DVTEclipseCDTUtils.INSTANCE.checkNoCPPProjectNature(NewProjectWizard.this.fProject)) {
                                DVTEclipseCDTUtils.INSTANCE.backupDotCProjectFile(NewProjectWizard.this.fProject, monitor);
                            }
                            NewProjectWizard.this.fProject.setSessionProperty(DVTStartupConstants.QN_DVT_TRY_RESTORE, (Object)true);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private IRunnableWithProgress createNewProjectOpRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Creating Project...", 10);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot workspaceRoot = workspace.getRoot();
                NewProjectWizard.this.fProject = workspaceRoot.getProject(NewProjectWizard.this.fModel.getName());
                IProjectDescription description = workspace.newProjectDescription(NewProjectWizard.this.fProject.getName());
                description.setLocation(NewProjectWizard.this.fModel.getLocation());
                String[] natures = NewProjectWizard.this.fModel.getNatures();
                ArrayList<String> naturesList = new ArrayList<String>(Arrays.asList(natures));
                if (natures.length > 1) {
                    naturesList.add(0, "ro.amiq.dvt.dvtnature");
                }
                if (naturesList.contains("ro.amiq.dvt.pfnature")) {
                    naturesList.add("org.eclipse.dltk.tcl.core.nature");
                }
                description.setNatureIds(naturesList.toArray(new String[naturesList.size()]));
                try {
                    try {
                        INatureContributor cppNatureContributor;
                        File location = NewProjectWizard.this.fModel.getLocation().toFile();
                        if (!location.exists()) {
                            location.mkdirs();
                        }
                        NewProjectWizard.this.createProjectFolder(naturesList);
                        if (!NewProjectWizard.this.fProject.exists()) {
                            File projectFile = new File(String.valueOf(location.getAbsolutePath()) + '/' + ".project");
                            if (projectFile.exists()) {
                                Files.delete(projectFile.toPath());
                            }
                            NewProjectWizard.this.fProject.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                        }
                        if (!NewProjectWizard.this.fModel.getFilteredPaths().isEmpty()) {
                            ResourceFilterUtils.applyDvtFilters(NewProjectWizard.this.fProject, NewProjectWizard.this.fModel.getFilteredPaths(), true);
                        }
                        ResourceFilterUtils.applyFiltersSelection(NewProjectWizard.this.fProject, NewProjectWizard.this.fModel.getFiltersSelection(), BuildConfigParseMode.FORCE_PARSE);
                        if (!NewProjectWizard.this.fProject.isOpen()) {
                            NewProjectWizard.this.fProject.open(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                            String buildConfigName = BuildConfigXml.load(NewProjectWizard.this.fProject).getActiveBuildConfigName();
                            if (buildConfigName == null || buildConfigName.isEmpty()) {
                                buildConfigName = "default";
                            }
                            DVTFileUtils.getInstance().openEditor(NewProjectWizard.this.fProject.getFile(".dvt/" + buildConfigName + ".build"), null);
                        }
                        if (DVTEclipseCDTUtils.INSTANCE.checkNoCPPProjectNature(NewProjectWizard.this.fProject)) {
                            DVTEclipseCDTUtils.INSTANCE.backupDotCProjectFile(NewProjectWizard.this.fProject, monitor);
                        }
                        IProjectDescription desc = NewProjectWizard.this.fProject.getDescription();
                        ICommand[] commands = desc.getBuildSpec();
                        boolean found = false;
                        int i = 0;
                        while (i < commands.length) {
                            if (commands[i].getBuilderName().equals("ro.amiq.dvt.MixedLangBuilder")) {
                                found = true;
                                break;
                            }
                            ++i;
                        }
                        if (!found) {
                            ICommand command = desc.newCommand();
                            command.setBuilderName("ro.amiq.dvt.MixedLangBuilder");
                            ICommand[] newCommands = new ICommand[commands.length + 1];
                            System.arraycopy(commands, 0, newCommands, 1, commands.length);
                            newCommands[0] = command;
                            desc.setBuildSpec(newCommands);
                            NewProjectWizard.this.fProject.setDescription(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        }
                        if ((cppNatureContributor = NatureContributors.getContributor(LanguageKind.CPP)) != null && cppNatureContributor.hasNature(NewProjectWizard.this.fProject)) {
                            cppNatureContributor.activateNature(NewProjectWizard.this.fProject);
                        }
                        NewProjectWizard.this.fProject.setSessionProperty(DVTStartupConstants.QN_DVT_FIRST_BUILD_AFTER_CREATION, (Object)true);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private void createProjectFolder(final ArrayList<String> naturesList) {
        String[] buildFiles;
        File location = this.fModel.getLocation().toFile();
        if (!location.exists()) {
            location.mkdirs();
        }
        boolean createDefaultBuild = true;
        File dotDvtFolder = new File(location, ".dvt");
        if (dotDvtFolder.exists() && (buildFiles = dotDvtFolder.list((dir, name) -> name.endsWith(".build"))).length > 0) {
            createDefaultBuild = false;
        }
        if (createDefaultBuild) {
            DefaultBuildConfigGenerator generator = new DefaultBuildConfigGenerator(){

                @Override
                public boolean isE() {
                    return naturesList.contains("ro.amiq.edt.enature");
                }

                @Override
                public boolean isSLN() {
                    return naturesList.contains("ro.amiq.slndt.slnnature");
                }

                @Override
                public boolean isMSDL() {
                    return naturesList.contains("ro.amiq.msdldt.msdlnature");
                }

                @Override
                public boolean isPSS() {
                    return naturesList.contains("ro.amiq.pssdt.pssnature");
                }

                @Override
                public boolean isVlog() {
                    return naturesList.contains("ro.amiq.vlogdt.VlogNature");
                }

                @Override
                public boolean isVhdl() {
                    return naturesList.contains("ro.amiq.vhdldt.VhdlNature");
                }

                @Override
                public boolean isAutoconfig() {
                    return NewProjectWizard.this.fModel.isAutoconfig();
                }
            };
            generator.writeFile(location, "default.build");
        }
    }
}

