/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.predefinedprojects;

import java.io.File;
import java.text.Collator;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.wizards.predefinedprojects.PredefinedProjectsVariablesDialog;

public abstract class PredefinedProjectUI
extends Composite {
    private static final String[] README_FILE_NAMES = new String[]{"README.TXT", "README.txt", "readme.txt"};
    public static final Map<String, String> fNaturesMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("ro.amiq.edt.enature", "e Language");
            this.put("ro.amiq.slndt.slnnature", "SLN");
            this.put("ro.amiq.msdldt.msdlnature", "M-SDL");
            this.put("ro.amiq.pssdt.pssnature", "PSS");
            this.put("ro.amiq.vlogdt.VlogNature", "SystemVerilog");
            this.put("ro.amiq.vhdldt.VhdlNature", "VHDL");
            this.put("ro.amiq.dvt.pfnature", "UPF/CPF");
        }
    };
    public static final String EMPTY_LIST_MESSAGE = "";
    private Text fLocationText = null;
    private Text fProjectDescriptionText = null;
    private Button fOverwriteTargetButton;
    private Table fProjectsTable;
    private Text fFilter;
    private Map<IProjectDescription, String> fProjectsPaths = new HashMap<IProjectDescription, String>();
    private boolean fQuick = false;
    private boolean fOverwriteTargetDirectory;
    private String fSelectedProjectPath;
    private String fCurrentlySelectedProjectName;
    private String fProjectToSelectName;
    private TableItem fDefaultSelectedItem;
    private static final String OVERWRITE_MESSAGE = "Overwrite";

    public PredefinedProjectUI(Composite parent, boolean quick, Map<IProjectDescription, String> projectsPaths, String projectToSelectName) {
        super(parent, 0);
        this.fQuick = quick;
        this.fProjectsPaths = projectsPaths;
        this.fProjectToSelectName = projectToSelectName;
        this.setLayout((Layout)new GridLayout());
        Group topGroup = new Group((Composite)this, 2048);
        topGroup.setLayout((Layout)new GridLayout());
        GridData topGroupGridData = new GridData(4, 4, true, true);
        topGroupGridData.minimumHeight = 200;
        topGroup.setLayoutData((Object)topGroupGridData);
        topGroup.setText("Select an example project");
        SashForm sashForm = new SashForm((Composite)topGroup, 2304);
        GridData sashFormGridData = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)sashFormGridData);
        Group sashLeftGr = new Group((Composite)sashForm, 0);
        sashLeftGr.setLayout((Layout)new GridLayout());
        GridData sashLeftGrGridData = new GridData(4, 4, true, true);
        sashLeftGrGridData.widthHint = 250;
        sashLeftGr.setLayoutData((Object)sashLeftGrGridData);
        this.fFilter = new Text((Composite)sashLeftGr, 2048);
        this.fFilter.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fFilter.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    PredefinedProjectUI.this.setSelectionWithEvent(0);
                    PredefinedProjectUI.this.fProjectsTable.setFocus();
                } else {
                    PredefinedProjectUI.this.populateProjectsTable(PredefinedProjectUI.this.fFilter.getText());
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fFilter.setMessage("Filter by: project name");
        DVTColorUtil.INSTANCE.setForeground((Control)this.fFilter, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.foregroundColor"));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fFilter, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor"));
        this.fProjectsTable = new Table((Composite)sashLeftGr, 0x10000B00);
        this.fProjectsTable.setHeaderVisible(true);
        GridData tableLayoutData = new GridData(4, 4, true, true);
        this.fProjectsTable.setLayoutData((Object)tableLayoutData);
        this.fProjectsTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = PredefinedProjectUI.this.fProjectsTable.getSelection();
                if (selection.length == 0) {
                    return;
                }
                PredefinedProjectUI.this.fCurrentlySelectedProjectName = selection[0].getText();
                IProjectDescription pd = PredefinedProjectUI.this.getProjDesc(PredefinedProjectUI.this.fCurrentlySelectedProjectName);
                PredefinedProjectUI.this.fSelectedProjectPath = PredefinedProjectUI.this.fProjectsPaths.get(pd);
                if (PredefinedProjectUI.this.fSelectedProjectPath == null) {
                    return;
                }
                String projectDescription = PredefinedProjectUI.EMPTY_LIST_MESSAGE;
                String[] stringArray = README_FILE_NAMES;
                int n = README_FILE_NAMES.length;
                int n2 = 0;
                while (n2 < n) {
                    String readmeFile = stringArray[n2];
                    try {
                        File projDescFile = new File(String.valueOf(PredefinedProjectUI.this.fSelectedProjectPath) + File.separator + readmeFile);
                        if (projDescFile.exists()) {
                            projectDescription = DVTFileUtils.getInstance().readFileContent(projDescFile);
                            break;
                        }
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
                if (projectDescription != null && !projectDescription.trim().isEmpty()) {
                    PredefinedProjectUI.this.fProjectDescriptionText.setText(projectDescription);
                } else {
                    PredefinedProjectUI.this.fProjectDescriptionText.setText("No description available");
                }
                PredefinedProjectUI.this.handleSelection(selection[0].getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        String[] titles1 = new String[]{"Project Name", "Nature"};
        int i = 0;
        while (i < titles1.length) {
            final TableColumn column = new TableColumn(this.fProjectsTable, 0);
            column.setText(titles1[i]);
            column.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TableItem[] items = PredefinedProjectUI.this.fProjectsTable.getItems();
                    Collator collator = Collator.getInstance(Locale.getDefault());
                    if (PredefinedProjectUI.this.fProjectsTable.getSortDirection() == 0 || PredefinedProjectUI.this.fProjectsTable.getSortDirection() == 128) {
                        PredefinedProjectUI.this.fProjectsTable.setSortDirection(1024);
                    } else {
                        PredefinedProjectUI.this.fProjectsTable.setSortDirection(128);
                    }
                    PredefinedProjectUI.this.fProjectsTable.setSortColumn(column);
                    int i = 1;
                    while (i < items.length) {
                        String value1 = items[i].getText(column.getText().equals("Project Name") ? 0 : 1);
                        int j = 0;
                        while (j < i) {
                            String value2 = items[j].getText(column.getText().equals("Project Name") ? 0 : 1);
                            int compare = collator.compare(value1, value2);
                            if (PredefinedProjectUI.this.fProjectsTable.getSortDirection() == 1024) {
                                if (compare < 0) {
                                    values = new String[]{items[i].getText(0), items[i].getText(1)};
                                    items[i].dispose();
                                    item = new TableItem(PredefinedProjectUI.this.fProjectsTable, 0, j);
                                    item.setText(values);
                                    items = PredefinedProjectUI.this.fProjectsTable.getItems();
                                    break;
                                }
                            } else if (compare > 0) {
                                values = new String[]{items[i].getText(0), items[i].getText(1)};
                                items[i].dispose();
                                item = new TableItem(PredefinedProjectUI.this.fProjectsTable, 0, j);
                                item.setText(values);
                                items = PredefinedProjectUI.this.fProjectsTable.getItems();
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    PredefinedProjectUI.this.fProjectsTable.setTopIndex(0);
                }
            });
            ++i;
        }
        this.fProjectDescriptionText = new Text((Composite)sashForm, 2624);
        this.fProjectDescriptionText.setText(EMPTY_LIST_MESSAGE);
        this.fProjectDescriptionText.setLayoutData((Object)new GridData(4, 4, true, true));
        sashForm.setWeights(new int[]{1, 1});
        this.populateProjectsTable(EMPTY_LIST_MESSAGE);
        if (!this.fQuick) {
            Group bottomGroup = new Group((Composite)this, 2048);
            bottomGroup.setLayout((Layout)new GridLayout(2, false));
            GridData bottomGroupGridData = new GridData(4, 0x1000000, true, false);
            bottomGroup.setLayoutData((Object)bottomGroupGridData);
            bottomGroup.setText("Project target directory ($DVT_PREDEFINED_PROJECTS_TARGET):");
            this.fLocationText = new Text((Composite)bottomGroup, 2048);
            this.fLocationText.setLayoutData((Object)new GridData(4, 4, true, false));
            String locationPath = System.getenv("DVT_PREDEFINED_PROJECTS_TARGET");
            if (locationPath == null || locationPath.isEmpty()) {
                locationPath = String.valueOf(System.getProperty("user.home")) + File.separator + "dvt_predefined_projects_target";
            }
            this.fLocationText.setText(locationPath);
            DVTFileUtils.getInstance().setLastDirectory(locationPath);
            this.fLocationText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PredefinedProjectUI.this.validateFields();
                }
            });
            Button directoryButton = new Button((Composite)bottomGroup, 8);
            directoryButton.setText("Browse...");
            directoryButton.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
            directoryButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String filterPath = DVTFileUtils.getInstance().getLastDirectory();
                    DirectoryDialog directoryDialog = new DirectoryDialog(PredefinedProjectUI.this.getShell());
                    directoryDialog.setFilterPath(filterPath);
                    String selectedDirectory = directoryDialog.open();
                    directoryDialog.setText(DVTFileUtils.getInstance().getLastDirectory());
                    if (selectedDirectory != null) {
                        PredefinedProjectUI.this.fLocationText.setText(selectedDirectory);
                        DVTFileUtils.getInstance().setLastDirectory(selectedDirectory);
                        PredefinedProjectUI.this.validateFields();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fOverwriteTargetButton = new Button((Composite)bottomGroup, 32);
            this.fOverwriteTargetButton.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            this.fOverwriteTargetButton.setText(OVERWRITE_MESSAGE);
            this.fOverwriteTargetButton.setSelection(false);
            this.fOverwriteTargetButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PredefinedProjectUI.this.fOverwriteTargetDirectory = PredefinedProjectUI.this.fOverwriteTargetButton.getSelection();
                    PredefinedProjectUI.this.validateFields();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        Group infoGroup = new Group((Composite)this, 2048);
        infoGroup.setLayout((Layout)new GridLayout());
        infoGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        infoGroup.setText("DVT Predefined Projects Locations");
        Link infoPredefProj = new Link((Composite)infoGroup, 64);
        infoPredefProj.setLayoutData((Object)new GridData(4, 4, true, true));
        infoPredefProj.setText("DVT scans for predefined projects in the directories specified by all the system variables starting with \"DVT_PREDEFINED_PROJECTS_EXT_\" and by default in \"DVT_PREDEFINED_PROJECTS\".\n<a>See all defined locations...</a>");
        DVTUiUtils.setPlatformLinkColor((Link)infoPredefProj);
        infoPredefProj.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                new PredefinedProjectsVariablesDialog().open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void setSelectionWithEvent(int index) {
        if (this.fProjectsTable == null) {
            return;
        }
        if (this.fProjectsTable.getItems() == null) {
            return;
        }
        this.setSelectionWithEvent(this.fProjectsTable.getItem(index));
    }

    protected void setSelectionWithEvent(TableItem ti) {
        if (ti == null) {
            return;
        }
        this.fProjectsTable.setSelection(ti);
        this.fProjectsTable.notifyListeners(13, new Event());
    }

    private void populateProjectsTable(String regexFilter) {
        this.fProjectsTable.removeAll();
        this.fProjectsTable.clearAll();
        this.fProjectDescriptionText.setText(EMPTY_LIST_MESSAGE);
        regexFilter = String.valueOf('*') + regexFilter.trim() + '*';
        StringMatcher matcher = new StringMatcher(regexFilter, true, false);
        LinkedList<String> names = new LinkedList<String>();
        if (this.fProjectsPaths.isEmpty()) {
            TableItem item = new TableItem(this.fProjectsTable, 0);
            item.setText(EMPTY_LIST_MESSAGE);
            item.setText(0, EMPTY_LIST_MESSAGE);
            item.setText(1, EMPTY_LIST_MESSAGE);
            return;
        }
        for (IProjectDescription projectDesc : this.fProjectsPaths.keySet()) {
            if (regexFilter != null && !regexFilter.isEmpty() && !matcher.match(projectDesc.getName())) continue;
            names.add(projectDesc.getName());
        }
        Collections.sort(names);
        for (String projectName : names) {
            IProjectDescription pd = this.getProjDesc(projectName);
            if (pd == null) continue;
            TableItem item = new TableItem(this.fProjectsTable, 0);
            item.setText(projectName);
            item.setText(0, projectName);
            if (projectName.equals(this.fProjectToSelectName)) {
                this.fDefaultSelectedItem = item;
            }
            String[] nIds = pd.getNatureIds();
            StringBuilder sb = new StringBuilder();
            int index = 0;
            int i = 0;
            while (i < nIds.length) {
                if (fNaturesMap.containsKey(nIds[i])) {
                    if (index > 0) {
                        sb.append(", ");
                    }
                    sb.append(fNaturesMap.get(nIds[i]));
                    ++index;
                }
                ++i;
            }
            item.setText(1, sb.toString());
        }
        int columnCount = this.fProjectsTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            this.fProjectsTable.getColumn(i).pack();
            ++i;
        }
        this.fProjectsTable.update();
    }

    private IProjectDescription getProjDesc(String projectName) {
        for (IProjectDescription pd : this.fProjectsPaths.keySet()) {
            if (!pd.getName().equals(projectName)) continue;
            return pd;
        }
        return null;
    }

    public String getSelectedProjectName() {
        return this.fCurrentlySelectedProjectName;
    }

    public String getSelectedProjectPath() {
        return this.fSelectedProjectPath;
    }

    public void resetOverwriteTargetDirectory() {
        this.fOverwriteTargetDirectory = false;
        this.fOverwriteTargetButton.setSelection(false);
    }

    public boolean getOverwriteTargetDirectory() {
        return this.fOverwriteTargetDirectory;
    }

    public String getTargetLocationPath() {
        return this.fLocationText.getText();
    }

    public abstract void validateFields();

    public abstract void handleSelection(String var1);

    public void initDone() {
        if (this.fDefaultSelectedItem != null) {
            this.setSelectionWithEvent(this.fDefaultSelectedItem);
        } else {
            this.fProjectsTable.setFocus();
        }
    }

    public void resetOverwriteButton() {
        if (this.fOverwriteTargetButton == null) {
            return;
        }
        this.fOverwriteTargetButton.setSelection(false);
        this.fOverwriteTargetDirectory = false;
    }

    public void disableOverwrite() {
        this.fOverwriteTargetButton.setText(OVERWRITE_MESSAGE);
        this.fOverwriteTargetButton.setEnabled(false);
    }

    public void enableOverwriteWithMessage(String message) {
        this.fOverwriteTargetButton.setText("Overwrite " + message);
        this.fOverwriteTargetButton.setEnabled(true);
    }
}

