/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.predefinedprojects;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import ro.amiq.dvt.dvtcommand.OpenPredefinedProjectUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.wizards.predefinedprojects.PredefinedProjectUI;
import ro.amiq.dvt.wizards.predefinedprojects.PredefinedProjectValidationMessage;
import ro.amiq.dvt.wizards.predefinedprojects.PredefinedProjectsWizard;
import ro.amiq.dvt.wizards.util.PredefinedProjectsUtils;

public class PredefinedProjectsFirstPage
extends WizardPage {
    private boolean fCanFlipToNextPage = false;
    private Map<IProjectDescription, String> fProjectsPaths = new HashMap<IProjectDescription, String>();
    private PredefinedProjectUI fLocationGroup;
    private String fProjectToSelectName;

    public PredefinedProjectsFirstPage(String projectToSelectName) {
        super("NewPredefinedProjectFirstPage");
        this.fProjectToSelectName = projectToSelectName;
        this.setTitle("Project Location");
        this.setDescription("Specify project location");
        this.setImageDescriptor(DVTImages.PREDEFINED_DVT_PROJECT_WIZ);
        this.scanForProjects();
    }

    protected void scanForProjects() {
        String systemVarPath = System.getenv("DVT_PREDEFINED_PROJECTS");
        if (PredefinedProjectsUtils.getAllEnvVars().isEmpty()) {
            this.setMessage("There is no environment variable starting with \"DVT_PREDEFINED_PROJECTS\" set!", 3);
            return;
        }
        File projectDir = new File(systemVarPath);
        if (!projectDir.exists()) {
            this.setMessage("The folder " + systemVarPath + " does not exist!", 3);
            return;
        }
        this.fProjectsPaths = PredefinedProjectsUtils.getPredefinedProjects(false);
        if (this.fProjectsPaths.size() > 0) {
            this.setMessage("Select a project form the list!");
        } else {
            this.setMessage("No example projects available!");
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.fLocationGroup = new PredefinedProjectUI(composite, false, this.fProjectsPaths, this.fProjectToSelectName){

            @Override
            public void validateFields() {
                PredefinedProjectsFirstPage.this.localValidateFields();
            }

            @Override
            public void handleSelection(String selection) {
                this.resetOverwriteButton();
                PredefinedProjectsFirstPage.this.localHandleSelection(selection);
            }
        };
        GridData locationGroupGridData = new GridData(4, 4, true, true);
        locationGroupGridData.widthHint = 800;
        this.fLocationGroup.setLayoutData(locationGroupGridData);
        Dialog.applyDialogFont((Control)parent);
        this.setControl((Control)composite);
        this.fLocationGroup.initDone();
        this.setPageComplete(false);
    }

    private void localHandleSelection(String selection) {
        String selectedProjectName = this.fLocationGroup.getSelectedProjectName();
        this.setMessage("You have selected: " + selectedProjectName);
        this.localValidateFields();
    }

    public boolean canFlipToNextPage() {
        return this.fCanFlipToNextPage;
    }

    private void localValidateFields() {
        boolean isOverwrite;
        String projectNewPath;
        String projectNewName = this.fLocationGroup.getSelectedProjectName().trim();
        PredefinedProjectValidationMessage validationMessage = OpenPredefinedProjectUtils.validateProjectFields(projectNewName, projectNewPath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(this.fLocationGroup.getTargetLocationPath()), isOverwrite = this.isOverwrite());
        if (validationMessage != PredefinedProjectValidationMessage.NO_PROBLEM) {
            this.setError(validationMessage.getErrorMessage());
            this.fLocationGroup.enableOverwriteWithMessage(validationMessage.getOverwriteMessage());
            return;
        }
        if (!isOverwrite) {
            this.fLocationGroup.disableOverwrite();
        }
        this.setMessage("Click on Finish in order to load the project!", 0);
        PredefinedProjectsWizard wizard = (PredefinedProjectsWizard)this.getWizard();
        wizard.fDestinationProjectFolder = String.valueOf(projectNewPath) + File.separator + projectNewName;
        wizard.fSourceProjectFolder = this.fLocationGroup.getSelectedProjectPath();
        wizard.fWizardStatus = 0;
        this.setPageComplete(true);
    }

    private void setError(String message) {
        this.setMessage(message, 3);
        PredefinedProjectsWizard wizard = (PredefinedProjectsWizard)this.getWizard();
        wizard.fWizardStatus = 1;
        this.setPageComplete(false);
    }

    public boolean isOverwrite() {
        return this.fLocationGroup.getOverwriteTargetDirectory();
    }
}

