/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.predefinedprojects;

import java.io.File;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import ro.amiq.dvt.dvtcommand.OpenPredefinedProjectUtils;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.wizards.predefinedprojects.PredefinedProjectsFirstPage;
import ro.amiq.dvt.wizards.util.PredefinedProjectsUtils;

public class PredefinedProjectsWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String ID = "ro.amiq.dvt.wizards.PredefinedProjectsWizard";
    public static final int FINISH = 0;
    public static final int CANCEL = 1;
    protected int fWizardStatus = 1;
    protected String fSourceProjectFolder = "";
    protected String fDestinationProjectFolder = "";
    private IConfigurationElement fConfigElement;
    protected PredefinedProjectsFirstPage fFirstPage;
    private IProjectDescription fDestinationProjectDescr;
    private String fProjectToSelectName;
    private String fFileToOpen;

    public PredefinedProjectsWizard() {
    }

    public PredefinedProjectsWizard(String selectProject, String openFile) {
        this.fProjectToSelectName = selectProject;
        this.fFileToOpen = openFile;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.setWindowTitle("Predefined Projects");
        this.fFirstPage = new PredefinedProjectsFirstPage(this.fProjectToSelectName);
        this.addPage((IWizardPage)this.fFirstPage);
    }

    public boolean canFinish() {
        return this.fWizardStatus == 0;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) throws CoreException {
        this.fConfigElement = cfig;
    }

    public boolean performFinish() {
        boolean overwrite = this.fFirstPage.isOverwrite();
        File destFolder = new File(this.fDestinationProjectFolder);
        File sourceFolder = new File(this.fSourceProjectFolder);
        if (overwrite) {
            OpenPredefinedProjectUtils.deleteExistingProject(destFolder);
        }
        if (!OpenPredefinedProjectUtils.copyProjectFolder(overwrite, destFolder, sourceFolder)) {
            return this.invalidateFinish();
        }
        File destinationProject = PredefinedProjectsUtils.getProjectFileFromDirectory(destFolder);
        this.fDestinationProjectDescr = Utils.getProjectDescription(destinationProject);
        return OpenPredefinedProjectUtils.createProject(destFolder, destinationProject, this.fDestinationProjectDescr, this.fFileToOpen, this.fConfigElement);
    }

    private boolean invalidateFinish() {
        this.fFirstPage.setMessage("Source directory is not available!", 3);
        this.fWizardStatus = 1;
        this.fFirstPage.setPageComplete(false);
        this.fFirstPage.scanForProjects();
        return false;
    }
}

