/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.browser.Browser;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewListener;

public class OpenDevToolsHandler
extends AbstractHandler {
    private static final String SHOW_DEV_TOOLS_METHOD_NAME = "showDevTools";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Browser browser = SpecadorPreviewListener.INSTANCE.getBrowser();
        if (browser == null) {
            return null;
        }
        Object webBrowser = browser.getWebBrowser();
        Class<?> chromiumBrowserClass = webBrowser.getClass();
        Method showDevToolsMethod = null;
        try {
            showDevToolsMethod = chromiumBrowserClass.getMethod(SHOW_DEV_TOOLS_METHOD_NAME, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        if (showDevToolsMethod == null) {
            return null;
        }
        try {
            showDevToolsMethod.setAccessible(true);
            showDevToolsMethod.invoke(webBrowser, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }
}

