/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import java.io.File;
import java.net.URL;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitoringType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.SpecadorExitCode;
import ro.amiq.dvt.specador.SpecadorPreviewProgressMonitor;
import ro.amiq.dvt.specador.SpecadorProgressMonitor;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.specador.templates.SpecadorGenerator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.wizards.specador.SpecadorManager;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewListener;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewView;

public class SpecadorJob
extends Job {
    public static final String JOB_NAME = "Generate Specador Preview";
    private final SpecadorModel model;
    private IRfNamedElement element;
    private boolean generateHTMLPreview;
    public static final int SPECADOR_PHASE_START = 2000;
    public static final int SPECADOR_PHASE_STOP = -2000;

    public SpecadorJob(SpecadorModel specadorModel) {
        super("Generate Specador Documentation");
        this.model = specadorModel;
    }

    public SpecadorJob(SpecadorModel specadorModel, IRfNamedElement namedElement) {
        super(JOB_NAME);
        this.model = specadorModel;
        this.element = namedElement;
        this.generateHTMLPreview = namedElement != null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected IStatus run(IProgressMonitor monitor) {
        block39: {
            block38: {
                try {
                    block36: {
                        block37: {
                            block34: {
                                block35: {
                                    block32: {
                                        block33: {
                                            block30: {
                                                block31: {
                                                    if (this.model == null) {
                                                        var14_2 = Status.CANCEL_STATUS;
                                                        return var14_2;
                                                    }
                                                    ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)this.model.getProject(), 8, 2000);
                                                    s = SpecadorManager.getFeatures(this.model.getProject());
                                                    projectName = this.model.getProject() == null ? null : this.model.getProject().getName();
                                                    MemoryMonitor.getInstance().startMemoryMonitor(MemoryMonitoringType.GEN_DOC_GUI, projectName);
                                                    if (this.generateHTMLPreview || DVTPlugin.getDefault().collect().cc(s)) break block30;
                                                    var8_7 = Status.CANCEL_STATUS;
                                                    if (this.generateHTMLPreview) break block31;
                                                    var12_11 = s;
                                                    var11_17 = s.length;
                                                    var10_23 = 0;
                                                    while (var10_23 < var11_17) {
                                                        ss = var12_11[var10_23];
                                                        DVTPlugin.getDefault().collect().i(ss);
                                                        ++var10_23;
                                                    }
                                                }
                                                FontFactory.restoreDefaultFontsOnThisThread();
                                                MemoryMonitor.getInstance().stopMemoryMonitor();
                                                ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)this.model.getProject(), 8, -2000);
                                                return var8_7;
                                            }
                                            if (!this.generateHTMLPreview) {
                                                DVTBuildConsoleRegistry.getConsole(this.model.getProject()).printStartSection("Start generating Specador documentation");
                                            }
                                            FontFactory.useAWTFontsOnThisThread();
                                            indexFilePath = "";
                                            v0 /* !! */  = specadorMonitor /* !! */  = this.generateHTMLPreview != false ? new SpecadorPreviewProgressMonitor(this.model, monitor) : new SpecadorProgressMonitor(this.model, monitor);
                                            if (this.generateHTMLPreview) {
                                                this.setPreferencesForPreview();
                                                indexFilePath = SpecadorGenerator.generateDocumentation(this.model, specadorMonitor /* !! */ , this.element);
                                                SpecadorPreviewListener.INSTANCE.setElementPath(this.element);
                                            } else {
                                                indexFilePath = SpecadorGenerator.generateDocumentation(this.model, specadorMonitor /* !! */ );
                                            }
                                            if (this.model.getOutputFormat() == SpecadorModel.OutputFormat.HTML) break block32;
                                            var8_8 = Status.OK_STATUS;
                                            if (this.generateHTMLPreview) break block33;
                                            var12_12 = s;
                                            var11_18 = s.length;
                                            var10_24 = 0;
                                            while (var10_24 < var11_18) {
                                                ss = var12_12[var10_24];
                                                DVTPlugin.getDefault().collect().i(ss);
                                                ++var10_24;
                                            }
                                        }
                                        FontFactory.restoreDefaultFontsOnThisThread();
                                        MemoryMonitor.getInstance().stopMemoryMonitor();
                                        ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)this.model.getProject(), 8, -2000);
                                        return var8_8;
                                    }
                                    indexFile = new File(indexFilePath);
                                    if (indexFile.exists()) break block34;
                                    var8_9 = Status.CANCEL_STATUS;
                                    if (this.generateHTMLPreview) break block35;
                                    var12_13 = s;
                                    var11_19 = s.length;
                                    var10_25 = 0;
                                    while (var10_25 < var11_19) {
                                        ss = var12_13[var10_25];
                                        DVTPlugin.getDefault().collect().i(ss);
                                        ++var10_25;
                                    }
                                }
                                FontFactory.restoreDefaultFontsOnThisThread();
                                MemoryMonitor.getInstance().stopMemoryMonitor();
                                ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)this.model.getProject(), 8, -2000);
                                return var8_9;
                            }
                            try {
                                if (this.generateHTMLPreview || this.model.isOpenInBrowser()) {
                                    this.openHTMLFileInBrowser(specadorMonitor /* !! */ , indexFile);
                                }
                                break block36;
                                {
                                    catch (Exception e) {
                                        DVTLogger.INSTANCE.logError((Throwable)e);
                                        DVTBuildConsoleRegistry.getConsole(this.model.getProject()).print(SpecadorConstants.cancelGenerateDocumentation);
                                        var8_10 = Status.CANCEL_STATUS;
                                        if (this.generateHTMLPreview) break block37;
                                        var12_14 = s;
                                        var11_20 = s.length;
                                        var10_26 = 0;
                                        ** while (var10_26 < var11_20)
                                    }
                                }
                            }
                            catch (Throwable var7_39) {
                                if (!this.generateHTMLPreview) {
                                    var12_15 = s;
                                    var11_21 = s.length;
                                    var10_27 = 0;
                                    while (var10_27 < var11_21) {
                                        ss = var12_15[var10_27];
                                        DVTPlugin.getDefault().collect().i(ss);
                                        ++var10_27;
                                    }
                                }
                                FontFactory.restoreDefaultFontsOnThisThread();
                                MemoryMonitor.getInstance().stopMemoryMonitor();
                                ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)this.model.getProject(), 8, -2000);
                                throw var7_39;
                            }
lbl-1000:
                            // 1 sources

                            {
                                ss = var12_14[var10_26];
                                DVTPlugin.getDefault().collect().i(ss);
                                ++var10_26;
                                continue;
                            }
                        }
                        FontFactory.restoreDefaultFontsOnThisThread();
                        MemoryMonitor.getInstance().stopMemoryMonitor();
                        ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)this.model.getProject(), 8, -2000);
                        return var8_10;
                    }
                    if (this.generateHTMLPreview) break block38;
                    var12_16 = s;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    break block39;
                }
                finally {
                    ObjectionManager.getInstance().clear(Objection.SPECADOR);
                }
                var11_22 = s.length;
                var10_28 = 0;
                while (var10_28 < var11_22) {
                    ss = var12_16[var10_28];
                    DVTPlugin.getDefault().collect().i(ss);
                    ++var10_28;
                }
            }
            FontFactory.restoreDefaultFontsOnThisThread();
            MemoryMonitor.getInstance().stopMemoryMonitor();
            ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)this.model.getProject(), 8, -2000);
            var14_3 = Status.OK_STATUS;
            return var14_3;
        }
        return Status.CANCEL_STATUS;
    }

    private void setPreferencesForPreview() {
        this.model.enablePreviewMode();
        this.model.setRawLocation(SpecadorPreviewListener.INSTANCE.getLocation().getAbsolutePath());
        this.model.setOutputFormat(SpecadorModel.OutputFormat.HTML);
        this.model.setExportSourceCode(false);
        if (this.model.getPreferencesFile() == null || !this.model.getPreferencesFile().exists()) {
            this.model.setDocFormattingType(DVTComment.CommentFormat.parse(PrefConst.getTooltipMarkupLanguage()));
            this.model.setDesignBlockDiagram(true);
            this.model.setUMLCollaborationDiagram(true);
        }
    }

    private void openHTMLFileInBrowser(SpecadorProgressMonitor specadorMonitor, File indexFile) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                if (specadorMonitor.isCanceled() || specadorMonitor.getExitCodeValue() != SpecadorExitCode.SUCCESS) {
                    DVTLogger.INSTANCE.logError("Specador HTML Preview exit code: " + specadorMonitor.getExitCode());
                    return;
                }
                if (this.generateHTMLPreview) {
                    IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ro.amiq.dvt.wizards.htmldoc.SpecadorPreviewBrowser", null, 2);
                    if (!(view instanceof SpecadorPreviewView)) {
                        return;
                    }
                    BuildEventManager.getInstance().registerListener(SpecadorPreviewListener.INSTANCE);
                    SpecadorPreviewListener.INSTANCE.setModel(this.model);
                    SpecadorPreviewListener.INSTANCE.setView((SpecadorPreviewView)view);
                    ((SpecadorPreviewView)view).openURL("file://" + indexFile);
                } else {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    if (browserSupport == null || !browserSupport.isInternalWebBrowserAvailable() || !EclipseUtils.hasWorkingBrowser()) {
                        return;
                    }
                    IWebBrowser browser = browserSupport.createBrowser(46, "SpecadorBrowser_" + this.model.getProject().getName(), null, null);
                    browser.openURL(new URL("file://" + indexFile.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    public boolean belongsTo(Object family) {
        return SpecadorJob.class.equals(family);
    }
}

