/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.specador.templates.SpecadorGenerator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtils;
import ro.amiq.dvt.utils.ProgressPrinter;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.wizards.specador.SpecadorModel;

public enum SpecadorManager {
    INSTANCE;

    public static final String DEFAULT_PREF_FILE_NAME = "specador_preferences.xml";
    public static final String DEFAULT_DOCUMENTATION_TITLE = "API Specification";
    public static final String DEFAULT_OVERVIEW_FILE_NAME = "README.txt";
    private String fCurrentDocumentationLocation = "";
    private HashMap<String, IBuildDoneListener.BuildFinishReason> buildCancelMap = new HashMap(1);

    public String getCurrentDocumentationLocation() {
        return this.fCurrentDocumentationLocation;
    }

    public void buildCancelUpdate(String projectName, IBuildDoneListener.BuildFinishReason buildFinishReason) {
        if (projectName == null) {
            return;
        }
        if (IBuildDoneListener.BuildFinishReason.isSuccessful(buildFinishReason)) {
            this.buildCancelMap.remove(projectName);
            return;
        }
        this.buildCancelMap.put(projectName, buildFinishReason);
    }

    public synchronized boolean wasBuildCanceled(IProject project) {
        if (project == null) {
            return false;
        }
        String projectName = project.getName();
        if (projectName == null || projectName.isEmpty()) {
            return false;
        }
        return IBuildDoneListener.BuildFinishReason.isCanceled(this.buildCancelMap.get(projectName));
    }

    public static String getVersion() {
        return Utils.getVersion();
    }

    public static List<String> getProjectNatures(IProject project) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            if (project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                result.add("ro.amiq.vlogdt.VlogNature");
            }
            if (project.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                result.add("ro.amiq.vhdldt.VhdlNature");
            }
            if (project.hasNature("ro.amiq.edt.enature")) {
                result.add("ro.amiq.edt.enature");
            }
            if (project.hasNature("ro.amiq.slndt.slnnature")) {
                result.add("ro.amiq.slndt.slnnature");
            }
            if (project.hasNature("ro.amiq.msdldt.msdlnature")) {
                result.add("ro.amiq.msdldt.msdlnature");
            }
            if (project.hasNature("ro.amiq.pssdt.pssnature")) {
                result.add("ro.amiq.pssdt.pssnature");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public static void recursiveClean(File directory) {
        try {
            File[] files = directory.listFiles();
            if (files == null) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    SpecadorManager.recursiveClean(file);
                }
                Files.delete(file.toPath());
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static boolean checkLicense(SpecadorModel model) {
        if (model.isPreviewMode()) {
            return true;
        }
        String[] features = SpecadorManager.getFeatures(model.getProject());
        return DVTSplashMLT.INSTANCE.cc(features);
    }

    public static String[] getFeatures(IProject project) {
        ArrayList<String> s = new ArrayList<String>();
        try {
            if (project.hasNature("ro.amiq.edt.enature")) {
                s.add("F655F7370656361646F72");
            }
            if (project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                s.add("F73765F7370656361646F72");
            }
            if (project.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                s.add("F7668646C5F7370656361646F72");
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        return s.toArray(new String[s.size()]);
    }

    public static String getHyperlinkForDiagrams(IRfNamedElement namedElement, LanguageKind modelNature) {
        LanguageKind elementNature = namedElement.getLanguageKind();
        if (elementNature == null) {
            return null;
        }
        SpecadorModel model = LanguageContributor.get(elementNature).getModel();
        String url = SpecadorGenerator.getHyperlink(namedElement, elementNature);
        if (url.isEmpty()) {
            return url;
        }
        return String.valueOf(File.separator) + model.getOutputFolderName() + File.separator + url;
    }

    public void logError(IProject project, Exception e) {
        String messageToPrint = SpecadorConstants.getMessage(SpecadorConstants.errorMessage, e.getMessage());
        ProgressPrinter.INSTANCE.printProgressRaw(project, messageToPrint);
        DVTLogger.INSTANCE.logError((Throwable)e);
    }

    public static void displayFailMessage(String message) {
        SmartCopyUtils.updateStatusBarWithError(message);
    }
}

