/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.diagrams.netlist.utils.NLFilterSet;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.SpecadorProgressMonitor;
import ro.amiq.dvt.specador.api.annotations.PreferenceTag;
import ro.amiq.dvt.specador.api.annotations.PreferenceTagAnnotation;
import ro.amiq.dvt.specador.templates.ILibraryWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.wizards.specador.SpecadorXMLParser;
import ro.amiq.dvt.wizards.specador.SpecadorXMLParser7;

public class SpecadorModel {
    private SpecadorModel outsideProjectModel;
    private SpecadorXMLParser parser;
    @PreferenceTagAnnotation(tag=PreferenceTag.DUMMY_GENERAL_OPTIONS)
    public String fDummyGeneralOptions;
    @PreferenceTagAnnotation(tag=PreferenceTag.OUTPUT_FORMAT)
    public OutputFormat fOutputFormat;
    @PreferenceTagAnnotation(tag=PreferenceTag.LOCATION)
    public String fRawLocation;
    private String fLocation;
    @PreferenceTagAnnotation(tag=PreferenceTag.OUTPUT_FOLDER_NAME)
    public String fOutputFolderName;
    @PreferenceTagAnnotation(tag=PreferenceTag.CLEAN_LOCATION)
    public boolean fCleanLocation;
    @PreferenceTagAnnotation(tag=PreferenceTag.OPEN_IN_BROWSER)
    public boolean fOpenInBrowser;
    @PreferenceTagAnnotation(tag=PreferenceTag.TITLE)
    public String fTitle;
    @PreferenceTagAnnotation(tag=PreferenceTag.AUTHOR)
    public String fAuthor;
    @PreferenceTagAnnotation(tag=PreferenceTag.COPYRIGHT)
    public String fCopyright;
    @PreferenceTagAnnotation(tag=PreferenceTag.VERSION)
    public String fVersion;
    @PreferenceTagAnnotation(tag=PreferenceTag.OVERVIEW_FILE)
    public String fOverviewFile;
    @PreferenceTagAnnotation(tag=PreferenceTag.ENHANCE_COMMENTS)
    public boolean fEnhanceComments;
    @PreferenceTagAnnotation(tag=PreferenceTag.DOC_FORMATTING_TYPE)
    public String fDocFormattingType;
    @PreferenceTagAnnotation(tag=PreferenceTag.CUSTOM_CSS_FILE)
    public String fCustomCssFile;
    @PreferenceTagAnnotation(tag=PreferenceTag.CUSTOM_JS_FILE)
    public String fCustomJsFile;
    @PreferenceTagAnnotation(tag=PreferenceTag.CUSTOM_INDEX_FILE)
    public String fCustomIndexFile;
    @PreferenceTagAnnotation(tag=PreferenceTag.USER_DEFINED_HTML)
    public String fUserDefinedHTML;
    @PreferenceTagAnnotation(tag=PreferenceTag.CREATED_BY_USER_WATERMARK)
    public boolean fCreatedByWatermark;
    @PreferenceTagAnnotation(tag=PreferenceTag.PUBLIC_ONLY)
    public boolean fPublicOnly;
    @PreferenceTagAnnotation(tag=PreferenceTag.FILTER_STRING)
    public String fFiltersString;
    @PreferenceTagAnnotation(tag=PreferenceTag.FILTER_PATH)
    public Map<String, StringMatcher> fFilterPaths = new HashMap<String, StringMatcher>();
    @PreferenceTagAnnotation(tag=PreferenceTag.ATTACH_PATH)
    public Map<String, String> fAttachedPaths = new HashMap<String, String>();
    @PreferenceTagAnnotation(tag=PreferenceTag.INCLUDE_PATH)
    public Map<String, StringMatcher> fIncludePaths = new HashMap<String, StringMatcher>();
    @PreferenceTagAnnotation(tag=PreferenceTag.FILTER_COMMENTS)
    public Set<String> fCommentFilters = new HashSet<String>();
    @PreferenceTagAnnotation(tag=PreferenceTag.FILTER_COMMENTS_START_TAG)
    public String fCommentFiltersStartTag = "";
    @PreferenceTagAnnotation(tag=PreferenceTag.FILTER_COMMENTS_END_TAG)
    public String fCommentFiltersEndTag = "";
    public CommentFilterStrategy fFilterStrategy;
    @PreferenceTagAnnotation(tag=PreferenceTag.JUST_PROJECT_FILES)
    public boolean fJustProjectFiles;
    @PreferenceTagAnnotation(tag=PreferenceTag.UML_CLASS_INHERITANCE_DIAGRAM)
    public boolean fUMLClassInheritanceDiagram;
    @PreferenceTagAnnotation(tag=PreferenceTag.UVM_TEST_DIAGRAM)
    public boolean fUvmTestDiagram;
    @PreferenceTagAnnotation(tag=PreferenceTag.UVM_COMPONENTS_DIAGRAM_DEPTH)
    public int fUvmComponentDiagramDepth;
    @PreferenceTagAnnotation(tag=PreferenceTag.UML_PACKAGE_INHERITANCE_DIAGRAM)
    public boolean fUMLPackageInheritanceDiagram;
    @PreferenceTagAnnotation(tag=PreferenceTag.UML_COLLABORATION_DIAGRAM)
    public boolean fUMLCollaborationDiagram;
    @PreferenceTagAnnotation(tag=PreferenceTag.UML_DIRECT_ASSOCIATIONS_DIAGRAM)
    public boolean fUMLDirectAssociationsDiagram;
    @PreferenceTagAnnotation(tag=PreferenceTag.ORTHOGONAL_CLASS_DIAGRAMS)
    public boolean fOrthogonalClassDiagrams;
    @PreferenceTagAnnotation(tag=PreferenceTag.BLOCK_DIAGRAM)
    public boolean fDesignBlockDiagram;
    @PreferenceTagAnnotation(tag=PreferenceTag.FLOW_DIAGRAM)
    public boolean fDesignFlowDiagram;
    @PreferenceTagAnnotation(tag=PreferenceTag.SCHEMATIC_DIAGRAM)
    public boolean fDesignSchematicDiagram;
    @PreferenceTagAnnotation(tag=PreferenceTag.DESIGN_DIAGRAM_FILTERS)
    public String fDesignDiagramFilters;
    @PreferenceTagAnnotation(tag=PreferenceTag.SUBINSTANCES_DIAGRAM)
    public boolean fDesignSubInstancesDiagram;
    @PreferenceTagAnnotation(tag=PreferenceTag.FSM_DIAGRAM)
    public boolean fFSMDiagrams;
    @PreferenceTagAnnotation(tag=PreferenceTag.FSM_DIAGRAM_DIRECTION)
    public String fFSMDiagramDirection;
    @PreferenceTagAnnotation(tag=PreferenceTag.FSM_PLACEMENT_STRATEGY)
    public String fFSMPlacementStrategy;
    @PreferenceTagAnnotation(tag=PreferenceTag.FSM_ENFORCE_EDGE_PORT_SIDE)
    public String fFSMEnforceEdgePortSide;
    @PreferenceTagAnnotation(tag=PreferenceTag.FSM_INITIAL_STATE_POSITION)
    public String fFSMInitialStatePosition;
    @PreferenceTagAnnotation(tag=PreferenceTag.FSM_SHOW_DEFAULT_STATE)
    public boolean fFSMShowDefaultState;
    @PreferenceTagAnnotation(tag=PreferenceTag.FSM_SHOW_LOOPBACK_EDGES)
    public boolean fFSMShowLoopbackEdges;
    @PreferenceTagAnnotation(tag=PreferenceTag.FSM_FILTER_COMMON_EXPRESSIONS_IN_CONDITIONS)
    public boolean fFSMFilterCommonExpressionsInConditions;
    @PreferenceTagAnnotation(tag=PreferenceTag.BITFIELD_DIAGRAM)
    public boolean fBitfieldDiagrams;
    @PreferenceTagAnnotation(tag=PreferenceTag.MAX_NOF_ELABORATED_INSTANCES)
    public int fMaxNoElaboratedInstances;
    @PreferenceTagAnnotation(tag=PreferenceTag.INSTANCE_PARAMETERS)
    public boolean fInstanceParameters;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_UNNAMED_ALWAYS_BLOCKS)
    public boolean fExportUnnamedAlwaysBlocks;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_SOURCE_CODE)
    public boolean fexportSourceCode;
    @PreferenceTagAnnotation(tag=PreferenceTag.DUMMY_LINK_PRE_GENERATED)
    public String fDummyLinkPreGenerated;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXTERNAL_DOC_PATH)
    public Map<String, String> fExternalDocPaths = new HashMap<String, String>();
    public Map<String, String> fDoxygenTagFiles = new HashMap<String, String>();
    @PreferenceTagAnnotation(tag=PreferenceTag.PROJECT_NATURE)
    public Set<String> fSelectedProjectNatures = new HashSet<String>();
    @PreferenceTagAnnotation(tag=PreferenceTag.SHOW_EXTERAL_DOC_REFS)
    public boolean fShowExternalDocRefs;
    @PreferenceTagAnnotation(tag=PreferenceTag.ORDER_PORTS)
    public boolean fOrderPorts;
    @PreferenceTagAnnotation(tag=PreferenceTag.ORDER_VARIABLES)
    public boolean fOrderVariables;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPAND_INCLUDE_DIRECTIVES)
    public boolean fExpandIncludeDirectivesInModules;
    @PreferenceTagAnnotation(tag=PreferenceTag.DUMMY_SV_SPECIFIC)
    public String fDummySVSpecific;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_MODULES)
    public boolean fExportVlogModules;
    public Set<String> fVlogLibrariesWithModules;
    public Set<String> fVlogLibrariesWithInterfaces;
    public Map<String, Set<String>> fVlogLibrariesWithPackages;
    private NLFilterSet fDesignDiagramFiltersSet;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_MODULES_VARIABLES)
    public boolean fExportVlogModulesVariables;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_INTERFACES)
    public boolean fExportVlogInterfaces;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_PROGRAMS)
    public boolean fExportVlogPrograms;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_MACROS)
    public boolean fExportVlogMacros;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_IFNDEF_GUARDS)
    public boolean fExportVlogIfndefGuards;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_CONTROL_DEFINES)
    public boolean fExportVlogControlDefines;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_GLOBAL_SCOPE)
    public boolean fExportVlogGlobalScope;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_PACKAGES)
    public boolean fExportVlogPackages;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_PACKAGES_VARIABLES)
    public boolean fExportVlogPackagesVariables;
    @PreferenceTagAnnotation(tag=PreferenceTag.VLOG_PACKAGE)
    public Set<String> fVlogSelectedPackageNames = new LinkedHashSet<String>();
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_LIBRARIES)
    public boolean fExportVlogLibraries;
    @PreferenceTagAnnotation(tag=PreferenceTag.VLOG_LIBRARY)
    public Set<String> fVlogSelectedLibraryNames = new LinkedHashSet<String>();
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_ASSERTIONS)
    public boolean fExportVlogAssertions;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_COVERGROUPS)
    public boolean fExportVlogCovergroups;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_INNER_CLASSES)
    public boolean fExportVlogInnerClasses;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_LOCALPARAMS)
    public boolean fExportVlogLocalparams;
    @PreferenceTagAnnotation(tag=PreferenceTag.HIDE_VLOG_INTERFACE_SIGNALS)
    public boolean fHideVlogInterfSignals;
    @PreferenceTagAnnotation(tag=PreferenceTag.DUMMY_VLOG_FILTER_CLASS_DIAGRAMS)
    public String fVlogFilterClassDiagramsDummy;
    @PreferenceTagAnnotation(tag=PreferenceTag.VLOG_FILTER_CLASS_DIAGRAMS)
    public List<String> fVlogFilterClassDiagrams;
    @PreferenceTagAnnotation(tag=PreferenceTag.VLOG_BRIEF_COMMENTS)
    public boolean fVlogBriefComments;
    @PreferenceTagAnnotation(tag=PreferenceTag.VLOG_FILTER_INDEX)
    public Set<String> fVlogFilterIndex;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VLOG_CLASS_INHERITED_MEMBERS)
    public boolean fExportVlogClassInheritedMembers;
    @PreferenceTagAnnotation(tag=PreferenceTag.DUMMY_VHDL_SPECIFIC)
    public String fDummyVhdlSpecific;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_VHDL_LIBRARIES)
    public boolean fExportVhdlLibraries;
    @PreferenceTagAnnotation(tag=PreferenceTag.VHDL_LIBRARY)
    public Set<String> fVhdlSelectedLibraryNames = new LinkedHashSet<String>();
    public Set<String> fVhdlLibrariesWithEntities;
    public Map<String, Set<String>> fVhdlLibrariesWithPackages;
    @PreferenceTagAnnotation(tag=PreferenceTag.DUMMY_EDT_SPECIFIC)
    public String fDummyESpecific;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_EDT_MACROS)
    public boolean fExportEdtMacros;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_EDT_PACKAGES)
    public boolean fExportEdtPackages;
    @PreferenceTagAnnotation(tag=PreferenceTag.EDT_PACKAGE)
    public Set<String> fEdtSelectedPackageNames = new LinkedHashSet<String>();
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_EDT_COVERGROUPS)
    public boolean fExportEdtCovergroups;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_EDT_CHECKS)
    public boolean fExportEdtChecks;
    @PreferenceTagAnnotation(tag=PreferenceTag.EXPORT_EDT_TESTS)
    public boolean fExportEdtTests;
    private boolean fEnablePreviewMode;
    public boolean fKeepDotFiles;
    protected SpecadorProgressMonitor fProgressMonitor;
    protected IProject fProject;
    protected Set<String> fProjectNatures = new HashSet<String>();
    protected List<IProjectChangeListener> fListeners = new ArrayList<IProjectChangeListener>();
    private File fCachedPreferencesFile;
    private Map<IRfNamedElement, List<ELInstance>> fElaboratedInstances = new HashMap<IRfNamedElement, List<ELInstance>>();

    public List<ELInstance> getElaboratedInstances(IRfNamedElement namedElement) {
        return this.fElaboratedInstances.getOrDefault(namedElement, Collections.emptyList());
    }

    private Map<IRfNamedElement, List<ELInstance>> computeElaboratedInstances(IProject project) {
        final HashMap<IRfNamedElement, List<ELInstance>> elaboratedInstances = new HashMap<IRfNamedElement, List<ELInstance>>();
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return elaboratedInstances;
        }
        IELMemory memory = elManager.getMemory();
        if (memory == null || !memory.hasBindings()) {
            return elaboratedInstances;
        }
        memory.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                List instances = elaboratedInstances.computeIfAbsent(instance.getBinding(false), k -> new ArrayList());
                if (instances.size() < SpecadorModel.this.getNoElaboratedInstances()) {
                    instances.add(instance);
                }
                return true;
            }
        });
        return elaboratedInstances;
    }

    public File getPreferencesFile() {
        return this.fCachedPreferencesFile;
    }

    public DVTPair<String, String> getCustomIndexFilePath() {
        return new DVTPair<String, String>(this.fCustomIndexFile, this.replaceEnvVars(this.fCustomIndexFile));
    }

    public void setCustomIndexFile(String rSTIndexFile) {
        this.fCustomIndexFile = rSTIndexFile;
    }

    public void setProject(IProject project) {
        this.setProject(project, true);
    }

    public void setProject(IProject project, boolean loadDefaultFile) {
        if (this.fProject == project) {
            return;
        }
        this.fProject = project;
        this.setProjectNatures();
        this.initDefaults();
        if (loadDefaultFile) {
            this.loadFromFile();
        }
        this.doPostCompileProcessing();
        this.notifyListeners(project);
    }

    public void initDefaults() {
        this.fRawLocation = PreferenceTag.LOCATION.getDefaultValue();
        this.fOutputFolderName = PreferenceTag.OUTPUT_FOLDER_NAME.getDefaultValue();
        this.fTitle = this.fProject != null ? String.valueOf(this.fProject.getName()) + " " + PreferenceTag.TITLE.getDefaultValue() : PreferenceTag.TITLE.getDefaultValue();
        this.fAuthor = "";
        this.fVersion = "";
        this.fCopyright = "";
        this.fOverviewFile = PreferenceTag.OVERVIEW_FILE.getDefaultValue();
        this.fFiltersString = PreferenceTag.FILTER_STRING.getDefaultValue();
        this.fCommentFilters = new HashSet<String>();
        this.fCommentFiltersStartTag = "";
        this.fCommentFiltersEndTag = "";
        this.fFilterStrategy = CommentFilterStrategy.ALL;
        this.fDocFormattingType = PreferenceTag.DOC_FORMATTING_TYPE.getDefaultValue();
        this.fCustomCssFile = PreferenceTag.CUSTOM_CSS_FILE.getDefaultValue();
        this.fCustomJsFile = PreferenceTag.CUSTOM_JS_FILE.getDefaultValue();
        this.fCustomIndexFile = PreferenceTag.CUSTOM_INDEX_FILE.getDefaultValue();
        this.fUserDefinedHTML = PreferenceTag.USER_DEFINED_HTML.getDefaultValue();
        this.fEnhanceComments = Boolean.parseBoolean(PreferenceTag.ENHANCE_COMMENTS.getDefaultValue());
        this.fCreatedByWatermark = Boolean.parseBoolean(PreferenceTag.CREATED_BY_USER_WATERMARK.getDefaultValue());
        this.fCleanLocation = Boolean.parseBoolean(PreferenceTag.CLEAN_LOCATION.getDefaultValue());
        this.fOpenInBrowser = Boolean.parseBoolean(PreferenceTag.OPEN_IN_BROWSER.getDefaultValue());
        this.fPublicOnly = Boolean.parseBoolean(PreferenceTag.PUBLIC_ONLY.getDefaultValue());
        this.fJustProjectFiles = Boolean.parseBoolean(PreferenceTag.JUST_PROJECT_FILES.getDefaultValue());
        this.fShowExternalDocRefs = Boolean.parseBoolean(PreferenceTag.SHOW_EXTERAL_DOC_REFS.getDefaultValue());
        this.fOutputFormat = OutputFormat.valueOf(PreferenceTag.OUTPUT_FORMAT.getDefaultValue().toUpperCase());
        this.fUMLCollaborationDiagram = Boolean.parseBoolean(PreferenceTag.UML_COLLABORATION_DIAGRAM.getDefaultValue());
        this.fUMLDirectAssociationsDiagram = Boolean.parseBoolean(PreferenceTag.UML_DIRECT_ASSOCIATIONS_DIAGRAM.getDefaultValue());
        this.fUMLClassInheritanceDiagram = Boolean.parseBoolean(PreferenceTag.UML_CLASS_INHERITANCE_DIAGRAM.getDefaultValue());
        this.fUMLPackageInheritanceDiagram = Boolean.parseBoolean(PreferenceTag.UML_PACKAGE_INHERITANCE_DIAGRAM.getDefaultValue());
        this.fOrthogonalClassDiagrams = Boolean.parseBoolean(PreferenceTag.ORTHOGONAL_CLASS_DIAGRAMS.getDefaultValue());
        this.fDesignBlockDiagram = Boolean.parseBoolean(PreferenceTag.BLOCK_DIAGRAM.getDefaultValue());
        this.fDesignFlowDiagram = Boolean.parseBoolean(PreferenceTag.FLOW_DIAGRAM.getDefaultValue());
        this.fDesignSchematicDiagram = Boolean.parseBoolean(PreferenceTag.SCHEMATIC_DIAGRAM.getDefaultValue());
        this.fDesignDiagramFilters = PreferenceTag.DESIGN_DIAGRAM_FILTERS.getDefaultValue();
        this.fDesignSubInstancesDiagram = Boolean.parseBoolean(PreferenceTag.SUBINSTANCES_DIAGRAM.getDefaultValue());
        try {
            this.fUvmComponentDiagramDepth = Integer.parseInt(PreferenceTag.UVM_COMPONENTS_DIAGRAM_DEPTH.getDefaultValue());
        }
        catch (NumberFormatException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.fFSMDiagrams = Boolean.parseBoolean(PreferenceTag.FSM_DIAGRAM.getDefaultValue());
        this.fFSMDiagramDirection = PreferenceTag.FSM_DIAGRAM_DIRECTION.getDefaultValue();
        this.fFSMPlacementStrategy = PreferenceTag.FSM_PLACEMENT_STRATEGY.getDefaultValue();
        this.fFSMEnforceEdgePortSide = PreferenceTag.FSM_ENFORCE_EDGE_PORT_SIDE.getDefaultValue();
        this.fFSMInitialStatePosition = PreferenceTag.FSM_INITIAL_STATE_POSITION.getDefaultValue();
        this.fFSMShowDefaultState = Boolean.parseBoolean(PreferenceTag.FSM_SHOW_DEFAULT_STATE.getDefaultValue());
        this.fFSMShowLoopbackEdges = Boolean.parseBoolean(PreferenceTag.FSM_SHOW_LOOPBACK_EDGES.getDefaultValue());
        this.fFSMFilterCommonExpressionsInConditions = Boolean.parseBoolean(PreferenceTag.FSM_FILTER_COMMON_EXPRESSIONS_IN_CONDITIONS.getDefaultValue());
        this.fexportSourceCode = Boolean.parseBoolean(PreferenceTag.EXPORT_SOURCE_CODE.getDefaultValue());
        this.fOrderPorts = Boolean.parseBoolean(PreferenceTag.ORDER_PORTS.getDefaultValue());
        this.fOrderVariables = Boolean.parseBoolean(PreferenceTag.ORDER_VARIABLES.getDefaultValue());
        this.fInstanceParameters = Boolean.parseBoolean(PreferenceTag.INSTANCE_PARAMETERS.getDefaultValue());
        this.fExportUnnamedAlwaysBlocks = Boolean.parseBoolean(PreferenceTag.EXPORT_UNNAMED_ALWAYS_BLOCKS.getDefaultValue());
        this.fVlogSelectedPackageNames = new LinkedHashSet<String>();
        this.fVlogSelectedLibraryNames = new LinkedHashSet<String>();
        this.fExportVlogGlobalScope = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_GLOBAL_SCOPE.getDefaultValue());
        this.fExportVlogPackages = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_PACKAGES.getDefaultValue());
        this.fExportVlogLibraries = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_LIBRARIES.getDefaultValue());
        this.fExportVlogModules = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_MODULES.getDefaultValue());
        this.fVlogLibrariesWithModules = new LinkedHashSet<String>();
        this.fVlogLibrariesWithInterfaces = new LinkedHashSet<String>();
        this.fVlogLibrariesWithPackages = new LinkedHashMap<String, Set<String>>();
        this.fExportVlogModulesVariables = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_MODULES_VARIABLES.getDefaultValue());
        this.fExportVlogPackagesVariables = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_PACKAGES_VARIABLES.getDefaultValue());
        this.fExportVlogInterfaces = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_INTERFACES.getDefaultValue());
        this.fExportVlogPrograms = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_PROGRAMS.getDefaultValue());
        this.fExportVlogMacros = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_MACROS.getDefaultValue());
        this.fExportVlogIfndefGuards = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_IFNDEF_GUARDS.getDefaultValue());
        this.fExportVlogControlDefines = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_CONTROL_DEFINES.getDefaultValue());
        this.fExportVlogAssertions = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_ASSERTIONS.getDefaultValue());
        this.fExportVlogCovergroups = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_COVERGROUPS.getDefaultValue());
        this.fExportVlogInnerClasses = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_INNER_CLASSES.getDefaultValue());
        this.fExportVlogLocalparams = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_LOCALPARAMS.getDefaultValue());
        this.fVlogFilterClassDiagrams = new ArrayList<String>();
        this.fHideVlogInterfSignals = Boolean.parseBoolean(PreferenceTag.HIDE_VLOG_INTERFACE_SIGNALS.getDefaultValue());
        this.fVlogBriefComments = Boolean.parseBoolean(PreferenceTag.VLOG_BRIEF_COMMENTS.getDefaultValue());
        this.fVlogFilterIndex = new HashSet<String>();
        this.fExpandIncludeDirectivesInModules = Boolean.parseBoolean(PreferenceTag.EXPAND_INCLUDE_DIRECTIVES.getDefaultValue());
        this.fExportVlogClassInheritedMembers = Boolean.parseBoolean(PreferenceTag.EXPORT_VLOG_CLASS_INHERITED_MEMBERS.getDefaultValue());
        try {
            this.fMaxNoElaboratedInstances = Integer.parseInt(PreferenceTag.MAX_NOF_ELABORATED_INSTANCES.getDefaultValue());
        }
        catch (NumberFormatException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.fEdtSelectedPackageNames = new LinkedHashSet<String>();
        this.fExportEdtMacros = Boolean.parseBoolean(PreferenceTag.EXPORT_EDT_MACROS.getDefaultValue());
        this.fExportEdtCovergroups = Boolean.parseBoolean(PreferenceTag.EXPORT_EDT_COVERGROUPS.getDefaultValue());
        this.fExportEdtChecks = Boolean.parseBoolean(PreferenceTag.EXPORT_EDT_CHECKS.getDefaultValue());
        this.fExportEdtPackages = Boolean.parseBoolean(PreferenceTag.EXPORT_EDT_PACKAGES.getDefaultValue());
        this.fExportEdtTests = Boolean.parseBoolean(PreferenceTag.EXPORT_EDT_TESTS.getDefaultValue());
        this.fVhdlSelectedLibraryNames = new LinkedHashSet<String>();
        this.fExportVhdlLibraries = Boolean.parseBoolean(PreferenceTag.EXPORT_VHDL_LIBRARIES.getDefaultValue());
        this.fVhdlLibrariesWithEntities = new LinkedHashSet<String>();
        this.fVhdlLibrariesWithPackages = new LinkedHashMap<String, Set<String>>();
        this.populateDefaultVlogLibraries();
        this.populateDefaultVhdlLibraries();
    }

    public void removeProjectNature(String nature) {
        this.fProjectNatures.remove(nature);
    }

    private void setProjectNatures() {
        try {
            this.fProjectNatures = new HashSet<String>();
            if (this.fProject.hasNature("ro.amiq.edt.enature")) {
                this.fProjectNatures.add("ro.amiq.edt.enature");
            }
            if (this.fProject.hasNature("ro.amiq.vlogdt.VlogNature")) {
                this.fProjectNatures.add("ro.amiq.vlogdt.VlogNature");
            }
            if (this.fProject.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                this.fProjectNatures.add("ro.amiq.vhdldt.VhdlNature");
            }
            this.setSelectedProjectNatures(new HashSet<String>(this.fProjectNatures));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Set<String> getProjectNatures() {
        return this.fProjectNatures;
    }

    public void setSelectedProjectNatures(Set<String> natures) {
        this.fSelectedProjectNatures = new HashSet<String>();
        for (String nature : natures) {
            if (!this.fProjectNatures.contains(nature)) continue;
            this.fSelectedProjectNatures.add(nature);
        }
    }

    public boolean isMixed() {
        return this.fSelectedProjectNatures.size() > 1;
    }

    public Set<String> getSelectedProjectNatures() {
        return this.fSelectedProjectNatures;
    }

    public boolean hasVlogNature() {
        return this.fProjectNatures.contains("ro.amiq.vlogdt.VlogNature");
    }

    public boolean hasEdtNature() {
        return this.fProjectNatures.contains("ro.amiq.edt.enature");
    }

    public boolean hasVhdlNature() {
        return this.fProjectNatures.contains("ro.amiq.vhdldt.VhdlNature");
    }

    public boolean isVlogNatureSelected() {
        return this.fSelectedProjectNatures.contains("ro.amiq.vlogdt.VlogNature");
    }

    public boolean isEdtNatureSelected() {
        return this.fSelectedProjectNatures.contains("ro.amiq.edt.enature");
    }

    public boolean isVhdlNatureSelected() {
        return this.fSelectedProjectNatures.contains("ro.amiq.vhdldt.VhdlNature");
    }

    public void setProjectBatch(IProject project) {
        this.fProject = project;
        this.setProjectNatures();
    }

    public void notifyListeners(IProject project) {
        for (IProjectChangeListener listener : this.fListeners) {
            listener.projectChanged(project);
        }
    }

    public void addProjectChangeListener(IProjectChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeProjectChangeListener(IProjectChangeListener listener) {
        this.fListeners.remove(listener);
    }

    public IProject getProject() {
        return this.fProject;
    }

    private String resolveAndNormalizeLocation(String baseLocation, String relativeLocation) {
        return Paths.get(baseLocation, new String[0]).resolve(this.replaceEnvVars(relativeLocation)).normalize().toString();
    }

    private void calculateLocation(String rawLocation) {
        String projectPath = this.getProject().getLocation().toOSString();
        this.fLocation = rawLocation.isEmpty() || rawLocation.equals("specador_docs") ? projectPath : this.resolveAndNormalizeLocation(projectPath, rawLocation);
    }

    public void setRawLocation(String location) {
        this.fRawLocation = location;
        this.calculateLocation(location);
    }

    public String getRawLocation() {
        return this.fRawLocation;
    }

    public String getLocation() {
        if (this.fLocation == null) {
            this.calculateLocation(this.fRawLocation);
        }
        return this.fLocation;
    }

    public void setTitleText(String titleText) {
        this.fTitle = titleText;
    }

    public String getTitleText() {
        return this.fTitle;
    }

    public String getAuthor() {
        return this.fAuthor;
    }

    public void setAuthor(String fAuthor) {
        this.fAuthor = fAuthor;
    }

    public String getCopyright() {
        return this.fCopyright;
    }

    public void setCopyright(String fCopyright) {
        this.fCopyright = fCopyright;
    }

    public String getOutputFolderName() {
        return this.fOutputFolderName;
    }

    public void setOutputFolderName(String fOutputFolderName) {
        this.fOutputFolderName = fOutputFolderName;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public void setVersion(String fVersion) {
        this.fVersion = fVersion;
    }

    public void setOverviewFile(String overviewFile) {
        this.fOverviewFile = overviewFile;
    }

    public String getOverviewFile() {
        return this.fOverviewFile;
    }

    public void setEnhanceComments(boolean enhanceComments) {
        this.fEnhanceComments = enhanceComments;
    }

    public boolean isEnhanceComments() {
        return this.fEnhanceComments;
    }

    public void setCreatedByWatermark(boolean createdByWatermark) {
        this.fCreatedByWatermark = createdByWatermark;
    }

    public boolean isCreatedByWatermark() {
        return this.fCreatedByWatermark;
    }

    public void setCleanLocation(boolean cleanLocation) {
        this.fCleanLocation = cleanLocation;
    }

    public boolean isCleanLocation() {
        return this.fCleanLocation;
    }

    public boolean isForPDF() {
        return this.getOutputFormat().equals((Object)OutputFormat.PDF);
    }

    public void setExportSourceCode(boolean includeHTML) {
        this.fexportSourceCode = includeHTML;
    }

    public boolean getExportSourceCode() {
        return this.fexportSourceCode;
    }

    public void setOpenInBrowser(boolean openInBrowser) {
        this.fOpenInBrowser = openInBrowser;
    }

    public boolean isOpenInBrowser() {
        return this.fOpenInBrowser;
    }

    public void setPublicOnlyAPI(boolean publicOnly) {
        this.fPublicOnly = publicOnly;
    }

    public boolean isPublicOnlyAPI() {
        return this.fPublicOnly;
    }

    public void setJustProjectFiles(boolean justProjectFiles) {
        this.fJustProjectFiles = justProjectFiles;
    }

    public boolean isJustProjectFiles() {
        return this.fJustProjectFiles;
    }

    public void setFiltersString(String filtersString) {
        this.fFiltersString = filtersString;
    }

    public String getFiltersString() {
        return this.fFiltersString;
    }

    public void setUMLPackageInheritanceDiagram(boolean umlInheritanceDiagram) {
        this.fUMLPackageInheritanceDiagram = umlInheritanceDiagram;
    }

    public boolean getUMLPackageInheritanceDiagram() {
        return this.fUMLPackageInheritanceDiagram;
    }

    public boolean getUvmTestDiagram() {
        return this.fUvmTestDiagram;
    }

    public void setUvmTestDiagram(boolean selection) {
        this.fUvmTestDiagram = selection;
    }

    public int getUvmComponentDiagramDepth() {
        return this.fUvmComponentDiagramDepth;
    }

    public void setUvmComponentDiagramDepth(int fUvmComponentDiagramDepth) {
        this.fUvmComponentDiagramDepth = fUvmComponentDiagramDepth;
    }

    public void setUMLClassInheritanceDiagram(boolean umlPackageInheritanceDiagram) {
        this.fUMLClassInheritanceDiagram = umlPackageInheritanceDiagram;
    }

    public boolean getUMLClassInheritanceDiagram() {
        return this.fUMLClassInheritanceDiagram;
    }

    public void setUMLCollaborationDiagram(boolean umlCollaborationDiagram) {
        this.fUMLCollaborationDiagram = umlCollaborationDiagram;
    }

    public boolean getUMLCollaborationDiagram() {
        return this.fUMLCollaborationDiagram;
    }

    public void setUMLDirectAssociationsDiagram(boolean umlDirectAssociationsDiagram) {
        this.fUMLDirectAssociationsDiagram = umlDirectAssociationsDiagram;
    }

    public boolean getUMLDirectAssociationsDiagram() {
        return this.fUMLDirectAssociationsDiagram;
    }

    public void setOrthogonalClassDiagrams(boolean orthogonalDiagrams) {
        this.fOrthogonalClassDiagrams = orthogonalDiagrams;
    }

    public boolean getOrthogonalClassDiagrams() {
        return this.fOrthogonalClassDiagrams;
    }

    public void setDesignBlockDiagram(boolean designBlockDiagram) {
        this.fDesignBlockDiagram = designBlockDiagram;
    }

    public boolean getDesignBlockDiagram() {
        return this.fDesignBlockDiagram;
    }

    public void setDesignFlowDiagram(boolean designFlowDiagram) {
        this.fDesignFlowDiagram = designFlowDiagram;
    }

    public boolean getDesignFlowDiagram() {
        return this.fDesignFlowDiagram;
    }

    public void setDesignSchematicDiagram(boolean designSchematicDiagram) {
        this.fDesignSchematicDiagram = designSchematicDiagram;
    }

    public boolean getDesignSchematicDiagram() {
        return this.fDesignSchematicDiagram;
    }

    public void setDesignDiagramFilters(String schematicDiagramFilters) {
        this.fDesignDiagramFilters = schematicDiagramFilters;
    }

    public String getDesignDiagramFilters() {
        return this.fDesignDiagramFilters;
    }

    public void setDesignSubInstancesDiagram(boolean selection) {
        this.fDesignSubInstancesDiagram = selection;
    }

    public boolean getDesignSubInstancesDiagram() {
        return this.fDesignSubInstancesDiagram;
    }

    public void setBitfieldDiagram(boolean bitfieldDiagram) {
        this.fBitfieldDiagrams = bitfieldDiagram;
    }

    public boolean getBitfieldDiagram() {
        return this.fBitfieldDiagrams;
    }

    public void setNoElaboratedInstances(int maxNoElaboratedInstances) {
        this.fMaxNoElaboratedInstances = maxNoElaboratedInstances;
    }

    public int getNoElaboratedInstances() {
        return this.fMaxNoElaboratedInstances;
    }

    public void setExportInstanceParameters(boolean fInstanceParameters) {
        this.fInstanceParameters = fInstanceParameters;
    }

    public boolean isExportInstanceParameters() {
        return this.fInstanceParameters;
    }

    public void setExportUnnamedAlwaysBlocks(boolean fExportUnnamedAlwaysBlocks) {
        this.fExportUnnamedAlwaysBlocks = fExportUnnamedAlwaysBlocks;
    }

    public boolean isExportUnnamedAlwaysBlocks() {
        return this.fExportUnnamedAlwaysBlocks;
    }

    public void setFSMDiagram(boolean fFSMDiagrams) {
        this.fFSMDiagrams = fFSMDiagrams;
    }

    public boolean getFSMDiagrams() {
        return this.fFSMDiagrams;
    }

    public void setFSMDiagramDirection(String fFSMDiagramDirection) {
        this.fFSMDiagramDirection = fFSMDiagramDirection;
    }

    public String getFSMDiagramDirection() {
        return this.fFSMDiagramDirection;
    }

    public void setFSMPlacementStrategy(String fFSMPlacementStrategy) {
        this.fFSMPlacementStrategy = fFSMPlacementStrategy;
    }

    public String getFSMPlacementStrategy() {
        return this.fFSMPlacementStrategy;
    }

    public void setFSMEnforceEdgePortSide(String fFSMEnforceEdgePortSide) {
        this.fFSMEnforceEdgePortSide = fFSMEnforceEdgePortSide;
    }

    public String getFSMEnforceEdgePortSide() {
        return this.fFSMEnforceEdgePortSide;
    }

    public void setFSMInitialStatePosition(String fFSMInitialStatePosition) {
        this.fFSMInitialStatePosition = fFSMInitialStatePosition;
    }

    public String getFSMInitialStatePosition() {
        return this.fFSMInitialStatePosition;
    }

    public void setFSMShowDefaultState(boolean fFSMShowDefaultState) {
        this.fFSMShowDefaultState = fFSMShowDefaultState;
    }

    public boolean getFSMShowDefaultState() {
        return this.fFSMShowDefaultState;
    }

    public void setFSMShowLoopbackEdges(boolean fFSMShowLoopbackEdges) {
        this.fFSMShowLoopbackEdges = fFSMShowLoopbackEdges;
    }

    public boolean getFSMFilterCommonExpressionsInConditions() {
        return this.fFSMFilterCommonExpressionsInConditions;
    }

    public void setFSMFilterCommonExpressionsInConditions(boolean fFSMFilterCommonExpressionsInConditions) {
        this.fFSMFilterCommonExpressionsInConditions = fFSMFilterCommonExpressionsInConditions;
    }

    public boolean getFSMShowLoopbackEdges() {
        return this.fFSMShowLoopbackEdges;
    }

    public void setOrderPorts(boolean fSortPorts) {
        this.fOrderPorts = fSortPorts;
    }

    public boolean isOrderPortsEnabled() {
        return this.fOrderPorts;
    }

    public void setOrderVariables(boolean fOrderVariables) {
        this.fOrderVariables = fOrderVariables;
    }

    public boolean isOrderVariablesEnabled() {
        return this.fOrderVariables;
    }

    public void setExpandIncludeDirectivesInModules(boolean expand) {
        this.fExpandIncludeDirectivesInModules = expand;
    }

    public boolean hasExpandIncludeDirectivesInModules() {
        return this.fExpandIncludeDirectivesInModules;
    }

    public void setHideVlogInterfSignals(boolean hideVlogSignals) {
        this.fHideVlogInterfSignals = hideVlogSignals;
    }

    public boolean isHideVlogInterfSignals() {
        return this.fHideVlogInterfSignals;
    }

    public void setExportVlogModules(boolean exportVlogModules) {
        this.fExportVlogModules = exportVlogModules;
    }

    public boolean isExportVlogModules() {
        return this.fExportVlogModules;
    }

    public void setVlogLibrariesWithModules(Set<String> librariesWithModules) {
        this.fVlogLibrariesWithModules = librariesWithModules;
    }

    public void addVlogLibraryWithModules(String libraryName) {
        this.fVlogLibrariesWithModules.add(libraryName);
    }

    public void removeVlogLibraryWithModules(String libraryName) {
        this.fVlogLibrariesWithModules.remove(libraryName);
    }

    public Set<String> getVlogLibrariesWithModules() {
        return this.fVlogLibrariesWithModules;
    }

    public void setVlogLibrariesWithInterfaces(Set<String> librariesWithInterfaces) {
        this.fVlogLibrariesWithInterfaces = librariesWithInterfaces;
    }

    public void addVlogLibraryWithInterfaces(String libraryName) {
        this.fVlogLibrariesWithInterfaces.add(libraryName);
    }

    public void removeVlogLibraryWithInterfaces(String libraryName) {
        this.fVlogLibrariesWithInterfaces.remove(libraryName);
    }

    public Set<String> getVlogLibrariesWithInterfaces() {
        return this.fVlogLibrariesWithInterfaces;
    }

    public void setVlogLibrariesWithPackages(Map<String, Set<String>> librariesWithPackages) {
        this.fVlogLibrariesWithPackages = librariesWithPackages;
    }

    public void addVlogPackageFromLibrary(String libraryName, String packageName) {
        if (!this.fVlogLibrariesWithPackages.containsKey(libraryName)) {
            this.fVlogLibrariesWithPackages.put(libraryName, new HashSet());
        }
        this.fVlogLibrariesWithPackages.get(libraryName).add(packageName);
    }

    public void addVlogPackagesFromLibrary(String libraryName) {
        List allVlogLibraries = this.getAllVlogLibraries().stream().filter(lib -> lib.getName().equals(libraryName)).collect(Collectors.toList());
        if (allVlogLibraries.isEmpty()) {
            return;
        }
        ILibraryWrapper library = (ILibraryWrapper)allVlogLibraries.get(0);
        if (library == null) {
            return;
        }
        if (!this.fVlogLibrariesWithPackages.containsKey(libraryName)) {
            this.fVlogLibrariesWithPackages.put(libraryName, new HashSet());
        }
        this.fVlogLibrariesWithPackages.get(libraryName).addAll(library.getPackageNames(this.hasVlogNature()));
    }

    public void removeVlogPackageFromLibrary(String libraryName, String packageName) {
        if (!this.fVlogLibrariesWithPackages.containsKey(libraryName)) {
            return;
        }
        this.fVlogLibrariesWithPackages.get(libraryName).remove(packageName);
    }

    public Map<String, Set<String>> getVlogLibrariesWithPackages() {
        return this.fVlogLibrariesWithPackages;
    }

    public void setExportVlogModulesVariables(boolean exportVlogModulesVariables) {
        this.fExportVlogModulesVariables = exportVlogModulesVariables;
    }

    public boolean isExportVlogModulesVariables() {
        return this.fExportVlogModulesVariables;
    }

    public void setExportVlogPackagesVariables(boolean exportVlogPackagesVariables) {
        this.fExportVlogPackagesVariables = exportVlogPackagesVariables;
    }

    public boolean isExportVlogPackagesVariables() {
        return this.fExportVlogPackagesVariables;
    }

    public void setExportVlogInterfaces(boolean exportVlogInterfaces) {
        this.fExportVlogInterfaces = exportVlogInterfaces;
    }

    public boolean isExportVlogInterfaces() {
        return this.fExportVlogInterfaces;
    }

    public void setExportVlogPrograms(boolean exportVlogPrograms) {
        this.fExportVlogPrograms = exportVlogPrograms;
    }

    public boolean isExportVlogPrograms() {
        return this.fExportVlogPrograms;
    }

    public void setExportVlogMacros(boolean exportVlogMacros) {
        this.fExportVlogMacros = exportVlogMacros;
    }

    public boolean isExportVlogMacros() {
        return this.fExportVlogMacros;
    }

    public void setExportVlogIfndefGuards(boolean exportVlogIfndefGuards) {
        this.fExportVlogIfndefGuards = exportVlogIfndefGuards;
    }

    public boolean isExportVlogIfndefGuards() {
        return this.fExportVlogIfndefGuards;
    }

    public void setExportVlogControlDefines(boolean exportVlogControlDefines) {
        this.fExportVlogControlDefines = exportVlogControlDefines;
    }

    public boolean isExportVlogControlDefines() {
        return this.fExportVlogControlDefines;
    }

    public void setExportVlogAssertions(boolean exportVlogAssertions) {
        this.fExportVlogAssertions = exportVlogAssertions;
    }

    public boolean isExportVlogAssertions() {
        return this.fExportVlogAssertions;
    }

    public void setExportVlogCovergroups(boolean exportVlogCovergroups) {
        this.fExportVlogCovergroups = exportVlogCovergroups;
    }

    public boolean isExportVlogCovergroups() {
        return this.fExportVlogCovergroups;
    }

    public void setExportVlogInnerClasses(boolean exportVlogInnerClasses) {
        this.fExportVlogInnerClasses = exportVlogInnerClasses;
    }

    public boolean isExportVlogInnerClasses() {
        return this.fExportVlogInnerClasses;
    }

    public void setExportVlogLocalparams(boolean exportVlogLocalparams) {
        this.fExportVlogLocalparams = exportVlogLocalparams;
    }

    public boolean isExportVlogLocalparams() {
        return this.fExportVlogLocalparams;
    }

    public void setExportVlogPackages(boolean exportVlogPackages) {
        this.fExportVlogPackages = exportVlogPackages;
    }

    public boolean isExportVlogPackages() {
        return this.fExportVlogPackages;
    }

    public void setExportVlogLibraries(boolean exportVlogLibraries) {
        this.fExportVlogLibraries = exportVlogLibraries;
    }

    public boolean isExportVlogLibraries() {
        return this.fExportVlogLibraries;
    }

    public void setExportVlogGlobalScope(boolean exportVlogGlobalScope) {
        this.fExportVlogGlobalScope = exportVlogGlobalScope;
    }

    public boolean isExportVlogGlobalScope() {
        return this.fExportVlogGlobalScope;
    }

    public void setVlogSelectedPackageNames(List<String> selectedPackageNames) {
        this.fVlogSelectedPackageNames = new LinkedHashSet<String>(selectedPackageNames);
    }

    public void removeVlogUnselectedPackages(List<String> selectedPackageNames) {
        List<String> packages = this.getAllVlogPackageNames();
        packages.removeAll(selectedPackageNames);
        for (String packageName : packages) {
            for (Set<String> packagesFromLibrary : this.fVlogLibrariesWithPackages.values()) {
                packagesFromLibrary.remove(packageName);
            }
        }
    }

    public void removeVhdlUnselectedLibraries(List<String> selectedLibrariesNames) {
        List<String> libraries = this.getAllVhdlLibraryNames();
        libraries.removeAll(selectedLibrariesNames);
        for (String libName : libraries) {
            this.fVhdlLibrariesWithEntities.remove(libName);
            this.fVhdlLibrariesWithPackages.remove(libName);
        }
    }

    public Set<String> getVlogSelectedPackageNames() {
        return this.fVlogSelectedPackageNames;
    }

    public void setVlogSelectedLibraryNames(Set<String> selectedLibraryNames) {
        this.fVlogSelectedLibraryNames = selectedLibraryNames;
    }

    public Set<String> getVlogSelectedLibraryNames() {
        return this.fVlogSelectedLibraryNames;
    }

    public void addVlogSelectedLibraryNames(String libraryName) {
        this.fVlogSelectedLibraryNames.add(libraryName);
    }

    public void removeVlogSelectedLibraryNames(String libraryName) {
        this.fVlogSelectedLibraryNames.remove(libraryName);
    }

    public void setVlogFilterClassDiagrams(List<String> filterDiagrams) {
        this.fVlogFilterClassDiagrams = filterDiagrams;
    }

    public List<String> getVlogFilterClassDiagrams() {
        return this.fVlogFilterClassDiagrams;
    }

    public void setVlogBriefComments(boolean briefComments) {
        this.fVlogBriefComments = briefComments;
    }

    public boolean getVlogBriefComments() {
        return this.fVlogBriefComments;
    }

    public void setVlogFilterIndex(List<String> filter) {
        this.fVlogFilterIndex = new HashSet<String>(filter);
    }

    public Set<String> getVlogFilterIndex() {
        return this.fVlogFilterIndex;
    }

    public void setExportVlogClassInheritedMembers(boolean exportVlogClassInheritedMembers) {
        this.fExportVlogClassInheritedMembers = exportVlogClassInheritedMembers;
    }

    public boolean isExportVlogClassInheritedMembers() {
        return this.fExportVlogClassInheritedMembers;
    }

    public void setExportVhdlLibraries(boolean exportVhdlLibraries) {
        this.fExportVhdlLibraries = exportVhdlLibraries;
    }

    public boolean isExportVhdlLibraries() {
        return this.fExportVhdlLibraries;
    }

    public void setVhdlSelectedLibraryNames(Set<String> selectedLibraryNames) {
        this.fVhdlSelectedLibraryNames = new LinkedHashSet<String>(selectedLibraryNames);
    }

    public void addVhdlSelectedLibraryNames(String libraryName) {
        this.fVhdlSelectedLibraryNames.add(libraryName);
    }

    public void removeVhdlSelectedLibraryNames(String libraryName) {
        this.fVhdlSelectedLibraryNames.remove(libraryName);
    }

    public Set<String> getVhdlSelectedLibraryNames() {
        return this.fVhdlSelectedLibraryNames;
    }

    public void setVhdlLibrariesWithEntities(Set<String> librariesWithEntities) {
        this.fVhdlLibrariesWithEntities = librariesWithEntities;
    }

    public void addVhdlLibrariesWithEntities(String libraryName) {
        this.fVhdlLibrariesWithEntities.add(libraryName);
    }

    public void removeVhdlLibrariesWithEntities(String libraryName) {
        this.fVhdlLibrariesWithEntities.remove(libraryName);
    }

    public Set<String> getVhdlLibrariesWithEntities() {
        return this.fVhdlLibrariesWithEntities;
    }

    public void setVhdlLibrariesWithPackages(Map<String, Set<String>> librariesWithPackages) {
        this.fVhdlLibrariesWithPackages = librariesWithPackages;
    }

    public void addVhdlPackageFromLibrary(String libraryName, String packageName) {
        if (!this.fVhdlLibrariesWithPackages.containsKey(libraryName)) {
            this.fVhdlLibrariesWithPackages.put(libraryName, new HashSet());
        }
        this.fVhdlLibrariesWithPackages.get(libraryName).add(packageName);
    }

    public void addVhdlPackagesFromLibrary(String libraryName) {
        List allVhdlLibraries = this.getAllVhdlLibraries().stream().filter(lib -> lib.getName().equals(libraryName)).collect(Collectors.toList());
        if (allVhdlLibraries.isEmpty()) {
            return;
        }
        ILibraryWrapper library = (ILibraryWrapper)allVhdlLibraries.get(0);
        if (library == null) {
            return;
        }
        if (!this.fVhdlLibrariesWithPackages.containsKey(libraryName)) {
            this.fVhdlLibrariesWithPackages.put(libraryName, new HashSet());
        }
        this.fVhdlLibrariesWithPackages.get(libraryName).addAll(library.getPackageNames(this.hasVhdlNature()));
    }

    public void removeVhdlPackageFromLibrary(String libraryName, String packageName) {
        if (!this.fVhdlLibrariesWithPackages.containsKey(libraryName)) {
            return;
        }
        this.fVhdlLibrariesWithPackages.get(libraryName).remove(packageName);
    }

    public Map<String, Set<String>> getVhdlLibrariesWithPackages() {
        return this.fVhdlLibrariesWithPackages;
    }

    public void setExportEdtPackages(boolean exportEdtPackages) {
        this.fExportEdtPackages = exportEdtPackages;
    }

    public boolean isExportEdtPackages() {
        return this.fExportEdtPackages;
    }

    public void setExportEdtMacros(boolean exportEdtMacros) {
        this.fExportEdtMacros = exportEdtMacros;
    }

    public boolean isExportEdtMacros() {
        return this.fExportEdtMacros;
    }

    public void setExportEdtCovergroups(boolean exportEdtCovergroups) {
        this.fExportEdtCovergroups = exportEdtCovergroups;
    }

    public boolean isExportEdtCovergroups() {
        return this.fExportEdtCovergroups;
    }

    public void setExportEdtChecks(boolean exportEdtChecks) {
        this.fExportEdtChecks = exportEdtChecks;
    }

    public boolean isExportEdtChecks() {
        return this.fExportEdtChecks;
    }

    public void setEdtSelectedPackageNames(List<String> selectedPackageNames) {
        this.fEdtSelectedPackageNames = new LinkedHashSet<String>(selectedPackageNames);
    }

    public void addEdtSelectedPackageNames(String selectedPackageName) {
        this.fEdtSelectedPackageNames.add(selectedPackageName);
    }

    public Set<String> getEdtSelectedPackageNames() {
        return this.fEdtSelectedPackageNames;
    }

    public void setExportEdtTests(boolean exportEdtTests) {
        this.fExportEdtTests = exportEdtTests;
    }

    public boolean isExportEdtTests() {
        return this.fExportEdtTests;
    }

    public File getFileFromPath(String filePath) {
        if (filePath == null) {
            return null;
        }
        if ((filePath = filePath.trim()).isEmpty()) {
            return null;
        }
        if ((filePath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(filePath)) == null) {
            return null;
        }
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            file = new File(this.getProject().getLocation().toFile(), filePath);
        }
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private void loadFromFile() {
        PreferenceTag[] preferenceTagArray = PreferenceTag.values();
        int n = preferenceTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceTag preferenceTag = preferenceTagArray[n2];
            preferenceTag.setReadOnly(false);
            ++n2;
        }
        List files = DVTSFiles.EXPORT_HTML_DVT.getAllFiles(true);
        if (files != null) {
            for (File file : files) {
                this.loadFromFile(file, false);
            }
        }
        this.initiateOutsideProjectModel();
        File file = this.fProject.getLocation().append(".dvt").append("specador_preferences.xml").toFile();
        if (!file.exists()) {
            return;
        }
        this.loadFromFile(file, true);
    }

    public void initiateOutsideProjectModel() {
        this.outsideProjectModel = this.makeCopy();
    }

    public void loadFromFile(File file, boolean projectLevelFile) {
        try {
            this.loadFromFileRaw(file, projectLevelFile);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void loadFromFileRaw(File file, boolean projectLevelFile) throws Exception {
        if (file == null || !file.exists()) {
            return;
        }
        this.fCachedPreferencesFile = file;
        this.parser = SpecadorXMLParser.newParser(file, false);
        this.parser.load(this, projectLevelFile);
    }

    public void saveFileForTest() {
        try {
            File f2 = this.fProject.getLocation().append("specador_preferences.xml").toFile();
            SpecadorXMLParser.newParser(f2, true).save(this, this.outsideProjectModel);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void saveToFile() {
        this.saveToFile(true);
    }

    public void saveToFile(boolean useTheLatestVersion) {
        String path = this.fProject.getLocation().append(".dvt").append("specador_preferences.xml").toOSString();
        if (path == null) {
            return;
        }
        try {
            File f2 = new File(path);
            if (this.fCachedPreferencesFile != null) {
                f2 = this.fCachedPreferencesFile;
            }
            SpecadorXMLParser.newParser(f2, useTheLatestVersion).save(this, this.outsideProjectModel);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void saveToFileNoCache(String path) {
        if (path == null) {
            return;
        }
        try {
            File file = new File(path);
            if (!file.createNewFile()) {
                return;
            }
            this.fCachedPreferencesFile = file;
            SpecadorXMLParser.newParser(file, true).save(this, this.outsideProjectModel);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public SpecadorXMLParser getParser() {
        return this.parser;
    }

    public List<String> getAllVlogPackageNames() {
        if (this.fProjectNatures.contains("ro.amiq.vlogdt.VlogNature")) {
            return LanguageContributor.get(LanguageKind.VLOG).getPackages(this.getProject());
        }
        return Collections.emptyList();
    }

    public List<ILibraryWrapper> getAllVlogLibraries() {
        if (this.fProjectNatures.contains("ro.amiq.vlogdt.VlogNature")) {
            return LanguageContributor.get(LanguageKind.VLOG).getLibraries(this);
        }
        return Collections.emptyList();
    }

    public ILibraryWrapper getVlogLibrary(String libraryName) {
        List<ILibraryWrapper> libraries = this.getAllVlogLibraries();
        for (ILibraryWrapper library : libraries) {
            if (!libraryName.equals(library.getName())) continue;
            return library;
        }
        return null;
    }

    public List<ILibraryWrapper> getAllVhdlLibraries() {
        if (this.fProjectNatures.contains("ro.amiq.vhdldt.VhdlNature")) {
            return LanguageContributor.get(LanguageKind.VHDL).getLibraries(this);
        }
        return Collections.emptyList();
    }

    public ILibraryWrapper getVhdlLibrary(String libraryName) {
        List<ILibraryWrapper> libraries = this.getAllVhdlLibraries();
        for (ILibraryWrapper library : libraries) {
            if (!libraryName.equals(library.getName())) continue;
            return library;
        }
        return null;
    }

    public List<String> getAllVhdlLibraryNames() {
        if (this.fProjectNatures.contains("ro.amiq.vhdldt.VhdlNature")) {
            return this.getAllVhdlLibraries().stream().map(l -> l.getName()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public List<String> getAllEdtPackageNames() {
        if (this.fProjectNatures.contains("ro.amiq.edt.enature")) {
            return LanguageContributor.get(LanguageKind.E).getPackages(this.getProject());
        }
        return new ArrayList<String>();
    }

    public StringMatcher[] getNamePatterns() {
        if (this.fFiltersString == null || this.fFiltersString.trim().length() == 0) {
            return new StringMatcher[0];
        }
        String[] filters = this.fFiltersString.split(",");
        ArrayList<StringMatcher> result = new ArrayList<StringMatcher>(filters.length);
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (!(filter = filter.trim()).isEmpty()) {
                result.add(new StringMatcher(filter, false, false));
            }
            ++n2;
        }
        return result.toArray(new StringMatcher[result.size()]);
    }

    public void addPath(String path, PreferenceTag tag) {
        if (PreferenceTag.FILTER_PATH.equals((Object)tag)) {
            this.addFilterPath(path);
            return;
        }
        if (PreferenceTag.ATTACH_PATH.equals((Object)tag)) {
            this.addAttachPath(path);
            return;
        }
        if (PreferenceTag.INCLUDE_PATH.equals((Object)tag)) {
            this.addIncludePath(path);
            return;
        }
        if (PreferenceTag.EXTERNAL_DOC_PATH.equals((Object)tag)) {
            this.addExternalDocPath(path);
        }
    }

    private String getRealPath(String path) {
        File realFile = new File(path);
        String canonicalPath = "";
        try {
            canonicalPath = realFile.getCanonicalPath();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return canonicalPath;
    }

    private String replaceEnvVars(String path) {
        return DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(path, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar(this.getProject(), envVarName, BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
    }

    public void addAttachPath(String path) {
        if (path.trim().isEmpty()) {
            return;
        }
        String replaced = this.replaceEnvVars(path);
        if (replaced == null) {
            this.fAttachedPaths.put(path, "");
            return;
        }
        String fullPath = replaced;
        if (!Paths.get(fullPath, new String[0]).isAbsolute() && this.getProject() != null && this.getProject().getLocation() != null) {
            fullPath = String.valueOf(this.getProject().getLocation().toOSString()) + File.separator + replaced;
        }
        this.fAttachedPaths.put(path, this.getRealPath(fullPath));
    }

    public void addFilterPath(String filterPath) {
        if (filterPath.trim().isEmpty()) {
            return;
        }
        String replaced = this.replaceEnvVars(filterPath);
        if (replaced == null) {
            this.fFilterPaths.put(filterPath, null);
            return;
        }
        String fullPath = replaced;
        if (!Paths.get(replaced, new String[0]).isAbsolute() && this.getProject() != null && this.getProject().getLocation() != null) {
            fullPath = this.getProject().getLocation() + File.separator + replaced;
        }
        this.fFilterPaths.put(filterPath, new StringMatcher(this.getRealPath(fullPath), false, false));
    }

    public void removeFilterPaths(String[] filterPaths) {
        String[] stringArray = filterPaths;
        int n = filterPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String filterPath = stringArray[n2];
            this.fFilterPaths.remove(filterPath);
            ++n2;
        }
    }

    public void addIncludePath(String includePath) {
        if (includePath.trim().isEmpty()) {
            return;
        }
        String replaced = this.replaceEnvVars(includePath);
        if (replaced == null) {
            this.fIncludePaths.put(includePath, null);
            return;
        }
        String fullPath = replaced;
        if (!Paths.get(replaced, new String[0]).isAbsolute() && this.getProject() != null && this.getProject().getLocation() != null) {
            fullPath = this.getProject().getLocation() + File.separator + replaced;
        }
        this.fIncludePaths.put(includePath, new StringMatcher(this.getRealPath(fullPath), false, false));
    }

    public void removeIncludePaths(String[] includePaths) {
        String[] stringArray = includePaths;
        int n = includePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String includePath = stringArray[n2];
            this.fIncludePaths.remove(includePath);
            ++n2;
        }
    }

    public void clearPaths(PreferenceTag tag) {
        if (PreferenceTag.FILTER_PATH.equals((Object)tag)) {
            this.clearFilterPaths();
            return;
        }
        if (PreferenceTag.ATTACH_PATH.equals((Object)tag)) {
            this.fAttachedPaths.clear();
            return;
        }
        if (PreferenceTag.INCLUDE_PATH.equals((Object)tag)) {
            this.fIncludePaths.clear();
            return;
        }
        if (PreferenceTag.EXTERNAL_DOC_PATH.equals((Object)tag)) {
            this.clearExternalDocPaths();
        }
    }

    public void clearFilterPaths() {
        this.fFilterPaths.clear();
    }

    public Set<String> getFilterPathsStrings() {
        return this.fFilterPaths.keySet();
    }

    public Collection<StringMatcher> getFilterPathsMatchers() {
        return this.fFilterPaths.values().stream().filter(p -> p != null).collect(Collectors.toList());
    }

    public Set<String> getIncludePathsStrings() {
        return this.fIncludePaths.keySet();
    }

    public Collection<StringMatcher> getIncludePathsMatchers() {
        return this.fIncludePaths.values().stream().filter(p -> p != null).collect(Collectors.toList());
    }

    public void clearCommentFitlers() {
        this.fCommentFilters.clear();
    }

    public List<String> getCommentFilters() {
        return this.fCommentFilters.stream().map(String::trim).filter(s -> !s.isEmpty()).map(String::toLowerCase).collect(Collectors.toList());
    }

    public String getCommentFiltersStartTag() {
        return this.fCommentFiltersStartTag;
    }

    public String getCommentFiltersEndTag() {
        return this.fCommentFiltersEndTag;
    }

    public String getCommentFiltersString() {
        return String.join((CharSequence)",", this.fCommentFilters);
    }

    public void addCommentFilter(String filter) {
        this.fCommentFilters.add(filter);
    }

    public void setCommentFilter(Set<String> filters) {
        this.fCommentFilters = filters;
    }

    public CommentFilterStrategy getFilterStrategy() {
        return this.fFilterStrategy;
    }

    public void setFilterStrategy(CommentFilterStrategy fFilterStrategy) {
        this.fFilterStrategy = fFilterStrategy;
    }

    public void setProgressMonitor(SpecadorProgressMonitor pm) {
        this.fProgressMonitor = pm;
    }

    public SpecadorProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor;
    }

    public DVTComment.CommentFormat getDocFormattingType() {
        return DVTComment.CommentFormat.parse(this.fDocFormattingType);
    }

    public void setDocFormattingType(DVTComment.CommentFormat formattingType) {
        this.fDocFormattingType = formattingType.getSpecadorXMLPreferenceName();
    }

    public String getCustomCssFile() {
        return this.replaceEnvVars(this.fCustomCssFile).trim();
    }

    public void setCustomCssFile(String customCssFile) {
        this.fCustomCssFile = customCssFile;
    }

    public String getCustomJsFile() {
        return this.replaceEnvVars(this.fCustomJsFile).trim();
    }

    public void setCustomJsFile(String customJsFile) {
        this.fCustomJsFile = customJsFile;
    }

    public String getUserDefinedHTML() {
        return this.fUserDefinedHTML;
    }

    public void addExternalDocPath(String path) {
        this.fExternalDocPaths.put(path, this.replaceEnvVars(path));
    }

    public void clearExternalDocPaths() {
        this.fExternalDocPaths.clear();
    }

    public Set<String> getFilterExternalDocPathsStrings() {
        return this.fExternalDocPaths.keySet();
    }

    public Collection<String> getFilterExternalDocPathsStringsTranslated() {
        return this.fExternalDocPaths.values();
    }

    public boolean isShowExternalDocRefs() {
        return this.fShowExternalDocRefs;
    }

    public void setShowExternalDocRefs(boolean show) {
        this.fShowExternalDocRefs = show;
    }

    public SpecadorModel makeCopy() {
        SpecadorModel result = new SpecadorModel();
        result.fProgressMonitor = this.fProgressMonitor;
        result.fOutputFormat = this.fOutputFormat;
        result.fEnablePreviewMode = this.fEnablePreviewMode;
        result.fProject = this.fProject;
        result.fProjectNatures = this.fProjectNatures;
        result.fSelectedProjectNatures = this.fSelectedProjectNatures;
        result.fListeners = this.fListeners;
        result.fFilterPaths = new HashMap<String, StringMatcher>(this.fFilterPaths);
        result.fAttachedPaths = new HashMap<String, String>(this.fAttachedPaths);
        result.fIncludePaths = new HashMap<String, StringMatcher>(this.fIncludePaths);
        result.fExternalDocPaths = this.fExternalDocPaths;
        result.fDoxygenTagFiles = this.fDoxygenTagFiles;
        result.fCommentFilters = this.fCommentFilters;
        result.fCommentFiltersStartTag = this.fCommentFiltersStartTag;
        result.fCommentFiltersEndTag = this.fCommentFiltersEndTag;
        result.fFilterStrategy = this.fFilterStrategy;
        result.fEnhanceComments = this.fEnhanceComments;
        result.fCreatedByWatermark = this.fCreatedByWatermark;
        result.fCleanLocation = this.fCleanLocation;
        result.fOpenInBrowser = this.fOpenInBrowser;
        result.fPublicOnly = this.fPublicOnly;
        result.fJustProjectFiles = this.fJustProjectFiles;
        result.fKeepDotFiles = this.fKeepDotFiles;
        result.fShowExternalDocRefs = this.fShowExternalDocRefs;
        result.fDocFormattingType = this.fDocFormattingType;
        result.fCustomCssFile = this.fCustomCssFile;
        result.fCustomJsFile = this.fCustomJsFile;
        result.fCustomIndexFile = this.fCustomIndexFile;
        result.fUserDefinedHTML = this.fUserDefinedHTML;
        result.fFiltersString = this.fFiltersString;
        result.fRawLocation = this.fRawLocation;
        result.fOutputFolderName = this.fOutputFolderName;
        result.fTitle = this.fTitle;
        result.fAuthor = this.fAuthor;
        result.fCopyright = this.fCopyright;
        result.fVersion = this.fVersion;
        result.fOverviewFile = this.fOverviewFile;
        result.fUMLClassInheritanceDiagram = this.fUMLClassInheritanceDiagram;
        result.fUMLPackageInheritanceDiagram = this.fUMLPackageInheritanceDiagram;
        result.fUMLDirectAssociationsDiagram = this.fUMLDirectAssociationsDiagram;
        result.fUMLCollaborationDiagram = this.fUMLCollaborationDiagram;
        result.fOrthogonalClassDiagrams = this.fOrthogonalClassDiagrams;
        result.fDesignBlockDiagram = this.fDesignBlockDiagram;
        result.fDesignFlowDiagram = this.fDesignFlowDiagram;
        result.fDesignSchematicDiagram = this.fDesignSchematicDiagram;
        result.fDesignDiagramFilters = this.fDesignDiagramFilters;
        result.fDesignDiagramFiltersSet = this.fDesignDiagramFiltersSet;
        result.fDesignSubInstancesDiagram = this.fDesignSubInstancesDiagram;
        result.fBitfieldDiagrams = this.fBitfieldDiagrams;
        result.fUvmComponentDiagramDepth = this.fUvmComponentDiagramDepth;
        result.fMaxNoElaboratedInstances = this.fMaxNoElaboratedInstances;
        result.fInstanceParameters = this.fInstanceParameters;
        result.fExportUnnamedAlwaysBlocks = this.fExportUnnamedAlwaysBlocks;
        result.fFSMDiagrams = this.fFSMDiagrams;
        result.fFSMDiagramDirection = this.fFSMDiagramDirection;
        result.fFSMPlacementStrategy = this.fFSMPlacementStrategy;
        result.fFSMEnforceEdgePortSide = this.fFSMEnforceEdgePortSide;
        result.fFSMInitialStatePosition = this.fFSMInitialStatePosition;
        result.fFSMShowDefaultState = this.fFSMShowDefaultState;
        result.fFSMShowLoopbackEdges = this.fFSMShowLoopbackEdges;
        result.fFSMFilterCommonExpressionsInConditions = this.fFSMFilterCommonExpressionsInConditions;
        result.fexportSourceCode = this.fexportSourceCode;
        result.fOrderPorts = this.fOrderPorts;
        result.fOrderVariables = this.fOrderVariables;
        result.fExportVlogGlobalScope = this.fExportVlogGlobalScope;
        result.fExportVlogPackages = this.fExportVlogPackages;
        result.fExportVlogLibraries = this.fExportVlogLibraries;
        result.fExportVlogModules = this.fExportVlogModules;
        result.fVlogLibrariesWithModules = this.fVlogLibrariesWithModules;
        result.fVlogLibrariesWithInterfaces = this.fVlogLibrariesWithInterfaces;
        result.fVlogLibrariesWithPackages = this.fVlogLibrariesWithPackages;
        result.fExportVlogModulesVariables = this.fExportVlogModulesVariables;
        result.fExportVlogPackagesVariables = this.fExportVlogPackagesVariables;
        result.fExportVlogInterfaces = this.fExportVlogInterfaces;
        result.fExportVlogPrograms = this.fExportVlogPrograms;
        result.fExportVlogMacros = this.fExportVlogMacros;
        result.fExportVlogIfndefGuards = this.fExportVlogIfndefGuards;
        result.fExportVlogControlDefines = this.fExportVlogControlDefines;
        result.fExportVlogAssertions = this.fExportVlogAssertions;
        result.fExportVlogCovergroups = this.fExportVlogCovergroups;
        result.fExportVlogInnerClasses = this.fExportVlogInnerClasses;
        result.fExportVlogLocalparams = this.fExportVlogLocalparams;
        result.fHideVlogInterfSignals = this.fHideVlogInterfSignals;
        result.fVlogFilterClassDiagrams = new ArrayList<String>(this.fVlogFilterClassDiagrams);
        result.fVlogSelectedPackageNames.addAll(this.fVlogSelectedPackageNames);
        result.fVlogSelectedLibraryNames.addAll(this.fVlogSelectedLibraryNames);
        result.fVlogFilterIndex = new HashSet<String>(this.fVlogFilterIndex);
        result.fDoxygenTagFiles.putAll(this.fDoxygenTagFiles);
        result.fExpandIncludeDirectivesInModules = this.fExpandIncludeDirectivesInModules;
        result.fExportVlogClassInheritedMembers = this.fExportVlogClassInheritedMembers;
        result.fExportEdtPackages = this.fExportEdtPackages;
        result.fExportEdtMacros = this.fExportEdtMacros;
        result.fExportEdtCovergroups = this.fExportEdtCovergroups;
        result.fExportEdtChecks = this.fExportEdtChecks;
        result.fEdtSelectedPackageNames.addAll(this.fEdtSelectedPackageNames);
        result.fExportEdtTests = this.fExportEdtTests;
        result.fExportVhdlLibraries = this.fExportVhdlLibraries;
        result.fVhdlSelectedLibraryNames.addAll(this.fVhdlSelectedLibraryNames);
        result.fVhdlLibrariesWithEntities = this.fVhdlLibrariesWithEntities;
        result.fVhdlLibrariesWithPackages = this.fVhdlLibrariesWithPackages;
        return result;
    }

    public void doPostCompileProcessing() {
        List<String> allPackages;
        this.fElaboratedInstances = this.computeElaboratedInstances(this.getProject());
        ArrayList<String> selected = new ArrayList<String>();
        Set<String> rawSelected = this.getVlogSelectedPackageNames();
        if (this.isExportVlogPackages() && this.getProjectNatures().contains("ro.amiq.vlogdt.VlogNature")) {
            allPackages = this.getAllVlogPackageNames();
            if (rawSelected == null || rawSelected.isEmpty()) {
                selected.addAll(allPackages);
            } else {
                for (String rawItem : rawSelected) {
                    for (String allItem : allPackages) {
                        if (!allItem.equals(rawItem)) continue;
                        selected.add(allItem);
                    }
                }
            }
        }
        if (!this.isLoadedFromPreferenceFile()) {
            selected.removeIf(p -> "uvm_pkg".equals(p));
        }
        this.setVlogSelectedPackageNames(selected);
        this.removeVlogUnselectedPackages(selected);
        selected = new ArrayList();
        rawSelected = this.getVhdlSelectedLibraryNames();
        if (this.isExportVhdlLibraries() && this.getProjectNatures().contains("ro.amiq.vhdldt.VhdlNature")) {
            List<String> allLibraries = this.getAllVhdlLibraryNames();
            if (rawSelected == null || rawSelected.isEmpty()) {
                selected.addAll(allLibraries);
            } else {
                for (String rawItem : rawSelected) {
                    for (String allItem : allLibraries) {
                        if (!allItem.equals(rawItem)) continue;
                        selected.add(allItem);
                    }
                }
            }
        }
        this.setVhdlSelectedLibraryNames(new HashSet<String>(selected));
        this.removeVhdlUnselectedLibraries(selected);
        selected = new ArrayList();
        rawSelected = this.getEdtSelectedPackageNames();
        if (this.isExportEdtPackages() && this.getProjectNatures().contains("ro.amiq.edt.enature")) {
            allPackages = this.getAllEdtPackageNames();
            if (rawSelected == null || rawSelected.isEmpty()) {
                selected.addAll(allPackages);
            } else {
                for (String rawItem : rawSelected) {
                    for (String allItem : allPackages) {
                        if (!allItem.equals(rawItem)) continue;
                        selected.add(allItem);
                    }
                }
            }
        }
        this.setEdtSelectedPackageNames(selected);
    }

    private boolean isLoadedFromPreferenceFile() {
        return this.fCachedPreferencesFile != null;
    }

    public void addDoxygenTagFiles(Map<String, String> doxygenTagFiles) {
        for (Map.Entry<String, String> entry : doxygenTagFiles.entrySet()) {
            if (this.fExternalDocPaths.get(entry.getKey()).isEmpty()) continue;
            this.fDoxygenTagFiles.put(this.fExternalDocPaths.get(entry.getKey()), entry.getValue());
        }
    }

    public Map<String, String> getDoxygenTagFiles() {
        return this.fDoxygenTagFiles;
    }

    public List<File> getAttachedLocations() {
        ArrayList<File> result = new ArrayList<File>();
        for (Map.Entry<String, String> e : this.fAttachedPaths.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            result.add(new File(e.getValue()));
        }
        return result;
    }

    public Collection<String> getAttachedRelativePaths() {
        return this.fAttachedPaths.keySet();
    }

    public void setOutputFormat(OutputFormat sphinxOutputFormat) {
        this.fOutputFormat = sphinxOutputFormat;
    }

    public OutputFormat getOutputFormat() {
        return this.fOutputFormat;
    }

    public void removeAttachedPaths(String[] paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            this.fAttachedPaths.remove(path);
            ++n2;
        }
    }

    public void setCommentFilterStartTag(String text) {
        this.fCommentFiltersStartTag = text;
    }

    public void setCommentFilterEndTag(String text) {
        this.fCommentFiltersEndTag = text;
    }

    public void populateDefaultVlogLibraries() {
        if (!this.hasVlogNature()) {
            return;
        }
        List<ILibraryWrapper> allLibraries = this.getAllVlogLibraries();
        for (ILibraryWrapper lib : allLibraries) {
            this.addVlogSelectedLibraryNames(lib.getName());
            if (lib.hasModules(this.hasVlogNature())) {
                this.addVlogLibraryWithModules(lib.getName());
            }
            if (lib.hasInterfaces(this.hasVlogNature())) {
                this.addVlogLibraryWithInterfaces(lib.getName());
            }
            if (lib.getPackageNames(this.hasVlogNature()).isEmpty()) continue;
            this.addVlogPackagesFromLibrary(lib.getName());
        }
    }

    public void populateDefaultVhdlLibraries() {
        if (!this.hasVhdlNature()) {
            return;
        }
        List<ILibraryWrapper> allLibraries = this.getAllVhdlLibraries();
        for (ILibraryWrapper lib : allLibraries) {
            this.addVhdlSelectedLibraryNames(lib.getName());
            if (lib.hasEntities(this.hasVhdlNature())) {
                this.addVhdlLibrariesWithEntities(lib.getName());
            }
            if (lib.getPackageNames(this.hasVhdlNature()).isEmpty()) continue;
            this.addVhdlPackagesFromLibrary(lib.getName());
        }
    }

    public void clearEdtPackages() {
        this.fEdtSelectedPackageNames.clear();
    }

    public NLFilterSet getDesignDiagramsFiltersSet() {
        if (!this.fDesignDiagramFilters.isEmpty() && this.fDesignDiagramFiltersSet == null) {
            this.fDesignDiagramFiltersSet = NLFilterSet.deserializeSingleSet("Filter\n" + this.fDesignDiagramFilters, null);
        }
        return this.fDesignDiagramFiltersSet;
    }

    public void clearVhdlLibraries() {
        this.fVhdlLibrariesWithEntities.clear();
        this.fVhdlLibrariesWithPackages.clear();
        this.fVhdlSelectedLibraryNames.clear();
    }

    public void clearVlogLibraries() {
        this.fVlogLibrariesWithModules.clear();
        this.fVlogLibrariesWithInterfaces.clear();
        this.fVlogLibrariesWithPackages.clear();
        this.fVlogSelectedLibraryNames.clear();
    }

    public void enablePreviewMode() {
        this.fEnablePreviewMode = true;
    }

    public boolean isPreviewMode() {
        return this.fEnablePreviewMode;
    }

    public OutputFormat getPreferenceFileOutputFormat(File file) throws Exception {
        if (file == null || !file.exists()) {
            return OutputFormat.HTML;
        }
        this.fCachedPreferencesFile = file;
        SpecadorXMLParser7 XMLParser2 = new SpecadorXMLParser7(file);
        if (XMLParser2.containsPreference(PreferenceTag.OUTPUT_FORMAT.getTagName(), OutputFormat.PDF.toString())) {
            return OutputFormat.PDF;
        }
        return OutputFormat.HTML;
    }

    public static enum CommentFilterStrategy {
        LINE("Line"),
        ALL("All");

        String commentStrategy;

        private CommentFilterStrategy(String commentStrategy) {
            this.commentStrategy = commentStrategy;
        }

        public String toString() {
            return this.commentStrategy;
        }
    }

    public static interface IProjectChangeListener {
        public void projectChanged(IProject var1);
    }

    public static enum OutputFormat {
        HTML,
        PDF,
        RST;


        public String toString() {
            if (this == RST) {
                return HTML.toString().toLowerCase();
            }
            return super.toString().toLowerCase();
        }

        public String toConsole() {
            if (this == HTML || this == RST) {
                return "html";
            }
            return "latexpdf";
        }

        public String toBuildPath() {
            if (this == HTML || this == RST) {
                return "html";
            }
            return "latex";
        }

        public static OutputFormat parse(String format) {
            if (format.toLowerCase().equals(PDF.toString())) {
                return PDF;
            }
            return HTML;
        }
    }
}

