/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.specador.templates.SpecadorGenerator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.ProjectSelectionDialog;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtils;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.wizards.specador.SpecadorJob;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewListener;

public class SpecadorPreviewHandler
extends AbstractHandler {
    public boolean isEnabled() {
        IProject[] projects = DVTUtilsCommon.getProjects();
        return projects.length != 0;
    }

    public boolean isHandled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IRfNamedElement previewElement;
        IProject project;
        block10: {
            IRfBreadcrumbElement bcElement;
            block9: {
                block7: {
                    block8: {
                        project = DVTPlugin.getSelectionManager().getLastSelectedProject();
                        if (project != null && project.isAccessible() && Utils.hasDvtNature(project)) break block7;
                        IProject[] projects = DVTUtilsCommon.getProjects();
                        if (projects.length != 0) break block8;
                        return null;
                    }
                    project = ProjectSelectionDialog.selectProject();
                    if (project != null) break block7;
                    return null;
                }
                if (DVTPlugin.getDefault().collect().c(project, "F636F7265")) break block9;
                return null;
            }
            DVTBuildUtils.waitForAllBuildJobsDone(IDVTConstants.VLOG_FAMILY_REPARSE);
            DVTBuildUtils.waitForAllBuildJobsDone(IDVTConstants.VHDL_FAMILY_REPARSE);
            DVTBuildUtils.waitForAllBuildJobsDone(IDVTConstants.E_FAMILY_REPARSE);
            IEditorPart editor = DVTPlugin.getActivePage().getActiveEditor();
            IRfScopeElement element = null;
            if (editor instanceof DVTEditor && (element = ((DVTEditor)editor).getCursorScope()) == null && (bcElement = ((DVTEditor)editor).getCursorScopeForBreadcrumb(false)) != null) {
                element = bcElement.getEnclosingScope();
            }
            if ((previewElement = SpecadorGenerator.getElementForPreview(element)) != null) break block10;
            SmartCopyUtils.updateStatusBarWithWarning("Specador HTML Preview is not available for the selected element!");
            return null;
        }
        try {
            SmartCopyUtils.updateStatusBarWithWarning(null);
            this.startPreview(project, previewElement);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private void startPreview(IProject project, IRfNamedElement element) {
        SpecadorPreviewListener.INSTANCE.loadExistingPreferenceFile(project);
        SpecadorModel model = SpecadorPreviewListener.INSTANCE.getModel();
        File preferenceFile = SpecadorPreviewListener.INSTANCE.getPreferenceFile();
        model.setProject(project);
        if (preferenceFile != null) {
            model.initDefaults();
            model.loadFromFile(preferenceFile, true);
        } else {
            model.initDefaults();
        }
        SpecadorJob genJob = new SpecadorJob(model, element);
        genJob.setProperty(IDVTConstants.BUILD_JOB_PROJECT_NAME, project.getName());
        genJob.setRule((ISchedulingRule)project);
        genJob.setUser(false);
        genJob.schedule();
    }
}

