/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import com.github.eclipsecolortheme.ColorTheme;
import com.github.eclipsecolortheme.ColorThemeSetting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.preferences.theme.DVTThemeUtils;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewView;

public enum SpecadorPreviewListener implements IBuildEventManagerListener
{
    INSTANCE;

    private static File location;
    private SpecadorPreviewView view;
    private SpecadorModel model;
    private RfElementPath elementPath;
    private IRfNamedElement namedElement;
    private File preferenceFile;
    private long lastAISessionID;
    private long lastAIMessageID;
    private String backgroundColor;
    private String foregroundColor;
    private String entireMessage = "";

    static {
        try {
            location = Files.createTempDirectory("specador_docs", new FileAttribute[0]).toFile();
            location.deleteOnExit();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Browser getBrowser() {
        return this.view.getBrowser();
    }

    public File getLocation() {
        return location;
    }

    public void clearLocation() {
        try {
            FileUtils.cleanDirectory((File)this.getLocation());
            FileUtils.deleteDirectory((File)this.getLocation());
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void refresh() {
        Display.getDefault().asyncExec(() -> this.view.refresh());
    }

    protected void setModel(SpecadorModel model) {
        this.model = model;
    }

    public SpecadorModel getModel() {
        if (this.model == null) {
            this.model = new SpecadorModel();
            this.model.initDefaults();
        }
        return this.model;
    }

    void setView(SpecadorPreviewView view) {
        this.view = view;
    }

    void setElementPath(IRfNamedElement element) {
        this.elementPath = RfElementPath.path(element);
        this.namedElement = element;
    }

    public IRfNamedElement getElement() {
        if (this.elementPath == null) {
            return null;
        }
        IRfNamedElement elementFromPath = this.elementPath.toNamedElement(this.model.getProject());
        if (elementFromPath != null) {
            return elementFromPath;
        }
        return this.namedElement;
    }

    public void clearPreferenceFile() {
        this.preferenceFile = null;
        if (this.model != null) {
            for (String nature : this.model.getProjectNatures()) {
                LanguageContributor.get(LanguageKind.from(nature)).removeSpecadorPreviewListenerFromBuildListeners();
            }
            this.model = null;
        }
    }

    private void setTheme() {
        ColorTheme activeTheme = DVTThemeUtils.getActiveTheme();
        this.backgroundColor = ((ColorThemeSetting)activeTheme.getEntries().get("background")).getColor().asHex();
        this.foregroundColor = ((ColorThemeSetting)activeTheme.getEntries().get("foreground")).getColor().asHex();
    }

    public String getBackgroundColor() {
        if (this.backgroundColor == null) {
            this.setTheme();
        }
        return this.backgroundColor;
    }

    public String getForegroundColor() {
        if (this.foregroundColor == null) {
            this.setTheme();
        }
        return this.foregroundColor;
    }

    public long getLastAIMessageID() {
        return this.lastAIMessageID;
    }

    public long getLastAISessionID() {
        return this.lastAISessionID;
    }

    void setPreferenceFile(File preferenceFile) {
        this.preferenceFile = preferenceFile;
    }

    public File getPreferenceFile() {
        return this.preferenceFile;
    }

    void loadExistingPreferenceFile(IProject project) {
        if (project == null) {
            return;
        }
        ScopedPreferenceStore projectPrefs = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "ro.amiq.dvt");
        String lastUsedPreferenceFileName = projectPrefs.getString("specadorPreferenceFile");
        File prefFile = new File(lastUsedPreferenceFileName);
        if (!prefFile.exists() && !(prefFile = project.getLocation().append(".dvt").append("specador_preferences.xml").toFile()).exists()) {
            return;
        }
        this.setPreferenceFile(prefFile);
    }

    @Override
    public void notifyFullBuild(IProject project) {
        if (this.view != null && project.equals((Object)this.model.getProject())) {
            this.model.doPostCompileProcessing();
            Display.getDefault().asyncExec(() -> this.view.refresh());
        }
    }

    @Override
    public void notifyIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
        if (this.view != null && project.equals((Object)this.model.getProject())) {
            this.model.doPostCompileProcessing();
            Display.getDefault().asyncExec(() -> this.view.refresh());
        }
    }

    @Override
    public void notifyCleanBuild(IProject project) {
    }

    public void startCommentDescription(long sessionId, long messageId) {
        this.lastAISessionID = sessionId;
        this.lastAIMessageID = messageId;
        this.view.startStream();
        this.entireMessage = "";
    }

    public void streamCommentDescription(String content) {
        this.view.streamChunk(content);
        this.entireMessage = String.valueOf(this.entireMessage) + content;
    }

    public void stopCommentDescription() {
        this.view.endStream(this.entireMessage);
    }

    public void insertComment(String comment) {
        IRfNamedElement element = this.getElement();
        if (element == null) {
            return;
        }
        IRfDefElement declaration = element.getDeclaration();
        ParserPath parserPath = declaration.getParserPath();
        DVTFileUtils.getInstance().addComment(element.getRfProject().getProject(), parserPath.toString(), declaration.getStartLine() - 1, comment, true, false);
    }
}

