/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewListener;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewPreferenceWizardContent;
import ro.amiq.dvt.wizards.specador.SpecadorXMLParser;

public class SpecadorPreviewPreferenceWizard
extends Wizard
implements INewWizard,
IPageChangedListener {
    private SpecadorModel fModel = new SpecadorModel();
    private IProject fProject;
    protected SpecadorPreviewPreferenceWizardContent fPreferencePage;

    public SpecadorPreviewPreferenceWizard(IProject project) {
        this.fProject = project;
        this.fModel.setProject(this.fProject);
    }

    public SpecadorModel getModel() {
        return this.fModel;
    }

    public boolean performFinish() {
        try {
            File file;
            String pathToPreferencesFile = this.fPreferencePage.getPathToPreferencesFile();
            if (pathToPreferencesFile != null && SpecadorXMLParser.isSpecadorPreferenceFile(file = new File(pathToPreferencesFile))) {
                SpecadorPreviewListener.INSTANCE.setPreferenceFile(file);
                SpecadorPreviewListener.INSTANCE.getModel().initDefaults();
                SpecadorPreviewListener.INSTANCE.getModel().loadFromFile(file, true);
                SpecadorPreviewListener.INSTANCE.refresh();
                ScopedPreferenceStore projectPrefs = new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.fProject), "ro.amiq.dvt");
                projectPrefs.setValue("specadorPreferenceFile", pathToPreferencesFile);
                projectPrefs.save();
            }
            return true;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public void dispose() {
        this.fModel.removeProjectChangeListener(this.fPreferencePage);
        if (this.fPreferencePage != null) {
            this.fPreferencePage.dispose();
        }
        this.fProject = null;
        super.dispose();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            if (this.fProject == null) {
                return;
            }
            if (this.fProject.hasNature("ro.amiq.vlogdt.VlogNature") || this.fProject.hasNature("ro.amiq.edt.enature") || this.fProject.hasNature("ro.amiq.slndt.slnnature") || this.fProject.hasNature("ro.amiq.msdldt.msdlnature") || this.fProject.hasNature("ro.amiq.pssdt.pssnature") || this.fProject.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                this.fModel.setProject(this.fProject);
            }
            this.setWindowTitle("Select XML preferences file for Specador Preview");
            this.fPreferencePage = new SpecadorPreviewPreferenceWizardContent("General Settings", this.fProject);
            this.fModel.addProjectChangeListener(this.fPreferencePage);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void pageChanged(PageChangedEvent event) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.fPreferencePage);
    }
}

