/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.wizards.AbstractWizardPage;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewPreferenceWizard;

public class SpecadorPreviewPreferenceWizardContent
extends AbstractWizardPage
implements SpecadorModel.IProjectChangeListener {
    private final IProject project;
    FieldDecoration infoField = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
    private String preferencesFilePath;
    private Button editPreferencesButton;

    public SpecadorPreviewPreferenceWizardContent(String pageName, IProject project) {
        super(pageName);
        this.setTitle("Specador Preview");
        this.setDescription("Specify preference file to use for Specador Preview.");
        this.project = project;
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 680;
        gridData.heightHint = 100;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)gridData);
        this.createPreferenceFileDialog(composite);
        composite.pack();
        parent.setLayout((Layout)compositeLayout);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        parent.layout();
    }

    private void createPreferenceFileDialog(Composite composite) {
        Composite parent = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 1;
        gridData = new GridData(1808);
        parent.setLayout((Layout)parentLayout);
        parent.setLayoutData((Object)gridData);
        Composite group = new Composite(parent, 0);
        gridData = new GridData(4, 4, true, false, 1, 1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        CLabel label = new CLabel(group, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Preference file:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_PREFERENCE_FILE));
        Composite textComposite = new Composite(group, 0);
        gridData = new GridData(4, 4, true, false, 1, 1);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginLeft = 5;
        layout.marginHeight = 0;
        gridData = new GridData(768);
        textComposite.setLayout((Layout)layout);
        textComposite.setLayoutData((Object)gridData);
        final Text preferenceFileField = new Text(textComposite, 2048);
        gridData = new GridData(4, 4, true, false, 2, 1);
        preferenceFileField.setLayoutData((Object)gridData);
        preferenceFileField.addModifyListener(e -> this.validatePreferencesFilePath(preferenceFileField.getText().trim()));
        ScopedPreferenceStore projectPrefs = new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.project), "ro.amiq.dvt");
        String lastUsedPrefFile = projectPrefs.getString("specadorPreferenceFile");
        String string = lastUsedPrefFile = new File(lastUsedPrefFile).exists() ? lastUsedPrefFile : "";
        if (lastUsedPrefFile.isEmpty()) {
            File defaultPreferencesFile = this.project.getLocation().append(".dvt").append("specador_preferences.xml").toFile();
            lastUsedPrefFile = defaultPreferencesFile.exists() ? defaultPreferencesFile.getAbsolutePath() : "";
        }
        preferenceFileField.setText(lastUsedPrefFile);
        ControlDecoration decoration = new ControlDecoration((Control)preferenceFileField, 16512);
        decoration.setImage(this.infoField.getImage());
        decoration.setDescriptionText("Provide a preferences file for the preview");
        Composite buttonGroup = new Composite(parent, 0);
        gridData = new GridData(4, 4, true, false, 2, 1);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        gridData = new GridData(768);
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)gridData);
        Button newPreferencesButton = SpecadorPreviewPreferenceWizardContent.createPushButton(buttonGroup, "New Preferences", 8);
        newPreferencesButton.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_NEW_PREFERENCE_FILE));
        gridData = new GridData(1, 2, false, false, 1, 1);
        newPreferencesButton.setLayoutData((Object)gridData);
        newPreferencesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    DVTPair wizardReturnValues = (DVTPair)commandService.getCommand("ro.amiq.dvt.wizards.htmldoc.HtmlDocWizardHandler").executeWithChecks(new ExecutionEvent());
                    if (wizardReturnValues == null) {
                        return;
                    }
                    int wizardReturnCode = (Integer)wizardReturnValues.getKey();
                    String newPreferenceFilePath = (String)wizardReturnValues.getValue();
                    if (wizardReturnCode == 1 || newPreferenceFilePath == null) {
                        return;
                    }
                    preferenceFileField.setText(newPreferenceFilePath);
                }
                catch (Exception ex) {
                    DVTLogger.INSTANCE.logError((Throwable)ex);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final Button editPreferencesButton = SpecadorPreviewPreferenceWizardContent.createPushButton(buttonGroup, "Edit Preferences", 8);
        editPreferencesButton.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_PREFERENCE_FILE));
        gridData = new GridData(1, 2, false, false, 1, 1);
        editPreferencesButton.setLayoutData((Object)gridData);
        editPreferencesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command command = commandService.getCommand("ro.amiq.dvt.wizards.htmldoc.HtmlDocWizardHandler");
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("preferencesFile", SpecadorPreviewPreferenceWizardContent.this.preferencesFilePath);
                    ExecutionEvent event = new ExecutionEvent(command, parameters, (Object)editPreferencesButton, null);
                    command.executeWithChecks(event);
                }
                catch (Exception ex) {
                    DVTLogger.INSTANCE.logError((Throwable)ex);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.editPreferencesButton = editPreferencesButton;
        Button browseButton = SpecadorPreviewPreferenceWizardContent.createPushButton(buttonGroup, "Browse File System...", 8);
        browseButton.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_BROWSE));
        gridData = new GridData(1, 2, false, false, 1, 1);
        browseButton.setLayoutData((Object)gridData);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SpecadorPreviewPreferenceWizardContent.this.getShell(), 4096);
                String xmlPath = DVTFileUtils.getInstance().getLastDirectory();
                if (xmlPath.equals(System.getProperty("user.home"))) {
                    xmlPath = SpecadorPreviewPreferenceWizardContent.this.getModel().getProject().getLocation().toOSString();
                }
                dialog.setFilterPath(xmlPath);
                String path = dialog.open();
                if (path == null || path.length() == 0) {
                    return;
                }
                preferenceFileField.setText(path);
                DVTFileUtils.getInstance().setLastDirectory(path);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button browseWorkspaceButton = SpecadorPreviewPreferenceWizardContent.createPushButton(buttonGroup, "Browse Workspace...", 8);
        browseWorkspaceButton.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_BROWSE));
        gridData = new GridData(1, 2, false, false, 1, 1);
        browseWorkspaceButton.setLayoutData((Object)gridData);
        browseWorkspaceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileTreeSelectionDialog dialog = new FileTreeSelectionDialog(SpecadorPreviewPreferenceWizardContent.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                dialog.setTitle("Workspace search");
                String xmlPath = DVTFileUtils.getInstance().getLastDirectory();
                if (xmlPath.equals(System.getProperty("user.home"))) {
                    xmlPath = SpecadorPreviewPreferenceWizardContent.this.getModel().getProject().getLocation().toOSString();
                }
                dialog.open();
                Object[] result = dialog.getResult();
                if (result == null) {
                    return;
                }
                IFile file = (IFile)result[0];
                String path = file.getLocation().toOSString();
                if (path == null || path.length() == 0) {
                    return;
                }
                preferenceFileField.setText(path);
                DVTFileUtils.getInstance().setLastDirectory(path);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        group.pack();
        this.setControl((Control)composite);
        composite.setLayout((Layout)parentLayout);
        composite.layout();
        this.validatePreferencesFilePath(preferenceFileField.getText());
    }

    private void validatePreferencesFilePath(String preferencesFilePath) {
        if (preferencesFilePath.isEmpty()) {
            this.setErrorMessage("Preferences file path is empty!");
            this.setPageComplete(false);
        } else {
            File preferencesFile = new File(preferencesFilePath);
            if (!preferencesFile.isAbsolute()) {
                preferencesFile = new File(this.getModel().getProject().getLocation().toOSString(), preferencesFilePath);
            }
            if (preferencesFile != null && preferencesFile.exists()) {
                if (preferencesFilePath.endsWith(".xml")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    this.preferencesFilePath = preferencesFilePath;
                } else {
                    this.setErrorMessage("Preferences file is not an Extensible Markup Language file!");
                    this.setPageComplete(false);
                }
            } else {
                this.setErrorMessage("Preferences file path does not point to an existing file!");
                this.setPageComplete(false);
            }
        }
        if (this.editPreferencesButton != null) {
            this.editPreferencesButton.setEnabled(this.isPageComplete());
        }
    }

    private SpecadorModel getModel() {
        IWizard wizard = this.getWizard();
        return ((SpecadorPreviewPreferenceWizard)wizard).getModel();
    }

    @Override
    public void projectChanged(IProject project) {
    }

    public String getPathToPreferencesFile() {
        return this.preferencesFilePath;
    }

    private static class FileTreeSelectionDialog
    extends ElementTreeSelectionDialog {
        public FileTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider);
            this.setInput(ResourcesPlugin.getWorkspace().getRoot());
            this.setAllowMultiple(false);
        }

        protected void updateOKStatus() {
            IStructuredSelection selection;
            boolean isFileSelected;
            super.updateOKStatus();
            Button okButton = this.getButton(0);
            if (okButton != null && (isFileSelected = (selection = (IStructuredSelection)this.getTreeViewer().getSelection()).getFirstElement() instanceof IFile)) {
                IFile file = (IFile)selection.getFirstElement();
                okButton.setEnabled(file.getFileExtension().equals("xml"));
            }
        }
    }
}

