/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.comment.formatter.CommentFormatter;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.ProjectSelectionDialog;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.preferences.theme.DVTThemeUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.JarUtils;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.wizards.specador.SpecadorJob;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewListener;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewPreferenceWizard;

public class SpecadorPreviewView
extends ViewPart {
    public static final String ID = "ro.amiq.dvt.wizards.htmldoc.SpecadorPreviewBrowser";
    private static final String WELCOME_MESSAGE_PAGE;
    private static final int BROWSER_LOADING_TIMEOUT = 5000;
    private static final Gson JSON_SERIALIZER;
    private AtomicBoolean visible = new AtomicBoolean();
    private AtomicBoolean initialised = new AtomicBoolean();
    private AtomicBoolean pageLoaded = new AtomicBoolean();
    private Browser browser;
    private BrowserHook hook;
    private static CompletableFuture<Void> specadorFuture;
    private static final int STREAM_MAX_CHUNK_SIZE = 128;
    private final StringBuilder generatedMarkdownMessage = new StringBuilder();
    private long lastMarkdownToHtmlUpdate;
    private static String testsNewPreferencesFilePath;

    static {
        block14: {
            JSON_SERIALIZER = new GsonBuilder().disableHtmlEscaping().create();
            String html = "";
            try {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (InputStream stream = JarUtils.getFileStream("welcome.html", SpecadorPreviewView.class);){
                        html = DVTStringUtil.streamToString(stream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    WELCOME_MESSAGE_PAGE = html;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                WELCOME_MESSAGE_PAGE = html;
                throw throwable;
            }
            WELCOME_MESSAGE_PAGE = html;
        }
        testsNewPreferencesFilePath = "";
    }

    public SpecadorPreviewView() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        activePage.addPartListener(new IPartListener2(){

            public void partVisible(IWorkbenchPartReference ref) {
                this.handleViewEvent(ref, true);
            }

            public void partHidden(IWorkbenchPartReference ref) {
                this.handleViewEvent(ref, false);
            }

            private void handleViewEvent(IWorkbenchPartReference ref, boolean visible) {
                if (ref.getPart(false) != SpecadorPreviewView.this) {
                    return;
                }
                SpecadorPreviewView.this.setVisible(visible);
                if (visible) {
                    if (SpecadorPreviewView.this.initialised.get()) {
                        Display.getDefault().asyncExec(SpecadorPreviewView.this::refresh);
                    } else {
                        SpecadorPreviewView.this.initialised.set(true);
                    }
                }
            }
        });
    }

    public void applyTheme() {
        if (DVTThemeUtils.isDarkUI()) {
            String foregroundColor = SpecadorPreviewListener.INSTANCE.getForegroundColor();
            String backgroundColor = SpecadorPreviewListener.INSTANCE.getBackgroundColor();
            this.getBrowser().execute("document.documentElement.classList.add('vscode-dark');document.documentElement.style.setProperty('--vscode-editor-foreground', '" + foregroundColor + "');" + "document.documentElement.style.setProperty('--vscode-editor-background', '" + backgroundColor + "');");
        }
    }

    public void createPartControl(Composite parent) {
        FillLayout gridLayout = new FillLayout();
        parent.setLayout((Layout)gridLayout);
        try {
            this.browser = new Browser(parent, 0);
            this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
            this.hook = new BrowserHook(this.browser);
            this.browser.setText(WELCOME_MESSAGE_PAGE);
            this.browser.addProgressListener(new ProgressListener(){

                public void completed(ProgressEvent event) {
                    SpecadorPreviewView.this.pageLoaded.set(true);
                    SpecadorPreviewView.this.applyTheme();
                }

                public void changed(ProgressEvent event) {
                }
            });
        }
        catch (SWTError e) {
            DVTLogger.INSTANCE.logError((Throwable)new Exception(e));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.createToolBar();
    }

    public void createToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.removeAll();
        toolBarManager.add((IAction)new EditPreferencesAction());
        toolBarManager.update(true);
    }

    public void refresh() {
        if (!this.getVisible() || this.browser == null || this.browser.isDisposed()) {
            return;
        }
        this.pageLoaded.set(false);
        IRfNamedElement element = SpecadorPreviewListener.INSTANCE.getElement();
        if (element == null) {
            return;
        }
        SpecadorModel model = SpecadorPreviewListener.INSTANCE.getModel();
        SpecadorJob genJob = new SpecadorJob(model, element);
        genJob.setProperty(IDVTConstants.BUILD_JOB_PROJECT_NAME, model.getProject().getName());
        genJob.setRule((ISchedulingRule)model.getProject());
        genJob.setUser(false);
        genJob.schedule();
    }

    public Browser getBrowser() {
        return this.browser;
    }

    private static CompletableFuture<Void> getSpecadorFuture() {
        return specadorFuture;
    }

    private static void setSpecadorFuture(CompletableFuture<Void> future) {
        specadorFuture = future;
    }

    private static String parseMarkdown(String content) {
        IRfNamedElement element = SpecadorPreviewListener.INSTANCE.getElement();
        return CommentFormatter.INSTANCE.format(content, DVTComment.CommentFormat.MARKDOWN, element, null).getKey();
    }

    public void openURL(String url) {
        this.pageLoaded.set(false);
        if (this.browser != null) {
            this.browser.setUrl(url);
        }
    }

    public void startStream() {
        this.generatedMarkdownMessage.setLength(0);
        this.lastMarkdownToHtmlUpdate = 0L;
        String toolTipFormatterPreference = PrefConst.getTooltipMarkupLanguage();
        boolean isMarkdown = DVTComment.CommentFormat.AUTO.getPreferenceName().equals(toolTipFormatterPreference) || DVTComment.CommentFormat.MARKDOWN.getPreferenceName().equals(toolTipFormatterPreference);
        String script = String.format("window.postMessage({type: 'stream_start', isMarkdown: %s}, '*');", JSON_SERIALIZER.toJson((Object)isMarkdown));
        Display.getDefault().syncExec(() -> this.browser.execute(script));
    }

    public void streamChunk(String content) {
        this.generatedMarkdownMessage.append(content);
        String markdown = "";
        if ((long)this.generatedMarkdownMessage.length() - this.lastMarkdownToHtmlUpdate > 128L) {
            markdown = JSON_SERIALIZER.toJson((Object)SpecadorPreviewView.parseMarkdown(this.generatedMarkdownMessage.toString()));
            this.lastMarkdownToHtmlUpdate = this.generatedMarkdownMessage.length();
        }
        String script = String.format("window.postMessage({type: 'stream', content: %s, html: %s}, '*');", JSON_SERIALIZER.toJson((Object)content), markdown.isBlank() ? JSON_SERIALIZER.toJson((Object)markdown) : markdown);
        Display.getDefault().syncExec(() -> this.browser.execute(script));
    }

    public void endStream(String entireMessage) {
        String script = String.format("window.postMessage({type: 'stream_end', entireMessage: %s, html: %s}, '*');", JSON_SERIALIZER.toJson((Object)entireMessage), JSON_SERIALIZER.toJson((Object)SpecadorPreviewView.parseMarkdown(entireMessage)));
        Display.getDefault().syncExec(() -> this.browser.execute(script));
        SpecadorPreviewView.getSpecadorFuture().complete(null);
    }

    public void dispose() {
        if (this.browser != null) {
            this.hook.dispose();
            this.browser.dispose();
        }
        SpecadorPreviewListener.INSTANCE.clearLocation();
        super.dispose();
    }

    public void setFocus() {
    }

    public String getHTMLContent() {
        StringBuilder result = new StringBuilder();
        Display.getDefault().syncExec(() -> {
            long timeout = System.currentTimeMillis() + 5000L;
            Display display = this.browser.getShell().getDisplay();
            while (!(this.pageLoaded.get() || System.currentTimeMillis() >= timeout || this.browser.getShell().isDisposed() || display.isDisposed())) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            result.append(this.browser.getText());
        });
        return result.toString();
    }

    public boolean getVisible() {
        return this.visible.get();
    }

    private void setVisible(boolean value) {
        this.visible.set(value);
    }

    public static void setTestNewPreferencesFilePath(String path) {
        testsNewPreferencesFilePath = path;
    }

    public static String getTestNewPreferencesFilePath() {
        return testsNewPreferencesFilePath;
    }

    private static class BrowserHook
    extends BrowserFunction {
        private static final String AI_ASSISTANT_PARSE_COMMAND = "parse";
        private static final String AI_ASSISTANT_IMPROVE_COMMAND = "improve";
        private static final String AI_ASSISTANT_GENERATE_COMMAND = "generate";
        private static final String AI_ASSISTANT_ACCEPT_COMMAND = "accept";
        private static final String AI_ASSISTANT_STOP_COMMAND = "stop";
        private Job aiGeneratorJob;

        public BrowserHook(Browser browser) {
            super(browser, "DVTBridge");
        }

        public Object function(Object[] arguments) {
            String command;
            IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
            if (aiHostContributor == null) {
                return super.function(arguments);
            }
            if (!(arguments[0] instanceof String)) {
                return super.function(arguments);
            }
            switch (command = (String)arguments[0]) {
                case "generate": {
                    this.handleGenerateCommand(arguments, aiHostContributor);
                    break;
                }
                case "accept": {
                    this.handleAcceptCommand(arguments, aiHostContributor);
                    break;
                }
                case "stop": {
                    this.handleStopCommand(aiHostContributor);
                    break;
                }
                case "parse": {
                    return this.handleParseCommand(arguments);
                }
                case "improve": {
                    this.handleImproveCommand(arguments, aiHostContributor);
                    break;
                }
            }
            return super.function(arguments);
        }

        private void handleGenerateCommand(final Object[] arguments, final IAIHostContributor aiHostContributor) {
            this.aiGeneratorJob = new Job("Generate Description for Specador Live Preview Job"){

                protected IStatus run(IProgressMonitor monitor) {
                    Object[] messages;
                    Object[] objectArray = messages = (Object[])arguments[1];
                    int n = messages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object messageObject = objectArray[n2];
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        String message = (String)messageObject;
                        SpecadorPreviewView.setSpecadorFuture(new CompletableFuture<Void>());
                        aiHostContributor.generateSpecadorLivePreviewDescription(SpecadorPreviewListener.INSTANCE.getElement(), message);
                        try {
                            SpecadorPreviewView.getSpecadorFuture().get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                        ++n2;
                    }
                    return Status.OK_STATUS;
                }
            };
            this.aiGeneratorJob.schedule();
        }

        private void handleAcceptCommand(final Object[] arguments, final IAIHostContributor aiHostContributor) {
            Job saveDescriptionJob = new Job("Save Descriptions for Specador Live Preview Job"){

                protected IStatus run(IProgressMonitor monitor) {
                    Object[] messages = (Object[])arguments[1];
                    SpecadorPreviewListener.INSTANCE.getModel().setDocFormattingType(DVTComment.CommentFormat.MARKDOWN);
                    aiHostContributor.saveSpecadorLivePreviewDescriptions(SpecadorPreviewListener.INSTANCE.getElement(), messages, SpecadorPreviewListener.INSTANCE.getModel());
                    return Status.OK_STATUS;
                }
            };
            saveDescriptionJob.schedule();
        }

        private void handleStopCommand(IAIHostContributor aiHostContributor) {
            aiHostContributor.stopSpecadorLivePreviewDescription(SpecadorPreviewListener.INSTANCE.getLastAISessionID(), SpecadorPreviewListener.INSTANCE.getLastAIMessageID());
            if (this.aiGeneratorJob != null) {
                SpecadorPreviewView.getSpecadorFuture().complete(null);
                this.aiGeneratorJob.cancel();
            }
        }

        private String handleParseCommand(Object[] arguments) {
            if (arguments[1] instanceof String) {
                return SpecadorPreviewView.parseMarkdown((String)arguments[1]);
            }
            return "";
        }

        private void handleImproveCommand(Object[] arguments, final IAIHostContributor aiHostContributor) {
            if (arguments[1] instanceof String && arguments[2] instanceof String) {
                final String userPrompt = (String)arguments[1];
                final String userDescription = (String)arguments[2];
                Job generateDescriptionJob = new Job("Generate Description for Specador Live Preview Job"){

                    protected IStatus run(IProgressMonitor monitor) {
                        aiHostContributor.improveSpecadorLivePreviewDescription(SpecadorPreviewListener.INSTANCE.getElement(), userPrompt, userDescription);
                        return Status.OK_STATUS;
                    }
                };
                generateDescriptionJob.schedule();
            }
        }

        public void dispose() {
            IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
            if (aiHostContributor != null) {
                aiHostContributor.stopSpecadorLivePreviewDescription(SpecadorPreviewListener.INSTANCE.getLastAISessionID(), SpecadorPreviewListener.INSTANCE.getLastAIMessageID());
            }
            if (this.aiGeneratorJob != null) {
                this.aiGeneratorJob.cancel();
                SpecadorPreviewView.getSpecadorFuture().complete(null);
            }
            super.dispose();
        }
    }

    static class EditPreferencesAction
    extends Action {
        public EditPreferencesAction() {
            super("Set Preferences");
            this.setToolTipText("Set Preview Preferences");
            this.setImageDescriptor(DVTImages.IMG_TAB_GRAPHVIZ_PREFERENCES);
        }

        public void run() {
            try {
                IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
                if (project == null || !project.isAccessible() || !Utils.hasDvtNature(project)) {
                    IProject[] projects = DVTUtilsCommon.getProjects();
                    if (projects.length == 0) {
                        return;
                    }
                    project = ProjectSelectionDialog.selectProject();
                    if (project == null) {
                        return;
                    }
                }
                this.startWizard(project);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        private void startWizard(IProject finalProject) {
            SpecadorPreviewPreferenceWizard wizard = new SpecadorPreviewPreferenceWizard(finalProject);
            if (wizard.getModel().getProject() == null) {
                return;
            }
            wizard.init(PlatformUI.getWorkbench(), null);
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard){

                protected void createButtonsForButtonBar(Composite parent) {
                    super.createButtonsForButtonBar(parent);
                    Button finishButton = this.getButton(16);
                    finishButton.setText("Apply");
                    this.setButtonLayoutData(finishButton);
                }

                public boolean isHelpAvailable() {
                    return false;
                }
            };
            dialog.open();
        }
    }
}

