/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import de.cau.cs.kieler.core.kgraph.KGraphElement;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.design.DBlockDiagram;
import ro.amiq.dvt.diagrams.design.DBlockDiagram2;
import ro.amiq.dvt.diagrams.design.DFlowDiagram;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramBatch;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableData;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableRow;
import ro.amiq.dvt.diagrams.fsm.editor.actions.TransitionLabelType;
import ro.amiq.dvt.diagrams.fsm.model.FSMModel;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfiguration;
import ro.amiq.dvt.diagrams.netlist.utils.NLFilterSet;
import ro.amiq.dvt.diagrams.uml.UMLDiagram;
import ro.amiq.dvt.diagrams.uml.draw.UMLDrawUtils;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLContainer;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLObject;
import ro.amiq.dvt.diagrams.uml.model.IUMLElement;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;
import ro.amiq.dvt.draw.DExporter;
import ro.amiq.dvt.draw.debug.DNullDebug;
import ro.amiq.dvt.draw.obj.base.DGroup;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.design.DDesignObject;
import ro.amiq.dvt.draw.obj.design.DModule;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DText;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.render.svg.DSVGExporter;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.fsm.convert.FSMConverter;
import ro.amiq.dvt.fsm.model.IFSMModel;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.ISpecadorContributor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.wizards.specador.SpecadorManager;
import ro.amiq.dvt.wizards.specador.SpecadorModel;

public class SpecadorSVGDiagramFactory {
    public static String newBlockDiagram(IRfNamedElement namedElement, String fontsFilePath, LanguageKind modelNature) {
        return SpecadorSVGDiagramFactory.exportDiagram(new DBlockDiagram(namedElement, new NLConfig(SpecadorSVGDiagramFactory.getNLConfiguration()), null), fontsFilePath, false, modelNature);
    }

    public static String newBlockDiagram2(IRfNamedElement namedElement, String fontsFilePath, LanguageKind modelNature) {
        return SpecadorSVGDiagramFactory.exportDiagram(new DBlockDiagram2(namedElement), fontsFilePath, false, modelNature);
    }

    public static String newFlowDiagram(IRfNamedElement namedElement, String fontsFilePath, boolean hasURLs, LanguageKind modelNature, NLFilterSet filters) {
        return SpecadorSVGDiagramFactory.exportDiagram(new DFlowDiagram(namedElement, new NLConfig(SpecadorSVGDiagramFactory.getNLConfiguration(), filters), null, true), fontsFilePath, hasURLs, modelNature);
    }

    public static String newSubInstancesDiagram(IRfNamedElement namedElement, String fontsFilePath, boolean hasURLs, LanguageKind modelNature, NLFilterSet filters) {
        NLConfig config = new NLConfig(SpecadorSVGDiagramFactory.getNLConfiguration(), filters);
        config.getFlags().add(NLConfiguration.SCHEMATIC_HIDE_LOGIC_GATES);
        config.setReduceGates(true);
        return SpecadorSVGDiagramFactory.exportDiagram(new DSchematicDiagram(1, namedElement, config, null, true), fontsFilePath, hasURLs, modelNature);
    }

    public static String newSchematicDiagram(IRfNamedElement namedElement, String fontsFilePath, boolean hasURLs, LanguageKind modelNature, NLFilterSet filters) {
        return SpecadorSVGDiagramFactory.exportDiagram(new DSchematicDiagram(1, namedElement, new NLConfig(SpecadorSVGDiagramFactory.getNLConfiguration(), filters), null, true), fontsFilePath, hasURLs, modelNature);
    }

    public static String newUMLDiagram(String name, UMLModel umlModel, String fontsFilePath, boolean hasURLs, LanguageKind modelNature) {
        return SpecadorSVGDiagramFactory.exportDiagram(new UMLDiagram("UML of " + name, name, umlModel), fontsFilePath, hasURLs, modelNature);
    }

    public static Map<String, DVTPair<String, String>> newFSMDiagrams(IRfNamedElement namedElement, String fontsFilePath, IProgressMonitor progressMonitor, SpecadorModel specadorModel) {
        if (namedElement == null) {
            return Collections.emptyMap();
        }
        Map<IRfFieldElement, IFSMModel> varWithModels = FSMConverter.convert(namedElement, 4, 200L, progressMonitor);
        if (varWithModels == null || varWithModels.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, DVTPair<String, String>> result = new LinkedHashMap<String, DVTPair<String, String>>();
        FSMDiagramConfiguration config = FSMDiagramConfiguration.getPreferencesSpecador(specadorModel);
        config.set(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SHOW_TRANSITION_LABELS, TransitionLabelType.INDEX);
        for (Map.Entry<IRfFieldElement, IFSMModel> entry : varWithModels.entrySet()) {
            IRfFieldElement variable;
            IFSMModel model = entry.getValue();
            if (!(model instanceof FSMModel) || (variable = entry.getKey()) == null) continue;
            FSMDiagramBatch fsmDiagramBatch = new FSMDiagramBatch(variable, variable.getName(), (FSMModel)model, new FSMTransitionTableData(), config);
            String svgDiagram = SpecadorSVGDiagramFactory.exportDiagram(fsmDiagramBatch, fontsFilePath, false, null);
            svgDiagram = svgDiagram.replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&");
            StringBuilder sb = new StringBuilder();
            for (FSMTransitionTableRow row : fsmDiagramBatch.getFSMTransitionTable().getRows()) {
                String condition = row.getCondition().toString();
                sb.append(row.getCurrentState().getNiceID()).append('\t').append(row.getNextState().getNiceID()).append('\t').append(condition.substring(1, condition.length() - 1)).append('\n');
            }
            result.put(variable.getName(), new DVTPair<String, String>(svgDiagram, sb.toString()));
        }
        return result;
    }

    public static String exportDiagram(DDiagram diagram, String fontsFilePath, boolean hasURLs, LanguageKind modelNature) {
        DObject result = SpecadorSVGDiagramFactory.exportDObject(diagram);
        if (hasURLs) {
            SpecadorSVGDiagramFactory.addURLs(result, modelNature, SpecadorSVGDiagramFactory.getSourceOfDiagram(result));
        }
        return DExporter.SVG.export(result, 1.0, DProperties.of(DSVGExporter.EMBEDDABLE, true, DSVGExporter.FONTS_FILE, new File(fontsFilePath)));
    }

    private static void addURLs(DObject object, LanguageKind modelNature, String sourceOfDiagram) {
        List<DObject> children;
        String url;
        IRfDesignElement namedElement;
        NLAbstractBase nlObject;
        if (object instanceof DModule && object instanceof DSelectable && (nlObject = KLayDrawUtils.getNLObject(((DModule)object).getProperty(DDesignObject.KELEMENT))) instanceof NLInstanceGate && (namedElement = ((NLInstanceGate)nlObject).getDesign()) != null && modelNature != null && (url = SpecadorManager.getHyperlinkForDiagrams(namedElement, modelNature)) != null && !url.isEmpty()) {
            if (!sourceOfDiagram.isEmpty()) {
                url = Paths.get(sourceOfDiagram, new String[0]).relativize(Paths.get(url, new String[0])).toString();
            }
            if (url != null && !url.isEmpty()) {
                ((DModule)object).setProperty(DModule.URL, url);
            }
        }
        if (object instanceof DUMLContainer && object instanceof DSelectable) {
            IRfNamedElement namedElement2 = null;
            KGraphElement kNode = ((DUMLContainer)object).getProperty(DUMLObject.KELEMENT);
            IUMLElement umlObject = (IUMLElement)UMLDrawUtils.getUMLObjectFromKElement(kNode);
            if (umlObject instanceof UMLNode) {
                String url2;
                Object element = ((UMLNode)umlObject).getElement();
                if (element instanceof IRfDefElement) {
                    namedElement2 = ((IRfDefElement)element).getNamedElement();
                } else if (element instanceof IRfNamedElement) {
                    namedElement2 = (IRfNamedElement)element;
                }
                if (namedElement2 != null && modelNature != null && (url2 = SpecadorManager.getHyperlinkForDiagrams(namedElement2, modelNature)) != null && !url2.isEmpty()) {
                    if (!sourceOfDiagram.isEmpty()) {
                        url2 = Paths.get(sourceOfDiagram, new String[0]).relativize(Paths.get(url2, new String[0])).toString();
                    }
                    if (url2 != null && !url2.isEmpty()) {
                        ((DUMLContainer)object).setProperty(DUMLObject.URL, url2);
                    }
                }
            }
        }
        if (object instanceof DGroup && (children = ((DGroup)object).getChildren()) != null) {
            for (DObject child : children) {
                SpecadorSVGDiagramFactory.addURLs(child, modelNature, sourceOfDiagram);
            }
        }
    }

    private static String getSourceOfDiagram(DObject object) {
        if (!(object instanceof DGroup)) {
            return "";
        }
        List<DObject> children = ((DGroup)object).getChildren();
        if (children == null || children.isEmpty()) {
            return "";
        }
        DObject dObject = children.get(0);
        if (dObject instanceof DModule && dObject instanceof DSelectable) {
            NLAbstractBase nlObject = KLayDrawUtils.getNLObject(((DModule)dObject).getProperty(DDesignObject.KELEMENT));
            if (!(nlObject instanceof NLInstanceGate)) {
                return "";
            }
            IRfDesignElement namedElement = ((NLInstanceGate)nlObject).getDesign();
            if (namedElement == null) {
                return "";
            }
            ISpecadorContributor contributor = LanguageContributor.get(namedElement.getLanguageKind());
            if (contributor == null) {
                return "";
            }
            return contributor.getURL(namedElement);
        }
        if (dObject instanceof DUMLContainer && dObject instanceof DSelectable) {
            IRfNamedElement namedElement = null;
            KGraphElement kNode = ((DUMLContainer)dObject).getProperty(DUMLObject.KELEMENT);
            IUMLElement umlObject = (IUMLElement)UMLDrawUtils.getUMLObjectFromKElement(kNode);
            if (!(umlObject instanceof UMLNode)) {
                return "";
            }
            Object element = ((UMLNode)umlObject).getElement();
            if (element instanceof IRfDefElement) {
                namedElement = ((IRfDefElement)element).getNamedElement();
            } else if (element instanceof IRfNamedElement) {
                namedElement = (IRfNamedElement)element;
            }
            if (namedElement == null) {
                return "";
            }
            ISpecadorContributor contributor = LanguageContributor.get(namedElement.getLanguageKind());
            if (contributor == null) {
                return "";
            }
            return contributor.getURL(namedElement);
        }
        return "";
    }

    public static DObject exportDObject(DDiagram diagram) {
        DObject result = diagram.getSceneGenerator().generate(DProgressMonitor.wrap((IProgressMonitor)new NullProgressMonitor(), message -> DVTLogger.INSTANCE.logInfo(message), DNullDebug::new));
        if (result == null) {
            result = new DText("Diagram generation failed!", 0, 0, FontFactory.getInstance().getFontData("Sans", 32, 0));
        }
        return result;
    }

    public static void testExportDiagramToFile(String filePath, DDiagram diagram, String fontsFilePath, DExporter exporter) throws IOException {
        DObject result = SpecadorSVGDiagramFactory.exportDObject(diagram);
        exporter.export(new File(filePath), result, 1.0, DProperties.of(DSVGExporter.EMBEDDABLE, true, DSVGExporter.FONTS_FILE, new File(fontsFilePath)));
    }

    public static Set<NLConfiguration> getNLConfiguration() {
        return EnumSet.of(NLConfiguration.FOR_SPECADOR, new NLConfiguration[]{NLConfiguration.FLOW_COLLAPSE_BIDIRECTIONAL_EDGES, NLConfiguration.FLOW_REDUCE_COMBINATIONAL_LOGIC_GATES, NLConfiguration.REDUCE_INTERFACES, NLConfiguration.REDUCE_EMPTY_BLOCKS, NLConfiguration.INSTANCE_GATE_LABELS_INSIDE, NLConfiguration.SCHEMATIC_SHOW_CONSTANTS});
    }
}

