/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.wizards.specador.SpecadorJob;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewListener;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewView;
import ro.amiq.dvt.wizards.specador.SpecadorWizardContent;
import ro.amiq.dvt.wizards.specador.SpecadorXMLParser;

public class SpecadorWizard
extends Wizard
implements INewWizard,
IPageChangedListener {
    private SpecadorModel fModel;
    private IProject fProject;
    private String preferenceFilePath;
    public static final String EDIT_PREFERENCES_TRIGGER = "Edit Preferences...";
    public static final String NEW_PREFERENCES_TRIGGER = "Set Preview Preferences...";
    public static final String GENERATE_DOCUMENTATION_TRIGGER = "Generate Documentation...";
    protected SpecadorWizardContent settingsPage;
    private File fLoadedPreferenceFile;
    private boolean editMode;
    private boolean newPrefsMode;
    private String prefFileToEdit;

    public SpecadorWizard(IProject project, boolean editMode, boolean newPrefsMode, String prefFileToEdit) {
        this.fProject = project;
        this.fModel = new SpecadorModel();
        this.fModel.setProject(this.fProject, !newPrefsMode);
        this.editMode = editMode;
        this.newPrefsMode = newPrefsMode;
        this.prefFileToEdit = prefFileToEdit;
        this.initModel();
    }

    public void initModel() {
        if (this.newPrefsMode) {
            this.fModel.initiateOutsideProjectModel();
            return;
        }
        if (this.prefFileToEdit != null) {
            this.fModel.initDefaults();
            this.fLoadedPreferenceFile = new File(this.prefFileToEdit);
        } else {
            IResource resource = DVTPlugin.getSelectionManager().getLastSelectedResource();
            if (!(resource instanceof IFile) || !resource.exists()) {
                return;
            }
            String extension = resource.getFileExtension();
            if (extension == null || !extension.equals("xml")) {
                return;
            }
            File file = resource.getLocation().toFile();
            if (!SpecadorXMLParser.isSpecadorPreferenceFile(file)) {
                return;
            }
            this.fLoadedPreferenceFile = file;
        }
        this.fModel.loadFromFile(this.fLoadedPreferenceFile, true);
    }

    public SpecadorModel getModel() {
        return this.fModel;
    }

    public boolean performFinish() {
        block10: {
            block9: {
                if (!this.newPrefsMode) break block9;
                this.preferenceFilePath = TestHelper.isSWTBotSuite() ? SpecadorPreviewView.getTestNewPreferencesFilePath() : this.openFileDialog();
                this.fModel.saveToFileNoCache(this.preferenceFilePath);
                IPath projectPath = this.fProject.getLocation();
                Path preferencePath = new Path(this.preferenceFilePath);
                IPath relativePath = preferencePath.makeRelativeTo(projectPath);
                IFile preferenceFile = this.fProject.getFile(relativePath);
                if (preferenceFile != null) {
                    preferenceFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                return true;
            }
            if (!TestHelper.isTestMode() || TestHelper.isSWTBotSuite()) {
                this.fModel.saveToFile(true);
                IFile preferenceFile = this.fProject.getFile(new Path(".dvt").append("specador_preferences.xml"));
                if (preferenceFile != null) {
                    preferenceFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            if (!this.editMode) break block10;
            if (SpecadorPreviewListener.INSTANCE.getPreferenceFile() != null && this.fModel.getPreferencesFile().getAbsolutePath().equals(SpecadorPreviewListener.INSTANCE.getPreferenceFile().getAbsolutePath())) {
                SpecadorPreviewListener.INSTANCE.getModel().initDefaults();
                SpecadorPreviewListener.INSTANCE.getModel().loadFromFile(this.fModel.getPreferencesFile(), true);
                if (this.prefFileToEdit == null) {
                    SpecadorPreviewListener.INSTANCE.refresh();
                }
            }
            return true;
        }
        try {
            SpecadorJob genJob = new SpecadorJob(this.getModel());
            genJob.setProperty(IDVTConstants.BUILD_JOB_PROJECT_NAME, this.getModel().getProject().getName());
            genJob.setRule((ISchedulingRule)this.getModel().getProject());
            genJob.setUser(true);
            genJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    private String openFileDialog() {
        String[] extensions = new String[]{"*.xml"};
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setFilterExtensions(extensions);
        String xmlPath = DVTFileUtils.getInstance().getLastDirectory();
        if (xmlPath.equals(System.getProperty("user.home"))) {
            xmlPath = this.getModel().getProject().getLocation().toOSString();
        }
        dialog.setFilterPath(xmlPath);
        return dialog.open();
    }

    public void savePreferences() {
        this.fModel.saveToFile();
    }

    public void dispose() {
        this.fModel.removeProjectChangeListener(this.settingsPage);
        if (this.settingsPage != null) {
            this.settingsPage.dispose();
        }
        this.fProject = null;
        super.dispose();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            if (this.fProject == null) {
                return;
            }
            if (this.fProject.hasNature("ro.amiq.vlogdt.VlogNature") || this.fProject.hasNature("ro.amiq.edt.enature") || this.fProject.hasNature("ro.amiq.slndt.slnnature") || this.fProject.hasNature("ro.amiq.msdldt.msdlnature") || this.fProject.hasNature("ro.amiq.pssdt.pssnature") || this.fProject.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                this.fModel.setProject(this.fProject);
            }
            this.setWindowTitle("Export Specador Documentation for " + this.fProject.getName());
            this.settingsPage = new SpecadorWizardContent("General Settings");
            this.settingsPage.setShowLoadedPath(!this.newPrefsMode);
            this.fModel.addProjectChangeListener(this.settingsPage);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void pageChanged(PageChangedEvent event) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.settingsPage);
    }

    public String getPreferenceFilePath() {
        return this.preferenceFilePath;
    }
}

